/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.ImportedModule;
import org.rascalmpl.ast.LocationLiteral;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.SyntaxDefinition;

public abstract class Import
extends AbstractAST {
    public Import(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasModule() {
        return false;
    }

    public ImportedModule getModule() {
        throw new UnsupportedOperationException();
    }

    public boolean hasAt() {
        return false;
    }

    public LocationLiteral getAt() {
        throw new UnsupportedOperationException();
    }

    public boolean hasName() {
        return false;
    }

    public QualifiedName getName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSyntax() {
        return false;
    }

    public SyntaxDefinition getSyntax() {
        throw new UnsupportedOperationException();
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isExtend() {
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isSyntax() {
        return false;
    }

    public static class Syntax
    extends Import {
        private final SyntaxDefinition syntax;

        public Syntax(ISourceLocation src, IConstructor node, SyntaxDefinition syntax) {
            super(src, node);
            this.syntax = syntax;
        }

        @Override
        public boolean isSyntax() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitImportSyntax(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.syntax.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.syntax.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Syntax)) {
                return false;
            }
            Syntax tmp = (Syntax)o;
            return tmp.syntax.equals(this.syntax);
        }

        @Override
        public int hashCode() {
            return 239 + 151 * this.syntax.hashCode();
        }

        @Override
        public SyntaxDefinition getSyntax() {
            return this.syntax;
        }

        @Override
        public boolean hasSyntax() {
            return true;
        }

        @Override
        public Object clone() {
            return Syntax.newInstance(this.getClass(), this.src, null, this.clone(this.syntax));
        }
    }

    public static class External
    extends Import {
        private final QualifiedName name;
        private final LocationLiteral at;

        public External(ISourceLocation src, IConstructor node, QualifiedName name, LocationLiteral at) {
            super(src, node);
            this.name = name;
            this.at = at;
        }

        @Override
        public boolean isExternal() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitImportExternal(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.at.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.at.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof External)) {
                return false;
            }
            External tmp = (External)o;
            return tmp.name.equals(this.name) && tmp.at.equals(this.at);
        }

        @Override
        public int hashCode() {
            return 719 + 773 * this.name.hashCode() + 277 * this.at.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public LocationLiteral getAt() {
            return this.at;
        }

        @Override
        public boolean hasAt() {
            return true;
        }

        @Override
        public Object clone() {
            return External.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.at));
        }
    }

    public static class Extend
    extends Import {
        private final ImportedModule module;

        public Extend(ISourceLocation src, IConstructor node, ImportedModule module) {
            super(src, node);
            this.module = module;
        }

        @Override
        public boolean isExtend() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitImportExtend(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.module.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.module.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Extend)) {
                return false;
            }
            Extend tmp = (Extend)o;
            return tmp.module.equals(this.module);
        }

        @Override
        public int hashCode() {
            return 937 + 521 * this.module.hashCode();
        }

        @Override
        public ImportedModule getModule() {
            return this.module;
        }

        @Override
        public boolean hasModule() {
            return true;
        }

        @Override
        public Object clone() {
            return Extend.newInstance(this.getClass(), this.src, null, this.clone(this.module));
        }
    }

    public static class Default
    extends Import {
        private final ImportedModule module;

        public Default(ISourceLocation src, IConstructor node, ImportedModule module) {
            super(src, node);
            this.module = module;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitImportDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.module.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.module.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.module.equals(this.module);
        }

        @Override
        public int hashCode() {
            return 401 + 139 * this.module.hashCode();
        }

        @Override
        public ImportedModule getModule() {
            return this.module;
        }

        @Override
        public boolean hasModule() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.module));
        }
    }
}

