/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.ModuleActuals;
import org.rascalmpl.ast.QualifiedName;

public abstract class ImportedModule
extends AbstractAST {
    public ImportedModule(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasActuals() {
        return false;
    }

    public ModuleActuals getActuals() {
        throw new UnsupportedOperationException();
    }

    public boolean hasName() {
        return false;
    }

    public QualifiedName getName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasRenamings() {
        return false;
    }

    public org.rascalmpl.ast.Renamings getRenamings() {
        throw new UnsupportedOperationException();
    }

    public boolean isActuals() {
        return false;
    }

    public boolean isActualsRenaming() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isRenamings() {
        return false;
    }

    public static class Renamings
    extends ImportedModule {
        private final QualifiedName name;
        private final org.rascalmpl.ast.Renamings renamings;

        public Renamings(ISourceLocation src, IConstructor node, QualifiedName name, org.rascalmpl.ast.Renamings renamings) {
            super(src, node);
            this.name = name;
            this.renamings = renamings;
        }

        @Override
        public boolean isRenamings() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitImportedModuleRenamings(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.renamings.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.renamings.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Renamings)) {
                return false;
            }
            Renamings tmp = (Renamings)o;
            return tmp.name.equals(this.name) && tmp.renamings.equals(this.renamings);
        }

        @Override
        public int hashCode() {
            return 643 + 229 * this.name.hashCode() + 271 * this.renamings.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Renamings getRenamings() {
            return this.renamings;
        }

        @Override
        public boolean hasRenamings() {
            return true;
        }

        @Override
        public Object clone() {
            return Renamings.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.renamings));
        }
    }

    public static class Default
    extends ImportedModule {
        private final QualifiedName name;

        public Default(ISourceLocation src, IConstructor node, QualifiedName name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitImportedModuleDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 127 + 67 * this.name.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }

    public static class ActualsRenaming
    extends ImportedModule {
        private final QualifiedName name;
        private final ModuleActuals actuals;
        private final org.rascalmpl.ast.Renamings renamings;

        public ActualsRenaming(ISourceLocation src, IConstructor node, QualifiedName name, ModuleActuals actuals, org.rascalmpl.ast.Renamings renamings) {
            super(src, node);
            this.name = name;
            this.actuals = actuals;
            this.renamings = renamings;
        }

        @Override
        public boolean isActualsRenaming() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitImportedModuleActualsRenaming(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.actuals.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.actuals.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.renamings.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.renamings.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ActualsRenaming)) {
                return false;
            }
            ActualsRenaming tmp = (ActualsRenaming)o;
            return tmp.name.equals(this.name) && tmp.actuals.equals(this.actuals) && tmp.renamings.equals(this.renamings);
        }

        @Override
        public int hashCode() {
            return 709 + 167 * this.name.hashCode() + 53 * this.actuals.hashCode() + 463 * this.renamings.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public ModuleActuals getActuals() {
            return this.actuals;
        }

        @Override
        public boolean hasActuals() {
            return true;
        }

        @Override
        public org.rascalmpl.ast.Renamings getRenamings() {
            return this.renamings;
        }

        @Override
        public boolean hasRenamings() {
            return true;
        }

        @Override
        public Object clone() {
            return ActualsRenaming.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.actuals), this.clone(this.renamings));
        }
    }

    public static class Actuals
    extends ImportedModule {
        private final QualifiedName name;
        private final ModuleActuals actuals;

        public Actuals(ISourceLocation src, IConstructor node, QualifiedName name, ModuleActuals actuals) {
            super(src, node);
            this.name = name;
            this.actuals = actuals;
        }

        @Override
        public boolean isActuals() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitImportedModuleActuals(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.actuals.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.actuals.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Actuals)) {
                return false;
            }
            Actuals tmp = (Actuals)o;
            return tmp.name.equals(this.name) && tmp.actuals.equals(this.actuals);
        }

        @Override
        public int hashCode() {
            return 397 + 137 * this.name.hashCode() + 811 * this.actuals.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public ModuleActuals getActuals() {
            return this.actuals;
        }

        @Override
        public boolean hasActuals() {
            return true;
        }

        @Override
        public Object clone() {
            return Actuals.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.actuals));
        }
    }
}

