/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.BooleanLiteral;
import org.rascalmpl.ast.DateTimeLiteral;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.IntegerLiteral;
import org.rascalmpl.ast.LocationLiteral;
import org.rascalmpl.ast.RationalLiteral;
import org.rascalmpl.ast.RealLiteral;
import org.rascalmpl.ast.RegExpLiteral;
import org.rascalmpl.ast.StringLiteral;

public abstract class Literal
extends AbstractAST {
    public Literal(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasBooleanLiteral() {
        return false;
    }

    public BooleanLiteral getBooleanLiteral() {
        throw new UnsupportedOperationException();
    }

    public boolean hasDateTimeLiteral() {
        return false;
    }

    public DateTimeLiteral getDateTimeLiteral() {
        throw new UnsupportedOperationException();
    }

    public boolean hasIntegerLiteral() {
        return false;
    }

    public IntegerLiteral getIntegerLiteral() {
        throw new UnsupportedOperationException();
    }

    public boolean hasLocationLiteral() {
        return false;
    }

    public LocationLiteral getLocationLiteral() {
        throw new UnsupportedOperationException();
    }

    public boolean hasRationalLiteral() {
        return false;
    }

    public RationalLiteral getRationalLiteral() {
        throw new UnsupportedOperationException();
    }

    public boolean hasRealLiteral() {
        return false;
    }

    public RealLiteral getRealLiteral() {
        throw new UnsupportedOperationException();
    }

    public boolean hasRegExpLiteral() {
        return false;
    }

    public RegExpLiteral getRegExpLiteral() {
        throw new UnsupportedOperationException();
    }

    public boolean hasStringLiteral() {
        return false;
    }

    public StringLiteral getStringLiteral() {
        throw new UnsupportedOperationException();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isLocation() {
        return false;
    }

    public boolean isRational() {
        return false;
    }

    public boolean isReal() {
        return false;
    }

    public boolean isRegExp() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public static class String
    extends Literal {
        private final StringLiteral stringLiteral;

        public String(ISourceLocation src, IConstructor node, StringLiteral stringLiteral) {
            super(src, node);
            this.stringLiteral = stringLiteral;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLiteralString(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.stringLiteral.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.stringLiteral.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            String tmp = (String)o;
            return tmp.stringLiteral.equals(this.stringLiteral);
        }

        @Override
        public int hashCode() {
            return 31 + 283 * this.stringLiteral.hashCode();
        }

        @Override
        public StringLiteral getStringLiteral() {
            return this.stringLiteral;
        }

        @Override
        public boolean hasStringLiteral() {
            return true;
        }

        @Override
        public Object clone() {
            return String.newInstance(this.getClass(), this.src, null, this.clone(this.stringLiteral));
        }
    }

    public static class RegExp
    extends Literal {
        private final RegExpLiteral regExpLiteral;

        public RegExp(ISourceLocation src, IConstructor node, RegExpLiteral regExpLiteral) {
            super(src, node);
            this.regExpLiteral = regExpLiteral;
        }

        @Override
        public boolean isRegExp() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLiteralRegExp(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.regExpLiteral.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.regExpLiteral.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RegExp)) {
                return false;
            }
            RegExp tmp = (RegExp)o;
            return tmp.regExpLiteral.equals(this.regExpLiteral);
        }

        @Override
        public int hashCode() {
            return 3 + 373 * this.regExpLiteral.hashCode();
        }

        @Override
        public RegExpLiteral getRegExpLiteral() {
            return this.regExpLiteral;
        }

        @Override
        public boolean hasRegExpLiteral() {
            return true;
        }

        @Override
        public Object clone() {
            return RegExp.newInstance(this.getClass(), this.src, null, this.clone(this.regExpLiteral));
        }
    }

    public static class Real
    extends Literal {
        private final RealLiteral realLiteral;

        public Real(ISourceLocation src, IConstructor node, RealLiteral realLiteral) {
            super(src, node);
            this.realLiteral = realLiteral;
        }

        @Override
        public boolean isReal() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLiteralReal(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.realLiteral.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.realLiteral.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Real)) {
                return false;
            }
            Real tmp = (Real)o;
            return tmp.realLiteral.equals(this.realLiteral);
        }

        @Override
        public int hashCode() {
            return 739 + 547 * this.realLiteral.hashCode();
        }

        @Override
        public RealLiteral getRealLiteral() {
            return this.realLiteral;
        }

        @Override
        public boolean hasRealLiteral() {
            return true;
        }

        @Override
        public Object clone() {
            return Real.newInstance(this.getClass(), this.src, null, this.clone(this.realLiteral));
        }
    }

    public static class Rational
    extends Literal {
        private final RationalLiteral rationalLiteral;

        public Rational(ISourceLocation src, IConstructor node, RationalLiteral rationalLiteral) {
            super(src, node);
            this.rationalLiteral = rationalLiteral;
        }

        @Override
        public boolean isRational() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLiteralRational(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.rationalLiteral.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.rationalLiteral.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Rational)) {
                return false;
            }
            Rational tmp = (Rational)o;
            return tmp.rationalLiteral.equals(this.rationalLiteral);
        }

        @Override
        public int hashCode() {
            return 127 + 89 * this.rationalLiteral.hashCode();
        }

        @Override
        public RationalLiteral getRationalLiteral() {
            return this.rationalLiteral;
        }

        @Override
        public boolean hasRationalLiteral() {
            return true;
        }

        @Override
        public Object clone() {
            return Rational.newInstance(this.getClass(), this.src, null, this.clone(this.rationalLiteral));
        }
    }

    public static class Location
    extends Literal {
        private final LocationLiteral locationLiteral;

        public Location(ISourceLocation src, IConstructor node, LocationLiteral locationLiteral) {
            super(src, node);
            this.locationLiteral = locationLiteral;
        }

        @Override
        public boolean isLocation() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLiteralLocation(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.locationLiteral.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.locationLiteral.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Location)) {
                return false;
            }
            Location tmp = (Location)o;
            return tmp.locationLiteral.equals(this.locationLiteral);
        }

        @Override
        public int hashCode() {
            return 283 + 521 * this.locationLiteral.hashCode();
        }

        @Override
        public LocationLiteral getLocationLiteral() {
            return this.locationLiteral;
        }

        @Override
        public boolean hasLocationLiteral() {
            return true;
        }

        @Override
        public Object clone() {
            return Location.newInstance(this.getClass(), this.src, null, this.clone(this.locationLiteral));
        }
    }

    public static class Integer
    extends Literal {
        private final IntegerLiteral integerLiteral;

        public Integer(ISourceLocation src, IConstructor node, IntegerLiteral integerLiteral) {
            super(src, node);
            this.integerLiteral = integerLiteral;
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLiteralInteger(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.integerLiteral.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.integerLiteral.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Integer)) {
                return false;
            }
            Integer tmp = (Integer)o;
            return tmp.integerLiteral.equals(this.integerLiteral);
        }

        @Override
        public int hashCode() {
            return 103 + 257 * this.integerLiteral.hashCode();
        }

        @Override
        public IntegerLiteral getIntegerLiteral() {
            return this.integerLiteral;
        }

        @Override
        public boolean hasIntegerLiteral() {
            return true;
        }

        @Override
        public Object clone() {
            return Integer.newInstance(this.getClass(), this.src, null, this.clone(this.integerLiteral));
        }
    }

    public static class DateTime
    extends Literal {
        private final DateTimeLiteral dateTimeLiteral;

        public DateTime(ISourceLocation src, IConstructor node, DateTimeLiteral dateTimeLiteral) {
            super(src, node);
            this.dateTimeLiteral = dateTimeLiteral;
        }

        @Override
        public boolean isDateTime() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLiteralDateTime(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.dateTimeLiteral.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.dateTimeLiteral.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DateTime)) {
                return false;
            }
            DateTime tmp = (DateTime)o;
            return tmp.dateTimeLiteral.equals(this.dateTimeLiteral);
        }

        @Override
        public int hashCode() {
            return 631 + 173 * this.dateTimeLiteral.hashCode();
        }

        @Override
        public DateTimeLiteral getDateTimeLiteral() {
            return this.dateTimeLiteral;
        }

        @Override
        public boolean hasDateTimeLiteral() {
            return true;
        }

        @Override
        public Object clone() {
            return DateTime.newInstance(this.getClass(), this.src, null, this.clone(this.dateTimeLiteral));
        }
    }

    public static class Boolean
    extends Literal {
        private final BooleanLiteral booleanLiteral;

        public Boolean(ISourceLocation src, IConstructor node, BooleanLiteral booleanLiteral) {
            super(src, node);
            this.booleanLiteral = booleanLiteral;
        }

        @Override
        public boolean isBoolean() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLiteralBoolean(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.booleanLiteral.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.booleanLiteral.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Boolean)) {
                return false;
            }
            Boolean tmp = (Boolean)o;
            return tmp.booleanLiteral.equals(this.booleanLiteral);
        }

        @Override
        public int hashCode() {
            return 577 + 643 * this.booleanLiteral.hashCode();
        }

        @Override
        public BooleanLiteral getBooleanLiteral() {
            return this.booleanLiteral;
        }

        @Override
        public boolean hasBooleanLiteral() {
            return true;
        }

        @Override
        public Object clone() {
            return Boolean.newInstance(this.getClass(), this.src, null, this.clone(this.booleanLiteral));
        }
    }
}

