/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Body;
import org.rascalmpl.ast.Header;
import org.rascalmpl.ast.IASTVisitor;

public abstract class Module
extends AbstractAST {
    public Module(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasBody() {
        return false;
    }

    public Body getBody() {
        throw new UnsupportedOperationException();
    }

    public boolean hasHeader() {
        return false;
    }

    public Header getHeader() {
        throw new UnsupportedOperationException();
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends Module {
        private final Header header;
        private final Body body;

        public Default(ISourceLocation src, IConstructor node, Header header, Body body) {
            super(src, node);
            this.header = header;
            this.body = body;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitModuleDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.header.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.header.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.body.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.header.equals(this.header) && tmp.body.equals(this.body);
        }

        @Override
        public int hashCode() {
            return 137 + 277 * this.header.hashCode() + 281 * this.body.hashCode();
        }

        @Override
        public Header getHeader() {
            return this.header;
        }

        @Override
        public boolean hasHeader() {
            return true;
        }

        @Override
        public Body getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.header), this.clone(this.body));
        }
    }
}

