/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.PathChars;
import org.rascalmpl.ast.PathTail;
import org.rascalmpl.ast.PrePathChars;

public abstract class PathPart
extends AbstractAST {
    public PathPart(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExpression() {
        return false;
    }

    public Expression getExpression() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPathChars() {
        return false;
    }

    public PathChars getPathChars() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTail() {
        return false;
    }

    public PathTail getTail() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPre() {
        return false;
    }

    public PrePathChars getPre() {
        throw new UnsupportedOperationException();
    }

    public boolean isInterpolated() {
        return false;
    }

    public boolean isNonInterpolated() {
        return false;
    }

    public static class NonInterpolated
    extends PathPart {
        private final PathChars pathChars;

        public NonInterpolated(ISourceLocation src, IConstructor node, PathChars pathChars) {
            super(src, node);
            this.pathChars = pathChars;
        }

        @Override
        public boolean isNonInterpolated() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitPathPartNonInterpolated(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.pathChars.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.pathChars.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NonInterpolated)) {
                return false;
            }
            NonInterpolated tmp = (NonInterpolated)o;
            return tmp.pathChars.equals(this.pathChars);
        }

        @Override
        public int hashCode() {
            return 967 + 257 * this.pathChars.hashCode();
        }

        @Override
        public PathChars getPathChars() {
            return this.pathChars;
        }

        @Override
        public boolean hasPathChars() {
            return true;
        }

        @Override
        public Object clone() {
            return NonInterpolated.newInstance(this.getClass(), this.src, null, this.clone(this.pathChars));
        }
    }

    public static class Interpolated
    extends PathPart {
        private final PrePathChars pre;
        private final Expression expression;
        private final PathTail tail;

        public Interpolated(ISourceLocation src, IConstructor node, PrePathChars pre, Expression expression, PathTail tail) {
            super(src, node);
            this.pre = pre;
            this.expression = expression;
            this.tail = tail;
        }

        @Override
        public boolean isInterpolated() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitPathPartInterpolated(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.pre.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.pre.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.tail.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tail.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Interpolated)) {
                return false;
            }
            Interpolated tmp = (Interpolated)o;
            return tmp.pre.equals(this.pre) && tmp.expression.equals(this.expression) && tmp.tail.equals(this.tail);
        }

        @Override
        public int hashCode() {
            return 383 + 853 * this.pre.hashCode() + 743 * this.expression.hashCode() + 331 * this.tail.hashCode();
        }

        @Override
        public PrePathChars getPre() {
            return this.pre;
        }

        @Override
        public boolean hasPre() {
            return true;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public PathTail getTail() {
            return this.tail;
        }

        @Override
        public boolean hasTail() {
            return true;
        }

        @Override
        public Object clone() {
            return Interpolated.newInstance(this.getClass(), this.src, null, this.clone(this.pre), this.clone(this.expression), this.clone(this.tail));
        }
    }
}

