/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.QualifiedName;

public abstract class ShellCommand
extends AbstractAST {
    public ShellCommand(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExpression() {
        return false;
    }

    public Expression getExpression() {
        throw new UnsupportedOperationException();
    }

    public boolean hasName() {
        return false;
    }

    public QualifiedName getName() {
        throw new UnsupportedOperationException();
    }

    public boolean isClear() {
        return false;
    }

    public boolean isEdit() {
        return false;
    }

    public boolean isHelp() {
        return false;
    }

    public boolean isHistory() {
        return false;
    }

    public boolean isListDeclarations() {
        return false;
    }

    public boolean isListModules() {
        return false;
    }

    public boolean isQuit() {
        return false;
    }

    public boolean isSetOption() {
        return false;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isUndeclare() {
        return false;
    }

    public boolean isUnimport() {
        return false;
    }

    public static class Unimport
    extends ShellCommand {
        private final QualifiedName name;

        public Unimport(ISourceLocation src, IConstructor node, QualifiedName name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isUnimport() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandUnimport(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Unimport)) {
                return false;
            }
            Unimport tmp = (Unimport)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 607 + 631 * this.name.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Unimport.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }

    public static class Undeclare
    extends ShellCommand {
        private final QualifiedName name;

        public Undeclare(ISourceLocation src, IConstructor node, QualifiedName name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isUndeclare() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandUndeclare(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Undeclare)) {
                return false;
            }
            Undeclare tmp = (Undeclare)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 857 + 127 * this.name.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Undeclare.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }

    public static class Test
    extends ShellCommand {
        public Test(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isTest() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandTest(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Test)) {
                return false;
            }
            Test tmp = (Test)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 997;
        }

        @Override
        public Object clone() {
            return Test.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class SetOption
    extends ShellCommand {
        private final QualifiedName name;
        private final Expression expression;

        public SetOption(ISourceLocation src, IConstructor node, QualifiedName name, Expression expression) {
            super(src, node);
            this.name = name;
            this.expression = expression;
        }

        @Override
        public boolean isSetOption() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandSetOption(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.expression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.expression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SetOption)) {
                return false;
            }
            SetOption tmp = (SetOption)o;
            return tmp.name.equals(this.name) && tmp.expression.equals(this.expression);
        }

        @Override
        public int hashCode() {
            return 383 + 397 * this.name.hashCode() + 929 * this.expression.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasExpression() {
            return true;
        }

        @Override
        public Object clone() {
            return SetOption.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.expression));
        }
    }

    public static class Quit
    extends ShellCommand {
        public Quit(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isQuit() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandQuit(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Quit)) {
                return false;
            }
            Quit tmp = (Quit)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 479;
        }

        @Override
        public Object clone() {
            return Quit.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class ListModules
    extends ShellCommand {
        public ListModules(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isListModules() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandListModules(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ListModules)) {
                return false;
            }
            ListModules tmp = (ListModules)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 907;
        }

        @Override
        public Object clone() {
            return ListModules.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class ListDeclarations
    extends ShellCommand {
        public ListDeclarations(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isListDeclarations() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandListDeclarations(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ListDeclarations)) {
                return false;
            }
            ListDeclarations tmp = (ListDeclarations)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 271;
        }

        @Override
        public Object clone() {
            return ListDeclarations.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class History
    extends ShellCommand {
        public History(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isHistory() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandHistory(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof History)) {
                return false;
            }
            History tmp = (History)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 523;
        }

        @Override
        public Object clone() {
            return History.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Help
    extends ShellCommand {
        public Help(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isHelp() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandHelp(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Help)) {
                return false;
            }
            Help tmp = (Help)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 983;
        }

        @Override
        public Object clone() {
            return Help.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Edit
    extends ShellCommand {
        private final QualifiedName name;

        public Edit(ISourceLocation src, IConstructor node, QualifiedName name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isEdit() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandEdit(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Edit)) {
                return false;
            }
            Edit tmp = (Edit)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 727 + 449 * this.name.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Edit.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }

    public static class Clear
    extends ShellCommand {
        public Clear(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isClear() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitShellCommandClear(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Clear)) {
                return false;
            }
            Clear tmp = (Clear)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 283;
        }

        @Override
        public Object clone() {
            return Clear.newInstance(this.getClass(), this.src, null);
        }
    }
}

