/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.BasicType;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.TypeArg;

public abstract class StructuredType
extends AbstractAST {
    public StructuredType(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasArguments() {
        return false;
    }

    public List<TypeArg> getArguments() {
        throw new UnsupportedOperationException();
    }

    public boolean hasBasicType() {
        return false;
    }

    public BasicType getBasicType() {
        throw new UnsupportedOperationException();
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends StructuredType {
        private final BasicType basicType;
        private final List<TypeArg> arguments;

        public Default(ISourceLocation src, IConstructor node, BasicType basicType, List<TypeArg> arguments) {
            super(src, node);
            this.basicType = basicType;
            this.arguments = arguments;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitStructuredTypeDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.basicType.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.basicType.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.arguments) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.basicType.equals(this.basicType) && tmp.arguments.equals(this.arguments);
        }

        @Override
        public int hashCode() {
            return 653 + 73 * this.basicType.hashCode() + 991 * this.arguments.hashCode();
        }

        @Override
        public BasicType getBasicType() {
            return this.basicType;
        }

        @Override
        public boolean hasBasicType() {
            return true;
        }

        @Override
        public List<TypeArg> getArguments() {
            return this.arguments;
        }

        @Override
        public boolean hasArguments() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.basicType), this.clone(this.arguments));
        }
    }
}

