/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.Type;

public abstract class TypeVar
extends AbstractAST {
    public TypeVar(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasBound() {
        return false;
    }

    public Type getBound() {
        throw new UnsupportedOperationException();
    }

    public boolean isBounded() {
        return false;
    }

    public boolean isFree() {
        return false;
    }

    public static class Free
    extends TypeVar {
        private final Name name;

        public Free(ISourceLocation src, IConstructor node, Name name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isFree() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeVarFree(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Free)) {
                return false;
            }
            Free tmp = (Free)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 331 + 167 * this.name.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Free.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }

    public static class Bounded
    extends TypeVar {
        private final Name name;
        private final Type bound;

        public Bounded(ISourceLocation src, IConstructor node, Name name, Type bound) {
            super(src, node);
            this.name = name;
            this.bound = bound;
        }

        @Override
        public boolean isBounded() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeVarBounded(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.bound.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.bound.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Bounded)) {
                return false;
            }
            Bounded tmp = (Bounded)o;
            return tmp.name.equals(this.name) && tmp.bound.equals(this.bound);
        }

        @Override
        public int hashCode() {
            return 173 + 541 * this.name.hashCode() + 491 * this.bound.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Type getBound() {
            return this.bound;
        }

        @Override
        public boolean hasBound() {
            return true;
        }

        @Override
        public Object clone() {
            return Bounded.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.bound));
        }
    }
}

