/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.env;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.staticErrors.UndeclaredModule;
import org.rascalmpl.interpreter.utils.Names;

public class GlobalEnvironment {
    private final HashMap<String, ModuleEnvironment> moduleEnvironment = new HashMap();
    private final HashMap<String, URI> moduleLocations = new HashMap();
    private final HashMap<URI, String> locationModules = new HashMap();
    private final Deque<String> extendStack = new ArrayDeque<String>();
    private final HashMap<String, ICallableValue> sourceResolvers = new HashMap();
    private boolean bootstrapper;

    public void pushExtend(String module) {
        this.extendStack.push(module);
    }

    public void popExtend() {
        this.extendStack.pop();
    }

    public boolean isCyclicExtend(String module) {
        return this.extendStack.contains(module);
    }

    public void clear() {
        this.moduleEnvironment.clear();
        this.moduleLocations.clear();
        this.locationModules.clear();
        this.sourceResolvers.clear();
    }

    public void registerSourceResolver(String scheme, ICallableValue function) {
        this.sourceResolvers.put(scheme, function);
    }

    public ModuleEnvironment addModule(ModuleEnvironment mod) {
        assert (mod != null);
        ModuleEnvironment env = this.moduleEnvironment.get(mod.getName());
        if (env == null) {
            this.moduleEnvironment.put(mod.getName(), mod);
            return mod;
        }
        if (env == mod) {
            return mod;
        }
        throw new ImplementationError("Reinstantiating same module " + mod.getName());
    }

    public ModuleEnvironment resetModule(String name) {
        ModuleEnvironment mod = this.moduleEnvironment.get(name);
        mod.reset();
        return mod;
    }

    public ModuleEnvironment getModule(String name) {
        return this.moduleEnvironment.get(name);
    }

    public ModuleEnvironment getModule(QualifiedName name, AbstractAST ast) {
        ModuleEnvironment module = this.getModule(Names.fullName(name));
        if (module == null) {
            throw new UndeclaredModule(Names.fullName(name), ast);
        }
        return module;
    }

    public boolean existsModule(String name) {
        return this.moduleEnvironment.containsKey(name);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("heap.modules: ");
        for (String mod : this.moduleEnvironment.keySet()) {
            res.append(mod + ",");
        }
        return res.toString();
    }

    public void removeModule(ModuleEnvironment env) {
        this.moduleEnvironment.remove(env.getName());
    }

    public void setModuleURI(String name, URI location) {
        this.moduleLocations.put(name, location);
        this.locationModules.put(location, name);
    }

    public URI getModuleURI(String name) {
        return this.moduleLocations.get(name);
    }

    public String getModuleForURI(URI location) {
        return this.locationModules.get(location);
    }

    public Environment getEnvironmentForName(QualifiedName name, Environment current) {
        if (Names.isQualified(name)) {
            ModuleEnvironment mod = this.getModule(Names.moduleName(name));
            if (mod == null) {
                throw new UndeclaredModule(Names.moduleName(name), name);
            }
            return mod;
        }
        return current;
    }

    public Set<String> getImportingModules(String mod) {
        HashSet<String> result = new HashSet<String>();
        for (ModuleEnvironment env : this.moduleEnvironment.values()) {
            if (!env.getImports().contains(mod)) continue;
            result.add(env.getName());
        }
        return result;
    }

    public Set<String> getExtendingModules(String mod) {
        HashSet<String> result = new HashSet<String>();
        ArrayDeque<String> todo = new ArrayDeque<String>();
        todo.add(mod);
        while (!todo.isEmpty()) {
            String next = (String)todo.remove();
            for (ModuleEnvironment env : this.moduleEnvironment.values()) {
                String extending;
                if (!env.getExtends().contains(next) || todo.contains(extending = env.getName()) || result.contains(extending)) continue;
                todo.addFirst(extending);
                result.add(extending);
            }
            result.add(next);
        }
        result.remove(mod);
        return result;
    }

    public AbstractFunction getResourceImporter(String resourceScheme) {
        for (ModuleEnvironment menv : this.moduleEnvironment.values()) {
            if (!menv.hasImporterForResource(resourceScheme)) continue;
            return menv.getResourceImporter(resourceScheme);
        }
        return null;
    }

    public void isBootstrapper(boolean b) {
        this.bootstrapper = b;
    }

    public boolean isBootstrapper() {
        return this.bootstrapper;
    }

    public List<String> getExtendCycle() {
        return Collections.unmodifiableList(this.extendStack.stream().collect(Collectors.toList()));
    }
}

