/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.semantics.dynamic.Tree;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class ConcreteOptPattern
extends AbstractMatchingResult {
    private final Opt type;
    private final IConstructor production;
    private final IMatchingResult optArg;

    public ConcreteOptPattern(IEvaluatorContext ctx, Tree.Appl x, List<IMatchingResult> list) {
        super(ctx, x);
        this.production = x.getProduction();
        if (list.size() == 0) {
            this.type = Opt.NotExist;
            this.optArg = null;
        } else if (list.size() == 1) {
            this.optArg = list.get(0);
            NonTerminalType nont = (NonTerminalType)this.optArg.getType(ctx.getCurrentEnvt(), null);
            this.type = SymbolAdapter.isOpt(nont.getSymbol()) ? Opt.MayExist : Opt.Exist;
        } else {
            throw new ImplementationError("optional with more than one element???", x.getLocation());
        }
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
        if (!subject.getStaticType().isSubtypeOf(RascalValueFactory.Tree)) {
            this.hasNext = false;
            return;
        }
        ITree tree = (ITree)subject.getValue();
        if (tree.getConstructorType() != RascalValueFactory.Tree_Appl) {
            this.hasNext = false;
            return;
        }
        IConstructor prod = TreeAdapter.getProduction(tree);
        if (!prod.equals(this.production)) {
            this.hasNext = false;
            return;
        }
        IList args = TreeAdapter.getArgs(tree);
        switch (this.type) {
            case MayExist: {
                this.optArg.initMatch(subject);
                this.hasNext = this.optArg.hasNext();
                return;
            }
            case Exist: {
                if (args.length() == 1) {
                    IConstructor arg = (IConstructor)args.get(0);
                    Type argType = RascalTypeFactory.getInstance().nonTerminalType(arg);
                    Result<IValue> argResult = ResultFactory.makeResult(argType, arg, this.ctx);
                    this.optArg.initMatch(argResult);
                    this.hasNext = this.optArg.hasNext();
                    return;
                }
                this.hasNext = false;
                return;
            }
            case NotExist: {
                this.hasNext = args.length() == 0;
                return;
            }
        }
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        return RascalTypeFactory.getInstance().nonTerminalType(ProductionAdapter.getType(this.production));
    }

    @Override
    public boolean hasNext() {
        if (!this.hasNext) {
            return false;
        }
        switch (this.type) {
            case MayExist: {
                return this.optArg.hasNext();
            }
            case Exist: {
                return this.optArg.hasNext();
            }
            case NotExist: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean next() {
        if (!this.hasNext()) {
            return false;
        }
        if (this.optArg != null) {
            return this.optArg.next();
        }
        this.hasNext = false;
        return true;
    }

    @Override
    public List<IVarPattern> getVariables() {
        if (this.optArg != null) {
            return this.optArg.getVariables();
        }
        return Collections.emptyList();
    }

    private static enum Opt {
        Exist,
        NotExist,
        MayExist;

    }
}

