/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.RedeclaredVariable;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.semantics.dynamic.QualifiedName;

public class QualifiedNamePattern
extends AbstractMatchingResult
implements IVarPattern {
    protected QualifiedName name;
    protected Type declaredType;
    protected boolean anonymous = false;
    protected boolean debug = false;
    protected boolean iWroteItMySelf;

    public QualifiedNamePattern(IEvaluatorContext ctx, Expression x, QualifiedName name) {
        super(ctx, x);
        Result<IValue> varRes;
        this.name = name;
        if (this.debug) {
            System.err.println("QualifiedNamePattern: " + name);
        }
        this.anonymous = this.getName().equals("_");
        Environment env = ctx.getCurrentEnvt();
        this.declaredType = this.anonymous ? TypeFactory.getInstance().valueType() : ((varRes = env.getSimpleVariable(name)) == null || varRes.getStaticType() == null ? TypeFactory.getInstance().valueType() : varRes.getStaticType());
        this.iWroteItMySelf = false;
    }

    public QualifiedNamePattern(IEvaluatorContext ctx) {
        super(ctx, null);
        this.anonymous = true;
        this.declaredType = TypeFactory.getInstance().valueType();
        this.iWroteItMySelf = false;
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        Type ot;
        if (this.anonymous) {
            return this.declaredType;
        }
        if (patternVars != null && patternVars.containsKey(this.getName()) && (ot = patternVars.get(this.getName()).getType()).compareTo(this.declaredType) < 0) {
            this.declaredType = ot;
        }
        return this.declaredType;
    }

    @Override
    public List<IVarPattern> getVariables() {
        LinkedList<IVarPattern> res = new LinkedList<IVarPattern>();
        res.addFirst(this);
        return res;
    }

    public String getName() {
        return ((QualifiedName.Default)this.name).lastName();
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public boolean next() {
        this.checkInitialized();
        if (!this.hasNext) {
            return false;
        }
        this.hasNext = false;
        if (this.debug) {
            System.err.println("AbstractPatternQualifiedName.match: " + this.name);
        }
        if (this.anonymous) {
            return true;
        }
        if (this.iWroteItMySelf) {
            this.ctx.getCurrentEnvt().storeVariable(this.name, (Result<IValue>)this.subject);
            return true;
        }
        Result<IValue> varRes = this.ctx.getCurrentEnvt().getSimpleVariable(this.name);
        if (varRes == null) {
            this.declaredType = this.subject.getStaticType();
            if (!this.ctx.getCurrentEnvt().declareVariable(this.declaredType, this.getName())) {
                throw new RedeclaredVariable(this.getName(), this.ctx.getCurrentAST());
            }
            this.ctx.getCurrentEnvt().storeVariable(this.name, (Result<IValue>)this.subject);
            this.iWroteItMySelf = true;
            return true;
        }
        if (varRes.getValue() == null) {
            this.declaredType = varRes.getStaticType();
            if (!this.ctx.getCurrentEnvt().declareVariable(this.declaredType, this.getName())) {
                throw new RedeclaredVariable(this.getName(), this.ctx.getCurrentAST());
            }
            this.ctx.getCurrentEnvt().storeVariable(this.name, (Result<IValue>)this.subject);
            this.iWroteItMySelf = true;
            return true;
        }
        if (this.debug) {
            System.err.printf("subject.getTYpe() = %s, varRes.getType() = %s\n", this.subject.getValue().getType(), varRes.getStaticType());
        }
        if (this.subject.getValue().getType().isSubtypeOf(varRes.getStaticType())) {
            if (this.debug) {
                System.err.println("returns " + this.subject.equals(varRes));
            }
            return this.subject.getValue().match(varRes.getValue());
        }
        return false;
    }

    public String toString() {
        return Names.fullName(this.name);
    }

    public boolean bindingInstance() {
        return this.iWroteItMySelf;
    }

    @Override
    public boolean isVarIntroducing() {
        return this.bindingInstance();
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public Type getType() {
        return this.declaredType;
    }

    @Override
    public void updateType(Type type) {
        this.declaredType = type;
    }
}

