/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.IntegerResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.NumberResult;
import org.rascalmpl.interpreter.result.RealResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;

public class RationalResult
extends ElementResult<IRational> {
    public RationalResult(Type type, IRational n, IEvaluatorContext ctx) {
        super(type, n, ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addRational(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> multiply(Result<V> result) {
        return result.multiplyRational(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> result) {
        return result.subtractRational(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> divide(Result<V> result) {
        return result.divideRational(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> makeRange(Result<V> that) {
        return that.makeRangeFromRational(this);
    }

    @Override
    public <U extends IValue, V extends IValue, W extends IValue> Result<U> makeStepRange(Result<V> to, Result<W> step) {
        return to.makeStepRangeFromRational(this, step);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToRational(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToRational(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> result) {
        return result.lessThanOrEqualRational(this);
    }

    @Override
    public <U extends IValue> Result<U> negative() {
        return ResultFactory.makeResult(this.type, ((IRational)this.getValue()).negate(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addRational(RationalResult n) {
        return ResultFactory.makeResult(this.type, ((IRational)this.getValue()).add((IRational)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractRational(RationalResult n) {
        return ResultFactory.makeResult(this.type, ((IRational)n.getValue()).subtract((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyRational(RationalResult n) {
        return ResultFactory.makeResult(this.type, ((IRational)this.getValue()).multiply((IRational)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideRational(RationalResult n) {
        try {
            return ResultFactory.makeResult(this.type, ((IRational)n.getValue()).divide((IRational)this.getValue()), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected <U extends IValue> Result<U> addInteger(IntegerResult n) {
        return ResultFactory.makeResult(this.type, ((IRational)this.getValue()).toRational().add((IInteger)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractInteger(IntegerResult n) {
        return ResultFactory.makeResult(this.type, ((IInteger)n.getValue()).toRational().subtract((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyInteger(IntegerResult n) {
        return ResultFactory.makeResult(this.type, ((IRational)this.getValue()).toRational().multiply((IInteger)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideInteger(IntegerResult n) {
        try {
            return ResultFactory.makeResult(this.type, ((IInteger)n.getValue()).toRational().divide((IRational)this.getValue()), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected <U extends IValue> Result<U> addReal(ElementResult<IReal> n) {
        return n.addRational(this);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyReal(ElementResult<IReal> n) {
        return n.multiplyRational(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractReal(ElementResult<IReal> n) {
        return this.widenToReal().subtractReal(n);
    }

    @Override
    protected <U extends IValue> Result<U> divideReal(ElementResult<IReal> n) {
        return this.widenToReal().divideReal(n);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromRational(RationalResult from) {
        return this.makeRangeWithDefaultStep(from);
    }

    private <U extends IValue, V extends INumber> Result<U> makeRangeWithDefaultStep(Result<V> from) {
        if (((INumber)from.getValue()).less((IRational)this.getValue()).getValue()) {
            return RationalResult.makeStepRangeFromToWithSecond(from, this, ResultFactory.makeResult(from.getStaticType(), ((INumber)from.getValue()).add(this.getValueFactory().rational(1, 1)), this.ctx), this.getValueFactory(), this.getTypeFactory(), this.ctx);
        }
        return RationalResult.makeStepRangeFromToWithSecond(from, this, ResultFactory.makeResult(from.getStaticType(), ((INumber)from.getValue()).subtract(this.getValueFactory().integer(1)), this.ctx), this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromRational(RationalResult from, Result<V> second) {
        return RationalResult.makeStepRangeFromToWithSecond(from, this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromReal(ElementResult<IReal> from) {
        return this.makeRangeWithDefaultStep(from);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromInteger(IntegerResult from) {
        return this.makeRangeWithDefaultStep(from);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromReal(ElementResult<IReal> from, Result<V> second) {
        return RationalResult.makeStepRangeFromToWithSecond(from, this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromNumber(NumberResult from) {
        return this.makeRangeWithDefaultStep(from);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromNumber(NumberResult from, Result<V> second) {
        return RationalResult.makeStepRangeFromToWithSecond(from, this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    public static <U extends IValue, V extends INumber, W extends INumber, X extends IValue> Result<U> makeStepRangeFromToWithSecond(Result<V> from, Result<W> to, Result<X> second, IValueFactory vf, TypeFactory tf, IEvaluatorContext ctx) {
        INumber iFrom = (INumber)from.getValue();
        INumber iTo = (INumber)to.getValue();
        if (!second.getStaticType().isSubtypeOf(tf.numberType())) {
            throw new UnexpectedType(tf.numberType(), second.getStaticType(), ctx.getCurrentAST());
        }
        INumber iSecond = (INumber)second.getValue();
        INumber diff = iSecond.subtract(iFrom);
        INumber zero = diff.subtract(diff);
        Type resultType = second.getStaticType().lub(from.getStaticType().lub(to.getStaticType()));
        IListWriter w = vf.listWriter();
        if (iFrom.lessEqual(iTo).getValue() && diff.greater(zero).getValue()) {
            do {
                w.append(iFrom);
                iFrom = iFrom.add(diff);
                if (!ctx.isInterrupted()) continue;
                throw new InterruptException(ctx.getStackTrace(), ctx.getCurrentAST().getLocation());
            } while (iFrom.lessEqual(iTo).getValue());
        } else if (iFrom.greaterEqual(iTo).getValue() && diff.less(zero).getValue()) {
            do {
                w.append(iFrom);
            } while ((iFrom = iFrom.add(diff)).greaterEqual(iTo).getValue());
        }
        return ResultFactory.makeResult(tf.listType(resultType), w.done(), ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addListRelation(ListRelationResult that) {
        return that.addRational(this);
    }

    @Override
    protected <U extends IValue> Result<U> addRelation(RelationResult that) {
        return that.addRational(this);
    }

    @Override
    protected Result<IBool> equalToRational(RationalResult that) {
        return ResultFactory.bool(((IRational)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> equalToInteger(IntegerResult that) {
        return ResultFactory.bool(((IInteger)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToRational(RationalResult that) {
        return ResultFactory.bool(!((IRational)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToReal(RealResult that) {
        return ResultFactory.bool(!((IReal)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualRational(RationalResult that) {
        return new LessThanOrEqualResult(((IRational)that.getValue()).less((IRational)this.getValue()).getValue(), ((IRational)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualInteger(IntegerResult that) {
        return new LessThanOrEqualResult(((IInteger)that.getValue()).less((IRational)this.getValue()).getValue(), ((IInteger)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).less((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).less((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanReal(RealResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).less((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IRational)that.getValue()).less((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).greater((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).greater((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).greaterEqual((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).greaterEqual((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IRational)that.getValue()).greaterEqual((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualReal(ElementResult<IReal> that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).greaterEqual((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IRational)that.getValue()).greater((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanReal(ElementResult<IReal> that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).greater((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> equalToReal(RealResult that) {
        return ResultFactory.bool(((IReal)that.getValue()).compare((INumber)this.getValue()) == 0, this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualReal(ElementResult<IReal> that) {
        return new LessThanOrEqualResult(((IReal)that.getValue()).less((IRational)this.getValue()).getValue(), ((IReal)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }

    <U extends IValue> Result<U> widenToReal() {
        return ResultFactory.makeResult(this.getTypeFactory().realType(), ((IRational)this.getValue()).toReal(this.getValueFactory().getPrecision()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addNumber(NumberResult n) {
        return ResultFactory.makeResult(this.type, ((IRational)this.getValue()).add((INumber)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractNumber(NumberResult n) {
        return ResultFactory.makeResult(this.type, ((INumber)n.getValue()).subtract((IRational)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyNumber(NumberResult n) {
        return ResultFactory.makeResult(this.type, ((IRational)this.getValue()).multiply((INumber)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideNumber(NumberResult n) {
        try {
            return ResultFactory.makeResult(n.getStaticType(), ((INumber)n.getValue()).divide((IRational)this.getValue(), this.getValueFactory().getPrecision()), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected Result<IBool> equalToNumber(NumberResult that) {
        return ResultFactory.bool(((INumber)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToNumber(NumberResult that) {
        return ResultFactory.bool(!((INumber)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualNumber(NumberResult that) {
        return new LessThanOrEqualResult(((INumber)that.getValue()).less((IRational)this.getValue()).getValue(), ((INumber)that.getValue()).equal((IRational)this.getValue()).getValue(), this.ctx);
    }
}

