/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.BoolResult;
import org.rascalmpl.interpreter.result.ConcreteSyntaxResult;
import org.rascalmpl.interpreter.result.ConstructorResult;
import org.rascalmpl.interpreter.result.DateTimeResult;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.FunctionResultFacade;
import org.rascalmpl.interpreter.result.IntegerResult;
import org.rascalmpl.interpreter.result.ListOrRelationResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.ListResult;
import org.rascalmpl.interpreter.result.MapResult;
import org.rascalmpl.interpreter.result.NodeResult;
import org.rascalmpl.interpreter.result.NumberResult;
import org.rascalmpl.interpreter.result.OverloadedFunction;
import org.rascalmpl.interpreter.result.RationalResult;
import org.rascalmpl.interpreter.result.RealResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.SetOrRelationResult;
import org.rascalmpl.interpreter.result.SetResult;
import org.rascalmpl.interpreter.result.SourceLocationResult;
import org.rascalmpl.interpreter.result.StringResult;
import org.rascalmpl.interpreter.result.TupleResult;
import org.rascalmpl.interpreter.result.ValueResult;
import org.rascalmpl.interpreter.result.VoidResult;
import org.rascalmpl.types.RascalType;
import org.rascalmpl.values.RascalValueFactory;

public class ResultFactory {
    public static <T extends IValue> Result<T> makeResult(Type declaredType, IValue value, IEvaluatorContext ctx) {
        return declaredType.accept(new Visitor(declaredType, value, ctx));
    }

    public static <T extends IValue> Result<T> nothing() {
        Type type = TypeFactory.getInstance().voidType();
        return type.accept(new Visitor(type, null, null));
    }

    public static <T extends IValue> Result<T> nothing(Type type) {
        return type.accept(new Visitor(type, null, null));
    }

    public static Result<IBool> bool(boolean b, IEvaluatorContext ctx) {
        IValueFactory vf = ctx.getValueFactory();
        IBool result = vf.bool(b);
        return new BoolResult(result.getType(), result, ctx);
    }

    private static class Visitor
    implements ITypeVisitor<Result<? extends IValue>, RuntimeException> {
        private IValue value;
        private Type declaredType;
        private IEvaluatorContext ctx;

        public Visitor(Type type, IValue value, IEvaluatorContext ctx) {
            this.declaredType = type;
            this.value = value;
            this.ctx = ctx;
        }

        @Override
        public ElementResult<? extends IValue> visitAbstractData(Type type) {
            if (type.isSubtypeOf(RascalValueFactory.Tree)) {
                return new ConcreteSyntaxResult(this.declaredType, (IConstructor)this.value, this.ctx);
            }
            return new ConstructorResult(this.declaredType, (IConstructor)this.value, this.ctx);
        }

        @Override
        public Result<? extends IValue> visitAlias(Type type) {
            return type.getAliased().accept(this);
        }

        @Override
        public BoolResult visitBool(Type boolType) {
            return new BoolResult(this.declaredType, (IBool)this.value, this.ctx);
        }

        @Override
        public Result<? extends IValue> visitConstructor(Type type) {
            if (RascalType.isNonterminal(RascalValueFactory.Tree)) {
                return new ConcreteSyntaxResult(this.declaredType, (IConstructor)this.value, this.ctx);
            }
            if (RascalType.isFunction(type)) {
                return (AbstractFunction)this.value;
            }
            return new ConstructorResult(this.declaredType.getAbstractDataType(), (IConstructor)this.value, this.ctx);
        }

        @Override
        public ElementResult<IReal> visitReal(Type type) {
            return new RealResult(this.declaredType, (IReal)this.value, this.ctx);
        }

        @Override
        public IntegerResult visitInteger(Type type) {
            return new IntegerResult(this.declaredType, (IInteger)this.value, this.ctx);
        }

        @Override
        public RationalResult visitRational(Type type) {
            return new RationalResult(this.declaredType, (IRational)this.value, this.ctx);
        }

        @Override
        public NumberResult visitNumber(Type type) {
            return new NumberResult(this.declaredType, (INumber)this.value, this.ctx);
        }

        @Override
        public ListOrRelationResult<IList> visitList(Type type) {
            if (type.isListRelation()) {
                if (this.value != null && !this.value.getType().isListRelation()) {
                    throw new ImplementationError("somehow a list relation value turned into a list, but its type did not change with it", this.ctx.getCurrentAST().getLocation());
                }
                return new ListRelationResult(this.declaredType, (IList)this.value, this.ctx);
            }
            return new ListResult(this.declaredType, (IList)this.value, this.ctx);
        }

        @Override
        public MapResult visitMap(Type type) {
            return new MapResult(this.declaredType, (IMap)this.value, this.ctx);
        }

        @Override
        public ElementResult<? extends IValue> visitNode(Type type) {
            if (type.isSubtypeOf(RascalValueFactory.Tree)) {
                return new ConcreteSyntaxResult(this.declaredType, (IConstructor)this.value, this.ctx);
            }
            return new NodeResult(this.declaredType, (INode)this.value, this.ctx);
        }

        @Override
        public Result<? extends IValue> visitParameter(Type parameterType) {
            Type instantiated;
            if (this.ctx != null && parameterType != (instantiated = parameterType.instantiate(this.ctx.getEvaluator().getCurrentEnvt().getStaticTypeBindings()))) {
                return instantiated.accept(this);
            }
            return parameterType.getBound().accept(this);
        }

        @Override
        public SetOrRelationResult<ISet> visitSet(Type type) {
            if (type.isRelation()) {
                if (this.value != null && !this.value.getType().isRelation()) {
                    throw new ImplementationError("somehow a relation value turned into a set, but its type did not change with it", this.ctx.getCurrentAST().getLocation());
                }
                return new RelationResult(this.declaredType, (ISet)this.value, this.ctx);
            }
            return new SetResult(this.declaredType, (ISet)this.value, this.ctx);
        }

        @Override
        public SourceLocationResult visitSourceLocation(Type type) {
            return new SourceLocationResult(this.declaredType, (ISourceLocation)this.value, this.ctx);
        }

        @Override
        public StringResult visitString(Type type) {
            return new StringResult(this.declaredType, (IString)this.value, this.ctx);
        }

        @Override
        public TupleResult visitTuple(Type type) {
            return new TupleResult(this.declaredType, (ITuple)this.value, this.ctx);
        }

        @Override
        public Result<?> visitFunction(Type type) {
            if (this.value instanceof AbstractFunction) {
                if (this.value.getType() != type) {
                    return new FunctionResultFacade(type, (AbstractFunction)this.value, this.ctx);
                }
                return (AbstractFunction)this.value;
            }
            if (this.value instanceof OverloadedFunction) {
                if (this.value.getType() != type) {
                    return new FunctionResultFacade(type, (OverloadedFunction)this.value, this.ctx);
                }
                return (OverloadedFunction)this.value;
            }
            return new ValueResult(this.declaredType, this.value, this.ctx);
        }

        @Override
        public ValueResult visitValue(Type type) {
            return new ValueResult(this.declaredType, this.value, this.ctx);
        }

        @Override
        public VoidResult visitVoid(Type type) {
            return new VoidResult(this.declaredType, this.ctx);
        }

        @Override
        public Result<? extends IValue> visitExternal(Type externalType) {
            if (!RascalType.isFunction(externalType)) {
                if (RascalType.isNonterminal(externalType)) {
                    return new ConcreteSyntaxResult(externalType, (IConstructor)this.value, this.ctx);
                }
                if (RascalType.isReified(externalType)) {
                    return new ConstructorResult(externalType, (IConstructor)this.value, this.ctx);
                }
            }
            return new ValueResult(this.declaredType, this.value, this.ctx);
        }

        @Override
        public Result<? extends IValue> visitDateTime(Type type) {
            return new DateTimeResult(this.declaredType, (IDateTime)this.value, this.ctx);
        }
    }
}

