/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.SourceLocationResult;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnsupportedSubscriptArity;

public class StringResult
extends ElementResult<IString> {
    private IString string;

    public StringResult(Type type, IString string, IEvaluatorContext ctx) {
        super(type, string, ctx);
        this.string = string;
    }

    @Override
    public Result<IBool> isKeyDefined(Result<?>[] subscripts) {
        if (subscripts.length != 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        Result<?> key = subscripts[0];
        if (!key.getStaticType().isSubtypeOf(this.getTypeFactory().integerType())) {
            throw new UnexpectedType(this.getTypeFactory().integerType(), key.getStaticType(), this.ctx.getCurrentAST());
        }
        int idx = ((IInteger)key.getValue()).intValue();
        int len = this.getValue().length();
        if (idx >= 0 && idx >= len || idx < 0 && idx < -len) {
            return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(false), this.ctx);
        }
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), this.getValueFactory().bool(true), this.ctx);
    }

    @Override
    public IString getValue() {
        return this.string;
    }

    protected int length() {
        return this.string.getValue().length();
    }

    protected void yield(StringBuilder b) {
        b.append(this.string.getValue());
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addString(this);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToString(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToString(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> result) {
        return result.lessThanString(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> result) {
        return result.lessThanOrEqualString(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> result) {
        return result.greaterThanString(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> result) {
        return result.greaterThanOrEqualString(this);
    }

    @Override
    protected <U extends IValue> Result<U> addString(StringResult s2) {
        return ResultFactory.makeResult(this.getStaticType(), s2.getValue().concat(this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> equalToString(StringResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> greaterThanString(StringResult that) {
        return ResultFactory.bool(that.getValue().compare(this.getValue()) > 0, this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualString(StringResult that) {
        return ResultFactory.bool(that.getValue().compare(this.getValue()) >= 0, this.ctx);
    }

    @Override
    protected Result<IBool> lessThanString(StringResult that) {
        return ResultFactory.bool(that.getValue().compare(this.getValue()) < 0, this.ctx);
    }

    @Override
    public Result<IValue> call(Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
        String name = this.getValue().getValue();
        INode node = this.getValueFactory().node(name, argValues, keyArgValues);
        return ResultFactory.makeResult(this.getTypeFactory().nodeType(), node, this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToString(StringResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualString(StringResult that) {
        int cmp = that.getValue().compare(this.getValue());
        return new LessThanOrEqualResult(cmp < 0, cmp == 0, this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addSourceLocation(SourceLocationResult that) {
        Result path = that.fieldAccess("path", new TypeStore(new TypeStore[0]));
        String parent = ((IString)path.getValue()).getValue();
        Object child = this.getValue().getValue();
        if (parent.endsWith("/")) {
            parent = parent.substring(0, parent.length() - 1);
        }
        if (!((String)child).startsWith("/")) {
            child = "/" + (String)child;
        }
        return that.fieldUpdate("path", ResultFactory.makeResult(this.getTypeFactory().stringType(), this.getValueFactory().string(parent + (String)child), this.ctx), new TypeStore(new TypeStore[0]));
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subscript(Result<?>[] subscripts) {
        if (subscripts.length != 1) {
            throw new UnsupportedSubscriptArity(this.getStaticType(), subscripts.length, this.ctx.getCurrentAST());
        }
        Result<?> key = subscripts[0];
        if (!key.getStaticType().isInteger()) {
            throw new UnexpectedType(TypeFactory.getInstance().integerType(), key.getStaticType(), this.ctx.getCurrentAST());
        }
        if (this.getValue().getValue().length() == 0) {
            throw RuntimeExceptionFactory.illegalArgument(this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        IInteger index = (IInteger)key.getValue();
        int idx = index.intValue();
        if (idx < 0) {
            idx += this.getValue().length();
        }
        if (idx >= this.getValue().length() || idx < 0) {
            throw RuntimeExceptionFactory.indexOutOfBounds(index, this.ctx.getCurrentAST(), this.ctx.getStackTrace());
        }
        return ResultFactory.makeResult(this.getStaticType(), this.getValue().substring(idx, idx + 1), this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> slice(Result<?> first, Result<?> second, Result<?> end) {
        return super.slice(first, second, end, this.getValue().length());
    }

    @Override
    public Result<IValue> makeSlice(int first, int second, int end) {
        StringBuilder buffer;
        block4: {
            buffer = new StringBuilder();
            IString s2 = this.getValue();
            int increment = second - first;
            if (first == end || increment == 0) break block4;
            if (first <= end) {
                for (int i = first; i >= 0 && i < end; i += increment) {
                    buffer.appendCodePoint(s2.charAt(i));
                }
            } else {
                for (int j = first; j >= 0 && j > end && j < this.getValue().length(); j += increment) {
                    buffer.appendCodePoint(s2.charAt(j));
                }
            }
        }
        return ResultFactory.makeResult(TypeFactory.getInstance().stringType(), this.getValueFactory().string(buffer.toString()), this.ctx);
    }
}

