/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import java.io.IOException;
import java.io.StringWriter;

public class LimitedResultWriter
extends StringWriter {
    private final int limit;
    private int position;
    private boolean limitReached;

    public LimitedResultWriter(int limit) {
        this.limit = limit;
        this.position = 0;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (this.position + len >= this.limit) {
            super.write(cbuf, off, len - (this.limit - this.position));
            this.limitReached = true;
            throw new IOLimitReachedException();
        }
        this.position += len;
        super.write(cbuf, off, len);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(int b) {
        if (this.position + 1 >= this.limit) {
            this.limitReached = true;
            throw new IOLimitReachedException();
        }
        ++this.position;
        super.write(b);
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.limitReached) {
            return result + "...";
        }
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() {
    }

    public static class IOLimitReachedException
    extends RuntimeException {
        private static final long serialVersionUID = -1396788285349799099L;

        public IOLimitReachedException() {
            super("Limit reached", null, true, false);
        }
    }
}

