/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern getLastIdentifier = Pattern.compile(".*?([\\\\]?[_a-zA-Z]([\\-_a-zA-Z0-9]|::[\\\\]?)*)\\s*$");

    public static String unescapeSingleQuoteAndBackslash(String str) {
        char[] chars = str.toCharArray();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            int b = chars[i];
            block0 : switch (b) {
                case 92: {
                    if (i >= chars.length - 1) {
                        b = 92;
                        break;
                    }
                    switch (chars[++i]) {
                        case '\\': {
                            b = 92;
                            break block0;
                        }
                        case '\'': {
                            b = 39;
                        }
                    }
                }
            }
            result.append((char)b);
        }
        return result.toString();
    }

    public static String unquote(String str) {
        return str.substring(1, str.length() - 1);
    }

    public static String unescapeBase(String str) {
        char[] chars = str.toCharArray();
        StringBuffer result = new StringBuffer();
        block18: for (int i = 0; i < chars.length; ++i) {
            int b = chars[i];
            switch (b) {
                case 92: {
                    switch (chars[++i]) {
                        case '\\': {
                            result.append('\\');
                            b = 92;
                            break;
                        }
                        case 'n': {
                            b = 10;
                            break;
                        }
                        case '\"': {
                            b = 34;
                            break;
                        }
                        case '\'': {
                            result.append('\\');
                            b = 39;
                            break;
                        }
                        case 't': {
                            b = 9;
                            break;
                        }
                        case 'b': {
                            b = 8;
                            break;
                        }
                        case 'f': {
                            b = 12;
                            break;
                        }
                        case 'r': {
                            b = 13;
                            break;
                        }
                        case '<': {
                            b = 60;
                            break;
                        }
                        case '>': {
                            b = 62;
                            break;
                        }
                        case 'a': {
                            StringBuilder a = new StringBuilder();
                            a.append(chars[++i]);
                            a.append(chars[++i]);
                            b = (char)Integer.parseInt(a.toString(), 16);
                            break;
                        }
                        case 'u': {
                            StringBuilder u = new StringBuilder();
                            u.append(chars[++i]);
                            u.append(chars[++i]);
                            u.append(chars[++i]);
                            u.append(chars[++i]);
                            b = (char)Integer.parseInt(u.toString(), 16);
                            break;
                        }
                        case 'U': {
                            StringBuilder U = new StringBuilder();
                            U.append(chars[++i]);
                            U.append(chars[++i]);
                            U.append(chars[++i]);
                            U.append(chars[++i]);
                            U.append(chars[++i]);
                            U.append(chars[++i]);
                            int cp = Integer.parseInt(U.toString(), 16);
                            result.appendCodePoint(cp);
                            continue block18;
                        }
                        default: {
                            b = 92;
                        }
                    }
                }
                default: {
                    result.append((char)b);
                }
            }
        }
        return result.toString();
    }

    public static OffsetLengthTerm findRascalIdentifierAtOffset(String buffer, int offset) {
        Matcher m4 = getLastIdentifier.matcher(buffer);
        int split = StringUtils.findSplitPoint(offset, buffer);
        if (split > 0) {
            m4.region(0, split + 1);
        }
        if (m4.matches()) {
            String originalTerm = m4.group(1);
            return new OffsetLengthTerm(m4.start(1), originalTerm.length(), originalTerm);
        }
        return null;
    }

    private static boolean validRascalIdentifier(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '\\';
    }

    private static int findSplitPoint(int currentCursorPosition, String currentConsoleInput) {
        for (int i = currentCursorPosition; i < currentConsoleInput.length(); ++i) {
            char currentChar = currentConsoleInput.charAt(i);
            if (currentChar == ':' && i + 1 < currentConsoleInput.length() && currentConsoleInput.charAt(i + 1) == ':') {
                ++i;
                continue;
            }
            if (StringUtils.validRascalIdentifier(currentChar)) continue;
            return i - 1;
        }
        return -1;
    }

    public static String[] splitQualifiedName(String name) {
        int splitPoint = name.lastIndexOf("::");
        if (splitPoint >= 0) {
            return new String[]{name.substring(0, splitPoint), name.substring(splitPoint + 2)};
        }
        return new String[]{name};
    }

    private static boolean validRascalLocation(char c) {
        return ('\t' < c || c > '\n') && c != '\r' && c != ' ' && c != '<' && c != '>';
    }

    public static int findRascalLocationStart(String line, int cursor) {
        for (int pos = Math.min(cursor, line.length() - 1); pos >= 0; --pos) {
            char c = line.charAt(pos);
            if (c == '|') {
                return pos;
            }
            if (StringUtils.validRascalLocation(c)) continue;
            return -1;
        }
        return -1;
    }

    public static int findRascalLocationEnd(String line, int locationStart) {
        assert (line.charAt(locationStart) == '|');
        for (int pos = locationStart + 1; pos < line.length(); ++pos) {
            char c = line.charAt(pos);
            if (c == '|') {
                return pos - 1;
            }
            if (StringUtils.validRascalLocation(c)) continue;
            return pos;
        }
        return line.length() - 1;
    }

    public static class OffsetLengthTerm {
        public final int offset;
        public final int length;
        public final String term;

        public OffsetLengthTerm(int offset, int length, String term) {
            this.offset = offset;
            this.length = length;
            this.term = term;
        }
    }
}

