/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.exceptions.FactParseError;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.io.StandardTextWriter;
import io.usethesource.vallang.io.binary.stream.IValueInputStream;
import io.usethesource.vallang.io.binary.stream.IValueOutputStream;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.visitors.IdentityVisitor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.Base32;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.JavaCompilation;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.utils.IResourceLocationProvider;
import org.rascalmpl.repl.streams.LimitedLineWriter;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.unicode.UnicodeOffsetLengthReader;
import org.rascalmpl.unicode.UnicodeOutputStreamWriter;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.LogicalMapResolver;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.UnsupportedSchemeException;
import org.rascalmpl.uri.file.MavenRepositoryURIResolver;
import org.rascalmpl.uri.jar.JarURIResolver;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;
import org.rascalmpl.values.parsetrees.visitors.TreeVisitor;

public class Prelude {
    private static final int FILE_BUFFER_SIZE = 8192;
    protected final URIResolverRegistry REGISTRY = URIResolverRegistry.getInstance();
    protected final IValueFactory values;
    protected final IRascalValueFactory rascalValues;
    private final Random random;
    private final boolean trackIO = System.getenv("TRACKIO") != null;
    private final PrintWriter out;
    private final TypeStore store;
    private final IRascalMonitor monitor;
    private final IResourceLocationProvider resourceProvider;
    private final int millisInAMinute = 60000;
    private final int millisInAnHour = 3600000;
    private Map<IValue, Distance> distance;
    private Map<IValue, IValue> pred;
    private Set<IValue> settled;
    private PriorityQueue<IValue> Q;
    private int MAXDISTANCE = 10000;
    private Map<IValue, LinkedList<IValue>> adjacencyList;
    private WeakReference<IList> indexes;
    protected final TypeReifier tr;
    private final Map<ISourceLocation, Set<ReleasableCallback>> registeredWatchers = new ConcurrentHashMap<ISourceLocation, Set<ReleasableCallback>>();

    public Prelude(IValueFactory values, IRascalValueFactory rascalValues, PrintWriter out, TypeStore store, IRascalMonitor monitor, IResourceLocationProvider resourceProvider) {
        this.values = values;
        this.rascalValues = rascalValues;
        this.store = store;
        this.out = out;
        this.tr = new TypeReifier(values);
        this.monitor = monitor;
        this.resourceProvider = resourceProvider;
        this.random = new Random();
    }

    private IValue createRandomValue(Type t2, int depth, int width) {
        return t2.randomValue(this.random, this.values, new TypeStore(new TypeStore[0]), Collections.emptyMap(), depth, width);
    }

    public IValue arbBool() {
        return this.values.bool(this.random.nextInt(2) == 1);
    }

    public IValue now() {
        return this.values.datetime(com.ibm.icu.util.Calendar.getInstance().getTimeInMillis());
    }

    public IValue createDate(IInteger year, IInteger month, IInteger day) {
        return this.values.date(year.intValue(), month.intValue(), day.intValue());
    }

    public IValue createTime(IInteger hour, IInteger minute, IInteger second, IInteger millisecond) {
        return this.values.time(hour.intValue(), minute.intValue(), second.intValue(), millisecond.intValue());
    }

    public IValue createTime(IInteger hour, IInteger minute, IInteger second, IInteger millisecond, IInteger timezoneHourOffset, IInteger timezoneMinuteOffset) {
        return this.values.time(hour.intValue(), minute.intValue(), second.intValue(), millisecond.intValue(), timezoneHourOffset.intValue(), timezoneMinuteOffset.intValue());
    }

    public IValue createDateTime(IInteger year, IInteger month, IInteger day, IInteger hour, IInteger minute, IInteger second, IInteger millisecond) {
        return this.values.datetime(year.intValue(), month.intValue(), day.intValue(), hour.intValue(), minute.intValue(), second.intValue(), millisecond.intValue());
    }

    public IValue createDateTime(IInteger year, IInteger month, IInteger day, IInteger hour, IInteger minute, IInteger second, IInteger millisecond, IInteger timezoneHourOffset, IInteger timezoneMinuteOffset) {
        return this.values.datetime(year.intValue(), month.intValue(), day.intValue(), hour.intValue(), minute.intValue(), second.intValue(), millisecond.intValue(), timezoneHourOffset.intValue(), timezoneMinuteOffset.intValue());
    }

    public IDateTime arbDateTime() {
        return (IDateTime)this.createRandomValue(TypeFactory.getInstance().dateTimeType(), 5, 5);
    }

    public IValue joinDateAndTime(IDateTime date, IDateTime time) {
        return this.values.datetime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute(), time.getMillisecondsOfSecond(), time.getTimezoneOffsetHours(), time.getTimezoneOffsetMinutes());
    }

    public IValue splitDateTime(IDateTime dt) {
        return this.values.tuple(this.values.date(dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth()), this.values.time(dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute(), dt.getMillisecondsOfSecond(), dt.getTimezoneOffsetHours(), dt.getTimezoneOffsetMinutes()));
    }

    public IValue incrementYears(IDateTime dt, IInteger n) {
        return this.incrementDate(dt, 1, "years", n);
    }

    public IValue incrementMonths(IDateTime dt, IInteger n) {
        return this.incrementDate(dt, 2, "months", n);
    }

    public IValue incrementDays(IDateTime dt, IInteger n) {
        return this.incrementDate(dt, 5, "days", n);
    }

    public static String getTZString(int hourOffset, int minuteOffset) {
        String tzString = "GMT" + (hourOffset < 0 || 0 == hourOffset && minuteOffset < 0 ? "-" : "+") + String.format("%02d", hourOffset >= 0 ? hourOffset : hourOffset * -1) + String.format("%02d", minuteOffset >= 0 ? minuteOffset : minuteOffset * -1);
        return tzString;
    }

    private IValue incrementDTField(IDateTime dt, int field, IInteger amount) {
        com.ibm.icu.util.Calendar cal = null;
        cal = this.dateTimeToCalendar(dt);
        cal.setLenient(true);
        cal.add(field, amount.intValue());
        if (dt.isDate()) {
            return this.calendarToDate(cal);
        }
        if (dt.isTime()) {
            return this.calendarToTime(cal);
        }
        return this.calendarToDateTime(cal);
    }

    private IValue calendarToDateTime(com.ibm.icu.util.Calendar cal) {
        int timezoneHours = cal.get(15) / 3600000;
        int timezoneMinutes = cal.get(15) % 3600000 / 60000;
        return this.createDateTime(this.values.integer(cal.get(1)), this.values.integer(cal.get(2) + 1), this.values.integer(cal.get(5)), this.values.integer(cal.get(11)), this.values.integer(cal.get(12)), this.values.integer(cal.get(13)), this.values.integer(cal.get(14)), this.values.integer(timezoneHours), this.values.integer(timezoneMinutes));
    }

    private IValue calendarToTime(com.ibm.icu.util.Calendar cal) {
        int timezoneHours = cal.get(15) / 3600000;
        int timezoneMinutes = cal.get(15) % 3600000 / 60000;
        return this.createTime(this.values.integer(cal.get(11)), this.values.integer(cal.get(12)), this.values.integer(cal.get(13)), this.values.integer(cal.get(14)), this.values.integer(timezoneHours), this.values.integer(timezoneMinutes));
    }

    private IValue calendarToDate(com.ibm.icu.util.Calendar cal) {
        return this.createDate(this.values.integer(cal.get(1)), this.values.integer(cal.get(2) + 1), this.values.integer(cal.get(5)));
    }

    private com.ibm.icu.util.Calendar dateTimeToCalendar(IDateTime dt) {
        TimeZone tz = dt.isDate() ? TimeZone.getDefault() : TimeZone.getTimeZone(Prelude.getTZString(dt.getTimezoneOffsetHours(), dt.getTimezoneOffsetMinutes()));
        com.ibm.icu.util.Calendar cal = com.ibm.icu.util.Calendar.getInstance(tz, Locale.getDefault());
        cal.setTimeInMillis(dt.getInstant());
        return cal;
    }

    private IValue incrementTime(IDateTime dt, int field, String fieldName, IInteger amount) {
        if (dt.isDate()) {
            throw RuntimeExceptionFactory.invalidUseOfDateException("Cannot increment the " + fieldName + " on a date value.");
        }
        return this.incrementDTField(dt, field, amount);
    }

    private IValue incrementDate(IDateTime dt, int field, String fieldName, IInteger amount) {
        if (dt.isTime()) {
            throw RuntimeExceptionFactory.invalidUseOfDateException("Cannot increment the " + fieldName + " on a time value.");
        }
        return this.incrementDTField(dt, field, amount);
    }

    public IValue incrementHours(IDateTime dt, IInteger n) {
        return this.incrementTime(dt, 11, "hours", n);
    }

    public IValue incrementMinutes(IDateTime dt, IInteger n) {
        return this.incrementTime(dt, 12, "minutes", n);
    }

    public IValue incrementSeconds(IDateTime dt, IInteger n) {
        return this.incrementTime(dt, 13, "seconds", n);
    }

    public IValue incrementMilliseconds(IDateTime dt, IInteger n) {
        return this.incrementTime(dt, 14, "milliseconds", n);
    }

    public IValue decrementYears(IDateTime dt, IInteger n) {
        return this.incrementDate(dt, 1, "years", n.negate());
    }

    public IValue decrementMonths(IDateTime dt, IInteger n) {
        return this.incrementDate(dt, 2, "months", n.negate());
    }

    public IValue decrementDays(IDateTime dt, IInteger n) {
        return this.incrementDate(dt, 5, "days", n.negate());
    }

    public IValue decrementHours(IDateTime dt, IInteger n) {
        return this.incrementTime(dt, 11, "hours", n.negate());
    }

    public IValue decrementMinutes(IDateTime dt, IInteger n) {
        return this.incrementTime(dt, 12, "minutes", n.negate());
    }

    public IValue decrementSeconds(IDateTime dt, IInteger n) {
        return this.incrementTime(dt, 13, "seconds", n.negate());
    }

    public IValue decrementMilliseconds(IDateTime dt, IInteger n) {
        return this.incrementTime(dt, 14, "milliseconds", n.negate());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IValue createDurationInternal(IDateTime dStart, IDateTime dEnd) {
        com.ibm.icu.util.Calendar startCal = com.ibm.icu.util.Calendar.getInstance();
        startCal.setTimeInMillis(dStart.getInstant());
        com.ibm.icu.util.Calendar endCal = com.ibm.icu.util.Calendar.getInstance();
        endCal.setTimeInMillis(dEnd.getInstant());
        ITuple duration = null;
        if (dStart.isDate()) {
            if (dEnd.isDate()) {
                return this.values.tuple(this.values.integer(startCal.fieldDifference(endCal.getTime(), 1)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 2)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 5)), this.values.integer(0), this.values.integer(0), this.values.integer(0), this.values.integer(0));
            }
            if (!dEnd.isTime()) throw RuntimeExceptionFactory.invalidUseOfDateTimeException("Cannot determine the duration between a date with no time and a datetime.");
            throw RuntimeExceptionFactory.invalidUseOfTimeException("Cannot determine the duration between a date with no time and a time with no date.");
        }
        if (dStart.isTime()) {
            if (dEnd.isTime()) {
                return this.values.tuple(this.values.integer(0), this.values.integer(0), this.values.integer(0), this.values.integer(startCal.fieldDifference(endCal.getTime(), 11)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 12)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 13)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 14)));
            }
            if (!dEnd.isDate()) throw RuntimeExceptionFactory.invalidUseOfDateTimeException("Cannot determine the duration between a time with no date and a datetime.");
            throw RuntimeExceptionFactory.invalidUseOfDateException("Cannot determine the duration between a time with no date and a date with no time.");
        }
        if (dEnd.isDateTime()) {
            return this.values.tuple(this.values.integer(startCal.fieldDifference(endCal.getTime(), 1)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 2)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 5)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 11)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 12)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 13)), this.values.integer(startCal.fieldDifference(endCal.getTime(), 14)));
        }
        if (!dEnd.isDate()) throw RuntimeExceptionFactory.invalidUseOfTimeException("Cannot determine the duration between a datetime and a time with no date.");
        throw RuntimeExceptionFactory.invalidUseOfDateException("Cannot determine the duration between a datetime and a date with no time.");
    }

    public IValue parseDate(IString inputDate, IString formatString) {
        try {
            java.text.SimpleDateFormat fmt = new java.text.SimpleDateFormat(formatString.getValue());
            fmt.parse(inputDate.getValue());
            Calendar cal = fmt.getCalendar();
            return this.values.date(cal.get(1), cal.get(2) + 1, cal.get(5));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input date: " + inputDate.getValue() + " using format string: " + formatString.getValue());
        }
        catch (ParseException e) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input date: " + inputDate.getValue() + " using format string: " + formatString.getValue());
        }
    }

    public IValue parseDateInLocale(IString inputDate, IString formatString, IString locale) {
        try {
            java.text.SimpleDateFormat fmt = new java.text.SimpleDateFormat(formatString.getValue(), new Locale(locale.getValue()));
            fmt.parse(inputDate.getValue());
            Calendar cal = fmt.getCalendar();
            return this.values.date(cal.get(1), cal.get(2) + 1, cal.get(5));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input date: " + inputDate.getValue() + " using format string: " + formatString.getValue() + " in locale: " + locale.getValue());
        }
        catch (ParseException e) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input date: " + inputDate.getValue() + " using format string: " + formatString.getValue() + " in locale: " + locale.getValue());
        }
    }

    public IValue parseTime(IString inputTime, IString formatString) {
        try {
            java.text.SimpleDateFormat fmt = new java.text.SimpleDateFormat(formatString.getValue());
            fmt.parse(inputTime.getValue());
            Calendar cal = fmt.getCalendar();
            int zoneHours = cal.get(15) / 3600000;
            int zoneMinutes = cal.get(15) / 60000 % 60;
            return this.values.time(cal.get(11), cal.get(12), cal.get(13), cal.get(14), zoneHours, zoneMinutes);
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input date: " + inputTime.getValue() + " using format string: " + formatString.getValue());
        }
        catch (ParseException e) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input date: " + inputTime.getValue() + " using format string: " + formatString.getValue());
        }
    }

    public IValue parseTimeInLocale(IString inputTime, IString formatString, IString locale) {
        try {
            java.text.SimpleDateFormat fmt = new java.text.SimpleDateFormat(formatString.getValue(), new Locale(locale.getValue()));
            fmt.parse(inputTime.getValue());
            Calendar cal = fmt.getCalendar();
            int zoneHours = cal.get(15) / 3600000;
            int zoneMinutes = cal.get(15) / 60000 % 60;
            return this.values.time(cal.get(11), cal.get(12), cal.get(13), cal.get(14), zoneHours, zoneMinutes);
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input time: " + inputTime.getValue() + " using format string: " + formatString.getValue() + " in locale: " + locale.getValue());
        }
        catch (ParseException e) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input time: " + inputTime.getValue() + " using format string: " + formatString.getValue() + " in locale: " + locale.getValue());
        }
    }

    public IString printSymbol(IConstructor symbol, IBool withLayout) {
        return this.values.string(SymbolAdapter.toString(symbol, withLayout.getValue()));
    }

    public IValue parseDateTime(IString inputDateTime, IString formatString) {
        return Prelude.parseDateTime(this.values, inputDateTime, formatString);
    }

    public static IValue parseDateTime(IValueFactory values, IString inputDateTime, IString formatString) {
        try {
            java.text.SimpleDateFormat fmt = new java.text.SimpleDateFormat(formatString.getValue());
            fmt.setLenient(false);
            fmt.parse(inputDateTime.getValue());
            Calendar cal = fmt.getCalendar();
            int zoneHours = cal.get(15) / 3600000;
            int zoneMinutes = cal.get(15) / 60000 % 60;
            return values.datetime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), zoneHours, zoneMinutes);
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input datetime: " + inputDateTime.getValue() + " using format string: " + formatString.getValue());
        }
        catch (ParseException e) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input datetime: " + inputDateTime.getValue() + " using format string: " + formatString.getValue());
        }
    }

    public IValue parseDateTimeInLocale(IString inputDateTime, IString formatString, IString locale) {
        try {
            java.text.SimpleDateFormat fmt = new java.text.SimpleDateFormat(formatString.getValue(), new Locale(locale.getValue()));
            fmt.parse(inputDateTime.getValue());
            Calendar cal = fmt.getCalendar();
            int zoneHours = cal.get(15) / 3600000;
            int zoneMinutes = cal.get(15) / 60000 % 60;
            return this.values.datetime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), zoneHours, zoneMinutes);
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input datetime: " + inputDateTime.getValue() + " using format string: " + formatString.getValue() + " in locale: " + locale.getValue());
        }
        catch (ParseException e) {
            throw RuntimeExceptionFactory.dateTimeParsingError("Cannot parse input datetime: " + inputDateTime.getValue() + " using format string: " + formatString.getValue() + " in locale: " + locale.getValue());
        }
    }

    private com.ibm.icu.util.Calendar getCalendarForDate(IDateTime inputDate) {
        if (inputDate.isDate() || inputDate.isDateTime()) {
            com.ibm.icu.util.Calendar cal = com.ibm.icu.util.Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
            cal.setLenient(false);
            cal.set(inputDate.getYear(), inputDate.getMonthOfYear() - 1, inputDate.getDayOfMonth());
            return cal;
        }
        throw new IllegalArgumentException("Cannot get date for a datetime that only represents the time");
    }

    private com.ibm.icu.util.Calendar getCalendarForTime(IDateTime inputTime) {
        if (inputTime.isTime() || inputTime.isDateTime()) {
            com.ibm.icu.util.Calendar cal = com.ibm.icu.util.Calendar.getInstance(TimeZone.getTimeZone(Prelude.getTZString(inputTime.getTimezoneOffsetHours(), inputTime.getTimezoneOffsetMinutes())), Locale.getDefault());
            cal.setLenient(false);
            cal.set(11, inputTime.getHourOfDay());
            cal.set(12, inputTime.getMinuteOfHour());
            cal.set(13, inputTime.getSecondOfMinute());
            cal.set(14, inputTime.getMillisecondsOfSecond());
            return cal;
        }
        throw new IllegalArgumentException("Cannot get time for a datetime that only represents the date");
    }

    public static com.ibm.icu.util.Calendar getCalendarForDateTime(IDateTime inputDateTime) {
        if (inputDateTime.isDateTime()) {
            com.ibm.icu.util.Calendar cal = com.ibm.icu.util.Calendar.getInstance(TimeZone.getTimeZone(Prelude.getTZString(inputDateTime.getTimezoneOffsetHours(), inputDateTime.getTimezoneOffsetMinutes())), Locale.getDefault());
            cal.setLenient(false);
            cal.set(inputDateTime.getYear(), inputDateTime.getMonthOfYear() - 1, inputDateTime.getDayOfMonth(), inputDateTime.getHourOfDay(), inputDateTime.getMinuteOfHour(), inputDateTime.getSecondOfMinute());
            cal.set(14, inputDateTime.getMillisecondsOfSecond());
            return cal;
        }
        throw new IllegalArgumentException("Cannot get date and time for a datetime that only represents the date or the time");
    }

    public IValue printDate(IDateTime inputDate, IString formatString) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(formatString.getValue());
            com.ibm.icu.util.Calendar cal = this.getCalendarForDate(inputDate);
            sd.setCalendar(cal);
            return this.values.string(sd.format(cal.getTime()));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print date " + inputDate + " with format " + formatString.getValue());
        }
    }

    public IValue printDate(IDateTime inputDate) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        com.ibm.icu.util.Calendar cal = this.getCalendarForDate(inputDate);
        sd.setCalendar(cal);
        return this.values.string(sd.format(cal.getTime()));
    }

    public IValue printDateInLocale(IDateTime inputDate, IString formatString, IString locale) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(formatString.getValue(), new ULocale(locale.getValue()));
            com.ibm.icu.util.Calendar cal = this.getCalendarForDate(inputDate);
            sd.setCalendar(cal);
            return this.values.string(sd.format(cal.getTime()));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print date " + inputDate + " with format " + formatString.getValue() + ", in locale: " + locale.getValue());
        }
    }

    public IValue printDateInLocale(IDateTime inputDate, IString locale) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd", new ULocale(locale.getValue()));
            com.ibm.icu.util.Calendar cal = this.getCalendarForDate(inputDate);
            sd.setCalendar(cal);
            return this.values.string(sd.format(cal.getTime()));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print time " + inputDate + " in locale: " + locale.getValue());
        }
    }

    public IValue printTime(IDateTime inputTime, IString formatString) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(formatString.getValue());
            com.ibm.icu.util.Calendar cal = this.getCalendarForTime(inputTime);
            sd.setCalendar(cal);
            return this.values.string(sd.format(cal.getTime()));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print time " + inputTime + " with format: " + formatString.getValue());
        }
    }

    public IValue printTime(IDateTime inputTime) {
        SimpleDateFormat sd = new SimpleDateFormat("HH:mm:ss.SSSZ");
        com.ibm.icu.util.Calendar cal = this.getCalendarForTime(inputTime);
        sd.setCalendar(cal);
        return this.values.string(sd.format(cal.getTime()));
    }

    public IValue printTimeInLocale(IDateTime inputTime, IString formatString, IString locale) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(formatString.getValue(), new ULocale(locale.getValue()));
            com.ibm.icu.util.Calendar cal = this.getCalendarForTime(inputTime);
            sd.setCalendar(cal);
            return this.values.string(sd.format(cal.getTime()));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print time " + inputTime + " in locale: " + locale.getValue());
        }
    }

    public IValue printTimeInLocale(IDateTime inputTime, IString locale) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat("HH:mm:ss.SSSZ", new ULocale(locale.getValue()));
            com.ibm.icu.util.Calendar cal = this.getCalendarForTime(inputTime);
            sd.setCalendar(cal);
            return this.values.string(sd.format(cal.getTime()));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print time " + inputTime + " in locale: " + locale.getValue());
        }
    }

    public IValue printDateTime(IDateTime inputDateTime, IString formatString) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(formatString.getValue());
            com.ibm.icu.util.Calendar cal = Prelude.getCalendarForDateTime(inputDateTime);
            sd.setCalendar(cal);
            return this.values.string(sd.format(cal.getTime()));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print datetime " + inputDateTime + " using format string: " + formatString.getValue());
        }
    }

    public IValue printDateTime(IDateTime inputDateTime) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        com.ibm.icu.util.Calendar cal = Prelude.getCalendarForDateTime(inputDateTime);
        sd.setCalendar(cal);
        return this.values.string(sd.format(cal.getTime()));
    }

    public IValue printDateTimeInLocale(IDateTime inputDateTime, IString formatString, IString locale) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(formatString.getValue(), new ULocale(locale.getValue()));
            com.ibm.icu.util.Calendar cal = Prelude.getCalendarForDateTime(inputDateTime);
            sd.setCalendar(cal);
            return this.values.string(sd.format(cal.getTime()));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print datetime " + inputDateTime + " using format string: " + formatString.getValue() + " in locale: " + locale.getValue());
        }
    }

    public IValue printDateTimeInLocale(IDateTime inputDateTime, IString locale) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ", new ULocale(locale.getValue()));
            com.ibm.icu.util.Calendar cal = Prelude.getCalendarForDateTime(inputDateTime);
            sd.setCalendar(cal);
            return this.values.string(sd.format(cal.getTime()));
        }
        catch (IllegalArgumentException iae) {
            throw RuntimeExceptionFactory.dateTimePrintingError("Cannot print datetime " + inputDateTime + " in locale: " + locale.getValue());
        }
    }

    public IValue daysDiff(IDateTime dtStart, IDateTime dtEnd) {
        if (!dtStart.isTime() && !dtEnd.isTime()) {
            com.ibm.icu.util.Calendar startCal = com.ibm.icu.util.Calendar.getInstance();
            startCal.setTimeInMillis(dtStart.getInstant());
            com.ibm.icu.util.Calendar endCal = com.ibm.icu.util.Calendar.getInstance();
            endCal.setTimeInMillis(dtEnd.getInstant());
            return this.values.integer(startCal.fieldDifference(endCal.getTime(), 5));
        }
        throw RuntimeExceptionFactory.invalidUseOfTimeException("Both inputs must include dates.");
    }

    private void buildAdjacencyListAndDistance(ISet G) {
        this.adjacencyList = new HashMap<IValue, LinkedList<IValue>>();
        this.distance = new HashMap<IValue, Distance>();
        for (IValue v : G) {
            ITuple tup = (ITuple)v;
            IValue from = tup.get(0);
            IValue to = tup.get(1);
            if (this.distance.get(from) == null) {
                this.distance.put(from, new Distance(this.MAXDISTANCE));
            }
            if (this.distance.get(to) == null) {
                this.distance.put(to, new Distance(this.MAXDISTANCE));
            }
            LinkedList adjacencies = this.adjacencyList.computeIfAbsent(from, k -> new LinkedList());
            adjacencies.add(to);
            this.adjacencyList.put(from, adjacencies);
        }
    }

    public IValue shortestPathPair(ISet G, IValue From, IValue To) {
        this.buildAdjacencyListAndDistance(G);
        IValue start = From;
        this.distance.put(start, new Distance(0));
        this.pred = new HashMap<IValue, IValue>();
        this.settled = new HashSet<IValue>();
        this.Q = new PriorityQueue<IValue>(G.size(), new NodeComparator(this.distance));
        this.Q.add(start);
        while (!this.Q.isEmpty()) {
            IValue u = (IValue)this.Q.remove();
            if (u.equals(To)) {
                return this.extractPath(start, u);
            }
            this.settled.add(u);
            this.relaxNeighbours(u);
        }
        return this.values.list(new IValue[0]);
    }

    private void relaxNeighbours(IValue u) {
        LinkedList<IValue> adjacencies = this.adjacencyList.get(u);
        if (adjacencies != null) {
            for (IValue v : this.adjacencyList.get(u)) {
                if (this.settled.contains(v)) continue;
                Distance dv = this.distance.get(v);
                Distance du = this.distance.get(u);
                if (dv.intval <= du.intval + 1) continue;
                dv.intval = du.intval + 1;
                this.pred.put(v, u);
                this.Q.add(v);
            }
        }
    }

    private IList extractPath(IValue start, IValue u) {
        IListWriter w = this.values.listWriter();
        if (!start.equals(u)) {
            w.insert(u);
            while (!this.pred.get(u).equals(start)) {
                u = this.pred.get(u);
                w.insert(u);
            }
        }
        w.insert(start);
        return (IList)w.done();
    }

    public void print(IValue arg) {
        PrintWriter currentOutStream = this.out;
        try {
            if (arg.getType().isString()) {
                ((IString)arg).write(currentOutStream);
            } else if (arg.getType().isSubtypeOf(RascalValueFactory.Tree)) {
                currentOutStream.print(TreeAdapter.yield((IConstructor)arg));
            } else if (arg.getType().isSubtypeOf(RascalValueFactory.Type)) {
                currentOutStream.print(SymbolAdapter.toString((IConstructor)((IConstructor)arg).get("symbol"), false));
            } else {
                currentOutStream.print(arg.toString());
            }
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
        finally {
            currentOutStream.flush();
        }
    }

    public void iprint(IValue arg, IInteger lineLimit) {
        StandardTextWriter w = new StandardTextWriter(true, 2);
        Writer output = this.out;
        if (lineLimit.signum() > 0) {
            output = new LimitedLineWriter(output, lineLimit.longValue());
        }
        try {
            w.write(arg, output);
        }
        catch (RuntimeException runtimeException) {
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string("Could not print indented value"));
        }
        finally {
            try {
                output.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public void iprintToFile(ISourceLocation sloc, IValue arg, IString charset) {
        StandardTextWriter w = new StandardTextWriter(true, 2);
        StringWriter sw = new StringWriter();
        try {
            w.write(arg, sw);
            this.writeFile(sloc, this.values.list(this.values.string(sw.toString())), charset);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public IString iprintToString(IValue arg) {
        StandardTextWriter w = new StandardTextWriter(true, 2);
        StringWriter sw = new StringWriter();
        try {
            w.write(arg, sw);
            return this.values.string(sw.toString());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public void iprintln(IValue arg, IInteger lineLimit) {
        this.iprint(arg, lineLimit);
        this.out.println();
        this.out.flush();
    }

    public void println() {
        this.out.println();
        this.out.flush();
    }

    public void println(IValue arg) {
        PrintWriter currentOutStream = this.out;
        try {
            if (arg.getType().isString()) {
                ((IString)arg).write(currentOutStream);
            } else if (arg.getType().isSubtypeOf(RascalValueFactory.Tree)) {
                currentOutStream.print(TreeAdapter.yield((IConstructor)arg));
            } else if (arg.getType().isSubtypeOf(RascalValueFactory.Type)) {
                currentOutStream.print(SymbolAdapter.toString((IConstructor)((IConstructor)arg).get("symbol"), false));
            } else {
                currentOutStream.print(arg.toString());
            }
            currentOutStream.println();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
        finally {
            currentOutStream.flush();
        }
    }

    public void rprintln(IValue arg) {
        PrintWriter currentOutStream = this.out;
        try {
            currentOutStream.print(arg.toString());
            currentOutStream.println();
        }
        finally {
            currentOutStream.flush();
        }
    }

    public void rprint(IValue arg) {
        PrintWriter currentOutStream = this.out;
        try {
            currentOutStream.print(arg.toString());
        }
        finally {
            currentOutStream.flush();
        }
    }

    public IValue exists(ISourceLocation sloc) {
        IBool result = this.values.bool(this.REGISTRY.exists(sloc));
        if (this.trackIO) {
            System.err.println("exists: " + sloc + " => " + result);
        }
        return result;
    }

    public IValue lastModified(ISourceLocation sloc) {
        try {
            IDateTime result = this.values.datetime(this.REGISTRY.lastModified(sloc));
            if (this.trackIO) {
                System.err.println("lastModified: " + sloc + " => " + result);
            }
            return result;
        }
        catch (FileNotFoundException e) {
            throw RuntimeExceptionFactory.pathNotFound(sloc);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public IValue created(ISourceLocation sloc) {
        try {
            IDateTime result = this.values.datetime(this.REGISTRY.created(sloc));
            if (this.trackIO) {
                System.err.println("lastModified: " + sloc + " => " + result);
            }
            return result;
        }
        catch (FileNotFoundException e) {
            throw RuntimeExceptionFactory.pathNotFound(sloc);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public void setLastModified(ISourceLocation sloc, IDateTime timestamp) {
        this.setLastModified(sloc, timestamp.getInstant());
    }

    private void setLastModified(ISourceLocation sloc, long timestamp) {
        try {
            this.REGISTRY.setLastModified(sloc, timestamp);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public IBool isDirectory(ISourceLocation sloc) {
        return this.values.bool(this.REGISTRY.isDirectory(sloc));
    }

    public IBool isFile(ISourceLocation sloc) {
        return this.values.bool(this.REGISTRY.isFile(sloc));
    }

    public void remove(ISourceLocation sloc, IBool recursive) {
        try {
            this.REGISTRY.remove(sloc, recursive.getValue());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public void mkDirectory(ISourceLocation sloc) {
        try {
            this.REGISTRY.mkDirectory(sloc);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public IList listEntries(ISourceLocation sloc) {
        try {
            String[] entries = this.REGISTRY.listEntries(sloc);
            if (entries == null) {
                throw RuntimeExceptionFactory.illegalArgument(sloc);
            }
            IListWriter w = this.values.listWriter();
            for (String entry : entries) {
                w.append(this.values.string(entry));
            }
            return (IList)w.done();
        }
        catch (FileNotFoundException e) {
            throw RuntimeExceptionFactory.pathNotFound(sloc);
        }
        catch (UnsupportedSchemeException e) {
            throw RuntimeExceptionFactory.schemeNotSupported(sloc);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public ISet charsets() {
        ISetWriter w = this.values.setWriter();
        for (String s2 : Charset.availableCharsets().keySet()) {
            w.insert(this.values.string(s2));
        }
        return (ISet)w.done();
    }

    public IString readFile(ISourceLocation sloc, IString charset, IBool inferCharset) {
        return Prelude.readFile(this.values, this.trackIO, sloc, charset.getValue(), inferCharset.getValue());
    }

    public static IString readFile(IValueFactory values, boolean trackIO, ISourceLocation sloc, String charset, boolean inferCharset) {
        IString iString;
        block10: {
            if (trackIO) {
                System.err.println("readFile: " + sloc);
            }
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            Reader reader = inferCharset ? reg.getCharacterReader(sloc) : reg.getCharacterReader(sloc, charset);
            try {
                iString = values.string(Prelude.consumeInputStream(reader));
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw RuntimeExceptionFactory.pathNotFound(sloc);
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(values.string(e.getMessage()));
                }
            }
            reader.close();
        }
        return iString;
    }

    public static String consumeInputStream(Reader in) throws IOException {
        int read;
        StringBuilder res = new StringBuilder();
        char[] chunk = new char[8192];
        while ((read = in.read(chunk, 0, chunk.length)) != -1) {
            res.append(chunk, 0, read);
        }
        return res.toString();
    }

    public static byte[] consumeInputStream(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        byte[] chunk = new byte[8192];
        while ((read = in.read(chunk, 0, chunk.length)) != -1) {
            res.write(chunk, 0, read);
        }
        return res.toByteArray();
    }

    public IValue md5HashFile(ISourceLocation sloc) {
        try {
            boolean useInputStream;
            MessageDigest md = MessageDigest.getInstance("MD5");
            boolean bl = useInputStream = !this.REGISTRY.supportsReadableFileChannel(sloc);
            if (!useInputStream) {
                try (FileChannel file = this.REGISTRY.getReadableFileChannel(sloc);){
                    ByteBuffer contents = null;
                    if (file.size() > 8192L) {
                        try {
                            contents = file.map(FileChannel.MapMode.READ_ONLY, 0L, file.size());
                        }
                        catch (IOException e) {
                            useInputStream = true;
                            contents = null;
                        }
                    } else {
                        contents = ByteBuffer.allocate((int)file.size());
                        file.read(contents);
                        contents.flip();
                    }
                    if (contents != null) {
                        md.update(contents);
                    }
                }
            }
            if (useInputStream) {
                try (InputStream in = this.REGISTRY.getInputStream(sloc);){
                    int count;
                    byte[] buf = new byte[8192];
                    while ((count = in.read(buf, 0, buf.length)) != -1) {
                        md.update(buf, 0, count);
                    }
                }
            }
            return this.translateHash(md);
        }
        catch (FileNotFoundException fnfex) {
            throw RuntimeExceptionFactory.pathNotFound(sloc);
        }
        catch (IOException ioex) {
            throw RuntimeExceptionFactory.io(this.values.string(ioex.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            throw RuntimeExceptionFactory.io(this.values.string("Cannot load MD5 digest algorithm"));
        }
    }

    private IString translateHash(MessageDigest md) {
        byte[] hash = md.digest();
        StringBuilder result = new StringBuilder(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            result.append(Integer.toString((hash[i] & 0xFF) + 256, 16).substring(1));
        }
        return this.values.string(result.toString());
    }

    public IValue md5Hash(IValue value) {
        try {
            final MessageDigest md = MessageDigest.getInstance("MD5");
            StandardTextWriter writer = new StandardTextWriter();
            final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            writer.write(value, new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    CharBuffer cb = CharBuffer.wrap(cbuf, off, len);
                    ByteBuffer bb = encoder.encode(cb);
                    md.update(bb);
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            });
            return this.translateHash(md);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            throw RuntimeExceptionFactory.io(this.values.string("no such algorithm: " + e.getMessage()));
        }
    }

    public void copy(ISourceLocation source, ISourceLocation target, IBool recursive, IBool overwrite) {
        try {
            this.REGISTRY.copy(source, target, recursive.getValue(), overwrite.getValue());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public void move(ISourceLocation source, ISourceLocation target, IBool overwrite) {
        try {
            this.REGISTRY.rename(source, target, overwrite.getValue());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public void touch(ISourceLocation sloc) {
        if (this.REGISTRY.exists(sloc)) {
            this.setLastModified(sloc, System.currentTimeMillis());
        } else {
            this.writeFile(sloc, this.values.list(this.values.string("")), this.values.string("UTF-8"));
        }
    }

    public void writeFile(ISourceLocation sloc, IList V, IString charset) {
        this.writeFile(sloc, V, false, charset, this.values.bool(false));
    }

    private void writeFile(ISourceLocation sloc, IList V, boolean append, IString charset, IBool inferCharset) {
        if (this.trackIO) {
            System.err.println("writeFile: " + sloc);
        }
        if (append && inferCharset.getValue()) {
            charset = this.values.string(this.REGISTRY.detectCharset(sloc).name());
        }
        this.writeFileEnc(sloc, charset, V, append);
    }

    public IBool canEncode(IString charset) {
        return this.values.bool(Charset.forName(charset.getValue()).canEncode());
    }

    private void writeFileEnc(ISourceLocation sloc, IString charset, IList V, boolean append) {
        block35: {
            URIResolverRegistry reg = this.REGISTRY;
            if (!Charset.forName(charset.getValue()).canEncode()) {
                throw RuntimeExceptionFactory.illegalArgument(charset);
            }
            Reader prefix = null;
            Reader postfix = null;
            try {
                sloc = reg.logicalToPhysical(sloc);
                if (sloc.hasOffsetLength()) {
                    try {
                        prefix = new UnicodeOffsetLengthReader(reg.getCharacterReader(sloc.top(), charset.getValue()), 0, sloc.getOffset() + (append ? sloc.getLength() : 0));
                        postfix = new UnicodeOffsetLengthReader(reg.getCharacterReader(sloc.top(), charset.getValue()), sloc.getOffset() + sloc.getLength(), -1);
                    }
                    catch (UnsupportedSchemeException unsupportedSchemeException) {
                        // empty catch block
                    }
                }
                OutputStream outStream = prefix != null ? new ByteArrayOutputStream(8192) : reg.getOutputStream(sloc, append);
                try (Closeable out = new UnicodeOutputStreamWriter(outStream, charset.getValue(), append);){
                    if (prefix != null) {
                        this.copy(prefix, (Writer)out);
                    }
                    for (IValue elem : V) {
                        if (elem.getType().isString()) {
                            ((IString)elem).write((Writer)out);
                            continue;
                        }
                        if (elem.getType().isSubtypeOf(RascalValueFactory.Tree)) {
                            TreeAdapter.yield((IConstructor)elem, (Writer)out);
                            continue;
                        }
                        new StandardTextWriter().write(elem, (Writer)out);
                    }
                    if (postfix != null) {
                        this.copy(postfix, (Writer)out);
                    }
                }
                if (prefix == null) break block35;
                out = reg.getOutputStream(sloc, false);
                try {
                    ((ByteArrayOutputStream)outStream).writeTo((OutputStream)out);
                }
                finally {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
            }
            catch (FileNotFoundException fnfex) {
                throw RuntimeExceptionFactory.pathNotFound(sloc);
            }
            catch (UnsupportedOperationException e) {
                assert (false);
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
            }
            catch (IOException ioex) {
                throw RuntimeExceptionFactory.io(this.values.string(ioex.getMessage()));
            }
            finally {
                try {
                    if (prefix != null) {
                        prefix.close();
                    }
                    if (postfix != null) {
                        postfix.close();
                    }
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
                }
            }
        }
    }

    public void writeFileBytes(ISourceLocation sloc, IList blist) {
        try (OutputStream out = this.REGISTRY.getOutputStream(sloc, false);){
            for (IValue ival : blist) {
                out.write((byte)((IInteger)ival).intValue());
            }
        }
        catch (FileNotFoundException e) {
            throw RuntimeExceptionFactory.pathNotFound(sloc);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public void appendToFile(ISourceLocation sloc, IList V, IString charset, IBool inferCharset) {
        this.writeFile(sloc, V, true, charset, inferCharset);
    }

    public IList readFileLines(ISourceLocation sloc, IString charset) {
        IList iList;
        block11: {
            if (this.trackIO) {
                System.err.println("readFileLines: " + sloc);
            }
            Reader reader = this.REGISTRY.getCharacterReader(sloc, charset.getValue());
            try {
                iList = this.consumeInputStreamLines(reader);
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException e) {
                    throw RuntimeExceptionFactory.malformedURI(sloc.toString());
                }
                catch (FileNotFoundException e) {
                    throw RuntimeExceptionFactory.pathNotFound(sloc);
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
                }
            }
            reader.close();
        }
        return iList;
    }

    private IList consumeInputStreamLines(Reader in) throws IOException {
        try (BufferedReader buf = new BufferedReader(in);){
            String line = null;
            IListWriter res = this.values.listWriter();
            while ((line = buf.readLine()) != null) {
                res.append(this.values.string(line));
            }
            IList iList = (IList)res.done();
            return iList;
        }
    }

    public IList readFileBytes(ISourceLocation sloc) {
        if (this.trackIO) {
            System.err.println("readFileBytes: " + sloc);
        }
        IListWriter w = this.values.listWriter();
        try (InputStream in = this.REGISTRY.getInputStream(sloc);){
            int read;
            byte[] bytes = new byte[8192];
            while ((read = in.read(bytes, 0, bytes.length)) != -1) {
                for (int i = 0; i < read; ++i) {
                    w.append(this.values.integer(bytes[i] & 0xFF));
                }
            }
        }
        catch (FileNotFoundException e) {
            throw RuntimeExceptionFactory.pathNotFound(sloc);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
        return (IList)w.done();
    }

    public IString readBase64(ISourceLocation sloc, IBool includePadding) {
        IString iString;
        int BUFFER_SIZE = 1536;
        Base64.Encoder encoder = Base64.getEncoder();
        if (!includePadding.getValue()) {
            encoder = encoder.withoutPadding();
        }
        BufferedInputStream in = new BufferedInputStream(this.REGISTRY.getInputStream(sloc), 1536);
        try {
            StringBuilder result = new StringBuilder();
            byte[] chunk = new byte[1536];
            int len = 0;
            while ((len = in.read(chunk)) == 1536) {
                result.append(new String(encoder.encode(chunk), StandardCharsets.ISO_8859_1));
            }
            if (len > 0) {
                chunk = Arrays.copyOf(chunk, len);
                result.append(new String(encoder.encode(chunk), StandardCharsets.ISO_8859_1));
            }
            iString = this.values.string(result.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
            }
        }
        in.close();
        return iString;
    }

    public void writeBase64(ISourceLocation sloc, IString base64content) {
        int BUFFER_SIZE = 1536;
        Base64.Decoder decoder = Base64.getDecoder();
        try (BufferedOutputStream output = new BufferedOutputStream(this.REGISTRY.getOutputStream(sloc, false), 1536);){
            output.write(decoder.decode(base64content.getValue()));
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public IString readBase32(ISourceLocation sloc, IBool includePadding) {
        IString iString;
        BufferedInputStream input = new BufferedInputStream(this.REGISTRY.getInputStream(sloc));
        try {
            Base32 encoder = new Base32();
            String encoded = encoder.encodeToString(input.readAllBytes());
            if (!includePadding.getValue()) {
                encoded = encoded.replace("=", "");
            }
            iString = this.values.string(encoded);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
            }
        }
        input.close();
        return iString;
    }

    public void writeBase32(ISourceLocation sloc, IString base32Content) {
        try (BufferedOutputStream output = new BufferedOutputStream(this.REGISTRY.getOutputStream(sloc, false));){
            Base32 decoder = new Base32(0, new byte[0], false, 61, CodecPolicy.LENIENT);
            output.write(decoder.decode(base32Content.getValue()));
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public IString createLink(IString title, IString target) {
        return this.values.string("\ue007[" + title.getValue().replaceAll("\\]", "_") + "](" + target.getValue() + ")");
    }

    public ISourceLocation arbLoc() {
        return (ISourceLocation)this.createRandomValue(TypeFactory.getInstance().sourceLocationType(), 1 + this.random.nextInt(5), 1 + this.random.nextInt(5));
    }

    public IValue elementAt(IList lst, IInteger index) {
        if (lst.length() == 0) {
            throw RuntimeExceptionFactory.emptyList();
        }
        try {
            int i = index.intValue();
            if (index.intValue() < 0) {
                i += lst.length();
            }
            return lst.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(index);
        }
    }

    public IList shuffle(IList l, IInteger seed) {
        return l.shuffle(new Random(0x1FFFFFFFFFFFFFFFL * (long)seed.hashCode()));
    }

    public IList shuffle(IList l) {
        return l.shuffle(new Random());
    }

    public IList sort(IList l, IFunction cmpv) {
        IValue[] tmpArr = new IValue[l.length()];
        for (int i = 0; i < l.length(); ++i) {
            tmpArr[i] = l.get(i);
        }
        new Sorting(tmpArr, new Less(cmpv)).shuffle().sort();
        IListWriter writer = this.values.listWriter();
        writer.append(tmpArr);
        return (IList)writer.done();
    }

    public IList sort(ISet l, IFunction cmpv) {
        IValue[] tmpArr = new IValue[l.size()];
        int i = 0;
        for (IValue elem : l) {
            tmpArr[i++] = elem;
        }
        new Sorting(tmpArr, new Less(cmpv)).sort();
        IListWriter writer = this.values.listWriter();
        writer.append(tmpArr);
        return (IList)writer.done();
    }

    public IList top(IInteger k, ISet l, IFunction cmpv) {
        LinkedList<IValue> result = new LinkedList<IValue>();
        Less less = new Less(cmpv);
        int K2 = k.intValue();
        int absK = Math.abs(K2);
        if (K2 == 0) {
            return this.values.list(new IValue[0]);
        }
        block0: for (IValue n : l) {
            if (result.isEmpty()) {
                result.add(n);
                continue;
            }
            int i = 0;
            for (IValue m4 : result) {
                if (K2 > 0 ? less.less(n, m4) : less.less(m4, n)) {
                    result.add(i, n);
                    if (result.size() <= absK) continue block0;
                    result.remove(absK);
                    continue block0;
                }
                ++i;
            }
        }
        IListWriter w = this.values.listWriter();
        w.appendAll(result);
        return (IList)w.done();
    }

    private IList makeUpTill(int from, int len) {
        IListWriter writer = this.values.listWriter();
        for (int i = from; i < len; ++i) {
            writer.append(this.values.integer(i));
        }
        return (IList)writer.done();
    }

    public IValue delete(IList lst, IInteger n) {
        try {
            return lst.delete(n.intValue());
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(n);
        }
    }

    public IValue domain(IList lst) {
        ISetWriter w = this.values.setWriter();
        int len = lst.length();
        for (int i = 0; i < len; ++i) {
            w.insert(this.values.integer(i));
        }
        return w.done();
    }

    public IValue head(IList lst) {
        if (lst.length() > 0) {
            return lst.get(0);
        }
        throw RuntimeExceptionFactory.emptyList();
    }

    public IValue last(IList lst) {
        if (lst.length() > 0) {
            return lst.get(lst.length() - 1);
        }
        throw RuntimeExceptionFactory.emptyList();
    }

    public IValue head(IList lst, IInteger n) throws IndexOutOfBoundsException {
        try {
            return lst.sublist(0, n.intValue());
        }
        catch (IndexOutOfBoundsException e) {
            IInteger end = this.values.integer(n.intValue() - 1);
            throw RuntimeExceptionFactory.indexOutOfBounds(end);
        }
    }

    public IValue getOneFrom(IList lst) {
        int n = lst.length();
        if (n > 0) {
            return lst.get(this.random.nextInt(n));
        }
        throw RuntimeExceptionFactory.emptyList();
    }

    public IValue insertAt(IList lst, IInteger n, IValue elm) throws IndexOutOfBoundsException {
        IListWriter w = this.values.listWriter();
        int k = n.intValue();
        if (k >= 0 && k <= lst.length()) {
            if (k == lst.length()) {
                w.insert(elm);
            }
            for (int i = lst.length() - 1; i >= 0; --i) {
                w.insert(lst.get(i));
                if (i != k) continue;
                w.insert(elm);
            }
            return w.done();
        }
        throw RuntimeExceptionFactory.indexOutOfBounds(n);
    }

    public IValue isEmpty(IList lst) {
        return this.values.bool(lst.isEmpty());
    }

    public IValue reverse(IList lst) {
        return lst.reverse();
    }

    public IValue size(IList lst) {
        return this.values.integer(lst.length());
    }

    public IValue slice(IList lst, IInteger start, IInteger len) {
        try {
            return lst.sublist(start.intValue(), len.intValue());
        }
        catch (IndexOutOfBoundsException e) {
            IInteger end = this.values.integer(start.intValue() + len.intValue());
            throw RuntimeExceptionFactory.indexOutOfBounds(end);
        }
    }

    public IValue tail(IList lst) {
        try {
            return lst.sublist(1, lst.length() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.emptyList();
        }
    }

    public IValue tail(IList lst, IInteger len) {
        int lenVal = len.intValue();
        int lstLen = lst.length();
        try {
            return lst.sublist(lstLen - lenVal, lenVal);
        }
        catch (IndexOutOfBoundsException e) {
            IInteger end = this.values.integer(lenVal - lstLen);
            throw RuntimeExceptionFactory.indexOutOfBounds(end);
        }
    }

    public IValue take(IInteger len, IList lst) {
        int lstLen;
        int lenVal = len.intValue();
        if (lenVal >= (lstLen = lst.length())) {
            return lst;
        }
        return lst.sublist(0, lenVal);
    }

    public IValue drop(IInteger len, IList lst) {
        int lstLen;
        int lenVal = len.intValue();
        if (lenVal >= (lstLen = lst.length())) {
            return this.values.list(new IValue[0]);
        }
        return lst.sublist(lenVal, lstLen - lenVal);
    }

    public IValue upTill(IInteger ni) {
        int n = ni.intValue();
        if (this.indexes == null || this.indexes.get() == null) {
            IList l = this.makeUpTill(0, n);
            this.indexes = new WeakReference<IList>(l);
            return (IValue)this.indexes.get();
        }
        IList l = (IList)this.indexes.get();
        if (l == null || n >= l.length()) {
            l = this.makeUpTill(0, n);
            this.indexes = new WeakReference<IList>(l);
            return l;
        }
        return l.sublist(0, n);
    }

    public IValue prefix(IList lst) {
        int lstLen = lst.length();
        if (lstLen <= 1) {
            return this.values.list(new IValue[0]);
        }
        return lst.sublist(0, lstLen - 1);
    }

    public IValue takeOneFrom(IList lst) {
        int n = lst.length();
        if (n > 0) {
            int k = this.random.nextInt(n);
            IValue pick = lst.get(0);
            IListWriter w = this.values.listWriter();
            for (int i = n - 1; i >= 0; --i) {
                if (i == k) {
                    pick = lst.get(i);
                    continue;
                }
                w.insert(lst.get(i));
            }
            return this.values.tuple(new IValue[]{pick, w.done()});
        }
        throw RuntimeExceptionFactory.emptyList();
    }

    public IMap toMap(IList lst) {
        HashMap<IValue, IListWriter> hm = new HashMap<IValue, IListWriter>();
        for (IValue v : lst) {
            ITuple t2 = (ITuple)v;
            IValue key = t2.get(0);
            IValue val = t2.get(1);
            IListWriter wValList = (IListWriter)hm.get(key);
            if (wValList == null) {
                wValList = this.values.listWriter();
                hm.put(key, wValList);
            }
            wValList.append(val);
        }
        IMapWriter w = this.values.mapWriter();
        for (IValue v : hm.keySet()) {
            w.put(v, (IValue)((IListWriter)hm.get(v)).done());
        }
        return (IMap)w.done();
    }

    public IValue toMapUnique(IList lst) {
        if (lst.length() == 0) {
            return this.values.mapWriter().done();
        }
        IMapWriter w = this.values.mapWriter();
        HashMap<IValue, IValue> seenKeys = new HashMap<IValue, IValue>();
        for (IValue v : lst) {
            ITuple t2 = (ITuple)v;
            IValue key = t2.get(0);
            IValue val = t2.get(1);
            if (seenKeys.containsKey(key)) {
                throw RuntimeExceptionFactory.MultipleKey(key, (IValue)seenKeys.get(key), val);
            }
            seenKeys.put(key, val);
            w.put(key, val);
        }
        return w.done();
    }

    public IValue toSet(IList lst) {
        ISetWriter w = this.values.setWriter();
        for (IValue v : lst) {
            w.insert(v);
        }
        return w.done();
    }

    public IValue toString(IList lst) {
        return this.values.string(lst.toString());
    }

    public IValue itoString(IList lst) {
        return this.itoStringValue(lst);
    }

    private IValue itoStringValue(IValue T) {
        StandardTextWriter w = new StandardTextWriter(true, 2);
        StringWriter result = new StringWriter();
        try {
            w.write(T, result);
            return this.values.string(result.toString());
        }
        catch (IOException e) {
            RuntimeExceptionFactory.io(this.values.string("Could not convert list to indented value"));
            throw new RuntimeException("previous command should always throw");
        }
    }

    public IValue delete(IMap M, IValue key) {
        return M.removeKey(key);
    }

    public IValue domain(IMap M) {
        ISetWriter w = this.values.setWriter();
        Iterator<Map.Entry<IValue, IValue>> iter = M.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<IValue, IValue> entry = iter.next();
            w.insert(entry.getKey());
        }
        return w.done();
    }

    public IValue getOneFrom(IMap m4) {
        int i = 0;
        int sz = m4.size();
        if (sz == 0) {
            throw RuntimeExceptionFactory.emptyMap();
        }
        int k = this.random.nextInt(sz);
        Iterator<Map.Entry<IValue, IValue>> iter = m4.entryIterator();
        while (iter.hasNext()) {
            if (i == k) {
                return iter.next().getKey();
            }
            iter.next();
            ++i;
        }
        throw RuntimeExceptionFactory.emptyMap();
    }

    public IValue invertUnique(IMap M) {
        IMapWriter w = this.values.mapWriter();
        HashMap<IValue, IValue> seenValues = new HashMap<IValue, IValue>();
        Iterator<Map.Entry<IValue, IValue>> iter = M.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<IValue, IValue> entry = iter.next();
            IValue key = entry.getKey();
            IValue val = entry.getValue();
            if (seenValues.containsKey(val)) {
                throw RuntimeExceptionFactory.MultipleKey(val, key, (IValue)seenValues.get(val));
            }
            seenValues.put(val, key);
            w.put(val, key);
        }
        return w.done();
    }

    public IValue invert(IMap M) {
        HashMap<IValue, ISetWriter> hm = new HashMap<IValue, ISetWriter>();
        Iterator<Map.Entry<IValue, IValue>> iter = M.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<IValue, IValue> entry = iter.next();
            IValue key = entry.getKey();
            IValue val = entry.getValue();
            hm.computeIfAbsent(val, k -> this.values.setWriter()).insert(key);
        }
        IMapWriter w = this.values.mapWriter();
        for (Map.Entry v : hm.entrySet()) {
            w.put((IValue)v.getKey(), (IValue)((ISetWriter)v.getValue()).done());
        }
        return w.done();
    }

    public IValue isEmpty(IMap M) {
        return this.values.bool(M.isEmpty());
    }

    public IValue range(IMap M) {
        ISetWriter w = this.values.setWriter();
        Iterator<Map.Entry<IValue, IValue>> iter = M.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<IValue, IValue> entry = iter.next();
            w.insert(entry.getValue());
        }
        return w.done();
    }

    public IValue size(IMap M) {
        return this.values.integer(M.size());
    }

    public IValue toList(IMap M) {
        IListWriter w = this.values.listWriter();
        Iterator<Map.Entry<IValue, IValue>> iter = M.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<IValue, IValue> entry = iter.next();
            w.insert(this.values.tuple(entry.getKey(), entry.getValue()));
        }
        return w.done();
    }

    public IValue toRel(IMap M) {
        ISetWriter w = this.values.setWriter();
        Iterator<Map.Entry<IValue, IValue>> iter = M.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<IValue, IValue> entry = iter.next();
            w.insert(this.values.tuple(entry.getKey(), entry.getValue()));
        }
        return w.done();
    }

    public IValue toString(IMap M) {
        return this.values.string(M.toString());
    }

    public IValue itoString(IMap M) {
        return this.itoStringValue(M);
    }

    public IValue arity(INode T) {
        return this.values.integer(T.arity());
    }

    public IValue getChildren(INode T) {
        IListWriter w = this.values.listWriter();
        for (IValue v : T.getChildren()) {
            w.append(v);
        }
        return w.done();
    }

    public IValue getKeywordParameters(INode T) {
        IMapWriter w = this.values.mapWriter();
        if (T.mayHaveKeywordParameters()) {
            for (Map.Entry<String, IValue> e : T.asWithKeywordParameters().getParameters().entrySet()) {
                w.put(this.values.string(e.getKey()), e.getValue());
            }
        }
        return w.done();
    }

    public IValue getName(INode T) {
        return this.values.string(T.getName());
    }

    public IValue makeNode(IString N2, IList V, IMap kwParams) {
        IList argList = V;
        IValue[] args = new IValue[argList.length()];
        int i = 0;
        for (IValue v : argList) {
            args[i++] = v;
        }
        HashMap<String, IValue> map = new HashMap<String, IValue>();
        for (IValue key : kwParams) {
            map.put(((IString)key).getValue(), kwParams.get(key));
        }
        return this.values.node(N2.getValue(), args, map);
    }

    public IValue toString(INode T) {
        return this.values.string(T.toString());
    }

    public IValue itoString(INode T) {
        return this.itoStringValue(T);
    }

    public INode setKeywordParameters(INode node, IMap kwargs) {
        HashMap<String, IValue> map = new HashMap<String, IValue>();
        kwargs.entryIterator().forEachRemaining(kv -> map.put(((IString)kv.getKey()).getValue(), (IValue)kv.getValue()));
        return node.asWithKeywordParameters().setParameters(map);
    }

    public INode mergeKeywordParameters(INode node, IMap kwargs) {
        Map<String, IValue> map = node.asWithKeywordParameters().getParameters();
        kwargs.entryIterator().forEachRemaining(kv -> map.put(((IString)kv.getKey()).getValue(), (IValue)kv.getValue()));
        return node.asWithKeywordParameters().setParameters(map);
    }

    public INode unset(INode node, IString label) {
        return node.mayHaveKeywordParameters() ? node.asWithKeywordParameters().unsetParameter(label.getValue()) : node;
    }

    public INode unset(INode node) {
        return node.mayHaveKeywordParameters() ? node.asWithKeywordParameters().unsetAll() : node;
    }

    public IValue unsetRec(IValue val) {
        return val.accept(new IdentityVisitor<RuntimeException>(){

            @Override
            public IValue visitConstructor(IConstructor o) throws RuntimeException {
                return this.visitNode(o);
            }

            @Override
            public IValue visitExternal(IExternalValue o) throws RuntimeException {
                if (o instanceof INode) {
                    return this.visitNode((INode)((Object)o));
                }
                return o;
            }

            @Override
            public IValue visitNode(INode o) throws RuntimeException {
                if (o.mayHaveKeywordParameters()) {
                    o = o.asWithKeywordParameters().unsetAll();
                }
                for (int c = 0; c < o.arity(); ++c) {
                    IValue old = o.get(c);
                    IValue replaced = old.accept(this);
                    if (replaced == old) continue;
                    o = o.set(c, replaced);
                }
                return o;
            }

            @Override
            public IValue visitMap(IMap o) throws RuntimeException {
                IMapWriter changedEntries = Prelude.this.values.mapWriter();
                Iterator<Map.Entry<IValue, IValue>> entries = o.entryIterator();
                while (entries.hasNext()) {
                    Map.Entry<IValue, IValue> ent = entries.next();
                    IValue key = ent.getKey();
                    IValue value = ent.getValue();
                    IValue newKey = key.accept(this);
                    IValue newValue = value.accept(this);
                    if (newKey != key) {
                        o = o.removeKey(key);
                        changedEntries.put(newKey, newValue);
                        continue;
                    }
                    if (value == newValue) continue;
                    changedEntries.put(key, newValue);
                }
                IMap changes = (IMap)changedEntries.done();
                if (changes.isEmpty()) {
                    return o;
                }
                return o.join(changes);
            }

            @Override
            public IValue visitList(IList o) throws RuntimeException {
                IWriter newList = null;
                for (int i = 0; i < o.length(); ++i) {
                    IValue elem = o.get(i);
                    IValue newElem = elem.accept(this);
                    if (newList != null) {
                        newList.append(newElem);
                        continue;
                    }
                    if (elem == newElem) continue;
                    newList = Prelude.this.values.listWriter();
                    for (int s2 = 0; s2 < i; ++s2) {
                        newList.append(o.get(s2));
                    }
                    newList.append(newElem);
                }
                return newList == null ? o : newList.done();
            }

            @Override
            public IValue visitSet(ISet o) throws RuntimeException {
                ISetWriter removed = Prelude.this.values.setWriter();
                ISetWriter added = Prelude.this.values.setWriter();
                for (IValue ent : o) {
                    IValue newEnt = ent.accept(this);
                    if (newEnt == ent) continue;
                    removed.append(ent);
                    added.append(newEnt);
                }
                ISet finalRemoved = (ISet)removed.done();
                if (finalRemoved.isEmpty()) {
                    return o;
                }
                ISet finalAdded = (ISet)added.done();
                if (finalRemoved.equals(o)) {
                    return finalAdded;
                }
                return o.subtract(finalRemoved).union(finalAdded);
            }

            @Override
            public IValue visitTuple(ITuple o) throws RuntimeException {
                IValue[] newChildren = null;
                for (int c = 0; c < o.arity(); ++c) {
                    IValue old = o.get(c);
                    IValue replaced = old.accept(this);
                    if (newChildren != null) {
                        newChildren[c] = replaced;
                        continue;
                    }
                    if (replaced == old) continue;
                    newChildren = new IValue[o.arity()];
                    for (int s2 = 0; s2 < c; ++s2) {
                        newChildren[s2] = o.get(s2);
                    }
                    newChildren[c] = replaced;
                }
                return newChildren == null ? o : Prelude.this.values.tuple(newChildren);
            }
        });
    }

    public INode arbNode() {
        return (INode)this.createRandomValue(TypeFactory.getInstance().nodeType(), 1 + this.random.nextInt(5), 1 + this.random.nextInt(5));
    }

    public IFunction parser(IValue start, IBool allowAmbiguity, IBool allowRecovery, IBool hasSideEffects, ISet filters) {
        return this.rascalValues.parser(start, allowAmbiguity, allowRecovery, hasSideEffects, this.values.bool(false), filters);
    }

    public IFunction parser(IValue start, IBool allowAmbiguity, IBool hasSideEffects, ISet filters) {
        return this.rascalValues.parser(start, allowAmbiguity, this.values.bool(false), hasSideEffects, this.values.bool(false), filters);
    }

    public IFunction firstAmbiguityFinder(IValue start, IBool allowRecovery, IBool hasSideEffects, ISet filters) {
        return this.rascalValues.parser(start, this.values.bool(true), allowRecovery, hasSideEffects, this.values.bool(true), filters);
    }

    public IFunction parsers(IValue start, IBool allowAmbiguity, IBool allowRecovery, IBool hasSideEffects, ISet filters) {
        return this.rascalValues.parsers(start, allowAmbiguity, allowRecovery, hasSideEffects, this.values.bool(false), filters);
    }

    public IFunction firstAmbiguityFinders(IValue start, IBool allowRecovery, IBool hasSideEffects, ISet filters) {
        return this.rascalValues.parsers(start, this.values.bool(true), allowRecovery, hasSideEffects, this.values.bool(true), filters);
    }

    public void storeParsers(IValue start, ISourceLocation saveLocation) {
        try {
            this.rascalValues.storeParsers(start, saveLocation);
        }
        catch (JavaCompilation e) {
            throw RuntimeExceptionFactory.javaCompilerException(e);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    public IFunction loadParsers(ISourceLocation savedLocation, IBool allowAmbiguity, IBool allowRecovery, IBool hasSideEffects, ISet filters) {
        try {
            return this.rascalValues.loadParsers(savedLocation, allowAmbiguity, allowRecovery, hasSideEffects, this.values.bool(false), filters);
        }
        catch (IOException | ClassNotFoundException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    public IFunction loadParser(IValue grammar, ISourceLocation savedLocation, IBool allowRecovery, IBool allowAmbiguity, IBool hasSideEffects, ISet filters) {
        try {
            return this.rascalValues.loadParser(grammar, savedLocation, allowAmbiguity, allowRecovery, hasSideEffects, this.values.bool(false), filters);
        }
        catch (IOException | ClassNotFoundException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    protected IConstructor makeConstructor(TypeStore store, Type returnType, String name, IValue ... args) {
        IConstructor value = this.values.constructor(store.lookupConstructor(returnType, name, TypeFactory.getInstance().tupleType(args)), args, new HashMap<String, IValue>());
        Type type = value.getType();
        if (type.isAbstractData()) {
            return value;
        }
        throw RuntimeExceptionFactory.implodeError("Calling of constructor " + name + " did not return a constructor");
    }

    protected String unescapedConsName(ITree tree) {
        String x = TreeAdapter.getConstructorName(tree);
        if (x != null) {
            x = x.replaceAll("\\\\", "");
        }
        return x;
    }

    protected Set<Type> findConstructors(Type type, String constructorName, int arity, TypeStore store) {
        HashSet<Type> constructors = new HashSet<Type>();
        for (Type constructor : store.lookupConstructor(type, constructorName)) {
            if (constructor.getArity() != arity) continue;
            constructors.add(constructor);
        }
        return constructors;
    }

    public IValue implode(IValue reifiedType, IConstructor arg) {
        ITree tree = (ITree)arg;
        TypeStore store = new TypeStore(new TypeStore[0]);
        Type type = this.tr.valueToType((IConstructor)reifiedType, store);
        try {
            IValue result = this.implode(store, type, tree, false);
            if (this.isUntypedNodeType(type) && !type.isTop() && (TreeAdapter.isList(tree) || TreeAdapter.isOpt(tree))) {
                result = this.values.node("", result);
            }
            return result;
        }
        catch (Backtrack b) {
            throw b.exception;
        }
    }

    private IValue[] implodeArgs(TypeStore store, Type type, IList args) {
        int length = args.length();
        IValue[] implodedArgs = new IValue[length];
        for (int i = 0; i < length; ++i) {
            Type argType = this.isUntypedNodeType(type) ? type : type.getFieldType(i);
            implodedArgs[i] = this.implode(store, argType, (ITree)args.get(i), false);
        }
        return implodedArgs;
    }

    protected IValue implode(TypeStore store, Type type, IConstructor arg0, boolean splicing) {
        ITree tree = (ITree)arg0;
        Backtrack failReason = null;
        if (type.isString() && !splicing) {
            return this.values.string(TreeAdapter.yield(tree));
        }
        if (SymbolAdapter.isStartSort(TreeAdapter.getType(tree))) {
            IList args = TreeAdapter.getArgs(tree);
            ITree before = (ITree)args.get(0);
            ITree ast = (ITree)args.get(1);
            ITree after = (ITree)args.get(2);
            IValue result = this.implode(store, type, ast, splicing);
            if (result.getType().isNode()) {
                IList afterComments;
                IMapWriter comments = this.values.mapWriter();
                comments.putAll((IMap)((INode)result).asWithKeywordParameters().getParameter("comments"));
                IList beforeComments = this.extractComments(before);
                if (!beforeComments.isEmpty()) {
                    comments.put(this.values.integer(-1), beforeComments);
                }
                if (!(afterComments = this.extractComments(after)).isEmpty()) {
                    comments.put(this.values.integer(((INode)result).arity()), afterComments);
                }
                result = ((INode)result).asWithKeywordParameters().setParameter("comments", (IValue)comments.done());
            }
            return result;
        }
        if (TreeAdapter.isLexical(tree)) {
            String constructorName = this.unescapedConsName(tree);
            String yield = TreeAdapter.yield(tree);
            if (constructorName != null) {
                if (!type.isAbstractData() && !this.isUntypedNodeType(type)) {
                    throw RuntimeExceptionFactory.illegalArgument((IValue)tree, "Constructor (" + constructorName + ") should match with abstract data type and not with " + type);
                }
                if (this.isUntypedNodeType(type)) {
                    return this.values.node(constructorName, this.values.string(yield));
                }
                Set<Type> conses = this.findConstructors(type, constructorName, 1, store);
                Iterator<Type> iter = conses.iterator();
                while (iter.hasNext()) {
                    try {
                        Type cons = iter.next();
                        ISourceLocation loc = TreeAdapter.getLocation(tree);
                        IConstructor ast = this.makeConstructor(store, type, constructorName, this.values.string(yield));
                        String locLabel = store.getKeywordParameterType(type, "location") == TypeFactory.getInstance().sourceLocationType() ? "location" : "src";
                        return ast.asWithKeywordParameters().setParameter(locLabel, loc);
                    }
                    catch (Backtrack b) {
                        failReason = b;
                    }
                }
                throw failReason != null ? failReason : new Backtrack(RuntimeExceptionFactory.illegalArgument((IValue)tree, "Cannot find a constructor " + type));
            }
            if (type.isInteger()) {
                return this.values.integer(yield);
            }
            if (type.isReal()) {
                return this.values.real(yield);
            }
            if (type.isBool()) {
                if (yield.equals("true")) {
                    return this.values.bool(true);
                }
                if (yield.equals("false")) {
                    return this.values.bool(false);
                }
                throw new Backtrack(RuntimeExceptionFactory.illegalArgument((IValue)tree, "Bool type does not match with " + yield));
            }
            if (type.isString() || this.isUntypedNodeType(type)) {
                return this.values.string(yield);
            }
            throw RuntimeExceptionFactory.illegalArgument((IValue)tree, "Missing lexical constructor");
        }
        if (TreeAdapter.isList(tree)) {
            if (type.isList() || splicing || this.isUntypedNodeType(type)) {
                Type elementType = type;
                if (!splicing && !this.isUntypedNodeType(type)) {
                    elementType = type.getElementType();
                }
                IListWriter w = this.values.listWriter();
                for (IValue arg : TreeAdapter.getListASTArgs(tree)) {
                    w.append(this.implode(store, elementType, (ITree)arg, false));
                }
                return w.done();
            }
            if (type.isSet()) {
                Type elementType = splicing ? type : type.getElementType();
                ISetWriter w = this.values.setWriter();
                for (IValue arg : TreeAdapter.getListASTArgs(tree)) {
                    w.insert(this.implode(store, elementType, (ITree)arg, false));
                }
                return w.done();
            }
            throw new Backtrack(RuntimeExceptionFactory.illegalArgument((IValue)tree, "Cannot match list with " + type));
        }
        if (TreeAdapter.isOpt(tree) && type.isBool()) {
            IList args = TreeAdapter.getArgs(tree);
            if (args.isEmpty()) {
                return this.values.bool(false);
            }
            return this.values.bool(true);
        }
        if (TreeAdapter.isOpt(tree)) {
            if (!type.isList() && !this.isUntypedNodeType(type)) {
                throw new Backtrack(RuntimeExceptionFactory.illegalArgument((IValue)tree, "Optional should match with a list and not " + type));
            }
            Type elementType = this.isUntypedNodeType(type) ? type : type.getElementType();
            IListWriter w = this.values.listWriter();
            Iterator conses = TreeAdapter.getASTArgs(tree).iterator();
            if (conses.hasNext()) {
                IValue arg = (IValue)conses.next();
                IValue implodedArg = this.implode(store, elementType, (ITree)arg, true);
                if (implodedArg instanceof IList) {
                    for (IValue nextArg : (IList)implodedArg) {
                        w.append(nextArg);
                    }
                } else {
                    w.append(implodedArg);
                }
            }
            return w.done();
        }
        if (TreeAdapter.isAmb(tree)) {
            if (!type.isSet()) {
                throw new Backtrack(RuntimeExceptionFactory.illegalArgument((IValue)tree, "Ambiguous node should match with set and not " + type));
            }
            Type elementType = type.getElementType();
            ISetWriter w = this.values.setWriter();
            for (IValue arg : TreeAdapter.getAlternatives(tree)) {
                w.insert(this.implode(store, elementType, (ITree)arg, false));
            }
            return w.done();
        }
        if (ProductionAdapter.hasAttribute(TreeAdapter.getProduction(tree), RascalValueFactory.Attribute_Bracket)) {
            return this.implode(store, type, (ITree)TreeAdapter.getASTArgs(tree).get(0), false);
        }
        if (TreeAdapter.isAppl(tree)) {
            IList args = TreeAdapter.getASTArgs(tree);
            int j = 0;
            IMapWriter cw = this.values.mapWriter();
            IListWriter aw = this.values.listWriter();
            for (IValue kid : TreeAdapter.getArgs(tree)) {
                if (TreeAdapter.isLayout((ITree)kid)) {
                    IList cts = this.extractComments((ITree)kid);
                    if (!cts.isEmpty()) {
                        cw.put(this.values.integer(j), cts);
                    }
                    ++j;
                    continue;
                }
                if (TreeAdapter.isLiteral((ITree)kid) || TreeAdapter.isCILiteral((ITree)kid) || TreeAdapter.isEmpty((ITree)kid)) continue;
                aw.append(kid);
            }
            args = (IList)aw.done();
            int length = args.length();
            IMap comments = (IMap)cw.done();
            String constructorName = this.unescapedConsName(tree);
            if (constructorName == null) {
                if (length == 1) {
                    return this.implode(store, type, (ITree)args.get(0), splicing);
                }
                if (this.isUntypedNodeType(type)) {
                    return this.values.tuple(this.implodeArgs(store, type, args));
                }
                if (!type.isTuple()) {
                    throw new Backtrack(RuntimeExceptionFactory.illegalArgument((IValue)tree, "Constructor does not match with " + type));
                }
                if (length != type.getArity()) {
                    throw new Backtrack(RuntimeExceptionFactory.arityMismatch(type.getArity(), length));
                }
                return this.values.tuple(this.implodeArgs(store, type, args));
            }
            if (this.isUntypedNodeType(type)) {
                INode ast = this.values.node(constructorName, this.implodeArgs(store, type, args));
                return ast.asWithKeywordParameters().setParameter("src", TreeAdapter.getLocation(tree)).asWithKeywordParameters().setParameter("comments", comments);
            }
            if (!type.isAbstractData()) {
                throw new Backtrack(RuntimeExceptionFactory.illegalArgument((IValue)tree, "Constructor (" + constructorName + ") should match with abstract data type and not with " + type));
            }
            Set<Type> conses = this.findConstructors(type, constructorName, length, store);
            Iterator<Type> iter = conses.iterator();
            while (iter.hasNext()) {
                try {
                    Type cons = iter.next();
                    ISourceLocation loc = TreeAdapter.getLocation(tree);
                    IValue[] implodedArgs = this.implodeArgs(store, cons, args);
                    IConstructor ast = this.makeConstructor(store, type, constructorName, implodedArgs);
                    String locLabel = store.getKeywordParameterType(type, "location") == TypeFactory.getInstance().sourceLocationType() ? "location" : "src";
                    return ast.asWithKeywordParameters().setParameter(locLabel, loc).asWithKeywordParameters().setParameter("comments", comments);
                }
                catch (Backtrack b) {
                    failReason = b;
                }
            }
            throw failReason != null ? failReason : new Backtrack(RuntimeExceptionFactory.illegalArgument((IValue)tree, "Cannot find a constructor for " + type + " with name " + constructorName + " and arity " + length + " for syntax type '" + ProductionAdapter.getSortName(TreeAdapter.getProduction(tree)) + "'"));
        }
        throw failReason != null ? failReason : new Backtrack(RuntimeExceptionFactory.illegalArgument((IValue)tree, "Cannot find a constructor for " + type));
    }

    private IList extractComments(IConstructor layout) {
        final IListWriter comments = this.values.listWriter();
        TreeVisitor<RuntimeException> visitor = new TreeVisitor<RuntimeException>(){

            @Override
            public ITree visitTreeAppl(ITree arg) {
                if (TreeAdapter.isComment(arg)) {
                    comments.append(Prelude.this.values.string(TreeAdapter.yield(arg)));
                } else {
                    for (IValue t2 : TreeAdapter.getArgs(arg)) {
                        t2.accept(this);
                    }
                }
                return arg;
            }

            @Override
            public ITree visitTreeAmb(ITree arg) {
                return arg;
            }

            @Override
            public ITree visitTreeChar(ITree arg) {
                return arg;
            }

            @Override
            public ITree visitTreeCycle(ITree arg) {
                return arg;
            }
        };
        layout.accept(visitor);
        return (IList)comments.done();
    }

    protected boolean isUntypedNodeType(Type type) {
        return type.isNode() && !type.isConstructor() && !type.isAbstractData() || type.isTop();
    }

    public IValue numerator(IRational n) {
        return n.numerator();
    }

    public IValue denominator(IRational n) {
        return n.denominator();
    }

    public IValue remainder(IRational n) {
        return n.remainder();
    }

    public IValue getOneFrom(ISet st) {
        int sz = st.size();
        if (sz == 0) {
            throw RuntimeExceptionFactory.emptySet();
        }
        int k = this.random.nextInt(sz);
        int i = 0;
        for (IValue v : st) {
            if (i == k) {
                return v;
            }
            ++i;
        }
        throw RuntimeExceptionFactory.emptySet();
    }

    public IValue getFirstFrom(ISet st) {
        int sz = st.size();
        if (sz == 0) {
            throw RuntimeExceptionFactory.emptySet();
        }
        Iterator iterator = st.iterator();
        if (iterator.hasNext()) {
            IValue v = (IValue)iterator.next();
            return v;
        }
        throw RuntimeExceptionFactory.emptySet();
    }

    public IValue isEmpty(ISet st) {
        return this.values.bool(st.isEmpty());
    }

    public IValue size(ISet st) {
        return this.values.integer(st.size());
    }

    public IMap index(ISet s2) {
        return Prelude.indexIterable(this.values, s2, s2.size());
    }

    public IMap index(IList l) {
        return Prelude.indexIterable(this.values, l, l.length());
    }

    public static IMap index(IValueFactory vf, ISet s2) {
        return Prelude.indexIterable(vf, s2, s2.size());
    }

    private static IMap indexIterable(IValueFactory values, Iterable<IValue> s2, int suggestedSize) {
        HashMap<IValue, ISetWriter> map = new HashMap<IValue, ISetWriter>(suggestedSize);
        for (IValue t2 : s2) {
            ITuple tuple = (ITuple)t2;
            IValue key = tuple.get(0);
            IValue value = tuple.get(1);
            map.computeIfAbsent(key, k -> values.setWriter()).insert(value);
        }
        IMapWriter mapWriter = values.mapWriter();
        for (Map.Entry ent : map.entrySet()) {
            mapWriter.put((IValue)ent.getKey(), (IValue)((ISetWriter)ent.getValue()).done());
        }
        return (IMap)mapWriter.done();
    }

    public IValue takeOneFrom(ISet st) {
        int n = st.size();
        if (n > 0) {
            int i = 0;
            int k = this.random.nextInt(n);
            IValue pick = null;
            ISetWriter w = this.values.setWriter();
            for (IValue v : st) {
                if (i == k) {
                    pick = v;
                } else {
                    w.insert(v);
                }
                ++i;
            }
            return this.values.tuple(new IValue[]{pick, w.done()});
        }
        throw RuntimeExceptionFactory.emptySet();
    }

    public IValue toList(ISet st) {
        IListWriter w = this.values.listWriter();
        for (IValue v : st) {
            w.insert(v);
        }
        return w.done();
    }

    public IValue toMap(ISet st) {
        HashMap<IValue, ISetWriter> hm = new HashMap<IValue, ISetWriter>();
        for (IValue v : st) {
            ITuple t2 = (ITuple)v;
            IValue key = t2.get(0);
            IValue val = t2.get(1);
            ISetWriter wValSet = (ISetWriter)hm.get(key);
            if (wValSet == null) {
                wValSet = this.values.setWriter();
                hm.put(key, wValSet);
            }
            wValSet.insert(val);
        }
        IMapWriter w = this.values.mapWriter();
        for (IValue v : hm.keySet()) {
            w.put(v, (IValue)((ISetWriter)hm.get(v)).done());
        }
        return w.done();
    }

    public IValue toMapUnique(ISet st) {
        IMapWriter w = this.values.mapWriter();
        HashMap<IValue, IValue> seenKeys = new HashMap<IValue, IValue>();
        for (IValue v : st) {
            ITuple t2 = (ITuple)v;
            IValue key = t2.get(0);
            IValue val = t2.get(1);
            if (seenKeys.containsKey(key)) {
                throw RuntimeExceptionFactory.MultipleKey(key, (IValue)seenKeys.get(key), val);
            }
            seenKeys.put(key, val);
            w.put(key, val);
        }
        return w.done();
    }

    public IValue toString(ISet st) {
        return this.values.string(st.toString());
    }

    public IValue itoString(ISet st) {
        return this.itoStringValue(st);
    }

    public IString arbString(IInteger n) {
        return (IString)this.createRandomValue(TypeFactory.getInstance().stringType(), n.intValue(), n.intValue());
    }

    public IBool isValidCharacter(IInteger i) {
        return this.values.bool(Character.isValidCodePoint(i.intValue()));
    }

    public IValue stringChar(IInteger i) {
        int intValue = i.intValue();
        if (Character.isValidCodePoint(intValue)) {
            return this.values.string(intValue);
        }
        throw RuntimeExceptionFactory.illegalArgument(i);
    }

    public IValue stringChars(IList lst) {
        int[] chars = new int[lst.length()];
        for (int i = 0; i < lst.length(); ++i) {
            chars[i] = ((IInteger)lst.get(i)).intValue();
            if (Character.isValidCodePoint(chars[i])) continue;
            throw RuntimeExceptionFactory.illegalArgument(this.values.integer(chars[i]));
        }
        return this.values.string(chars);
    }

    public IValue charAt(IString s2, IInteger i) throws IndexOutOfBoundsException {
        try {
            return this.values.integer(s2.charAt(i.intValue()));
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(i);
        }
    }

    public IValue endsWith(IString s2, IString suffix) {
        return this.values.bool(s2.getValue().endsWith(suffix.getValue()));
    }

    public IString trim(IString s2) {
        return this.values.string(s2.getValue().trim());
    }

    public IString squeeze(IString src, IString charSet) {
        if (charSet.getValue().isEmpty()) {
            return src;
        }
        Pattern isCharset = Pattern.compile("[" + charSet.getValue() + "]", 256);
        StringBuilder result = new StringBuilder(src.length());
        PrimitiveIterator.OfInt chars = src.iterator();
        int previousMatch = -1;
        while (chars.hasNext()) {
            int cp = chars.nextInt();
            if (cp == previousMatch) continue;
            String c = Character.toString(cp);
            previousMatch = isCharset.matcher(c).matches() ? cp : -1;
            result.append(c);
        }
        return this.values.string(result.toString());
    }

    public IString capitalize(IString src) {
        StringBuilder result = new StringBuilder(src.length());
        boolean lastWhitespace = true;
        for (int cIndex = 0; cIndex < src.length(); ++cIndex) {
            int cp = src.charAt(cIndex);
            if (Character.isWhitespace(cp)) {
                lastWhitespace = true;
            } else if (lastWhitespace) {
                lastWhitespace = false;
                cp = Character.toUpperCase(cp);
            }
            result.appendCodePoint(cp);
        }
        return this.values.string(result.toString());
    }

    public IString uncapitalize(IString src) {
        StringBuilder result = new StringBuilder(src.length());
        boolean lastWhitespace = true;
        for (int cIndex = 0; cIndex < src.length(); ++cIndex) {
            int cp = src.charAt(cIndex);
            if (Character.isWhitespace(cp)) {
                lastWhitespace = true;
            } else if (lastWhitespace) {
                lastWhitespace = false;
                cp = Character.toLowerCase(cp);
            }
            result.appendCodePoint(cp);
        }
        return this.values.string(result.toString());
    }

    public IList split(IString sep, IString src) {
        String[] lst = src.getValue().split(Pattern.quote(sep.getValue()));
        IListWriter lw = this.values.listWriter();
        for (String s2 : lst) {
            lw.append(this.values.string(s2));
        }
        return (IList)lw.done();
    }

    public IString wrap(IString src, IInteger wrapLength) {
        int wrapAt = wrapLength.intValue();
        if (wrapAt < 1) {
            wrapAt = 1;
        }
        int iLength = src.length();
        StringBuilder result = new StringBuilder(iLength + iLength / wrapAt);
        int lineBegin = 0;
        while (iLength - lineBegin > wrapAt) {
            int lineEnd;
            while (lineBegin < iLength && src.charAt(lineBegin) == 32) {
                ++lineBegin;
            }
            for (lineEnd = lineBegin + wrapAt; lineEnd > lineBegin && lineEnd < iLength && src.charAt(lineEnd) != 32; --lineEnd) {
            }
            if (lineEnd > lineBegin) {
                result.append(src.substring(lineBegin, lineEnd).getValue());
                result.append(System.lineSeparator());
                lineBegin = lineEnd + 1;
                continue;
            }
            for (lineEnd = lineBegin + wrapAt; lineEnd < iLength && src.charAt(lineEnd) != 32; ++lineEnd) {
            }
            result.append(src.substring(lineBegin, lineEnd).getValue());
            if (lineEnd < iLength) {
                result.append(System.lineSeparator());
            }
            lineBegin = lineEnd + 1;
        }
        if (lineBegin < iLength) {
            result.append(src.substring(lineBegin).getValue());
        }
        return this.values.string(result.toString());
    }

    public IValue format(IString s2, IString dir, IInteger n, IString pad) {
        int nVal;
        StringBuffer res = new StringBuffer();
        int sLen = s2.length();
        if (sLen > (nVal = n.intValue())) {
            return s2;
        }
        int padLen = pad.length();
        String dirVal = dir.getValue();
        int start = dirVal.equals("right") ? nVal - sLen : (dirVal.equals("center") ? (nVal - sLen) / 2 : 0);
        int i = 0;
        while (i < start) {
            if (i + padLen < start) {
                res.append(pad.getValue());
                i += padLen;
                continue;
            }
            res.append(pad.substring(0, start - i).getValue());
            i += start - i;
        }
        res.append(s2.getValue());
        i = start + sLen;
        while (i < nVal) {
            if (i + padLen < nVal) {
                res.append(pad.getValue());
                i += padLen;
                continue;
            }
            res.append(pad.substring(0, nVal - i).getValue());
            i += nVal - i;
        }
        return this.values.string(res.toString());
    }

    public IValue isEmpty(IString s2) {
        return this.values.bool(s2.getValue().isEmpty());
    }

    public IValue reverse(IString s2) {
        return s2.reverse();
    }

    public IValue size(IString s2) {
        return this.values.integer(s2.length());
    }

    public IValue startsWith(IString s2, IString prefix) {
        if (prefix.length() == 0) {
            return this.values.bool(true);
        }
        return this.values.bool(s2.getValue().startsWith(prefix.getValue()));
    }

    public IValue substring(IString s2, IInteger begin) {
        try {
            return s2.substring(begin.intValue());
        }
        catch (IndexOutOfBoundsException e) {
            throw RuntimeExceptionFactory.indexOutOfBounds(begin);
        }
    }

    public IValue substring(IString s2, IInteger begin, IInteger end) {
        try {
            return s2.substring(begin.intValue(), end.intValue());
        }
        catch (IndexOutOfBoundsException e) {
            int bval = begin.intValue();
            IInteger culprit = bval < 0 || bval >= s2.length() ? begin : end;
            throw RuntimeExceptionFactory.indexOutOfBounds(culprit);
        }
    }

    public IValue toInt(IString s2) {
        try {
            String sval = s2.getValue();
            boolean isNegative = false;
            int radix = 10;
            if (sval.equals("0")) {
                return this.values.integer(0);
            }
            if (sval.startsWith("-")) {
                isNegative = true;
                sval = sval.substring(1);
            }
            if (sval.startsWith("0x") || sval.startsWith("0X")) {
                radix = 16;
                sval = sval.substring(2);
            } else if (sval.startsWith("0")) {
                radix = 8;
                sval = sval.substring(1);
            }
            BigInteger bi = new BigInteger((String)(isNegative ? "-" + sval : sval), radix);
            return this.values.integer(bi.toString());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)s2, e.getMessage());
        }
    }

    public IValue toInt(IString s2, IInteger r) {
        try {
            String sval = s2.getValue();
            boolean isNegative = false;
            int radix = r.intValue();
            if (sval.equals("0")) {
                return this.values.integer(0);
            }
            if (sval.startsWith("-")) {
                isNegative = true;
                sval = sval.substring(1);
            }
            BigInteger bi = new BigInteger((String)(isNegative ? "-" + sval : sval), radix);
            return this.values.integer(bi.toString());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument();
        }
    }

    public IValue toReal(IString s2) {
        try {
            return this.values.real(s2.getValue());
        }
        catch (NumberFormatException e) {
            throw RuntimeExceptionFactory.illegalArgument();
        }
    }

    public IValue toReal(IRational s2) {
        return s2.toReal(this.values.getPrecision());
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = from.read(buffer, 0, buffer.length)) != -1) {
            to.write(buffer, 0, read);
        }
    }

    private void copy(Reader from, Writer to) throws IOException {
        int read;
        char[] buffer = new char[4096];
        while ((read = from.read(buffer, 0, buffer.length)) != -1) {
            to.write(buffer, 0, read);
        }
    }

    private String toBase64(InputStream src, int estimatedSize, boolean includePadding) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(estimatedSize);
        Base64.Encoder encoder = Base64.getEncoder();
        if (!includePadding) {
            encoder = encoder.withoutPadding();
        }
        OutputStream dest = encoder.wrap(result);
        Prelude.copy(src, dest);
        dest.close();
        return result.toString(StandardCharsets.ISO_8859_1.name());
    }

    public IString toBase64(IString in, IString charsetName, IBool includePadding) {
        try {
            Charset charset = Charset.forName(charsetName.getValue());
            ByteBufferBackedInputStream bytes = new ByteBufferBackedInputStream(charset.encode(in.getValue()));
            return this.values.string(this.toBase64(bytes, in.length() * 2, includePadding.getValue()));
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public IString toBase64(ISourceLocation file, IBool includePadding) {
        return this.readBase64(file, includePadding);
    }

    private void fromBase64(String src, OutputStream target) throws IOException {
        ByteBufferBackedInputStream bytes = new ByteBufferBackedInputStream(StandardCharsets.ISO_8859_1.encode(src));
        Prelude.copy(Base64.getDecoder().wrap(bytes), target);
    }

    public IString fromBase64(IString in, IString charset) {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream(in.length());
            this.fromBase64(in.getValue(), result);
            return this.values.string(result.toString(charset.getValue()));
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    public IString toBase32(IString in, IString charsetName, IBool includePadding) {
        Base32 encoder = new Base32();
        Charset charset = Charset.forName(charsetName.getValue());
        String encoded = encoder.encodeToString(in.getValue().getBytes(charset));
        if (!includePadding.getValue()) {
            encoded = encoded.replace("=", "");
        }
        return this.values.string(encoded);
    }

    public IString fromBase32(IString in, IString charsetName) {
        Base32 decoder = new Base32(0, new byte[0], false, 61, CodecPolicy.LENIENT);
        byte[] data = decoder.decode(in.getValue());
        Charset charset = Charset.forName(charsetName.getValue());
        return this.values.string(new String(data, charset));
    }

    public IValue toLowerCase(IString s2) {
        return this.values.string(s2.getValue().toLowerCase());
    }

    public IValue toUpperCase(IString s2) {
        return this.values.string(s2.getValue().toUpperCase());
    }

    private boolean match(IString subject, int i, IString pattern) {
        if (i + pattern.length() > subject.length()) {
            return false;
        }
        for (int k = 0; k < pattern.length(); ++k) {
            if (subject.charAt(i) != pattern.charAt(k)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IValue replaceAll(IString str, IString find, IString replacement) {
        int fLength = find.length();
        if (fLength == 0) {
            return str;
        }
        int iLength = str.length();
        StringBuilder b = new StringBuilder(iLength * 2);
        int i = 0;
        boolean matched = false;
        while (i < iLength) {
            if (this.match(str, i, find)) {
                matched = true;
                b.append(replacement.getValue());
                i += Math.max(1, fLength);
                continue;
            }
            b.appendCodePoint(str.charAt(i));
            ++i;
        }
        return !matched ? str : this.values.string(b.toString());
    }

    public IValue replaceFirst(IString str, IString find, IString replacement) {
        int fLength = find.length();
        if (fLength == 0) {
            return str;
        }
        int iLength = str.length();
        StringBuilder b = new StringBuilder(iLength * 2);
        int i = 0;
        boolean matched = false;
        while (i < iLength) {
            if (!matched && this.match(str, i, find)) {
                matched = true;
                b.append(replacement.getValue());
                i += fLength;
                continue;
            }
            b.appendCodePoint(str.charAt(i));
            ++i;
        }
        return !matched ? str : this.values.string(b.toString());
    }

    public IValue replaceLast(IString str, IString find, IString replacement) {
        int fLength = find.length();
        if (fLength == 0) {
            return str;
        }
        int iLength = str.length();
        StringBuilder b = new StringBuilder(iLength * 2);
        for (int i = iLength - fLength; i >= 0; --i) {
            if (!this.match(str, i, find)) continue;
            b.append(str.substring(0, i).getValue());
            b.append(replacement.getValue());
            b.append(str.substring(i + fLength).getValue());
            return this.values.string(b.toString());
        }
        return str;
    }

    public IValue escape(IString str, IMap substitutions) {
        StringBuilder b = new StringBuilder(str.length() * 2);
        int sLength = str.length();
        for (int c = 0; c < sLength; ++c) {
            IString chr = str.substring(c, c + 1);
            IString sub = (IString)substitutions.get(chr);
            if (sub != null) {
                b.append(sub.getValue());
                continue;
            }
            b.append(chr.getValue());
        }
        return this.values.string(b.toString());
    }

    public IValue contains(IString str, IString find) {
        return this.values.bool(str.getValue().indexOf(find.getValue()) >= 0);
    }

    public IValue findAll(IString str, IString find) {
        int iLength = str.length();
        int fLength = find.length();
        IListWriter w = this.values.listWriter();
        for (int i = 0; i <= iLength - fLength; ++i) {
            if (!this.match(str, i, find)) continue;
            w.append(this.values.integer(i));
        }
        return w.done();
    }

    public IValue findFirst(IString str, IString find) {
        int iLength = str.length();
        int fLength = find.length();
        for (int i = 0; i <= iLength - fLength; ++i) {
            if (!this.match(str, i, find)) continue;
            return this.values.integer(i);
        }
        return this.values.integer(-1);
    }

    public IValue findLast(IString str, IString find) {
        int iLength = str.length();
        int fLength = find.length();
        for (int i = iLength - fLength; i >= 0; --i) {
            if (!this.match(str, i, find)) continue;
            return this.values.integer(i);
        }
        return this.values.integer(-1);
    }

    public IList fieldsOf(IValue v) {
        if (!v.getType().isTuple()) {
            throw RuntimeExceptionFactory.illegalArgument(v, "argument of type tuple is required");
        }
        ITuple tp = (ITuple)v;
        Type tt = tp.getType();
        int a = tt.getArity();
        IListWriter w = this.values.listWriter();
        for (int i = 0; i < a; ++i) {
            String fname = tt.getFieldName(i);
            if (fname == null) {
                fname = "";
            }
            w.append(this.values.string(fname));
        }
        return (IList)w.done();
    }

    public IInteger getFileLength(ISourceLocation g2) {
        IInteger iInteger;
        block11: {
            if (g2.getScheme().equals("file")) {
                File f = new File(g2.getURI());
                if (!f.exists() || f.isDirectory()) {
                    throw RuntimeExceptionFactory.io(this.values.string(g2.toString()));
                }
                return this.values.integer(f.length());
            }
            InputStream in = this.REGISTRY.getInputStream(g2);
            try {
                int block;
                long total = 0L;
                byte[] buffer = new byte[2048];
                while ((block = in.read(buffer)) != -1) {
                    total += (long)block;
                }
                iInteger = this.values.integer(total);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(e.getMessage());
                }
            }
            in.close();
        }
        return iInteger;
    }

    public void registerLocations(IString scheme, IString auth, IMap map) {
        if (this.monitor instanceof IDEServices) {
            ((IDEServices)this.monitor).registerLocations(scheme, auth, map);
        }
        this.REGISTRY.registerLogical(new LogicalMapResolver(scheme.getValue(), auth.getValue(), map));
    }

    public void unregisterLocations(IString scheme, IString auth) {
        if (this.monitor instanceof IDEServices) {
            ((IDEServices)this.monitor).unregisterLocations(scheme, auth);
        } else {
            this.REGISTRY.unregisterLogical(scheme.getValue(), auth.getValue());
        }
    }

    public ISourceLocation resolveLocation(ISourceLocation loc) {
        try {
            return this.REGISTRY.logicalToPhysical(loc);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.schemeNotSupported(loc);
        }
    }

    public ISourceLocation mavenize(ISourceLocation jar) {
        return MavenRepositoryURIResolver.mavenize(jar);
    }

    public ISourceLocation jarify(ISourceLocation jar) {
        return JarURIResolver.jarify(jar);
    }

    public ISet findResources(IString fileName) {
        return this.resourceProvider.findResources(fileName.getValue()).stream().collect(this.values.setWriter());
    }

    public ISourceLocation relativize(ISourceLocation outside, ISourceLocation inside) {
        return URIUtil.relativize(outside, inside);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IValue readBinaryValueFile(IValue type, ISourceLocation loc) {
        if (this.trackIO) {
            System.err.println("readBinaryValueFile: " + loc);
        }
        TypeStore store = new TypeStore(RascalValueFactory.getStore());
        Type start = this.tr.valueToType((IConstructor)type, store);
        try (IValueInputStream in = this.constructValueReader(loc);){
            IValue val = in.read();
            if (!val.getType().isSubtypeOf(start)) throw RuntimeExceptionFactory.io(this.values.string("Requested type " + start + ", but found " + val.getType()));
            IValue iValue = val;
            return iValue;
        }
        catch (IOException e) {
            System.err.println("readBinaryValueFile: " + loc + " throws " + e.getMessage());
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
        catch (Exception e) {
            System.err.println("readBinaryValueFile: " + loc + " throws " + e.getMessage());
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
        }
    }

    private IValueInputStream constructValueReader(ISourceLocation loc) throws IOException {
        FileChannel channel;
        URIResolverRegistry registry = this.REGISTRY;
        if (registry.supportsReadableFileChannel(loc) && (channel = registry.getReadableFileChannel(loc)) != null) {
            return new IValueInputStream(channel, this.values, RascalValueFactory.TYPE_STORE_SUPPLIER);
        }
        return new IValueInputStream(registry.getInputStream(loc), this.values, RascalValueFactory.TYPE_STORE_SUPPLIER);
    }

    public IInteger __getFileSize(ISourceLocation loc) throws URISyntaxException, IOException {
        return Prelude.__getFileSize(this.values, loc);
    }

    public static IInteger __getFileSize(IValueFactory values, ISourceLocation loc) throws URISyntaxException, IOException {
        if (loc.getScheme().contains("compressed+")) {
            loc = URIUtil.changeScheme(loc, loc.getScheme().replace("compressed+", ""));
        }
        IInteger result = values.integer(0);
        try (InputStream in = URIResolverRegistry.getInstance().getInputStream(loc);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer, 0, buffer.length)) != -1) {
                result = result.add(values.integer(read));
            }
            IInteger iInteger = result;
            return iInteger;
        }
    }

    public IValue readTextValueFile(IValue type, ISourceLocation loc) {
        IValue iValue;
        block12: {
            if (this.trackIO) {
                System.err.println("readTextValueFile: " + loc);
            }
            TypeStore store = new TypeStore(new TypeStore[0]);
            Type start = this.tr.valueToType((IConstructor)type, store);
            Reader in = this.REGISTRY.getCharacterReader(loc, StandardCharsets.UTF_8);
            try {
                iValue = new StandardTextReader().read(this.values, store, start, in);
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FactParseError e) {
                    throw RuntimeExceptionFactory.parseError(this.values.sourceLocation(loc, e.getOffset(), 1));
                }
                catch (FactTypeUseException e) {
                    throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
                }
                catch (Exception e) {
                    throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
                }
            }
            in.close();
        }
        return iValue;
    }

    public IValue readTextValueString(IValue type, IString input) {
        TypeStore store = new TypeStore(new TypeStore[0]);
        Type start = this.tr.valueToType((IConstructor)type, store);
        StringReader in = new StringReader(input.getValue());
        try {
            IValue iValue = new StandardTextReader().read(this.values, store, start, in);
            in.close();
            return iValue;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FactParseError e) {
                throw RuntimeExceptionFactory.parseError(this.values.sourceLocation(URIUtil.rootLocation("unknown"), e.getOffset(), 1));
            }
            catch (FactTypeUseException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
            }
            catch (Exception e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
            }
        }
    }

    public void writeBinaryValueFile(ISourceLocation loc, IValue value, IBool compression) {
        if (this.trackIO) {
            System.err.println("_writeBinaryValueFile: " + loc);
        }
        try (IValueOutputStream writer = this.constructValueWriter(loc, IValueOutputStream.CompressionRate.Normal);){
            writer.write(value);
        }
        catch (IOException ioex) {
            throw RuntimeExceptionFactory.io(this.values.string(ioex.getMessage()));
        }
    }

    private IValueOutputStream constructValueWriter(ISourceLocation loc, IValueOutputStream.CompressionRate compression) throws IOException {
        FileChannel channel;
        URIResolverRegistry registry = this.REGISTRY;
        if (registry.supportsWritableFileChannel(loc) && (channel = registry.getWriteableFileChannel(loc, false)) != null) {
            return new IValueOutputStream(channel, this.values, compression);
        }
        return new IValueOutputStream(registry.getOutputStream(loc, false), this.values, compression);
    }

    public void writeBinaryValueFile(ISourceLocation loc, IValue value, IConstructor compression) {
        if (this.trackIO) {
            System.err.println("writeBinaryValueFile: " + loc);
        }
        try (IValueOutputStream writer = this.constructValueWriter(loc, this.translateCompression(compression));){
            writer.write(value);
        }
        catch (IOException ioex) {
            throw RuntimeExceptionFactory.io(this.values.string(ioex.getMessage()));
        }
    }

    private IValueOutputStream.CompressionRate translateCompression(IConstructor compression) {
        switch (compression.getName()) {
            case "disabled": {
                return IValueOutputStream.CompressionRate.None;
            }
            case "light": {
                return IValueOutputStream.CompressionRate.Light;
            }
            case "normal": {
                return IValueOutputStream.CompressionRate.Normal;
            }
            case "strong": {
                return IValueOutputStream.CompressionRate.Strong;
            }
            case "extreme": {
                return IValueOutputStream.CompressionRate.Extreme;
            }
        }
        return IValueOutputStream.CompressionRate.Normal;
    }

    public void writeTextValueFile(ISourceLocation loc, IValue value) {
        Prelude.writeTextValueFile(this.values, this.trackIO, loc, value);
    }

    public static void writeTextValueFile(IValueFactory values, boolean trackIO, ISourceLocation loc, IValue value) {
        if (trackIO) {
            System.err.println("writeTextValueFile: " + loc);
        }
        try (OutputStreamWriter out = new OutputStreamWriter(URIResolverRegistry.getInstance().getOutputStream(loc, false), StandardCharsets.UTF_8);){
            new StandardTextWriter().write(value, out);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(values.string(e.getMessage()));
        }
    }

    public IBool rexpMatch(IString s2, IString re) {
        return this.values.bool(Pattern.matches(re.getValue(), s2.getValue()));
    }

    public ISourceLocation uuid() {
        return URIUtil.correctLocation("uuid", UUID.randomUUID().toString(), "");
    }

    public IInteger uuidi() {
        UUID uuid = UUID.randomUUID();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeLong(uuid.getMostSignificantBits());
            data.writeLong(uuid.getLeastSignificantBits());
            return this.values.integer(bytes.toByteArray());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string("could not generate unique number " + uuid));
        }
    }

    public IValue randomValue(IValue type, IInteger depth, IInteger width) {
        return this.randomValue(type, this.values.integer(this.random.nextInt()), depth, width);
    }

    public IValue randomValue(IValue type, IInteger seed, IInteger depth, IInteger width) {
        TypeStore store = new TypeStore(RascalValueFactory.getStore());
        Type start = this.tr.valueToType((IConstructor)type, store);
        Random random = new Random(seed.intValue());
        return start.randomValue(random, this.values, store, Collections.emptyMap(), depth.intValue(), width.intValue());
    }

    public void sleep(IInteger seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds.longValue());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void watch(ISourceLocation src, IBool recursive, IFunction callback) {
        try {
            ReleasableCallback wrappedCallback = new ReleasableCallback(src, recursive.getValue(), callback, this.values, this.store);
            Set registered = this.registeredWatchers.computeIfAbsent(src, k -> ConcurrentHashMap.newKeySet());
            if (registered.add(wrappedCallback)) {
                this.REGISTRY.watch(src, recursive.getValue(), wrappedCallback);
            }
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    public void unwatch(ISourceLocation src, IBool recursive, IFunction callback) {
        try {
            Set registered = this.registeredWatchers.computeIfAbsent(src, k -> ConcurrentHashMap.newKeySet());
            boolean isRecursive = recursive.getValue();
            for (ReleasableCallback rc : registered) {
                if (rc.recursive != isRecursive || !callback.equals(rc.target.get())) continue;
                this.REGISTRY.unwatch(src, isRecursive, rc);
                registered.remove(rc);
                return;
            }
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    private static boolean isSameFilePure(ISourceLocation a, ISourceLocation b) {
        a = a.top();
        b = b.top();
        if (!a.hasFragment() && !b.hasFragment()) {
            return a.equals(b);
        }
        return a.getScheme().equals(b.getScheme()) && a.getAuthority().equals(b.getAuthority()) && a.getPath().equals(b.getPath()) && a.getQuery().equals(b.getQuery());
    }

    public IBool isSameFile(ISourceLocation a, ISourceLocation b) {
        return this.values.bool(Prelude.isSameFilePure(a, b));
    }

    public IBool isStrictlyContainedIn(ISourceLocation inner, ISourceLocation outer) {
        if (!Prelude.isSameFilePure(inner, outer)) {
            return this.values.bool(false);
        }
        if (inner.hasOffsetLength()) {
            if (outer.hasOffsetLength()) {
                int innerStart = inner.getOffset();
                int innerEnd = innerStart + inner.getLength();
                int outerStart = outer.getOffset();
                int outerEnd = outerStart + outer.getLength();
                return this.values.bool(innerStart == outerStart && innerEnd < outerEnd || innerStart > outerStart && innerEnd <= outerEnd);
            }
            return this.values.bool(inner.getLength() > 0);
        }
        return this.values.bool(false);
    }

    public IBool isContainedIn(ISourceLocation inner, ISourceLocation outer) {
        if (!Prelude.isSameFilePure(inner, outer)) {
            return this.values.bool(false);
        }
        if (inner.hasOffsetLength()) {
            if (outer.hasOffsetLength()) {
                int innerStart = inner.getOffset();
                int innerEnd = innerStart + inner.getLength();
                int outerStart = outer.getOffset();
                int outerEnd = outerStart + outer.getLength();
                return this.values.bool(outerStart <= innerStart && innerEnd <= outerEnd);
            }
            return this.values.bool(true);
        }
        return this.values.bool(!outer.hasOffsetLength());
    }

    public IBool isOverlapping(ISourceLocation first, ISourceLocation second) {
        if (!Prelude.isSameFilePure(first, second)) {
            return this.values.bool(false);
        }
        if (first.hasOffsetLength() && second.hasOffsetLength()) {
            int firstStart = first.getOffset();
            int firstEnd = firstStart + first.getLength() - 1;
            int secondStart = second.getOffset();
            int secondEnd = secondStart + second.getLength() - 1;
            return this.values.bool(firstStart <= secondStart && secondStart <= firstEnd || secondStart <= firstStart && firstStart <= secondEnd);
        }
        return this.values.bool(true);
    }

    private static final class ReleasableCallback
    implements Consumer<ISourceLocationWatcher.ISourceLocationChanged> {
        private final WeakReference<IFunction> target;
        private final ISourceLocation src;
        private final boolean recursive;
        private final int hash;
        private final IValueFactory values;
        private final TypeStore store;

        public ReleasableCallback(ISourceLocation src, boolean recursive, IFunction target, IValueFactory values, TypeStore store) {
            this.src = src;
            this.recursive = recursive;
            this.target = new WeakReference<IFunction>(target);
            this.hash = src.hashCode() + 7 * target.hashCode();
            this.values = values;
            this.store = store;
        }

        @Override
        public void accept(ISourceLocationWatcher.ISourceLocationChanged e) {
            IFunction callback = (IFunction)this.target.get();
            if (callback == null) {
                try {
                    URIResolverRegistry.getInstance().unwatch(this.src, this.recursive, this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            callback.call(this.convertChangeEvent(e));
        }

        private IValue convertChangeEvent(ISourceLocationWatcher.ISourceLocationChanged e) {
            Type changeEvent = this.store.lookupConstructors("changeEvent").iterator().next();
            return this.values.constructor(changeEvent, e.getLocation(), this.convertChangeType(e.getChangeType()), this.convertFileType(e.getType()));
        }

        private IValue convertFileType(ISourceLocationWatcher.ISourceLocationType type) {
            Type file = this.store.lookupConstructors("file").iterator().next();
            Type directory = this.store.lookupConstructors("directory").iterator().next();
            switch (type) {
                case FILE: {
                    return this.values.constructor(file);
                }
                case DIRECTORY: {
                    return this.values.constructor(directory);
                }
            }
            throw RuntimeExceptionFactory.illegalArgument();
        }

        private IValue convertChangeType(ISourceLocationWatcher.ISourceLocationChangeType changeType) {
            Type deleted = this.store.lookupConstructors("deleted").iterator().next();
            Type created = this.store.lookupConstructors("created").iterator().next();
            Type modified = this.store.lookupConstructors("modified").iterator().next();
            switch (changeType) {
                case DELETED: {
                    return this.values.constructor(deleted);
                }
                case CREATED: {
                    return this.values.constructor(created);
                }
                case MODIFIED: {
                    return this.values.constructor(modified);
                }
            }
            throw RuntimeExceptionFactory.illegalArgument();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReleasableCallback) {
                ReleasableCallback other = (ReleasableCallback)obj;
                IFunction actualTarget = (IFunction)this.target.get();
                return actualTarget != null && this.src.equals(other.src) && this.recursive == other.recursive && actualTarget.equals(other.target.get());
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class NodeComparator
    implements Comparator<IValue> {
        private final Map<IValue, Distance> distance;

        NodeComparator(Map<IValue, Distance> distance) {
            this.distance = distance;
        }

        @Override
        public int compare(IValue arg0, IValue arg1) {
            int d0 = this.distance.get((Object)arg0).intval;
            int d1 = this.distance.get((Object)arg1).intval;
            return d0 < d1 ? -1 : (d0 == d1 ? 0 : 1);
        }
    }

    private static class Distance {
        public int intval;

        Distance(int n) {
            this.intval = n;
        }
    }

    public class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }

    protected static class Backtrack
    extends RuntimeException {
        Throw exception;

        public Backtrack(Throw exception) {
            this.exception = exception;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private class Sorting {
        private final IValue[] array;
        private final int size;
        private final Less less;

        private void swap(int i, int j) {
            IValue tmp = this.array[i];
            this.array[i] = this.array[j];
            this.array[j] = tmp;
        }

        public Sorting(IValue[] array, Less less) {
            this.array = array;
            this.size = array.length;
            this.less = less;
        }

        public Sorting sort() {
            if (this.size == 0) {
                return this;
            }
            if (this.less.less(this.array[0], this.array[0])) {
                throw RuntimeExceptionFactory.illegalArgument((IValue)this.less.less, "A reflexive comparator can not be used for sorting. At least one element is less than itself: " + this.less);
            }
            this.sort(0, this.size - 1);
            return this;
        }

        public Sorting shuffle() {
            for (int i = 0; i < this.size; ++i) {
                this.swap(i, i + (int)(Math.random() * (double)(this.size - i)));
            }
            return this;
        }

        private void sort(int low, int high) {
            IValue pivot = this.array[low + (high - low) / 2];
            int oldLow = low;
            int oldHigh = high;
            try {
                while (low < high) {
                    while (this.less.less(this.array[low], pivot)) {
                        ++low;
                    }
                    while (this.less.less(pivot, this.array[high])) {
                        --high;
                    }
                    if (low > high) continue;
                    this.swap(low, high);
                    ++low;
                    --high;
                }
            }
            catch (IndexOutOfBoundsException e) {
                for (IValue elem : this.array) {
                    if (!this.less.less(elem, elem)) continue;
                    throw RuntimeExceptionFactory.illegalArgument((IValue)this.less.less, "A reflexive comparator can not be used for sorting. At least one element is less than itself with the given comparator: " + elem);
                }
                throw e;
            }
            if (oldLow < high) {
                this.sort(oldLow, high);
            }
            if (low < oldHigh) {
                this.sort(low, oldHigh);
            }
        }
    }

    private class Less {
        private final IFunction less;

        Less(IFunction less) {
            this.less = less;
        }

        public boolean less(IValue x, IValue y) {
            return ((IBool)this.less.call(x, y)).getValue();
        }
    }
}

