/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.analysis.statistics;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math.MathException;
import org.apache.commons.math.stat.inference.ChiSquareTestImpl;
import org.apache.commons.math.stat.inference.OneWayAnovaImpl;
import org.apache.commons.math.stat.inference.TTestImpl;
import org.apache.commons.math.stat.ranking.NaturalRanking;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;

public class Inferences {
    private final IValueFactory values;
    double[] expected;
    long[] observed;

    public Inferences(IValueFactory values) {
        this.values = values;
    }

    void makeChi(IList dataValues) {
        int n = dataValues.length();
        this.expected = new double[n];
        this.observed = new long[n];
        int i = 0;
        for (IValue v : dataValues) {
            ITuple t2 = (ITuple)v;
            INumber exp = (INumber)t2.get(0);
            INumber obs = (INumber)t2.get(1);
            this.expected[i] = (long)exp.toReal(this.values.getPrecision()).doubleValue();
            this.observed[i] = obs.toInteger().longValue();
            if (this.expected[i] < 0.0 || this.observed[i] < 0L) {
                throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "Chi test requires positive values");
            }
            ++i;
        }
    }

    double[] makeT(IList dataValues) {
        int n = dataValues.length();
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            INumber d = (INumber)dataValues.get(i);
            data[i] = d.toReal(this.values.getPrecision()).doubleValue();
        }
        return data;
    }

    public IValue chiSquare(IList dataValues) {
        this.makeChi(dataValues);
        return this.values.real(new ChiSquareTestImpl().chiSquare(this.expected, this.observed));
    }

    public IValue chiSquareTest(IList dataValues) {
        this.makeChi(dataValues);
        try {
            return this.values.real(new ChiSquareTestImpl().chiSquareTest(this.expected, this.observed));
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, e.getMessage());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, e.getMessage());
        }
    }

    public IValue chiSquareTest(IList dataValues, IReal alpha) {
        this.makeChi(dataValues);
        try {
            return this.values.bool(new ChiSquareTestImpl().chiSquareTest(this.expected, this.observed, alpha.doubleValue()));
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, e.getMessage());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, e.getMessage());
        }
    }

    public IValue tTest(IList sample1, IList sample2) {
        double[] s1 = this.makeT(sample1);
        double[] s2 = this.makeT(sample2);
        try {
            double r = new TTestImpl().tTest(s1, s2);
            return this.values.real(r);
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)sample1, e.getMessage());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)sample1, e.getMessage());
        }
    }

    public IValue tTest(IList sample1, IList sample2, INumber alpha) {
        double[] s1 = this.makeT(sample1);
        double[] s2 = this.makeT(sample2);
        try {
            return this.values.bool(new TTestImpl().tTest(s1, s2, alpha.toReal(this.values.getPrecision()).doubleValue()));
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)sample1, e.getMessage());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)sample1, e.getMessage());
        }
    }

    public IValue tTest(INumber mu, IList sample, INumber alpha) {
        double[] s2 = this.makeT(sample);
        try {
            return this.values.bool(new TTestImpl().tTest(mu.toReal(this.values.getPrecision()).doubleValue(), s2, alpha.toReal(this.values.getPrecision()).doubleValue()));
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)sample, e.getMessage());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)sample, e.getMessage());
        }
    }

    public IValue gini(IList dataValues) {
        int i;
        if (dataValues.length() < 2) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)dataValues, "At least 2 observations required");
        }
        double sum = 0.0;
        double g2 = 0.0;
        double N2 = 0.0;
        double[] xvalues = new double[dataValues.length()];
        for (int i2 = 0; i2 < dataValues.length(); ++i2) {
            ITuple T = (ITuple)dataValues.get(i2);
            xvalues[i2] = ((INumber)T.get(0)).toReal(this.values.getPrecision()).doubleValue();
        }
        double[] rank = new NaturalRanking().rank(xvalues);
        for (i = 0; i < rank.length; ++i) {
            rank[i] = (double)rank.length - rank[i] + 1.0;
        }
        for (i = 0; i < dataValues.length(); ++i) {
            ITuple T = (ITuple)dataValues.get(i);
            double Y = ((INumber)T.get(1)).toReal(this.values.getPrecision()).doubleValue();
            if (Y < 0.0) {
                throw RuntimeExceptionFactory.illegalArgument((IValue)T, "Frequency should be positive");
            }
            g2 += xvalues[i] * rank[i] * Y;
            N2 += Y;
            sum += xvalues[i] * Y;
        }
        double avg = sum / N2;
        return this.values.real((N2 + 1.0) / (N2 - 1.0) - 2.0 * g2 / (N2 * (N2 - 1.0) * avg));
    }

    Collection<double[]> makeAnova(IList dataValues) {
        int n = dataValues.length();
        ArrayList<double[]> res = new ArrayList<double[]>();
        for (int i = 0; i < n; ++i) {
            IList cat = (IList)dataValues.get(i);
            int m4 = cat.length();
            double[] dat = new double[m4];
            for (int j = 0; j < m4; ++j) {
                dat[i] = ((INumber)cat.get(j)).toReal(this.values.getPrecision()).doubleValue();
            }
            res.add(dat);
        }
        return res;
    }

    public IValue anovaFValue(IList categoryData) {
        try {
            return this.values.real(new OneWayAnovaImpl().anovaFValue(this.makeAnova(categoryData)));
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)categoryData, e.getMessage());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)categoryData, e.getMessage());
        }
    }

    public IValue anovaPValue(IList categoryData) {
        try {
            return this.values.real(new OneWayAnovaImpl().anovaPValue(this.makeAnova(categoryData)));
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)categoryData, e.getMessage());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)categoryData, e.getMessage());
        }
    }

    public IValue anovaTest(IList categoryData, INumber alpha) {
        try {
            return this.values.bool(new OneWayAnovaImpl().anovaTest(this.makeAnova(categoryData), alpha.toReal(this.values.getPrecision()).doubleValue()));
        }
        catch (IllegalArgumentException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)categoryData, e.getMessage());
        }
        catch (MathException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)categoryData, e.getMessage());
        }
    }
}

