/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Collectors;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.library.lang.json.internal.JsonValueReader;
import org.rascalmpl.library.lang.json.internal.JsonValueWriter;
import org.rascalmpl.types.ReifiedType;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;

public class IO {
    private final IRascalValueFactory values;
    private final IRascalMonitor monitor;

    public IO(IRascalValueFactory values, IRascalMonitor monitor) {
        this.values = values;
        this.monitor = monitor;
    }

    public IValue readJSON(IValue type, ISourceLocation loc, IString dateTimeFormat, IBool lenient, IBool trackOrigins, IFunction parsers, IMap nulls, IBool explicitConstructorNames, IBool explicitDataTypes) {
        IValue iValue;
        TypeStore store = new TypeStore(new TypeStore[0]);
        Type start = new TypeReifier(this.values).valueToType((IConstructor)type, store);
        if (parsers.getType() instanceof ReifiedType && parsers.getType().getTypeParameters().getFieldType(0).isTop()) {
            parsers = null;
        }
        JsonReader in = new JsonReader(URIResolverRegistry.getInstance().getCharacterReader(loc));
        try {
            in.setLenient(lenient.getValue());
            iValue = new JsonValueReader(this.values, store, this.monitor, trackOrigins.getValue() ? loc : null).setCalendarFormat(dateTimeFormat.getValue()).setParsers(parsers).setNulls(this.unreify(nulls)).setExplicitConstructorNames(explicitConstructorNames.getValue()).setExplicitDataTypes(explicitDataTypes.getValue()).read(in, start);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
            }
            catch (NullPointerException e) {
                throw RuntimeExceptionFactory.io(this.values.string("NPE in error handling code"), null, null);
            }
        }
        in.close();
        return iValue;
    }

    private Map<Type, IValue> unreify(IMap nulls) {
        TypeReifier tr = new TypeReifier(this.values);
        return nulls.stream().map(t2 -> (ITuple)t2).collect(Collectors.toMap(t2 -> tr.valueToType((IConstructor)t2.get(0)), t2 -> t2.get(1)));
    }

    public IValue parseJSON(IValue type, IString src, IString dateTimeFormat, IBool lenient, IBool trackOrigins, IFunction parsers, IMap nulls, IBool explicitConstructorNames, IBool explicitDataTypes) {
        IValue iValue;
        TypeStore store = new TypeStore(new TypeStore[0]);
        Type start = new TypeReifier(this.values).valueToType((IConstructor)type, store);
        JsonReader in = new JsonReader(new StringReader(src.getValue()));
        try {
            in.setLenient(lenient.getValue());
            iValue = new JsonValueReader(this.values, store, this.monitor, trackOrigins.getValue() ? URIUtil.rootLocation("unknown") : null).setCalendarFormat(dateTimeFormat.getValue()).setParsers(parsers).setNulls(this.unreify(nulls)).setExplicitConstructorNames(explicitConstructorNames.getValue()).setExplicitDataTypes(explicitDataTypes.getValue()).read(in, start);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()));
            }
            catch (NullPointerException e) {
                throw RuntimeExceptionFactory.io(this.values.string("NPE"));
            }
        }
        in.close();
        return iValue;
    }

    public void writeJSON(ISourceLocation loc, IValue value, IBool unpackedLocations, IString dateTimeFormat, IBool dateTimeAsInt, IInteger indent, IBool dropOrigins, IFunction formatter, IBool explicitConstructorNames, IBool explicitDataTypes) {
        try (JsonWriter out = new JsonWriter(new OutputStreamWriter(URIResolverRegistry.getInstance().getOutputStream(loc, false), Charset.forName("UTF8")));){
            if (indent.intValue() > 0) {
                out.setIndent("        ".substring(0, indent.intValue() % 9));
            }
            new JsonValueWriter().setCalendarFormat(dateTimeFormat.getValue()).setDatesAsInt(dateTimeAsInt.getValue()).setUnpackedLocations(unpackedLocations.getValue()).setDropOrigins(dropOrigins.getValue()).setFormatters(formatter).setExplicitConstructorNames(explicitConstructorNames.getValue()).setExplicitDataTypes(explicitDataTypes.getValue()).write(out, value);
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
        }
    }

    public IString asJSON(IValue value, IBool unpackedLocations, IString dateTimeFormat, IBool dateTimeAsInt, IInteger indent, IBool dropOrigins, IFunction formatter, IBool explicitConstructorNames, IBool explicitDataTypes) {
        IString iString;
        StringWriter string = new StringWriter();
        JsonWriter out = new JsonWriter(string);
        try {
            if (indent.intValue() > 0) {
                out.setIndent("        ".substring(0, indent.intValue() % 9));
            }
            new JsonValueWriter().setCalendarFormat(dateTimeFormat.getValue()).setDatesAsInt(dateTimeAsInt.getValue()).setUnpackedLocations(unpackedLocations.getValue()).setDropOrigins(dropOrigins.getValue()).setFormatters(formatter).setExplicitConstructorNames(explicitConstructorNames.getValue()).setExplicitDataTypes(explicitDataTypes.getValue()).write(out, value);
            iString = this.values.string(string.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
            }
        }
        out.close();
        return iString;
    }
}

