/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.rsf;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.uri.URIResolverRegistry;

public class RSFIO {
    private static final TypeFactory types = TypeFactory.getInstance();
    private final IValueFactory values;
    private TypeReifier tr;

    public RSFIO(IValueFactory values) {
        this.values = values;
        this.tr = new TypeReifier(values);
    }

    public IValue readRSF(ISourceLocation nameRSFFile) {
        HashMap<String, ISetWriter> table = new HashMap<String, ISetWriter>();
        Reader input = null;
        try {
            input = URIResolverRegistry.getInstance().getCharacterReader(nameRSFFile);
            BufferedReader bufRead = new BufferedReader(input);
            String line = bufRead.readLine();
            while (line != null) {
                String[] fields = line.split("\\s+");
                String name = fields[0];
                if (!table.containsKey(name)) {
                    table.put(name, this.values.setWriter());
                }
                ISetWriter rw = (ISetWriter)table.get(name);
                rw.insert(this.values.tuple(this.values.string(fields[1]), this.values.string(fields[2])));
                line = bufRead.readLine();
            }
            bufRead.close();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
                }
            }
        }
        IMapWriter mw = this.values.mapWriter();
        for (Map.Entry entry : table.entrySet()) {
            mw.insert(this.values.tuple(new IValue[]{this.values.string((String)entry.getKey()), ((ISetWriter)entry.getValue()).done()}));
        }
        return mw.done();
    }

    private IValue getElementAsTypedValue(String elem, Type type) {
        if (type.isString()) {
            return this.values.string(elem);
        }
        if (type.isInteger()) {
            return this.values.integer(elem);
        }
        if (type.isReal()) {
            return this.values.real(elem);
        }
        if (type.isBool()) {
            return this.values.bool(elem.toLowerCase().equals("true"));
        }
        return null;
    }

    public IValue readRSFRelation(IValue result, IString relName, ISourceLocation loc) {
        Type resultType = this.tr.valueToType((IConstructor)result, new TypeStore(new TypeStore[0]));
        while (resultType.isAliased()) {
            resultType = resultType.getAliased();
        }
        if (!resultType.isRelation() || resultType.getArity() != 2) {
            throw RuntimeExceptionFactory.illegalArgument(this.values.string("Type of an RSF relation should be a binary relation"), null, null);
        }
        Type elem1Type = resultType.getFieldType(0);
        Type elem2Type = resultType.getFieldType(1);
        ISetWriter rw = this.values.setWriter();
        String rname = relName.getValue();
        try (Reader reader = URIResolverRegistry.getInstance().getCharacterReader(loc);){
            String line = this.readLine(reader);
            while (!line.isEmpty()) {
                String[] fields = line.split("\\s+");
                String name = fields[0];
                if (name.equals(rname)) {
                    IValue v1 = this.getElementAsTypedValue(fields[1], elem1Type);
                    IValue v2 = this.getElementAsTypedValue(fields[2], elem2Type);
                    rw.insert(this.values.tuple(v1, v2));
                }
                line = this.readLine(reader);
            }
            reader.close();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
        }
        return rw.done();
    }

    private boolean isEOL(int c) {
        return c == 10 || c == 13;
    }

    private String readLine(Reader reader) throws IOException {
        StringWriter sw = new StringWriter();
        int lastChar = reader.read();
        while (lastChar != -1) {
            if (this.isEOL(lastChar)) {
                return sw.toString();
            }
            sw.append((char)lastChar);
            lastChar = reader.read();
        }
        return sw.toString();
    }

    public IValue getRSFTypes(ISourceLocation loc) {
        HashMap<String, Type> table = new HashMap<String, Type>();
        Reader reader = null;
        try {
            reader = URIResolverRegistry.getInstance().getCharacterReader(loc);
            String line = this.readLine(reader);
            while (!line.isEmpty()) {
                String[] fields = line.split("\\s+");
                String name = fields[0];
                Type t1 = this.getElementType(fields[1]);
                Type t2 = this.getElementType(fields[2]);
                Type t1t2Tuple = types.tupleType(t1, t2);
                if (!table.containsKey(name)) {
                    table.put(name, t1t2Tuple);
                } else {
                    table.put(name, ((Type)table.get(name)).lub(t1t2Tuple));
                }
                line = this.readLine(reader);
            }
            reader.close();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(this.values.string(e.getMessage()), null, null);
                }
            }
        }
        IMapWriter mr = this.values.mapWriter();
        for (Map.Entry entry : table.entrySet()) {
            Type t2 = (Type)entry.getValue();
            mr.put(this.values.string((String)entry.getKey()), this.tr.typeToValue(types.relType(t2.getFieldType(0), t2.getFieldType(1)), new TypeStore(new TypeStore[0]), (IMap)this.values.mapWriter().done()));
        }
        return mr.done();
    }

    private Type getElementType(String elem) {
        if (elem.isEmpty()) {
            return types.voidType();
        }
        if (elem.matches("^[+-]?[0-9]+$")) {
            return types.integerType();
        }
        if (elem.matches("[+-]?[0-9]+\\.[0-9]*")) {
            return types.realType();
        }
        if (elem.equals("true") || elem.equals("false")) {
            return types.boolType();
        }
        return types.stringType();
    }
}

