/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.jline.utils.OSUtils;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.library.Messages;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.file.MavenRepositoryURIResolver;
import org.rascalmpl.uri.jar.JarURIResolver;
import org.rascalmpl.util.maven.Artifact;
import org.rascalmpl.util.maven.MavenParser;
import org.rascalmpl.util.maven.ModelResolutionError;
import org.rascalmpl.util.maven.Scope;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;

public class PathConfig {
    private static final IValueFactory vf = ValueFactoryFactory.getValueFactory();
    private static final TypeFactory tf = TypeFactory.getInstance();
    private static final TypeStore store = new TypeStore(new TypeStore[0]);
    public static final Type PathConfigType = tf.abstractDataType(store, "PathConfig", new Type[0]);
    public static final Map<String, Type> PathConfigFields = Map.of("srcs", tf.listType(tf.sourceLocationType()), "ignores", tf.listType(tf.sourceLocationType()), "bin", tf.sourceLocationType(), "generatedSources", tf.sourceLocationType(), "libs", tf.listType(tf.sourceLocationType()), "messages", tf.listType(Messages.Message));
    private final Type pathConfigConstructor = tf.constructor(store, PathConfigType, "pathConfig", new Type[0]);
    private final List<ISourceLocation> srcs;
    private final List<ISourceLocation> libs;
    private final ISourceLocation bin;
    private final List<ISourceLocation> ignores;
    private final ISourceLocation generatedSources;
    private final List<IConstructor> messages;
    private static final List<ISourceLocation> defaultIgnores = Collections.emptyList();
    private static final ISourceLocation defaultGeneratedSources = URIUtil.unknownLocation();
    private static final List<IConstructor> defaultMessages = Collections.emptyList();
    private static final ISourceLocation defaultBin = URIUtil.unknownLocation();
    private static final List<ISourceLocation> defaultLibs = Collections.emptyList();

    public PathConfig() {
        this.srcs = Collections.emptyList();
        this.ignores = defaultIgnores;
        this.bin = defaultBin;
        this.libs = Collections.emptyList();
        this.generatedSources = defaultGeneratedSources;
        this.messages = defaultMessages;
    }

    public PathConfig(IConstructor pcfg) throws IOException {
        this(PathConfig.srcs(pcfg), PathConfig.libs(pcfg), PathConfig.bin(pcfg), PathConfig.ignores(pcfg), PathConfig.generatedSources(pcfg), PathConfig.messages(pcfg));
    }

    public PathConfig(List<ISourceLocation> srcs, List<ISourceLocation> libs, ISourceLocation bin) {
        this(srcs, libs, bin, defaultIgnores);
    }

    public PathConfig(List<ISourceLocation> srcs, List<ISourceLocation> libs, ISourceLocation bin, List<ISourceLocation> ignores) {
        this(srcs, libs, bin, ignores, defaultGeneratedSources);
    }

    public PathConfig(List<ISourceLocation> srcs, List<ISourceLocation> libs, ISourceLocation bin, List<ISourceLocation> ignores, ISourceLocation generatedSources) {
        this(srcs, libs, bin, ignores, generatedSources, defaultMessages);
    }

    public PathConfig(List<ISourceLocation> srcs, List<ISourceLocation> libs, ISourceLocation bin, List<ISourceLocation> ignores, ISourceLocation generatedSources, List<IConstructor> messages) {
        this.srcs = PathConfig.dedup(srcs);
        this.ignores = PathConfig.dedup(ignores);
        this.libs = PathConfig.dedup(libs);
        this.bin = bin;
        this.generatedSources = generatedSources;
        this.messages = messages;
    }

    public PathConfig(IList srcs, IList libs, ISourceLocation bin) {
        this.srcs = PathConfig.initializeLocList(srcs);
        this.libs = PathConfig.initializeLocList(libs);
        this.bin = bin;
        this.ignores = defaultIgnores;
        this.generatedSources = defaultGeneratedSources;
        this.messages = defaultMessages;
    }

    public PathConfig(IList srcs, IList libs, ISourceLocation bin, IList ignores) {
        this.srcs = PathConfig.initializeLocList(srcs);
        this.libs = PathConfig.initializeLocList(libs);
        this.bin = bin;
        this.ignores = PathConfig.initializeLocList(ignores);
        this.generatedSources = defaultGeneratedSources;
        this.messages = defaultMessages;
    }

    public PathConfig(IList srcs, IList libs, ISourceLocation bin, IList ignores, ISourceLocation generatedSources) {
        this.srcs = PathConfig.initializeLocList(srcs);
        this.libs = PathConfig.initializeLocList(libs);
        this.bin = bin;
        this.ignores = PathConfig.initializeLocList(ignores);
        this.generatedSources = generatedSources;
        this.messages = defaultMessages;
    }

    public PathConfig(IList srcs, IList libs, ISourceLocation bin, IList ignores, ISourceLocation generatedSources, IList messages) {
        this.srcs = PathConfig.initializeLocList(srcs);
        this.libs = PathConfig.initializeLocList(libs);
        this.bin = bin;
        this.ignores = PathConfig.initializeLocList(ignores);
        this.generatedSources = generatedSources;
        this.messages = PathConfig.convertMessages(messages);
    }

    private static IList messages(IConstructor pcfg) {
        return PathConfig.getListValueFromConstructor(pcfg, defaultMessages, "messages");
    }

    private static ISourceLocation generatedSources(IConstructor pcfg) {
        ISourceLocation val = (ISourceLocation)pcfg.asWithKeywordParameters().getParameter("generatedSources");
        return val == null ? defaultGeneratedSources : val;
    }

    private static IList ignores(IConstructor pcfg) {
        return PathConfig.getListValueFromConstructor(pcfg, defaultIgnores, "ignores");
    }

    private static IList getListValueFromConstructor(IConstructor pcfg, List<? extends IValue> def, String label) {
        IList val = (IList)pcfg.asWithKeywordParameters().getParameter(label);
        return val == null ? def.stream().collect(vf.listWriter()) : val;
    }

    private static ISourceLocation bin(IConstructor pcfg) {
        ISourceLocation val = (ISourceLocation)pcfg.asWithKeywordParameters().getParameter("bin");
        return val == null ? defaultBin : val;
    }

    private static IList libs(IConstructor pcfg) {
        return PathConfig.getListValueFromConstructor(pcfg, defaultLibs, "libs");
    }

    private static IList srcs(IConstructor pcfg) {
        return PathConfig.getListValueFromConstructor(pcfg, Collections.emptyList(), "srcs");
    }

    private static List<ISourceLocation> initializeLocList(IList srcs) {
        return PathConfig.dedup(PathConfig.convertLocs(srcs));
    }

    private static List<ISourceLocation> dedup(List<ISourceLocation> list) {
        ArrayList<ISourceLocation> filtered = new ArrayList<ISourceLocation>(list.size());
        for (ISourceLocation elem : list) {
            if (filtered.contains(elem)) continue;
            filtered.add(elem);
        }
        return filtered;
    }

    private static List<ISourceLocation> convertLocs(IList locs) {
        ArrayList<ISourceLocation> result = new ArrayList<ISourceLocation>();
        for (IValue p : locs) {
            if (p instanceof ISourceLocation) {
                result.add((ISourceLocation)p);
                continue;
            }
            throw new RuntimeException("Path should contain source locations and not " + p.getClass().getName());
        }
        return result;
    }

    private static List<IConstructor> convertMessages(IList locs) {
        ArrayList<IConstructor> result = new ArrayList<IConstructor>();
        for (IValue p : locs) {
            if (p instanceof IConstructor) {
                result.add((IConstructor)p);
                continue;
            }
            throw new RuntimeException("Messages should contain message constructors and not " + p.getClass().getName());
        }
        return result;
    }

    String makeFileName(String qualifiedModuleName) {
        return this.makeFileName(qualifiedModuleName, "rsc");
    }

    public static ISourceLocation getDefaultBin() {
        return defaultBin;
    }

    public static ISourceLocation getDefaultGeneratedSources() {
        return defaultGeneratedSources;
    }

    public static IList getDefaultIgnoresList() {
        return PathConfig.convertLocs(defaultIgnores);
    }

    private static IList convertLocs(List<ISourceLocation> locs) {
        IListWriter w = vf.listWriter();
        w.appendAll(locs);
        return (IList)w.done();
    }

    public static List<ISourceLocation> getDefaultIgnores() {
        return Collections.unmodifiableList(defaultIgnores);
    }

    public IValueFactory getValueFactory() {
        return vf;
    }

    public IList getSrcs() {
        return vf.list(this.srcs.toArray(new IValue[0]));
    }

    public ISourceLocation getGeneratedSources() {
        return this.generatedSources;
    }

    public IList getMessages() {
        return vf.list(this.messages.toArray(new IValue[this.messages.size()]));
    }

    public PathConfig addSourceLoc(ISourceLocation dir) throws IOException {
        ArrayList<ISourceLocation> extendedsrcs = new ArrayList<ISourceLocation>(this.srcs);
        extendedsrcs.add(dir);
        return new PathConfig(extendedsrcs, this.libs, this.bin, this.ignores, this.generatedSources, this.messages);
    }

    public PathConfig setGeneratedSources(ISourceLocation dir) throws IOException {
        return new PathConfig(this.srcs, this.libs, this.bin, this.ignores, dir, this.messages);
    }

    public IList getIgnores() {
        return vf.list(this.ignores.toArray(new IValue[0]));
    }

    public PathConfig addIgnoreLoc(ISourceLocation dir) throws IOException {
        ArrayList<ISourceLocation> extendedignores = new ArrayList<ISourceLocation>(this.ignores);
        extendedignores.add(dir);
        return new PathConfig(this.srcs, this.libs, this.bin, extendedignores, this.generatedSources, this.messages);
    }

    public IList getLibs() {
        return vf.list(this.libs.toArray(new IValue[0]));
    }

    public IList getLibsAndTarget() {
        return this.getLibs().append(this.getBin());
    }

    public PathConfig addLibLoc(ISourceLocation dir) throws IOException {
        ArrayList<ISourceLocation> extendedlibs = new ArrayList<ISourceLocation>(this.libs);
        extendedlibs.add(dir);
        return new PathConfig(this.srcs, extendedlibs, this.bin, this.ignores, this.generatedSources, this.messages);
    }

    public static PathConfig fromSourceProjectMemberRascalManifest(ISourceLocation projectMember, RascalConfigMode mode) throws IOException {
        if (!URIResolverRegistry.getInstance().isDirectory(projectMember)) {
            projectMember = URIUtil.getParentLocation(projectMember);
        }
        return PathConfig.fromSourceProjectRascalManifest(PathConfig.inferProjectRoot(projectMember), mode, true);
    }

    public static ISourceLocation resolveProjectOnClasspath(String projectName) throws IOException {
        RascalManifest mf = new RascalManifest();
        Enumeration<URL> mfs = PathConfig.class.getClassLoader().getResources("META-INF/RASCAL.MF");
        for (URL url : Collections.list(mfs)) {
            try {
                ISourceLocation loc;
                String libName = mf.getProjectName(url.openStream());
                if (libName == null || !libName.equals(projectName)) continue;
                if (url.getProtocol().equals("jar") && url.getPath().startsWith("file:/")) {
                    loc = vf.sourceLocation("file", null, URIUtil.fromURL(new URL(url.getPath())).getPath());
                    loc = URIUtil.changePath(loc, loc.getPath().replace("!/META-INF/RASCAL.MF", ""));
                } else {
                    loc = vf.sourceLocation(URIUtil.fromURL(url));
                    loc = URIUtil.getParentLocation(URIUtil.getParentLocation(loc));
                }
                return loc;
            }
            catch (IOException | URISyntaxException e) {
                throw new FileNotFoundException(e.getMessage());
            }
        }
        throw new FileNotFoundException(projectName + " jar could not be located in the current runtime classpath");
    }

    public static ISourceLocation resolveCurrentRascalRuntimeJar() throws IOException {
        return PathConfig.resolveProjectOnClasspath("rascal");
    }

    public static ISourceLocation inferProjectRoot(ISourceLocation member) {
        ISourceLocation current = member;
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        while (current != null && reg.exists(current) && reg.isDirectory(current)) {
            if (reg.exists(URIUtil.getChildLocation(current, "META-INF/RASCAL.MF"))) {
                return current;
            }
            if (URIUtil.getParentLocation(current).equals(current)) {
                return reg.isDirectory(member) ? member : URIUtil.getParentLocation(member);
            }
            current = URIUtil.getParentLocation(current);
        }
        return current;
    }

    public PathConfig parse(String pathConfigString) throws IOException {
        try {
            IConstructor cons = (IConstructor)new StandardTextReader().read(vf, store, PathConfigType, new StringReader(pathConfigString));
            IWithKeywordParameters<? extends IConstructor> kwp = cons.asWithKeywordParameters();
            IList srcs = (IList)kwp.getParameter("srcs");
            IList libs = (IList)kwp.getParameter("libs");
            IList ignores = (IList)kwp.getParameter("ignores");
            ISourceLocation generated = (ISourceLocation)kwp.getParameter("generatedSources");
            IList messages = (IList)kwp.getParameter("message");
            ISourceLocation bin = (ISourceLocation)kwp.getParameter("bin");
            return new PathConfig(srcs != null ? srcs : vf.list(new IValue[0]), libs != null ? libs : vf.list(new IValue[0]), bin != null ? bin : URIUtil.rootLocation("cwd"), ignores != null ? ignores : vf.list(new IValue[0]), generated != null ? generated : null, messages != null ? messages : vf.list(new IValue[0]));
        }
        catch (FactTypeUseException e) {
            throw new IOException(e);
        }
    }

    private static void buildRascalConfig(ISourceLocation workspaceRascal, RascalConfigMode mode, List<Artifact> mavenClassPath, IListWriter srcs, IListWriter libs, IListWriter messages) throws IOException {
        if (mode == RascalConfigMode.INTERPRETER) {
            srcs.append(URIUtil.rootLocation("std"));
            libs.append(PathConfig.resolveCurrentRascalRuntimeJar());
        } else {
            srcs.append(URIUtil.getChildLocation(workspaceRascal, "src/org/rascalmpl/library"));
        }
        srcs.append(URIUtil.getChildLocation(workspaceRascal, "src/org/rascalmpl/compiler"));
        srcs.append(URIUtil.getChildLocation(workspaceRascal, "src/org/rascalmpl/tutor"));
        srcs.append(URIUtil.getChildLocation(workspaceRascal, "test/org/rascalmpl/test/data"));
        srcs.append(URIUtil.getChildLocation(workspaceRascal, "test/org/rascalmpl/benchmark"));
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        ISourceLocation typepal = URIUtil.correctLocation("project", "typepal", "src");
        if (reg.exists(typepal)) {
            typepal = reg.logicalToPhysical(typepal);
        } else {
            try {
                typepal = PathConfig.resolveProjectOnClasspath("typepal");
                typepal = MavenRepositoryURIResolver.mavenize(typepal);
                typepal = JarURIResolver.jarify(typepal);
            }
            catch (FileNotFoundException e) {
                messages.append(Messages.error("Could not find typepal in local project, rascal compiler will not work", workspaceRascal));
            }
        }
        srcs.append(typepal);
    }

    private static void buildRascalLSPConfig(ISourceLocation manifestRoot, RascalConfigMode mode, List<Artifact> mavenClasspath, IListWriter srcs, IListWriter libs, IListWriter messages) throws IOException {
        ISourceLocation insideRascalJar = JarURIResolver.jarify(PathConfig.resolveCurrentRascalRuntimeJar());
        ISourceLocation rascalCompiler = URIUtil.getChildLocation(insideRascalJar, "org/rascalmpl/compiler");
        ISourceLocation typepal = URIUtil.getChildLocation(insideRascalJar, "org/rascalmpl/typepal");
        if (mode == RascalConfigMode.INTERPRETER) {
            srcs.append(URIUtil.rootLocation("std"));
            srcs.append(rascalCompiler);
            srcs.append(typepal);
        } else {
            libs.append(JarURIResolver.jarify(PathConfig.resolveCurrentRascalRuntimeJar()));
            srcs.append(rascalCompiler);
            srcs.append(typepal);
        }
        libs.append(PathConfig.resolveCurrentRascalRuntimeJar());
        PathConfig.translateSources(manifestRoot, srcs, messages);
        for (Artifact art : mavenClasspath) {
            String artId = art.getCoordinate().getArtifactId();
            if (artId.equals("rascal") || artId.equals("typepal")) continue;
            PathConfig.addArtifactToPathConfig(art, manifestRoot, mode, srcs, libs, messages);
        }
    }

    private static void translateSources(ISourceLocation manifestRoot, IListWriter srcs, IListWriter messages) {
        RascalManifest manifest = new RascalManifest();
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        for (String srcName : manifest.getSourceRoots(manifestRoot)) {
            ISourceLocation srcFolder = URIUtil.getChildLocation(manifestRoot, srcName);
            if (!reg.exists(srcFolder) || !reg.isDirectory(srcFolder)) {
                messages.append(Messages.error("Source folder " + srcFolder + " does not exist.", PathConfig.getRascalMfLocation(manifestRoot)));
            }
            srcs.append(srcFolder);
        }
    }

    private static void buildNormalProjectConfig(ISourceLocation manifestRoot, RascalConfigMode mode, List<Artifact> mavenClasspath, boolean isRoot, IListWriter srcs, IListWriter libs, IListWriter messages) throws IOException, URISyntaxException {
        if (isRoot) {
            if (mode == RascalConfigMode.INTERPRETER) {
                srcs.append(URIUtil.rootLocation("std"));
                libs.append(PathConfig.resolveCurrentRascalRuntimeJar());
            } else {
                assert (mode == RascalConfigMode.COMPILER) : "should be compiler";
                libs.append(JarURIResolver.jarify(PathConfig.resolveCurrentRascalRuntimeJar()));
            }
        }
        for (Artifact art : mavenClasspath) {
            PathConfig.addArtifactToPathConfig(art, manifestRoot, mode, srcs, libs, messages);
        }
        if (isRoot || mode == RascalConfigMode.INTERPRETER) {
            PathConfig.translateSources(manifestRoot, srcs, messages);
        } else if (manifestRoot.getScheme().equals("project")) {
            libs.append(URIUtil.correctLocation("target", manifestRoot.getAuthority(), ""));
        } else {
            libs.append(URIUtil.getChildLocation(manifestRoot, "target/classes"));
        }
    }

    private static void addArtifactToPathConfig(Artifact art, ISourceLocation manifestRoot, RascalConfigMode mode, IListWriter srcs, IListWriter libs, IListWriter messages) throws IOException {
        RascalManifest manifest = new RascalManifest();
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        try {
            ISourceLocation projectLoc;
            Path resolvedLocation = art.getResolved();
            if (resolvedLocation == null) {
                ISourceLocation projectLoc2 = URIUtil.correctLocation("project", art.getCoordinate().getArtifactId(), "");
                if (reg.exists(projectLoc2)) {
                    messages.append(Messages.info("Redirected: " + art.getCoordinate() + " to: " + projectLoc2, PathConfig.getPomXmlLocation(manifestRoot)));
                    PathConfig.addProjectAndItsDependencies(mode, srcs, libs, messages, projectLoc2);
                } else {
                    messages.append(Messages.error("Declared dependency does not exist: " + art.getCoordinate(), PathConfig.getPomXmlLocation(manifestRoot)));
                }
                return;
            }
            ISourceLocation dep = MavenRepositoryURIResolver.mavenize(URIUtil.createFileLocation(resolvedLocation));
            String libProjectName = manifest.getManifestProjectName(manifest.manifest(dep));
            if (libProjectName == null || libProjectName.isEmpty()) {
                libs.append(dep);
                return;
            }
            if (libProjectName.equals("rascal")) {
                return;
            }
            boolean dependsOnRascalLSP = libProjectName.equals("rascal-lsp");
            if (dependsOnRascalLSP) {
                PathConfig.checkLSPVersionsMatch(manifestRoot, messages, dep);
            }
            if (reg.exists(projectLoc = URIUtil.correctLocation("project", libProjectName, "")) && !dependsOnRascalLSP) {
                messages.append(Messages.info("Redirected: " + art.getCoordinate() + " to: " + projectLoc, PathConfig.getPomXmlLocation(manifestRoot)));
                PathConfig.addProjectAndItsDependencies(mode, srcs, libs, messages, projectLoc);
            } else {
                libs.append(dep);
                if (mode == RascalConfigMode.COMPILER) {
                    ISourceLocation jarifiedDep = JarURIResolver.jarify(dep);
                    if (jarifiedDep != dep) {
                        libs.append(jarifiedDep);
                    }
                } else {
                    assert (mode == RascalConfigMode.INTERPRETER) : "there should be only 2 modes";
                    PathConfig.addLibraryToSourcePath(reg, srcs, messages, dep);
                }
            }
        }
        catch (URISyntaxException e) {
            messages.append(Messages.error("Could not convert " + art.getCoordinate() + " to a loc: " + e, manifestRoot));
        }
    }

    private static void addProjectAndItsDependencies(RascalConfigMode mode, IListWriter srcs, IListWriter libs, IListWriter messages, ISourceLocation projectLoc) throws IOException, URISyntaxException {
        projectLoc = PathConfig.safeResolve(projectLoc);
        List<Artifact> childMavenClasspath = PathConfig.getPomXmlCompilerClasspath(projectLoc, messages);
        PathConfig.buildNormalProjectConfig(projectLoc, mode, childMavenClasspath, false, srcs, libs, messages);
    }

    private static void checkLSPVersionsMatch(ISourceLocation manifestRoot, IListWriter messages, ISourceLocation dep) throws IOException {
        try {
            ISourceLocation loadedRascalLsp = PathConfig.resolveProjectOnClasspath("rascal-lsp");
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            try (InputStream in = reg.getInputStream(loadedRascalLsp);
                 InputStream in2 = reg.getInputStream(dep);){
                String version = new Manifest(in).getMainAttributes().getValue("Specification-Version");
                String otherVersion = new Manifest(in2).getMainAttributes().getValue("Specification-Version");
                if (version != null && !version.equals(otherVersion)) {
                    messages.append(Messages.warning("Pom.xml dependency on rascal-lsp has version " + otherVersion + " while the effective version in the VScode extension is " + version + ". This can have funny effects in the IDE while debugging or code browsing.", PathConfig.getPomXmlLocation(manifestRoot)));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static PathConfig fromSourceProjectRascalManifest(ISourceLocation manifestRoot, RascalConfigMode mode, boolean isRoot) {
        manifestRoot = PathConfig.safeResolve(manifestRoot);
        RascalManifest manifest = new RascalManifest();
        IRascalValueFactory vf = IRascalValueFactory.getInstance();
        String projectName = manifest.getProjectName(manifestRoot);
        IListWriter libsWriter = (IListWriter)vf.listWriter().unique();
        IListWriter srcsWriter = (IListWriter)vf.listWriter().unique();
        IListWriter messages = vf.listWriter();
        if (isRoot) {
            messages.append(Messages.info("Rascal version:" + RascalManifest.getRascalVersionNumber(), manifestRoot));
        }
        ISourceLocation target = manifestRoot.getScheme().equals("project") ? URIUtil.correctLocation("target", projectName, "") : URIUtil.getChildLocation(manifestRoot, "target/classes");
        ISourceLocation generatedSources = URIUtil.getChildLocation(manifestRoot, "target/generatedSources");
        try {
            List<Artifact> mavenClasspath = PathConfig.getPomXmlCompilerClasspath(manifestRoot, messages);
            if (projectName.equals("rascal")) {
                messages.append(Messages.info("Detected Rascal project self-application", PathConfig.getPomXmlLocation(manifestRoot)));
                PathConfig.buildRascalConfig(manifestRoot, mode, mavenClasspath, srcsWriter, libsWriter, messages);
            } else if (projectName.equals("rascal-lsp")) {
                PathConfig.buildRascalLSPConfig(manifestRoot, mode, mavenClasspath, srcsWriter, libsWriter, messages);
            } else {
                PathConfig.buildNormalProjectConfig(manifestRoot, mode, mavenClasspath, isRoot, srcsWriter, libsWriter, messages);
            }
        }
        catch (IOException | URISyntaxException e) {
            messages.append(Messages.warning(e.getMessage(), PathConfig.getPomXmlLocation(manifestRoot)));
        }
        if (!projectName.isEmpty()) {
            PathConfig.validateProjectName(manifestRoot, projectName, messages);
        }
        return new PathConfig((IList)srcsWriter.done(), (IList)libsWriter.done(), target, vf.list(new IValue[0]), generatedSources, (IList)messages.done());
    }

    private static ISourceLocation upgradeToProjectScheme(ISourceLocation loc, String projectName) {
        ISourceLocation projectResolved;
        if (loc.getScheme().equals("project") || projectName == null || projectName.isBlank()) {
            return loc;
        }
        ISourceLocation projectScheme = URIUtil.correctLocation("project", projectName, "");
        ISourceLocation originalResolved = PathConfig.safeResolve(loc);
        if (PathConfig.semanticallySame(originalResolved, projectResolved = PathConfig.safeResolve(projectScheme))) {
            return projectScheme;
        }
        return loc;
    }

    private static boolean semanticallySame(ISourceLocation a, ISourceLocation b) {
        if (!a.getScheme().equals("file")) {
            return a.equals(b);
        }
        if (!b.getScheme().equals("file")) {
            return false;
        }
        Object aPath = a.getPath();
        Object bPath = b.getPath();
        if (((String)aPath).endsWith("/")) {
            if (!((String)bPath).endsWith("/")) {
                bPath = (String)bPath + "/";
            }
        } else if (((String)bPath).endsWith("/")) {
            aPath = (String)aPath + "/";
        }
        if (OSUtils.IS_WINDOWS || OSUtils.IS_OSX) {
            return ((String)aPath).equalsIgnoreCase((String)bPath);
        }
        return ((String)aPath).equals(bPath);
    }

    private static ISourceLocation safeResolve(ISourceLocation loc) {
        try {
            ISourceLocation result = URIResolverRegistry.getInstance().logicalToPhysical(loc);
            if (result != null) {
                return result;
            }
            return loc;
        }
        catch (IOException ignored) {
            return loc;
        }
    }

    private static void validateProjectName(ISourceLocation manifestRoot, String projectName, IListWriter messages) {
        try {
            RascalManifest manifest = new RascalManifest();
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            ISourceLocation projectLoc = URIUtil.correctLocation("project", projectName, "");
            manifestRoot = reg.logicalToPhysical(manifestRoot);
            if (!projectLoc.equals(manifestRoot) && !projectName.equals(URIUtil.getLocationName(manifestRoot))) {
                messages.append(Messages.error("Project-Name in RASCAL.MF (" + projectName + ") should be equal to folder name (" + URIUtil.getLocationName(manifestRoot) + ")", PathConfig.getRascalMfLocation(manifestRoot)));
            }
            try (InputStream mfi = manifest.manifest(manifestRoot);){
                String reqlibs = new Manifest(mfi).getMainAttributes().getValue("Require-Libraries");
                if (reqlibs != null && !reqlibs.isEmpty()) {
                    messages.append(Messages.info("Require-Libraries in RASCAL.MF are not used anymore. Please use Maven dependencies in pom.xml.", PathConfig.getRascalMfLocation(manifestRoot)));
                }
            }
        }
        catch (IOException e) {
            messages.append(Messages.error(e.getMessage(), PathConfig.getRascalMfLocation(manifestRoot)));
        }
    }

    private static void addLibraryToSourcePath(URIResolverRegistry reg, IListWriter srcsWriter, IListWriter messages, ISourceLocation jar) {
        ISourceLocation unpacked = JarURIResolver.jarify(jar);
        if (!reg.exists(URIUtil.getChildLocation(unpacked, "META-INF/RASCAL.MF"))) {
            return;
        }
        RascalManifest manifest = new RascalManifest();
        boolean foundSrc = false;
        for (String src : manifest.getSourceRoots(jar)) {
            ISourceLocation srcLib = URIUtil.getChildLocation(unpacked, src);
            if (reg.exists(srcLib)) {
                srcsWriter.append(srcLib);
                foundSrc = true;
                continue;
            }
            messages.append(Messages.error(srcLib + " source folder does not exist.", URIUtil.getChildLocation(jar, "META-INF/RASCAL.MF")));
        }
        if (!foundSrc) {
            srcsWriter.append(jar);
        }
    }

    private static ISourceLocation getRascalMfLocation(ISourceLocation project) {
        return URIUtil.getChildLocation(project, "META-INF/RASCAL.MF");
    }

    private static ISourceLocation getPomXmlLocation(ISourceLocation project) {
        try {
            ISourceLocation pomxml = URIUtil.getChildLocation(project, "pom.xml");
            return URIResolverRegistry.getInstance().logicalToPhysical(pomxml);
        }
        catch (IOException e) {
            assert (false) : e.getMessage();
            return URIUtil.correctLocation("unknown", "", "pom.xml");
        }
    }

    private static List<Artifact> getPomXmlCompilerClasspath(ISourceLocation manifestRoot, IListWriter messages) {
        try {
            ISourceLocation resolved;
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            if (!manifestRoot.getScheme().equals("file") && (resolved = reg.logicalToPhysical(manifestRoot)) != null) {
                if (!resolved.getScheme().equals("file")) {
                    return Collections.emptyList();
                }
                manifestRoot = resolved;
            }
            if (!manifestRoot.getPath().endsWith("pom.xml")) {
                manifestRoot = URIUtil.getChildLocation(manifestRoot, "pom.xml");
            }
            MavenParser mavenParser = new MavenParser(Path.of(manifestRoot.getURI()));
            Artifact rootProject = mavenParser.parseProject();
            messages.appendAll(rootProject.getMessages());
            List<Artifact> result = rootProject.resolveDependencies(Scope.COMPILE, mavenParser);
            for (Artifact a : result) {
                messages.appendAll(a.getMessages());
            }
            return result;
        }
        catch (IOException | RuntimeException | ModelResolutionError e) {
            return Collections.emptyList();
        }
    }

    public ISourceLocation getBin() {
        return this.bin;
    }

    String makeFileName(String qualifiedModuleName, String extension) {
        return qualifiedModuleName.replaceAll("::", "/") + "." + extension;
    }

    public String getModuleName(ISourceLocation moduleLoc) throws IOException {
        String modulePath = moduleLoc.getPath();
        if (!modulePath.endsWith(".rsc")) {
            throw new IOException("Not a Rascal source file: " + moduleLoc);
        }
        if (moduleLoc.getScheme().equals("std") || moduleLoc.getScheme().equals("mvn")) {
            return this.pathToModulename(modulePath, "/");
        }
        for (ISourceLocation dir : this.srcs) {
            if (!modulePath.startsWith(dir.getPath()) || moduleLoc.getScheme() != dir.getScheme()) continue;
            return this.pathToModulename(modulePath, dir.getPath());
        }
        for (ISourceLocation dir : this.libs) {
            if (!modulePath.startsWith(dir.getPath()) || moduleLoc.getScheme() != dir.getScheme()) continue;
            return this.pathToModulename(modulePath, dir.getPath());
        }
        throw new IOException("No module name found for " + moduleLoc + "\n" + this);
    }

    private String pathToModulename(String modulePath, String folder) {
        String moduleName = modulePath.replaceFirst(folder, "").replace(".rsc", "");
        if (moduleName.startsWith("/")) {
            moduleName = moduleName.substring(1, moduleName.length());
        }
        return moduleName.replace("/", "::");
    }

    private String moduleToDir(String module) {
        return module.replaceAll("::", "/");
    }

    private ISourceLocation getFullURI(String path, ISourceLocation dir) throws URISyntaxException {
        return URIUtil.getChildLocation(dir, path);
    }

    public List<String> listModuleEntries(String moduleRoot) {
        assert (!moduleRoot.endsWith("::"));
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        try {
            String modulePath = this.moduleToDir(moduleRoot);
            ArrayList<String> result = new ArrayList<String>();
            for (ISourceLocation dir : this.srcs) {
                ISourceLocation full = this.getFullURI(modulePath, dir);
                if (!reg.exists(full)) continue;
                try {
                    String[] entries = reg.listEntries(full);
                    if (entries == null) continue;
                    for (String module : entries) {
                        if (module.endsWith(".rsc")) {
                            result.add(module.substring(0, module.length() - ".rsc".length()));
                            continue;
                        }
                        if (module.indexOf(46) != -1 || !reg.isDirectory(this.getFullURI(module, full))) continue;
                        result.add(module + "::");
                    }
                }
                catch (IOException iOException) {
                }
            }
            if (result.size() > 0) {
                return result;
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public IConstructor asConstructor() {
        HashMap<String, IValue> config = new HashMap<String, IValue>();
        config.put("srcs", this.getSrcs());
        config.put("ignores", this.getIgnores());
        config.put("bin", this.getBin());
        config.put("libs", this.getLibs());
        config.put("generatedSources", this.getGeneratedSources());
        config.put("messages", this.getMessages());
        return vf.constructor(this.pathConfigConstructor, new IValue[0], config);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        w.append("Path configuration items:").append("\n").append("srcs:            ").append(this.getSrcs().toString()).append("\n").append("ignores:         ").append(this.getIgnores().toString()).append("\n").append("libs:            ").append(this.getLibs().toString()).append("\n").append("bin:             ").append(this.getBin().toString()).append("\n").append("generatedSources:").append(this.getGeneratedSources().toString()).append("\n").append("messages:        ").append(this.getMessages().toString()).append("\n");
        return w.toString();
    }

    public static enum RascalConfigMode {
        INTERPRETER,
        COMPILER;

    }
}

