/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.List;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.Configuration;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.load.StandardLibraryContributor;
import org.rascalmpl.interpreter.utils.JavaBridge;
import org.rascalmpl.interpreter.utils.Profiler;
import org.rascalmpl.parser.gtd.IGTD;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;

public class ParserGenerator {
    private final Evaluator evaluator;
    private final JavaBridge bridge;
    private final IValueFactory vf;
    private static final String packageName = "org.rascalmpl.java.parser.object";
    private static final boolean debug = false;

    public ParserGenerator(IRascalMonitor monitor, PrintWriter out, List<ClassLoader> loaders, IValueFactory factory, Configuration config) {
        GlobalEnvironment heap = new GlobalEnvironment();
        ModuleEnvironment scope = new ModuleEnvironment("$parsergenerator$", heap);
        this.evaluator = new Evaluator(ValueFactoryFactory.getValueFactory(), Reader.nullReader(), out, out, scope, heap, monitor);
        this.evaluator.getConfiguration().setGeneratorProfiling(config.getGeneratorProfilingProperty());
        this.evaluator.addRascalSearchPathContributor(StandardLibraryContributor.getInstance());
        this.evaluator.setBootstrapperProperty(true);
        this.bridge = new JavaBridge(loaders, factory, config);
        this.vf = factory;
        this.evaluator.doImport(monitor, "lang::rascal::grammar::ParserGenerator", "lang::rascal::grammar::ConcreteSyntax", "lang::rascal::grammar::definition::Modules", "lang::rascal::grammar::definition::Priorities", "lang::rascal::grammar::definition::Regular", "lang::rascal::grammar::definition::Keywords", "lang::rascal::grammar::definition::Literals", "lang::rascal::grammar::definition::Parameters", "lang::rascal::grammar::definition::Symbols", "analysis::grammars::Ambiguity");
    }

    public void setGeneratorProfiling(boolean f) {
        this.evaluator.getConfiguration().setGeneratorProfiling(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue diagnoseAmbiguity(IConstructor parseForest) {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            return this.evaluator.call("diagnose", parseForest);
        }
    }

    private void debugOutput(Object thing, String file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConstructor getGrammarFromModules(IRascalMonitor monitor, String main, IMap modules) {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            return (IConstructor)this.evaluator.call(monitor, "modules2grammar", this.vf.string(main), modules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConstructor getExpandedGrammar(IRascalMonitor monitor, String main, IMap definition) {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            IConstructor g2 = this.getGrammarFromModules(monitor, main, definition);
            g2 = (IConstructor)this.evaluator.call(monitor, "expandKeywords", g2);
            g2 = (IConstructor)this.evaluator.call(monitor, "makeRegularStubs", g2);
            g2 = (IConstructor)this.evaluator.call(monitor, "expandRegularSymbols", g2);
            g2 = (IConstructor)this.evaluator.call(monitor, "expandParameterizedSymbols", g2);
            g2 = (IConstructor)this.evaluator.call(monitor, "literals", g2);
            return g2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISet getNestingRestrictions(IRascalMonitor monitor, IConstructor g2) {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            return (ISet)this.evaluator.call(monitor, "doNotNest", g2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParserMethodName(IConstructor symbol) {
        switch (symbol.getName()) {
            case "start": {
                return "start__" + this.getParserMethodName(SymbolAdapter.getStart(symbol));
            }
            case "layouts": {
                return "layouts_" + SymbolAdapter.getName(symbol);
            }
            case "sort": 
            case "lex": 
            case "keywords": {
                return SymbolAdapter.getName(symbol);
            }
        }
        Object object = this.evaluator;
        synchronized (object) {
            return ((IString)this.evaluator.call((IRascalMonitor)null, "getParserMethodName", symbol)).getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConstructor symbolTreeToSymbol(IConstructor symbol) {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            return (IConstructor)this.evaluator.call((IRascalMonitor)null, "sym2symbol", symbol);
        }
    }

    public Class<IGTD<IConstructor, ITree, ISourceLocation>> getNewParser(IRascalMonitor monitor, ISourceLocation loc, String name, IMap definition) {
        Profiler profiler = this.evaluator.getConfiguration().getGeneratorProfilingProperty() ? new Profiler(this.evaluator) : null;
        try {
            if (profiler != null) {
                profiler.start();
            }
            IConstructor grammar = IRascalValueFactory.getInstance().grammar(definition);
            this.debugOutput(grammar, System.getProperty("java.io.tmpdir") + "/grammar.trm");
            Class<IGTD<IConstructor, ITree, ISourceLocation>> clazz = this.getNewParser(monitor, loc, name, grammar);
            return clazz;
        }
        catch (ClassCastException e) {
            throw new ImplementationError("parser generator:" + e.getMessage(), e);
        }
        catch (Throw e) {
            throw new ImplementationError("parser generator: " + e.getMessage() + e.getTrace());
        }
        finally {
            if (profiler != null) {
                profiler.pleaseStop();
                this.evaluator.getOutPrinter().println("PROFILE:");
                profiler.report();
                profiler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<IGTD<IConstructor, ITree, ISourceLocation>> getNewParser(IRascalMonitor monitor, ISourceLocation loc, String name, IConstructor grammar) {
        try {
            IString classString;
            String normName = name.replaceAll("::", "_").replaceAll("\\\\", "_");
            Evaluator evaluator = this.evaluator;
            synchronized (evaluator) {
                classString = (IString)this.evaluator.call(monitor, "newGenerate", this.vf.string(packageName), this.vf.string(normName), grammar);
            }
            this.debugOutput(classString, System.getProperty("java.io.tmpdir") + "/parser.java");
            return this.bridge.compileJava(loc, "org.rascalmpl.java.parser.object." + normName, classString.getValue());
        }
        catch (ClassCastException e) {
            throw new ImplementationError("parser generator:" + e.getMessage(), e);
        }
        catch (Throw e) {
            throw new ImplementationError("parser generator: " + e.getMessage() + e.getTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNewParser(IRascalMonitor monitor, ISourceLocation loc, String name, IMap definition, ISourceLocation target) throws IOException {
        try (OutputStream out = URIResolverRegistry.getInstance().getOutputStream(target, false);){
            IString classString;
            String normName = name.replaceAll("::", "_").replaceAll("\\\\", "_");
            IConstructor grammar = IRascalValueFactory.getInstance().grammar(definition);
            Evaluator evaluator = this.evaluator;
            synchronized (evaluator) {
                classString = (IString)this.evaluator.call(monitor, "newGenerate", this.vf.string(packageName), this.vf.string(normName), grammar);
            }
            this.debugOutput(classString, System.getProperty("java.io.tmpdir") + "/parser.java");
            this.bridge.compileJava(loc, "org.rascalmpl.java.parser.object." + normName, classString.getValue(), out);
        }
        catch (ClassCastException e) {
            throw new ImplementationError("parser generator:" + e.getMessage(), e);
        }
        catch (Throw e) {
            throw new ImplementationError("parser generator: " + e.getMessage() + e.getTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IString createHole(IConstructor part, IInteger size) {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            return (IString)this.evaluator.call("createHole", part, size);
        }
    }
}

