/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.result.out;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.result.SkippedNode;
import org.rascalmpl.parser.gtd.result.out.INodeConstructorFactory;

public class SkippedNodeFlattener<T, P> {
    private Map<MemoKey, T> memoTable = new HashMap<MemoKey, T>();

    public T convertToUPTR(INodeConstructorFactory<T, P> nodeConstructorFactory, SkippedNode node, PositionStore positionStore) {
        MemoKey key = new MemoKey(node);
        T result = this.memoTable.get(key);
        if (result != null) {
            return result;
        }
        result = nodeConstructorFactory.createSkippedNode(node.getSkippedChars());
        if (node.getInputUri() != null) {
            int startOffset = node.getOffset();
            int endOffset = startOffset + node.getLength();
            P sourceLocation = nodeConstructorFactory.createPositionInformation(node.getInputUri(), startOffset, endOffset, positionStore);
            result = nodeConstructorFactory.addPositionInformation(result, sourceLocation);
        }
        this.memoTable.put(key, result);
        return result;
    }

    private static class MemoKey {
        private int offset;
        private int length;

        public MemoKey(SkippedNode node) {
            this.offset = node.getOffset();
            this.length = node.getLength();
        }

        public boolean equals(Object peer) {
            if (!(peer instanceof MemoKey)) {
                return false;
            }
            MemoKey peerKey = (MemoKey)peer;
            return this.offset == peerKey.offset && this.length == peerKey.length;
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.length);
        }
    }
}

