/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.match;

import java.util.Arrays;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;

public class CaseInsensitiveStringMatchRestriction
implements ICompletionFilter {
    private final int[][] string;

    public CaseInsensitiveStringMatchRestriction(int[][] chars) {
        this.string = chars;
        assert (Arrays.stream(chars).noneMatch(letter -> ((int[])letter).length != 2));
    }

    @Override
    public boolean isFiltered(int[] input, int start, int end, PositionStore positionStore) {
        if (end - start != this.string.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (input[start + i] == this.string[i][0] || input[start + i] == this.string[i][1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(ICompletionFilter otherCompletionFilter) {
        if (!(otherCompletionFilter instanceof CaseInsensitiveStringMatchRestriction)) {
            return false;
        }
        CaseInsensitiveStringMatchRestriction otherStringMatchFilter = (CaseInsensitiveStringMatchRestriction)otherCompletionFilter;
        int[][] otherString = otherStringMatchFilter.string;
        if (this.string.length != otherString.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (this.string[i][0] == otherString[i][0] && this.string[i][1] == otherString[i][1]) continue;
            return false;
        }
        return true;
    }
}

