/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.precede;

import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public class StringPrecedeRequirement
implements IEnterFilter {
    private final int[] string;

    public StringPrecedeRequirement(int[] string) {
        this.string = string;
    }

    @Override
    public boolean isFiltered(int[] input, int start, PositionStore positionStore) {
        int startLocation = start - this.string.length;
        if (startLocation < 0) {
            return true;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (input[startLocation + i] == this.string[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEqual(IEnterFilter otherEnterFilter) {
        if (!(otherEnterFilter instanceof StringPrecedeRequirement)) {
            return false;
        }
        StringPrecedeRequirement otherStringPrecedeFilter = (StringPrecedeRequirement)otherEnterFilter;
        int[] otherString = otherStringPrecedeFilter.string;
        if (this.string.length != otherString.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (this.string[i] == otherString[i]) continue;
            return false;
        }
        return true;
    }
}

