/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.uptr.recovery;

import org.rascalmpl.parser.uptr.recovery.InputMatcher;

public class LiteralMatcher
implements InputMatcher {
    private int[] chars;

    public LiteralMatcher(String literal) {
        this.chars = new int[literal.length()];
        for (int i = 0; i < literal.length(); ++i) {
            this.chars[i] = literal.codePointAt(i);
        }
    }

    public LiteralMatcher(int[] literal) {
        this.chars = literal;
    }

    @Override
    public InputMatcher.MatchResult findMatch(int[] input, int startLocation, int maxLength) {
        int length = this.chars.length;
        int limit = Math.min(startLocation + maxLength - length, input.length - length + 1);
        for (int start = startLocation; start < limit; ++start) {
            boolean matches = true;
            for (int i = 0; i < length; ++i) {
                if (input[start + i] == this.chars[i]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return new InputMatcher.MatchResult(start, length);
        }
        return null;
    }

    public String toString() {
        return "LiteralMatcher[" + new String(this.chars, 0, this.chars.length) + "]";
    }
}

