/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.rascal;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class RascalLineParser
implements Parser {
    private final Function<String, ITree> commandParser;
    private static final Pattern RASCAL_STRING = Pattern.compile("^[\">]([^\"<\\\\]|([\\\\].))*([\"<]|$)");
    private static final Pattern RASCAL_LOCATION = Pattern.compile("^[\\|\\>][^\\|\\<\\t-\\n\\r ]*[\\|\\<]?");
    private static final Pattern RASCAL_NAME = Pattern.compile("^((([A-Za-z_][A-Za-z0-9_]*)|([\\\\][A-Za-z_]([\\-A-Za-z0-9_])*))(::)?)+");
    private static final Pattern RASCAL_WHITE_SPACE = Pattern.compile("^(\\p{Zs}|([/][*]([^*]|([*][^/]))*[*][/]))*");

    public RascalLineParser(Function<String, ITree> commandParser) {
        this.commandParser = commandParser;
    }

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        switch (context) {
            case UNSPECIFIED: 
            case ACCEPT_LINE: {
                return this.parseFullRascalCommand(line, cursor, true);
            }
            case COMPLETE: {
                try {
                    return this.parseFullRascalCommand(line, cursor, false);
                }
                catch (EOFError e) {
                    return this.splitWordsOnly(line, cursor);
                }
            }
            case SECONDARY_PROMPT: {
                throw new SyntaxError(-1, -1, "Unsupported SECONDARY_PROMPT");
            }
            case SPLIT_LINE: {
                throw new SyntaxError(-1, -1, "Unsupported SPLIT_LINE");
            }
        }
        throw new UnsupportedOperationException("Unimplemented context: " + context);
    }

    private ParsedLine splitWordsOnly(String line, int cursor) {
        ArrayList<LexedWord> words = new ArrayList<LexedWord>();
        this.parseWords(line, 0, words);
        return new ParsedLineLexedWords(words, cursor, line);
    }

    private void parseWords(String buffer, int position, List<LexedWord> words) {
        boolean inString = false;
        boolean inLocation = false;
        while (position < buffer.length()) {
            if ((position = this.eatWhiteSpace(buffer, position)) >= buffer.length()) {
                return;
            }
            char c = buffer.charAt(position);
            boolean isWord = true;
            int wordEnd = position;
            if (c == '\"' || c == '>' && inString) {
                wordEnd = RascalLineParser.parseEndedAfter(buffer, position, RASCAL_STRING);
                inString = wordEnd != buffer.length() && buffer.charAt(wordEnd - 1) != '\"';
            } else if (c == '|' || c == '>' && inLocation) {
                wordEnd = RascalLineParser.parseEndedAfter(buffer, position, RASCAL_LOCATION);
                inLocation = wordEnd != buffer.length() && buffer.charAt(wordEnd - 1) != '|';
            } else if (Character.isJavaIdentifierPart(c) || c == '\\') {
                wordEnd = RascalLineParser.parseEndedAfter(buffer, position, RASCAL_NAME);
            } else if (c == ':' && words.isEmpty()) {
                ++wordEnd;
            } else {
                ++wordEnd;
                isWord = false;
            }
            if (wordEnd == position) {
                wordEnd = buffer.length();
            }
            if (isWord) {
                words.add(new LexedWord(buffer, position, wordEnd));
            }
            position = wordEnd;
        }
    }

    private static int parseEndedAfter(String buffer, int position, Pattern parser) {
        Matcher matcher = parser.matcher(buffer);
        matcher.region(position, buffer.length());
        if (!matcher.find()) {
            return position;
        }
        return matcher.end();
    }

    private int eatWhiteSpace(String buffer, int position) {
        return RascalLineParser.parseEndedAfter(buffer, position, RASCAL_WHITE_SPACE);
    }

    private ParsedLine parseFullRascalCommand(String line, int cursor, boolean completeStatementMode) throws SyntaxError {
        try {
            return this.translateTree(this.commandParser.apply(line), line, cursor);
        }
        catch (ParseError pe) {
            if (!completeStatementMode || this.lastLineIsBlank(line)) {
                return this.splitWordsOnly(line, cursor);
            }
            throw new EOFError(pe.getBeginLine(), pe.getBeginColumn(), "Parse error");
        }
        catch (Throwable e) {
            throw new EOFError(-1, -1, "Unexpected failure during parsing of the command: " + e.getMessage());
        }
    }

    private boolean lastLineIsBlank(String line) {
        return line.endsWith("\n");
    }

    private ParsedLine translateTree(ITree command, String line, int cursor) {
        ArrayList<LexedWord> result = new ArrayList<LexedWord>();
        this.collectWords(command, result, line, 0);
        return new ParsedLineLexedWords(result, cursor, line);
    }

    private int collectWords(ITree t2, List<LexedWord> words, String line, int offset) {
        int length;
        boolean isWord;
        if (TreeAdapter.isLayout(t2)) {
            isWord = false;
        } else if (TreeAdapter.isLexical(t2) || TreeAdapter.isLiteral(t2) || TreeAdapter.isCILiteral(t2)) {
            isWord = true;
        } else if (TreeAdapter.isSort(t2) && TreeAdapter.getSortName(t2).equals("QualifiedName")) {
            isWord = true;
        } else {
            if (TreeAdapter.isSort(t2)) {
                ISourceLocation loc = TreeAdapter.getLocation(t2);
                boolean isWord2 = false;
                for (IValue c : t2.getArgs()) {
                    if (!(c instanceof ITree)) continue;
                    offset = this.collectWords((ITree)c, words, line, offset);
                }
                return loc == null ? offset : loc.getOffset() + loc.getLength();
            }
            if (TreeAdapter.isTop(t2)) {
                boolean isWord3 = false;
                IList args = t2.getArgs();
                ISourceLocation preLoc = TreeAdapter.getLocation((ITree)args.get(0));
                offset += preLoc == null ? 0 : preLoc.getLength();
                offset = this.collectWords((ITree)args.get(1), words, line, offset);
                ISourceLocation postLoc = TreeAdapter.getLocation((ITree)args.get(2));
                return offset + (postLoc == null ? 0 : postLoc.getLength());
            }
            isWord = false;
        }
        ISourceLocation loc = TreeAdapter.getLocation(t2);
        int n = length = loc == null ? TreeAdapter.yield(t2).length() : loc.getLength();
        if (isWord) {
            words.add(new LexedWord(line, offset, offset + length));
        }
        return offset + length;
    }

    private static class LexedWord {
        private final String buffer;
        private final int begin;
        private final int end;

        public LexedWord(String buffer, int begin, int end) {
            this.buffer = buffer;
            this.begin = begin;
            this.end = end;
        }

        public boolean cursorInside(int cursor) {
            return this.begin <= cursor && cursor <= this.end;
        }

        String word() {
            return this.buffer.substring(this.begin, this.end);
        }
    }

    private final class ParsedLineLexedWords
    implements ParsedLine {
        private final ArrayList<LexedWord> words;
        private final int cursor;
        private final String line;
        private final @Nullable LexedWord atCursor;

        private ParsedLineLexedWords(ArrayList<LexedWord> words, int cursor, String line) {
            this.words = words;
            this.cursor = cursor;
            this.line = line;
            if (cursor >= line.length() - 1 && (words.isEmpty() || !words.get(words.size() - 1).cursorInside(cursor))) {
                words.add(new LexedWord(line + " ", cursor, cursor));
            }
            this.atCursor = words.stream().filter(l -> l.cursorInside(cursor)).findFirst().orElse(null);
        }

        @Override
        public String word() {
            return this.atCursor == null ? "" : this.atCursor.word();
        }

        @Override
        public int wordCursor() {
            return this.atCursor == null ? 0 : this.cursor - this.atCursor.begin;
        }

        @Override
        public int wordIndex() {
            return this.atCursor == null ? -1 : this.words.indexOf(this.atCursor);
        }

        @Override
        public List<String> words() {
            return this.words.stream().map(LexedWord::word).collect(Collectors.toList());
        }

        @Override
        public String line() {
            return this.line;
        }

        @Override
        public int cursor() {
            return this.cursor;
        }
    }
}

