/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.rascal;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.jansi.Ansi;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.Parser;
import org.jline.terminal.Terminal;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.repl.IREPLService;
import org.rascalmpl.repl.StopREPLException;
import org.rascalmpl.repl.TerminalProgressBarMonitor;
import org.rascalmpl.repl.completers.RascalCommandCompletion;
import org.rascalmpl.repl.completers.RascalIdentifierCompletion;
import org.rascalmpl.repl.completers.RascalKeywordCompletion;
import org.rascalmpl.repl.completers.RascalLocationCompletion;
import org.rascalmpl.repl.completers.RascalModuleCompletion;
import org.rascalmpl.repl.output.ICommandOutput;
import org.rascalmpl.repl.rascal.IRascalLanguageProtocol;
import org.rascalmpl.repl.rascal.ParseErrorPrinter;
import org.rascalmpl.repl.rascal.RascalLineParser;
import org.rascalmpl.repl.streams.StreamUtil;

public class RascalReplServices
implements IREPLService {
    private final IRascalLanguageProtocol lang;
    private final @Nullable Path historyFile;
    private boolean unicodeSupported = false;
    private boolean ansiSupported = false;
    private Terminal term;
    private PrintWriter out;
    private PrintWriter err;

    @Override
    public String name() {
        return "Rascal REPL";
    }

    public RascalReplServices(IRascalLanguageProtocol lang, @Nullable Path historyFile) {
        this.lang = lang;
        this.historyFile = historyFile;
    }

    @Override
    public IDEServices connect(Terminal term, boolean ansiColorsSupported, boolean unicodeSupported) {
        if (this.out != null) {
            throw new IllegalStateException("Repl Service is already initialized");
        }
        this.term = term;
        this.unicodeSupported = unicodeSupported;
        this.ansiSupported = ansiColorsSupported;
        TerminalProgressBarMonitor monitor = new TerminalProgressBarMonitor(term);
        this.out = monitor;
        this.err = StreamUtil.generateErrorStream(term, monitor);
        return this.lang.initialize(term.reader(), this.out, this.err, monitor, term);
    }

    @Override
    public void disconnect() {
        if (this.err != null) {
            this.err.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public Parser inputParser() {
        return new RascalLineParser(this.lang::parseCommand);
    }

    @Override
    public ICommandOutput handleInput(String input) throws InterruptedException, StopREPLException {
        try {
            return this.lang.handleInput(input);
        }
        catch (ParseError pe) {
            return ParseErrorPrinter.parseErrorMaybePrompt(pe, this.lang.promptRootLocation(), input, this.term, this.prompt(false, this.unicodeSupported).length() + 1);
        }
    }

    @Override
    public void handleInterrupt() throws InterruptedException {
        this.lang.cancelRunningCommandRequested();
    }

    @Override
    public String prompt(boolean ansiColorsSupported, boolean unicodeSupported) {
        String prompt = "rascal>";
        if (ansiColorsSupported) {
            return Ansi.ansi().reset().bold().a(prompt).reset().toString();
        }
        return prompt;
    }

    @Override
    public String parseErrorPrompt(boolean ansiColorsSupported, boolean unicodeSupported) {
        String errorPrompt = (unicodeSupported ? "\u2502" : "|") + "%N %P>";
        if (ansiColorsSupported) {
            return Ansi.ansi().reset().bold().a(errorPrompt).reset().toString();
        }
        return errorPrompt;
    }

    @Override
    public String interruptedPrompt(boolean ansiColorsSupported, boolean unicodeSupported) {
        String prompt = ">>>>>>> Interrupted";
        if (unicodeSupported) {
            prompt = prompt.replace(">", "\u00bb");
        }
        if (ansiColorsSupported) {
            return Ansi.ansi().reset().fgRed().bold().a(prompt).reset().toString();
        }
        return prompt;
    }

    @Override
    public PrintWriter errorWriter() {
        return this.err;
    }

    @Override
    public PrintWriter outputWriter() {
        return this.out;
    }

    @Override
    public void flush() {
        this.lang.flush();
        this.err.flush();
        this.out.flush();
    }

    @Override
    public boolean supportsCompletion() {
        return true;
    }

    @Override
    public List<Completer> completers() {
        ArrayList<Completer> result = new ArrayList<Completer>();
        RascalModuleCompletion moduleCompleter = new RascalModuleCompletion(this.lang::lookupModules);
        RascalIdentifierCompletion idCompleter = new RascalIdentifierCompletion(this.lang::completePartialIdentifier);
        result.add(new RascalCommandCompletion(new TreeMap<String, String>(this.lang.availableCommandLineOptions()), idCompleter::completePartialIdentifier, (s2, c) -> moduleCompleter.completeModuleNames((String)s2, (List<Candidate>)c, false)));
        result.add(moduleCompleter);
        result.add(idCompleter);
        result.add(new RascalKeywordCompletion());
        result.add(new RascalLocationCompletion());
        return result;
    }

    @Override
    public boolean storeHistory() {
        return this.historyFile != null;
    }

    @Override
    public Path historyFile() {
        return this.historyFile;
    }
}

