/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.function.Function;
import org.rascalmpl.shell.CommandOptions;
import org.rascalmpl.shell.Option;
import org.rascalmpl.shell.OptionType;

public class OptionBuilder {
    CommandOptions commandOptions;
    IValueFactory vf;
    OptionType optionType;
    String name;
    private IValue initialValue;
    private Object defaultValue;
    private boolean mayForceNoDefault;

    OptionBuilder(CommandOptions commandOptions, OptionType optionType, String name) {
        this.commandOptions = commandOptions;
        this.vf = commandOptions.vf;
        this.optionType = optionType;
        this.name = name;
        switch (optionType) {
            case INT: {
                this.initialValue = this.vf.integer(0);
                break;
            }
            case STR: {
                this.initialValue = this.vf.string("");
                break;
            }
            case LOC: {
                this.initialValue = null;
                break;
            }
            case LOCS: {
                this.initialValue = this.vf.list(new IValue[0]);
                break;
            }
            case BOOL: {
                this.initialValue = this.vf.bool(false);
            }
        }
    }

    void check(OptionType ot) {
        if (this.optionType != ot) {
            throw new RuntimeException("Default value required of type " + ot.toString().toLowerCase());
        }
    }

    public OptionBuilder boolDefault(boolean defaultValue) {
        this.check(OptionType.BOOL);
        this.defaultValue = this.commandOptions.vf.bool(defaultValue);
        return this;
    }

    public OptionBuilder boolDefault(Function<CommandOptions, Boolean> defaultValue) {
        this.check(OptionType.BOOL);
        this.defaultValue = defaultValue;
        return this;
    }

    public OptionBuilder intDefault(int defaultValue) {
        this.check(OptionType.INT);
        this.defaultValue = this.commandOptions.vf.integer(defaultValue);
        return this;
    }

    public OptionBuilder intDefault(Function<CommandOptions, Integer> defaultValue) {
        this.check(OptionType.INT);
        this.defaultValue = defaultValue;
        return this;
    }

    public OptionBuilder strDefault(String defaultValue) {
        this.check(OptionType.STR);
        this.defaultValue = this.commandOptions.vf.string(defaultValue);
        return this;
    }

    public OptionBuilder strDefault(Function<CommandOptions, String> defaultValue) {
        this.check(OptionType.STR);
        this.defaultValue = defaultValue;
        return this;
    }

    public OptionBuilder locDefault(ISourceLocation defaultValue) {
        this.check(OptionType.LOC);
        this.defaultValue = defaultValue;
        return this;
    }

    public OptionBuilder locDefault(Function<CommandOptions, ISourceLocation> defaultValue) {
        this.check(OptionType.LOC);
        this.defaultValue = defaultValue;
        return this;
    }

    public OptionBuilder locsDefault(IList defaultValue) {
        this.check(OptionType.LOCS);
        this.defaultValue = defaultValue;
        return this;
    }

    public OptionBuilder locsDefault(Function<CommandOptions, IList> defaultValue) {
        this.check(OptionType.LOCS);
        this.defaultValue = defaultValue;
        return this;
    }

    public OptionBuilder respectNoDefaults() {
        this.mayForceNoDefault = true;
        return this;
    }

    public CommandOptions help(String helpText) {
        return this.commandOptions.addOption(new Option(this.optionType, this.name, this.initialValue, this.defaultValue, this.mayForceNoDefault, helpText));
    }
}

