/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import io.usethesource.vallang.IValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.rascalmpl.shell.Option;
import org.rascalmpl.shell.OptionType;

class Options
implements Iterable<Option> {
    ArrayList<Option> options = new ArrayList();

    Options() {
    }

    Options add(Option option) {
        this.options.add(option);
        return this;
    }

    public IValue get(OptionType optionType, String name) {
        for (Option option : this.options) {
            IValue v = option.get(optionType, name);
            if (v == null) continue;
            return v;
        }
        throw new RuntimeException("Option " + name + " has not been declared");
    }

    public boolean hasNonDefaultValue(OptionType optionType, String name) {
        for (Option option : this.options) {
            if (!option.provides(optionType, name)) continue;
            return option.currentValue != option.initialValue;
        }
        return false;
    }

    public boolean contains(OptionType optionType, String name) {
        for (Option option : this.options) {
            if (!option.provides(optionType, name)) continue;
            return true;
        }
        return false;
    }

    public boolean set(OptionType optionType, String name, IValue newValue) {
        for (Option option : this.options) {
            if (!option.set(optionType, name, newValue)) continue;
            return true;
        }
        throw new RuntimeException("Option " + name + " could not be set");
    }

    public void update(OptionType optionType, String name, Function<IValue, IValue> updater) {
        for (Option option : this.options) {
            if (!option.update(optionType, name, updater)) continue;
            return;
        }
        throw new RuntimeException("Option " + name + " could not be updated");
    }

    public List<String> getAllRespectNoDefaults() {
        ArrayList<String> result = new ArrayList<String>();
        for (Option option : this.options) {
            if (!option.respectsNoDefaults) continue;
            result.add(option.name);
        }
        return result;
    }

    @Override
    public Iterator<Option> iterator() {
        return this.options.iterator();
    }
}

