/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.test.infrastructure;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.io.StandardTextWriter;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import org.rascalmpl.exceptions.Throw;

public class QuickCheck {
    public static final String TRIES = "tries";
    public static final String MAXDEPTH = "maxDepth";
    public static final String MAXWIDTH = "maxWidth";
    public static final String EXPECT_TAG = "expected";
    public static final TestResult SUCCESS = new TestResult(true, null);
    private final Random random;
    private final IValueFactory vf;

    public QuickCheck(Random random, IValueFactory vf) {
        this.random = random;
        this.vf = vf;
    }

    public TestResult test(String functionName, Type formals, String expectedException, BiFunction<Type[], IValue[], TestResult> executeTest, TypeStore store, int tries, int maxDepth, int maxWidth) {
        if (formals.getArity() == 0) {
            tries = 1;
        }
        Type[] types = new Type[formals.getArity()];
        for (int n = 0; n < formals.getArity(); ++n) {
            types[n] = formals.getFieldType(n);
        }
        IValue[] values = new IValue[formals.getArity()];
        for (int i = 0; i < tries; ++i) {
            Throwable thrownException;
            int n;
            HashMap<Type, Type> tpbindings = new HashMap<Type, Type>();
            for (n = 0; n < values.length; ++n) {
                values[n] = types[n].randomValue(this.random, this.vf, store, tpbindings, maxDepth, maxWidth);
            }
            for (n = 0; n < formals.getArity(); ++n) {
                types[n] = types[n].instantiate(tpbindings);
            }
            TestResult result = executeTest.apply(types, values);
            if (result.succeeded() && (!result.succeeded() || expectedException == null) || this.wasExpectedException(expectedException, thrownException = result.thrownException())) continue;
            boolean smallerFound = false;
            IValue[] smallerValues = new IValue[formals.getArity()];
            for (int depth = 1; depth < maxDepth && !smallerFound; ++depth) {
                for (int width = 1; width < maxWidth && !smallerFound; ++width) {
                    for (int j = 0; j < tries && !smallerFound; ++j) {
                        Throwable thrownException2;
                        int n2;
                        for (n2 = 0; n2 < values.length; ++n2) {
                            smallerValues[n2] = types[n2].randomValue(this.random, this.vf, store, tpbindings, maxDepth, maxWidth);
                        }
                        for (n2 = 0; n2 < formals.getArity(); ++n2) {
                            types[n2] = types[n2].instantiate(tpbindings);
                        }
                        TestResult smallerResult = executeTest.apply(types, smallerValues);
                        if (smallerResult.succeeded() && (!smallerResult.succeeded() || expectedException == null) || this.wasExpectedException(expectedException, thrownException2 = smallerResult.thrownException())) continue;
                        values = smallerValues;
                        result = smallerResult;
                        thrownException = thrownException2;
                        smallerFound = true;
                    }
                }
            }
            if (thrownException != null && !this.wasExpectedException(expectedException, thrownException)) {
                return new UnExpectedExceptionThrownResult(functionName, types, tpbindings, values, thrownException);
            }
            if (expectedException != null && thrownException == null) {
                return new ExceptionNotThrownResult(functionName, types, tpbindings, values, expectedException);
            }
            return new TestFailedResult(functionName, "test returned false", types, tpbindings, values);
        }
        return SUCCESS;
    }

    protected boolean wasExpectedException(String expectedException, Throwable thrownException) {
        if (thrownException == null && expectedException != null) {
            return false;
        }
        if (thrownException != null && expectedException != null) {
            if (thrownException instanceof Throw) {
                IValue rascalException = ((Throw)thrownException).getException();
                if (rascalException instanceof IString && ((IString)rascalException).getValue().equals(expectedException)) {
                    return true;
                }
                if (rascalException instanceof IConstructor && ((IConstructor)rascalException).getName().equals(expectedException)) {
                    return true;
                }
            } else if (thrownException.getClass().toString().endsWith("." + expectedException)) {
                return true;
            }
        }
        return false;
    }

    public static class ExceptionNotThrownResult
    extends TestFailedResult {
        public ExceptionNotThrownResult(String functionName, Type[] actualTypes, Map<Type, Type> tpbindings, IValue[] values, String expected) {
            super(functionName, "test did not throw '" + expected + "' exception", actualTypes, tpbindings, values);
        }
    }

    public static class UnExpectedExceptionThrownResult
    extends TestFailedResult {
        public UnExpectedExceptionThrownResult(String functionName, Type[] actualTypes, Map<Type, Type> tpbindings, IValue[] values, Throwable thrownException) {
            super(functionName, "test threw unexpected exception", actualTypes, tpbindings, values);
            this.thrownException = thrownException;
        }

        @Override
        public void writeMessage(PrintWriter out) {
            super.writeMessage(out);
            out.println("Exception:");
            if (this.thrownException instanceof Throw) {
                out.println(((Throw)this.thrownException).getMessage());
                try {
                    ((Throw)this.thrownException).getTrace().prettyPrintedString(out, new StandardTextWriter(true));
                }
                catch (IOException iOException) {}
            } else {
                this.thrownException.printStackTrace(out);
            }
            out.flush();
        }
    }

    private static class TestFailedResult
    extends TestResult {
        protected final String functionName;
        protected final IValue[] values;
        protected final Type[] actualTypes;
        protected final Map<Type, Type> typeBindings;
        protected final String msg;

        public TestFailedResult(String functionName, String msg, Type[] actualTypes, Map<Type, Type> typeBindings, IValue[] values) {
            super(false, null);
            this.functionName = functionName;
            this.msg = msg;
            this.actualTypes = actualTypes;
            this.typeBindings = typeBindings;
            this.values = values;
        }

        @Override
        public void writeMessage(PrintWriter out) {
            out.println("Test " + this.functionName + " failed due to\n\t" + this.msg + "\n");
            if (this.typeBindings.size() > 0) {
                out.println("Type parameters:");
                for (Map.Entry<Type, Type> ent : this.typeBindings.entrySet()) {
                    out.println("\t" + ent.getKey() + " => " + ent.getValue());
                }
            }
            if (this.values.length > 0) {
                out.println("Actual parameters:");
                for (int i = 0; i < this.values.length; ++i) {
                    IValue arg = this.values[i];
                    out.println("\t" + this.actualTypes[i] + " =>" + arg);
                }
            }
            out.println();
        }
    }

    public static class TestResult {
        protected boolean succeeded;
        protected Throwable thrownException;

        public TestResult(boolean succeeded, Throwable thrownException) {
            this.succeeded = succeeded;
            this.thrownException = thrownException;
        }

        public boolean succeeded() {
            return this.succeeded;
        }

        public void writeMessage(PrintWriter out) {
        }

        public Throwable thrownException() {
            return this.thrownException;
        }
    }
}

