/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.types;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.visitors.BottomUpVisitor;
import io.usethesource.vallang.visitors.IdentityVisitor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.rascalmpl.ast.Type;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.types.IRascalTypeVisitor;
import org.rascalmpl.types.RascalType;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.SymbolFactory;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class NonTerminalType
extends RascalType {
    private final IConstructor symbol;

    public NonTerminalType(IConstructor cons) {
        if (cons.getConstructorType() == RascalValueFactory.Tree_Appl) {
            this.symbol = TreeAdapter.getType((ITree)cons);
        } else if (cons.getConstructorType() == RascalValueFactory.Tree_Amb) {
            ISet alts = TreeAdapter.getAlternatives((ITree)cons);
            if (!alts.isEmpty()) {
                ITree first = (ITree)alts.iterator().next();
                this.symbol = TreeAdapter.getType(first);
            } else {
                this.symbol = IRascalValueFactory.getInstance().constructor(RascalValueFactory.Symbol_Empty);
            }
        } else if (cons.getConstructorType() == RascalValueFactory.Tree_Char) {
            this.symbol = TreeAdapter.getType((ITree)cons);
        } else if (cons.getConstructorType() == RascalValueFactory.Tree_Cycle) {
            this.symbol = TreeAdapter.getType((ITree)cons);
        } else if (cons.getType() == RascalValueFactory.Symbol) {
            this.symbol = cons;
        } else if (cons.getType() == RascalValueFactory.Production) {
            this.symbol = ProductionAdapter.getType(cons);
        } else {
            throw new ImplementationError("Invalid concrete syntax type constructor:" + cons);
        }
    }

    NonTerminalType(Type type, boolean lex, String layout) {
        this(SymbolFactory.typeToSymbol(type, lex, layout));
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Reifier(symbols);
    }

    @Override
    public boolean isNonterminal() {
        return true;
    }

    @Override
    public boolean isAbstractData() {
        return true;
    }

    @Override
    public io.usethesource.vallang.type.Type asAbstractDataType() {
        return RascalValueFactory.Tree;
    }

    public IConstructor getSymbol() {
        return this.symbol;
    }

    @Override
    public int getArity() {
        return this.symbol.arity();
    }

    public boolean isConcreteListType() {
        return SymbolAdapter.isAnyList(this.getSymbol());
    }

    public boolean isOptionalType() {
        return SymbolAdapter.isOpt(this.getSymbol());
    }

    @Override
    public io.usethesource.vallang.type.Type getAbstractDataType() {
        return RascalValueFactory.Tree;
    }

    @Override
    public boolean hasField(String fieldName) {
        return true;
    }

    @Override
    public boolean hasKeywordField(String fieldName, TypeStore store) {
        return RascalValueFactory.Tree.hasKeywordField(fieldName, store);
    }

    @Override
    public String getName() {
        return RascalValueFactory.Tree.getName();
    }

    @Override
    public io.usethesource.vallang.type.Type getTypeParameters() {
        return RascalValueFactory.Tree.getTypeParameters();
    }

    @Override
    public <T, E extends Throwable> T accept(IRascalTypeVisitor<T, E> visitor) throws E {
        return visitor.visitNonTerminal(this);
    }

    @Override
    protected boolean isSubtypeOfAbstractData(io.usethesource.vallang.type.Type type) {
        return type.equivalent(RascalValueFactory.Tree);
    }

    @Override
    protected boolean isSubtypeOfNode(io.usethesource.vallang.type.Type type) {
        return true;
    }

    @Override
    protected io.usethesource.vallang.type.Type lubWithNode(io.usethesource.vallang.type.Type type) {
        return type;
    }

    @Override
    protected io.usethesource.vallang.type.Type lubWithAbstractData(io.usethesource.vallang.type.Type type) {
        return type.equivalent(RascalValueFactory.Tree) ? type : TF.nodeType();
    }

    @Override
    protected io.usethesource.vallang.type.Type lubWithConstructor(io.usethesource.vallang.type.Type type) {
        return type.getAbstractDataType().equivalent(RascalValueFactory.Tree) ? RascalValueFactory.Tree : TF.nodeType();
    }

    @Override
    protected io.usethesource.vallang.type.Type glbWithNode(io.usethesource.vallang.type.Type type) {
        return this;
    }

    @Override
    protected io.usethesource.vallang.type.Type glbWithAbstractData(io.usethesource.vallang.type.Type type) {
        return type.equivalent(RascalValueFactory.Tree) ? this : TF.voidType();
    }

    @Override
    protected io.usethesource.vallang.type.Type glbWithConstructor(io.usethesource.vallang.type.Type type) {
        return TF.voidType();
    }

    @Override
    protected boolean isSupertypeOf(io.usethesource.vallang.type.Type type) {
        if (type instanceof NonTerminalType) {
            return ((NonTerminalType)type).isSubtypeOfNonTerminal(this);
        }
        return super.isSupertypeOf(type);
    }

    @Override
    protected boolean isSupertypeOf(RascalType type) {
        return type.isSubtypeOfNonTerminal(this);
    }

    @Override
    protected io.usethesource.vallang.type.Type lub(RascalType type) {
        return type.lubWithNonTerminal(this);
    }

    @Override
    protected io.usethesource.vallang.type.Type glb(RascalType type) {
        return type.glbWithNonTerminal(this);
    }

    @Override
    public boolean intersects(io.usethesource.vallang.type.Type other) {
        if (other == RascalValueFactory.Tree) {
            return true;
        }
        if (other instanceof NonTerminalType) {
            return ((NonTerminalType)other).intersectsWithNonTerminal(this);
        }
        return false;
    }

    @Override
    protected boolean intersects(RascalType type) {
        return type.intersectsWithNonTerminal(this);
    }

    @Override
    protected boolean intersectsWithNonTerminal(RascalType type) {
        return this.comparable(type);
    }

    @Override
    protected boolean intersectsWithAbstractData(io.usethesource.vallang.type.Type type) {
        return type == RascalValueFactory.Tree;
    }

    @Override
    protected boolean intersectsWithNode(io.usethesource.vallang.type.Type type) {
        return true;
    }

    @Override
    public boolean isSubtypeOfNonTerminal(RascalType other) {
        if (other == this) {
            return true;
        }
        IConstructor otherSym = ((NonTerminalType)other).symbol;
        if (SymbolAdapter.isIterPlus(this.symbol) && (SymbolAdapter.isIterStar(otherSym) || SymbolAdapter.isIterPlus(otherSym)) || SymbolAdapter.isIterStar(this.symbol) && SymbolAdapter.isIterStar(otherSym)) {
            RascalType nt1 = (RascalType)RTF.nonTerminalType(SymbolAdapter.getSymbol(this.symbol));
            RascalType nt2 = (RascalType)RTF.nonTerminalType(SymbolAdapter.getSymbol(otherSym));
            return nt1.isSubtypeOfNonTerminal(nt2);
        }
        if (SymbolAdapter.isIterPlusSeps(this.symbol) && (SymbolAdapter.isIterStarSeps(otherSym) || SymbolAdapter.isIterPlusSeps(otherSym)) || SymbolAdapter.isIterStarSeps(this.symbol) && SymbolAdapter.isIterStarSeps(otherSym)) {
            RascalType nt2;
            RascalType nt1 = (RascalType)RTF.nonTerminalType(SymbolAdapter.getSymbol(this.symbol));
            if (nt1.isSubtypeOfNonTerminal(nt2 = (RascalType)RTF.nonTerminalType(SymbolAdapter.getSymbol(otherSym)))) {
                IList seps1 = SymbolAdapter.getSeparators(this.symbol);
                IList seps2 = SymbolAdapter.getSeparators(otherSym);
                int sep1index = seps1.length() == 3 ? 1 : 0;
                int sep2index = seps2.length() == 3 ? 1 : 0;
                nt1 = (RascalType)RTF.nonTerminalType((IConstructor)seps1.get(sep1index));
                nt2 = (RascalType)RTF.nonTerminalType((IConstructor)seps2.get(sep2index));
                return nt1.isSubtypeOfNonTerminal(nt2);
            }
            return false;
        }
        if (SymbolAdapter.isOpt(this.symbol) && SymbolAdapter.isOpt(otherSym)) {
            RascalType nt1 = (RascalType)RTF.nonTerminalType(SymbolAdapter.getSymbol(this.symbol));
            RascalType nt2 = (RascalType)RTF.nonTerminalType(SymbolAdapter.getSymbol(otherSym));
            return nt1.isSubtypeOfNonTerminal(nt2);
        }
        if (SymbolAdapter.isCharClass(this.symbol) && SymbolAdapter.isCharClass(otherSym)) {
            block0: for (IValue elem : SymbolAdapter.getRanges(this.symbol)) {
                IInteger from = (IInteger)((IConstructor)elem).get("begin");
                IInteger to = (IInteger)((IConstructor)elem).get("end");
                for (IValue otherElem : SymbolAdapter.getRanges(otherSym)) {
                    IInteger otherFrom = (IInteger)((IConstructor)otherElem).get("begin");
                    IInteger otherTo = (IInteger)((IConstructor)otherElem).get("end");
                    if (!from.greaterEqual(otherFrom).getValue() || !to.lessEqual(otherTo).getValue()) continue;
                    continue block0;
                }
                return false;
            }
            return true;
        }
        if (SymbolAdapter.isParameter(otherSym)) {
            return this.isSubtypeOf(RTF.nonTerminalType((IConstructor)otherSym.get("bound")));
        }
        return SymbolAdapter.isEqual(otherSym, this.symbol);
    }

    @Override
    protected io.usethesource.vallang.type.Type lubWithNonTerminal(RascalType other) {
        IConstructor otherSym = ((NonTerminalType)other).symbol;
        if (SymbolAdapter.isIterPlus(this.symbol) && SymbolAdapter.isIterStar(otherSym)) {
            return other;
        }
        if (SymbolAdapter.isIterPlus(otherSym) && SymbolAdapter.isIterStar(this.symbol)) {
            return this;
        }
        if (SymbolAdapter.isIterPlusSeps(this.symbol) && SymbolAdapter.isIterStarSeps(otherSym)) {
            return other;
        }
        if (SymbolAdapter.isIterPlusSeps(otherSym) && SymbolAdapter.isIterStarSeps(this.symbol)) {
            return this;
        }
        if (SymbolAdapter.isCharClass(this.symbol) && SymbolAdapter.isCharClass(otherSym)) {
            return RTF.nonTerminalType(SymbolAdapter.unionCharClasses(this.symbol, otherSym));
        }
        return SymbolAdapter.isEqual(otherSym, this.symbol) ? this : RascalValueFactory.Tree;
    }

    @Override
    protected io.usethesource.vallang.type.Type glbWithNonTerminal(RascalType other) {
        IConstructor otherSym = ((NonTerminalType)other).symbol;
        if (SymbolAdapter.isIterPlus(this.symbol) && SymbolAdapter.isIterStar(otherSym)) {
            return this;
        }
        if (SymbolAdapter.isIterPlus(otherSym) && SymbolAdapter.isIterStar(this.symbol)) {
            return other;
        }
        if (SymbolAdapter.isIterPlusSeps(this.symbol) && SymbolAdapter.isIterStarSeps(otherSym)) {
            return this;
        }
        if (SymbolAdapter.isIterPlusSeps(otherSym) && SymbolAdapter.isIterStarSeps(this.symbol)) {
            return other;
        }
        if (SymbolAdapter.isCharClass(otherSym) && SymbolAdapter.isCharClass(this.symbol)) {
            return RTF.nonTerminalType(SymbolAdapter.intersectCharClasses(this.symbol, otherSym));
        }
        return SymbolAdapter.isEqual(otherSym, this.symbol) ? other : TF.voidType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            NonTerminalType other = (NonTerminalType)obj;
            return this.symbol.equals(other.symbol);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 133333331 + 1331 * this.symbol.hashCode();
    }

    @Override
    public String toString() {
        return SymbolAdapter.toString(this.symbol, false);
    }

    @Override
    public IValue randomValue(Random random, IValueFactory vf, TypeStore store, Map<io.usethesource.vallang.type.Type, io.usethesource.vallang.type.Type> typeParameters, int maxDepth, int maxBreadth) {
        IRascalValueFactory rvf = (IRascalValueFactory)vf;
        return rvf.appl(vf.constructor(RascalValueFactory.Production_Default, this.symbol, vf.list(new IValue[0]), vf.set(new IValue[0])), vf.list(new IValue[0]));
    }

    public static class Reifier
    extends TypeFactory.TypeReifier {
        public Reifier(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Set<io.usethesource.vallang.type.Type> getSymbolConstructorTypes() {
            return Arrays.stream(new io.usethesource.vallang.type.Type[]{RascalValueFactory.Symbol_Label, RascalValueFactory.Symbol_Start, RascalValueFactory.Symbol_Lit, RascalValueFactory.Symbol_Cilit, RascalValueFactory.Symbol_Empty, RascalValueFactory.Symbol_Seq, RascalValueFactory.Symbol_Opt, RascalValueFactory.Symbol_Alt, RascalValueFactory.Symbol_Sort, RascalValueFactory.Symbol_Lex, RascalValueFactory.Symbol_Keywords, RascalValueFactory.Symbol_Meta, RascalValueFactory.Symbol_Conditional, RascalValueFactory.Symbol_IterSeps, RascalValueFactory.Symbol_IterStarSeps, RascalValueFactory.Symbol_Iter, RascalValueFactory.Symbol_IterStar, RascalValueFactory.Symbol_ParameterizedSort, RascalValueFactory.Symbol_ParameterizedLex, RascalValueFactory.Symbol_Parameter, RascalValueFactory.Symbol_Layouts, RascalValueFactory.Symbol_CharClass, RascalValueFactory.Production_Default}).collect(Collectors.toSet());
        }

        @Override
        public io.usethesource.vallang.type.Type getSymbolConstructorType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public io.usethesource.vallang.type.Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            if (this.symbols().isLabel(symbol)) {
                symbol = this.symbols().getLabeledSymbol(symbol);
            }
            return RascalType.RTF.nonTerminalType(symbol);
        }

        @Override
        public void asProductions(io.usethesource.vallang.type.Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            if (store instanceof TypeReifier.TypeStoreWithSyntax) {
                TypeReifier.TypeStoreWithSyntax syntax = (TypeReifier.TypeStoreWithSyntax)store;
                this.addRulesForSort(vf, ((NonTerminalType)type).symbol, syntax, grammar, new HashSet<IConstructor>());
            }
        }

        @Override
        public IConstructor toSymbol(io.usethesource.vallang.type.Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            this.asProductions(type, vf, store, grammar, done);
            return ((NonTerminalType)type).symbol;
        }

        private void addRulesForSymbol(final IValueFactory vf, IConstructor sort, final TypeReifier.TypeStoreWithSyntax syntax, final ISetWriter grammar, final Set<IConstructor> done) {
            if (SymbolAdapter.isLex(sort) || SymbolAdapter.isSort(sort) || SymbolAdapter.isKeyword(sort)) {
                this.addRulesForSort(vf, sort, syntax, grammar, done);
            } else {
                sort.accept(new BottomUpVisitor<IValue, RuntimeException>(new IdentityVisitor<RuntimeException>(){

                    @Override
                    public IValue visitConstructor(IConstructor o) throws RuntimeException {
                        if (o.getType() == RascalValueFactory.Symbol) {
                            this.addRulesForSort(vf, o, syntax, grammar, done);
                        }
                        return o;
                    }
                }, vf));
            }
        }

        private void addRulesForSort(IValueFactory vf, IConstructor sort, TypeReifier.TypeStoreWithSyntax syntax, ISetWriter grammar, Set<IConstructor> done) {
            if (done.contains(sort)) {
                return;
            }
            for (IValue rule : syntax.getRules(sort)) {
                grammar.insert(vf.tuple(sort, rule));
                done.add(sort);
                if (!ProductionAdapter.isDefault((IConstructor)rule)) continue;
                for (IValue arg : ProductionAdapter.getSymbols((IConstructor)rule)) {
                    this.addRulesForSymbol(vf, (IConstructor)arg, syntax, grammar, done);
                }
            }
        }

        @Override
        public boolean isRecursive() {
            return true;
        }

        @Override
        public io.usethesource.vallang.type.Type randomInstance(Supplier<io.usethesource.vallang.type.Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return TypeFactory.getInstance().stringType();
        }
    }
}

