/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.unicode;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.rascalmpl.unicode.ByteOrderMarker;

public class UnicodeOutputStreamWriter
extends OutputStreamWriter {
    public UnicodeOutputStreamWriter(OutputStream out, String charsetName) throws IOException {
        super(out, UnicodeOutputStreamWriter.getCharset(charsetName));
        ByteOrderMarker bom = ByteOrderMarker.fromString(charsetName);
        if (bom != null && bom.shouldBom()) {
            this.writeBOM(bom, out);
        }
    }

    public UnicodeOutputStreamWriter(OutputStream out, String charsetName, boolean append) throws IOException {
        super(out, UnicodeOutputStreamWriter.getCharset(charsetName));
        ByteOrderMarker bom;
        if (!append && (bom = ByteOrderMarker.fromString(charsetName)) != null && bom.shouldBom()) {
            this.writeBOM(bom, out);
        }
    }

    private static Charset getCharset(String charsetName) throws UnsupportedEncodingException {
        ByteOrderMarker bom = ByteOrderMarker.fromString(charsetName);
        if (bom != null) {
            return bom.getCharset();
        }
        if (Charset.isSupported(charsetName)) {
            return Charset.forName(charsetName);
        }
        throw new UnsupportedEncodingException("Charset " + charsetName + " is not supported");
    }

    void writeBOM(ByteOrderMarker bom, OutputStream out) throws IOException {
        for (int b : bom.getHeader()) {
            out.write(b);
        }
    }
}

