/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public abstract class FileTree {
    protected final ConcurrentNavigableMap<String, FSEntry> fs = new ConcurrentSkipListMap<String, FSEntry>();
    protected long totalSize = 0L;
    protected IOException throwMe = null;
    private static final String biggestChar = new String(new int[]{0x10FFFF}, 0, 1);

    public boolean exists(String path) {
        if (this.throwMe != null) {
            return false;
        }
        if ("/".equals(path)) {
            return true;
        }
        String result = this.fs.ceilingKey(path);
        if (result == null) {
            return false;
        }
        if (result.equals(path)) {
            return true;
        }
        if (!path.endsWith("/") && result.startsWith(path)) {
            char separator = result.charAt(path.length());
            if (separator == '/') {
                return true;
            }
            if (separator < '/') {
                return this.exists(path + "/");
            }
        }
        return result.startsWith(path);
    }

    public boolean isDirectory(String path) {
        if (this.throwMe != null) {
            return false;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if ("/".equals(path)) {
            return true;
        }
        String result = this.fs.ceilingKey((String)path);
        if (result == null) {
            return false;
        }
        return result.startsWith((String)path);
    }

    public boolean isFile(String path) {
        if (this.throwMe != null) {
            return false;
        }
        return this.fs.containsKey(path);
    }

    public long getLastModified(String path) throws IOException {
        if (this.throwMe != null) {
            throw this.throwMe;
        }
        FSEntry result = (FSEntry)this.fs.get(path);
        if (result == null) {
            throw new FileNotFoundException(path);
        }
        return result.lastModified;
    }

    public String[] directChildren(String path) throws IOException {
        String subPath;
        if (this.throwMe != null) {
            throw this.throwMe;
        }
        if (!((String)path).endsWith("/") && !((String)path).isEmpty()) {
            path = (String)path + "/";
        }
        NavigableMap contents = this.fs.tailMap(path, true);
        String end = this.fs.higherKey((String)path + biggestChar);
        int offset = ((String)path).length();
        ArrayList<String> result = new ArrayList<String>();
        Object previousDir = "+";
        Iterator iterator = contents.keySet().iterator();
        while (iterator.hasNext() && (subPath = (String)iterator.next()) != end) {
            int nextSlash = subPath.indexOf(47, offset);
            if (nextSlash != -1) {
                if (subPath.startsWith((String)previousDir, offset)) continue;
                previousDir = subPath.substring(offset, nextSlash);
                result.add((String)previousDir);
                previousDir = (String)previousDir + "/";
                continue;
            }
            result.add(subPath.substring(offset));
        }
        return result.toArray(new String[0]);
    }

    public long totalSize() {
        return this.totalSize;
    }

    public static class FSEntry {
        public long lastModified;

        public FSEntry(long lastModified) {
            this.lastModified = lastModified;
        }
    }
}

