/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.util.function.Consumer;

public interface ISourceLocationWatcher {
    public String scheme();

    public void watch(ISourceLocation var1, Consumer<ISourceLocationChanged> var2) throws IOException;

    public void unwatch(ISourceLocation var1, Consumer<ISourceLocationChanged> var2) throws IOException;

    public static ISourceLocationChanged fileCreated(ISourceLocation loc) {
        return ISourceLocationWatcher.makeChange(loc, ISourceLocationChangeType.CREATED, ISourceLocationType.FILE);
    }

    public static ISourceLocationChanged directoryCreated(ISourceLocation loc) {
        return ISourceLocationWatcher.makeChange(loc, ISourceLocationChangeType.CREATED, ISourceLocationType.DIRECTORY);
    }

    public static ISourceLocationChanged fileDeleted(ISourceLocation loc) {
        return ISourceLocationWatcher.makeChange(loc, ISourceLocationChangeType.DELETED, ISourceLocationType.FILE);
    }

    public static ISourceLocationChanged directoryDeleted(ISourceLocation loc) {
        return ISourceLocationWatcher.makeChange(loc, ISourceLocationChangeType.DELETED, ISourceLocationType.DIRECTORY);
    }

    public static ISourceLocationChanged fileModified(ISourceLocation loc) {
        return ISourceLocationWatcher.makeChange(loc, ISourceLocationChangeType.MODIFIED, ISourceLocationType.FILE);
    }

    public static ISourceLocationChanged directoryModified(ISourceLocation loc) {
        return ISourceLocationWatcher.makeChange(loc, ISourceLocationChangeType.MODIFIED, ISourceLocationType.DIRECTORY);
    }

    public static ISourceLocationChanged makeChange(final ISourceLocation loc, final ISourceLocationChangeType changeType, final ISourceLocationType fileType) {
        return new ISourceLocationChanged(){

            @Override
            public ISourceLocationChangeType getChangeType() {
                return changeType;
            }

            @Override
            public ISourceLocation getLocation() {
                return loc;
            }

            @Override
            public ISourceLocationType getType() {
                return fileType;
            }
        };
    }

    public static enum ISourceLocationType {
        FILE,
        DIRECTORY;

    }

    public static enum ISourceLocationChangeType {
        CREATED,
        DELETED,
        MODIFIED;

    }

    public static interface ISourceLocationChanged {
        public ISourceLocation getLocation();

        public ISourceLocationChangeType getChangeType();

        public ISourceLocationType getType();

        default public boolean isCreated() {
            return this.getChangeType() == ISourceLocationChangeType.CREATED;
        }

        default public boolean isDeleted() {
            return this.getChangeType() == ISourceLocationChangeType.DELETED;
        }

        default public boolean isChanged() {
            return this.getChangeType() == ISourceLocationChangeType.MODIFIED;
        }

        default public boolean isFile() {
            return this.getType() == ISourceLocationType.FILE;
        }

        default public boolean isDirectory() {
            return this.getType() == ISourceLocationType.DIRECTORY;
        }
    }
}

