/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.rascalmpl.values.ValueFactoryFactory;

public class URIUtil {
    public static final String URI_PATH_SEPARATOR = "/";
    private static final IValueFactory vf = ValueFactoryFactory.getValueFactory();
    private static final ISourceLocation unknownLocation = URIUtil.rootLocation("unknown");

    public static URI create(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        return URIUtil.fixUnicode(new URI(scheme, authority, path, query, fragment));
    }

    public static URI create(String scheme, String authority, String path) throws URISyntaxException {
        return URIUtil.create(scheme, authority, path, null, null);
    }

    public static URI create(String scheme, String userInformation, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        return URIUtil.fixUnicode(new URI(scheme, userInformation, host, port, path, query, fragment));
    }

    public static URI createFile(String path) throws URISyntaxException {
        File file = new File(URIUtil.fixWindowsPath(path));
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return URIUtil.fixUnicode(file.toURI());
    }

    public static URI fromURL(URL url) throws URISyntaxException {
        try {
            return URIUtil.create(url.getProtocol(), URIUtil.decodeURLPart(url.getAuthority()), URIUtil.decodeURLPart(url.getPath()), url.getQuery() == null ? null : URIUtil.decodeURLPart(url.getQuery()), url.getRef() == null ? null : URIUtil.decodeURLPart(url.getRef()));
        }
        catch (UnsupportedEncodingException e) {
            throw new URISyntaxException(url.toString(), e.getMessage());
        }
    }

    private static String decodeURLPart(String part) throws UnsupportedEncodingException {
        return part == null || part.isEmpty() ? "" : URLDecoder.decode(part, StandardCharsets.UTF_8.name());
    }

    public static ISourceLocation createFileLocation(String path) throws URISyntaxException {
        return vf.sourceLocation(URIUtil.createFile(path));
    }

    public static ISourceLocation createFileLocation(Path path) throws URISyntaxException {
        return vf.sourceLocation(URIUtil.createFile(path.toString()));
    }

    private static String fixWindowsPath(String path) {
        if (!((String)path).startsWith(URI_PATH_SEPARATOR)) {
            path = URI_PATH_SEPARATOR + (String)path;
        }
        return path;
    }

    @Deprecated
    public static URI createRascalModule(String moduleName) {
        return URIUtil.assumeCorrect("rascal", moduleName, "");
    }

    public static URI createFromEncoded(String value) throws URISyntaxException {
        return URIUtil.fixUnicode(new URI(value));
    }

    public static URI assumeCorrect(String value) {
        try {
            return URIUtil.createFromEncoded(value);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException y = new IllegalArgumentException();
            y.initCause(e);
            throw y;
        }
    }

    public static URI assumeCorrect(String scheme, String authority, String path) {
        try {
            return URIUtil.create(scheme, authority, path);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException y = new IllegalArgumentException();
            y.initCause(e);
            throw y;
        }
    }

    public static URI assumeCorrect(String scheme, String authority, String path, String query) {
        try {
            return URIUtil.create(scheme, authority, path, query, null);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException y = new IllegalArgumentException();
            y.initCause(e);
            throw y;
        }
    }

    public static ISourceLocation assumeCorrectLocation(String uri) {
        try {
            return URIUtil.createFromURI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ISourceLocation correctLocation(String scheme, String authority, String path) {
        try {
            return URIUtil.createLocation(scheme, authority, path);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException y = new IllegalArgumentException();
            y.initCause(e);
            throw y;
        }
    }

    private static ISourceLocation createLocation(String scheme, String authority, String path) throws URISyntaxException {
        return vf.sourceLocation(scheme, authority, path);
    }

    @Deprecated
    public static ISourceLocation invalidLocation() {
        return URIUtil.unknownLocation();
    }

    public static ISourceLocation unknownLocation() {
        return unknownLocation;
    }

    public static URI rootScheme(String scheme) {
        return URI.create(scheme + ":///");
    }

    public static ISourceLocation rootLocation(String scheme) {
        try {
            return vf.sourceLocation(scheme, "", URI_PATH_SEPARATOR);
        }
        catch (URISyntaxException e) {
            assert (false);
            return null;
        }
    }

    public static URI fixUnicode(URI uri) throws URISyntaxException {
        return new URI(uri.toASCIIString());
    }

    private static String getCorrectAuthority(URI uri) {
        if (uri.getAuthority() == null) {
            return "";
        }
        return uri.getAuthority();
    }

    private static String getCorrectAuthority(ISourceLocation uri) {
        if (!uri.hasAuthority()) {
            return "";
        }
        return uri.getAuthority();
    }

    public static URI changeScheme(URI uri, String newScheme) throws URISyntaxException {
        return URIUtil.create(newScheme, URIUtil.getCorrectAuthority(uri), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public static ISourceLocation changeScheme(ISourceLocation loc, String newScheme) throws URISyntaxException {
        ISourceLocation newLoc = vf.sourceLocation(newScheme, URIUtil.getCorrectAuthority(loc), loc.getPath(), loc.hasQuery() ? loc.getQuery() : null, loc.hasFragment() ? loc.getFragment() : null);
        if (loc.hasLineColumn()) {
            newLoc = vf.sourceLocation(newLoc, loc.getOffset(), loc.getLength(), loc.getBeginLine(), loc.getEndLine(), loc.getBeginColumn(), loc.getEndColumn());
        } else if (loc.hasOffsetLength()) {
            newLoc = vf.sourceLocation(newLoc, loc.getOffset(), loc.getLength());
        }
        return newLoc;
    }

    public static URI changeAuthority(URI uri, String newAuthority) throws URISyntaxException {
        return URIUtil.create(uri.getScheme(), newAuthority == null ? "" : newAuthority, uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public static URI changePath(URI uri, String newPath) throws URISyntaxException {
        return URIUtil.create(uri.getScheme(), URIUtil.getCorrectAuthority(uri), newPath, uri.getQuery(), uri.getFragment());
    }

    public static ISourceLocation changePath(ISourceLocation uri, String newPath) throws URISyntaxException {
        return vf.sourceLocation(uri.getScheme(), URIUtil.getCorrectAuthority(uri), newPath, uri.getQuery(), uri.getFragment());
    }

    public static URI changeQuery(URI uri, String newQuery) throws URISyntaxException {
        return URIUtil.create(uri.getScheme(), URIUtil.getCorrectAuthority(uri), uri.getPath(), newQuery, uri.getFragment());
    }

    public static ISourceLocation changeQuery(ISourceLocation uri, String newQuery) throws URISyntaxException {
        return vf.sourceLocation(uri.getScheme(), URIUtil.getCorrectAuthority(uri), uri.getPath(), newQuery, uri.getFragment());
    }

    public static URI changeFragment(URI uri, String newFragment) throws URISyntaxException {
        return URIUtil.create(uri.getScheme(), URIUtil.getCorrectAuthority(uri), uri.getPath(), uri.getQuery(), newFragment);
    }

    public static URI changeUserInformation(URI uri, String newUserInformation) throws URISyntaxException {
        return URIUtil.create(uri.getScheme(), newUserInformation, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public static URI changeHost(URI uri, String newHost) throws URISyntaxException {
        return URIUtil.create(uri.getScheme(), uri.getUserInfo(), newHost, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public static URI changePort(URI uri, int newPort) throws URISyntaxException {
        return URIUtil.create(uri.getScheme(), uri.getUserInfo(), uri.getHost(), newPort, uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public static URI getParentURI(URI uri) {
        File file = new File(uri.getPath());
        File parent = file.getParentFile();
        if (parent != null && !parent.getName().isEmpty()) {
            try {
                return URIUtil.changePath(uri, parent.getAbsolutePath());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ISourceLocation getParentLocation(ISourceLocation loc) {
        String currentPath = loc.getPath();
        assert (currentPath.startsWith(URI_PATH_SEPARATOR));
        if (currentPath.equals(URI_PATH_SEPARATOR)) {
            return loc;
        }
        try {
            int pathSep = currentPath.lastIndexOf(47);
            return URIUtil.changePath(loc, currentPath.substring(0, pathSep));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static ISourceLocation getChildLocation(ISourceLocation loc, String child) {
        Object childPath = loc.getPath();
        if (childPath == null || ((String)childPath).isEmpty()) {
            childPath = URI_PATH_SEPARATOR;
        } else if (!((String)childPath).endsWith(URI_PATH_SEPARATOR)) {
            childPath = (String)childPath + URI_PATH_SEPARATOR;
        }
        if (!child.equals(URI_PATH_SEPARATOR)) {
            childPath = (String)childPath + child;
        }
        try {
            return vf.sourceLocation(loc.getScheme(), URIUtil.getCorrectAuthority(loc), (String)childPath, loc.hasQuery() ? loc.getQuery() : null, loc.hasFragment() ? loc.getFragment() : null);
        }
        catch (URISyntaxException e) {
            assert (false);
            return loc;
        }
    }

    public static String getURIName(URI uri) {
        File file = new File(uri.getPath());
        return file.getName();
    }

    public static String getLocationName(ISourceLocation uri) {
        File file = new File(uri.getPath());
        return file.getName();
    }

    public static boolean isParentOf(ISourceLocation parent, ISourceLocation child) {
        String childPath;
        if (!parent.getScheme().equals(child.getScheme())) {
            return false;
        }
        if (!parent.getAuthority().equals(child.getAuthority())) {
            return false;
        }
        Object parentPath = parent.getPath();
        if (!((String)parentPath).endsWith(URI_PATH_SEPARATOR)) {
            parentPath = (String)parentPath + URI_PATH_SEPARATOR;
        }
        return (childPath = child.getPath()).length() > ((String)parentPath).length() && childPath.startsWith((String)parentPath);
    }

    public static ISourceLocation removeExtension(ISourceLocation file) {
        if (file.getPath().indexOf(".") != -1) {
            try {
                return URIUtil.changePath(file, file.getPath().substring(0, file.getPath().lastIndexOf(".")));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return file;
    }

    public static ISourceLocation relativize(ISourceLocation outside, ISourceLocation inside) {
        try {
            if (outside.getPath().endsWith(URI_PATH_SEPARATOR)) {
                outside = URIUtil.changePath(outside, outside.getPath().substring(0, outside.getPath().length() - 1));
            }
            if (inside.getPath().endsWith(URI_PATH_SEPARATOR)) {
                inside = URIUtil.changePath(inside, inside.getPath().substring(0, inside.getPath().length() - 1));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (outside.equals(inside)) {
            return URIUtil.correctLocation("relative", "", URI_PATH_SEPARATOR);
        }
        if (!URIUtil.isParentOf(outside, inside)) {
            return inside;
        }
        String[] outsidePath = outside.getPath().split(URI_PATH_SEPARATOR);
        String[] insidePath = inside.getPath().split(URI_PATH_SEPARATOR);
        StringBuilder relativePath = new StringBuilder();
        for (int i = outsidePath.length; i < insidePath.length; ++i) {
            relativePath.append(URI_PATH_SEPARATOR);
            relativePath.append(insidePath[i]);
        }
        return URIUtil.correctLocation("relative", "", relativePath.toString());
    }

    public static ISourceLocation removeAuthority(ISourceLocation loc) {
        try {
            ISourceLocation res = vf.sourceLocation(loc.getScheme(), "", loc.getPath(), loc.hasQuery() ? loc.getQuery() : null, loc.hasFragment() ? loc.getFragment() : null);
            if (loc.hasLineColumn()) {
                return vf.sourceLocation(res, loc.getOffset(), loc.getLength(), loc.getBeginLine(), loc.getEndLine(), loc.getBeginColumn(), loc.getEndColumn());
            }
            if (loc.hasOffsetLength()) {
                return vf.sourceLocation(res, loc.getOffset(), loc.getLength(), loc.getBeginLine(), loc.getEndLine(), loc.getBeginColumn(), loc.getEndColumn());
            }
            return res;
        }
        catch (UnsupportedOperationException | URISyntaxException e) {
            assert (false);
            return loc;
        }
    }

    public static ISourceLocation removeOffset(ISourceLocation prev) {
        return prev.top();
    }

    public static ISourceLocation createFromURI(String value) throws URISyntaxException {
        return vf.sourceLocation(URIUtil.createFromEncoded(value));
    }

    public static String getExtension(ISourceLocation loc) {
        String path = loc.getPath();
        boolean endsWithSlash = path.endsWith(URI_PATH_SEPARATOR);
        if (endsWithSlash) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() > 1) {
            int slashIndex = path.lastIndexOf(URI_PATH_SEPARATOR);
            int index = path.lastIndexOf(46);
            if (index != -1 && index > slashIndex) {
                return path.substring(index + 1);
            }
        }
        return "";
    }

    public static ISourceLocation changeExtension(ISourceLocation location, String ext) throws URISyntaxException {
        Object path = location.getPath();
        boolean endsWithSlash = ((String)path).endsWith(URI_PATH_SEPARATOR);
        if (endsWithSlash) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        if (((String)path).length() > 1) {
            int slashIndex = ((String)path).lastIndexOf(URI_PATH_SEPARATOR);
            int index = ((String)path).substring(slashIndex).lastIndexOf(46);
            if (index == -1 && !ext.isEmpty()) {
                path = (String)path + (!ext.startsWith(".") ? "." : "") + ext;
            } else if (!ext.isEmpty()) {
                path = ((String)path).substring(0, slashIndex + index) + (!ext.startsWith(".") ? "." : "") + ext;
            } else if (index != -1) {
                path = ((String)path).substring(0, slashIndex + index);
            }
            if (endsWithSlash) {
                path = (String)path + URI_PATH_SEPARATOR;
            }
        }
        return URIUtil.changePath(location, (String)path);
    }

    public static URI invalidURI() {
        return URIUtil.rootScheme("invalid");
    }
}

