/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.rascalmpl.uri.FileTree;

public class JarInputStreamFileTree
extends FileTree {
    public JarInputStreamFileTree(InputStream in) {
        this.totalSize = 0L;
        try (JarInputStream stream = new JarInputStream(in);){
            JarEntry next = null;
            int pos = 0;
            while ((next = stream.getNextJarEntry()) != null) {
                if (!next.isDirectory()) {
                    String name = next.getName();
                    this.totalSize += (long)(16 + name.length() * 2);
                    this.fs.put(name, new IndexFSEntry(next.getTime(), pos++));
                    continue;
                }
                ++pos;
            }
        }
        catch (IOException e) {
            this.throwMe = e;
            this.fs.clear();
        }
    }

    public int getPosition(String path) {
        IndexFSEntry ent = (IndexFSEntry)this.fs.get(path);
        if (ent == null) {
            return -1;
        }
        return ent.position;
    }

    private static class IndexFSEntry
    extends FileTree.FSEntry {
        public int position;

        public IndexFSEntry(long lastModified, int position) {
            super(lastModified);
            this.position = position;
        }
    }
}

