/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.libraries;

import io.usethesource.vallang.ISourceLocation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import org.rascalmpl.uri.FileTree;
import org.rascalmpl.uri.ISourceLocationInputOutput;

public class MemoryResolver
implements ISourceLocationInputOutput {
    private final ConcurrentMap<String, InMemoryFileTree> fileSystems = new ConcurrentHashMap<String, InMemoryFileTree>();

    @Override
    public String scheme() {
        return "memory";
    }

    private InMemoryFileTree getFS(String authority) {
        return this.fileSystems.computeIfAbsent(authority, a -> new InMemoryFileTree());
    }

    private File get(ISourceLocation uri) {
        return (File)this.getFS(uri.getAuthority()).getFileSystem().get(uri.getPath());
    }

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        File file = this.get(uri);
        if (file == null) {
            throw new FileNotFoundException();
        }
        return new ByteArrayInputStream(file.contents);
    }

    @Override
    public OutputStream getOutputStream(final ISourceLocation uri, boolean append) throws IOException {
        if (uri.getScheme().endsWith("+readonly")) {
            throw new AccessDeniedException(uri.toString());
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                File file = MemoryResolver.this.get(uri);
                byte[] content = this.toByteArray();
                if (file == null) {
                    file = new File();
                    MemoryResolver.this.getFS(uri.getAuthority()).getFileSystem().put(uri.getPath(), file);
                }
                file.newContent(content);
                super.close();
            }
        };
        if (append) {
            File file = this.get(uri);
            if (file == null) {
                throw new FileNotFoundException();
            }
            result.write(file.contents);
        }
        return result;
    }

    @Override
    public long lastModified(ISourceLocation uri) throws IOException {
        File file = this.get(uri);
        if (file == null) {
            throw new FileNotFoundException();
        }
        return file.lastModified;
    }

    @Override
    public void setLastModified(ISourceLocation uri, long timestamp) throws IOException {
        File file = this.get(uri);
        if (file == null) {
            throw new FileNotFoundException(uri.toString());
        }
        file.lastModified = timestamp;
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return null;
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        return this.getFS(uri.getAuthority()).exists(uri.getPath());
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        return this.getFS(uri.getAuthority()).isDirectory(uri.getPath());
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        return this.getFS(uri.getAuthority()).isFile(uri.getPath());
    }

    @Override
    public String[] list(ISourceLocation uri) throws IOException {
        return this.getFS(uri.getAuthority()).directChildren(uri.getPath());
    }

    @Override
    public boolean supportsHost() {
        return false;
    }

    @Override
    public void mkDirectory(ISourceLocation uri) throws IOException {
        if (uri.getScheme().endsWith("+readonly")) {
            throw new AccessDeniedException(uri.toString());
        }
    }

    @Override
    public void remove(ISourceLocation uri) throws IOException {
        if (uri.getScheme().endsWith("+readonly")) {
            throw new AccessDeniedException(uri.toString());
        }
        ConcurrentNavigableMap<String, FileTree.FSEntry> ft = this.getFS(uri.getAuthority()).getFileSystem();
        ft.remove(uri.getPath());
        if (ft.isEmpty()) {
            this.fileSystems.remove(uri.getAuthority());
        }
    }

    private static final class File
    extends FileTree.FSEntry {
        byte[] contents = null;

        public File() {
            super(System.currentTimeMillis());
        }

        public void newContent(byte[] byteArray) {
            long newTimestamp = System.currentTimeMillis();
            if (newTimestamp <= this.lastModified) {
                newTimestamp = this.lastModified + 1L;
            }
            this.lastModified = newTimestamp;
            this.contents = byteArray;
        }

        public String toString() {
            return String.valueOf(this.lastModified);
        }
    }

    private final class InMemoryFileTree
    extends FileTree {
        private InMemoryFileTree() {
        }

        public ConcurrentNavigableMap<String, FileTree.FSEntry> getFileSystem() {
            return this.fs;
        }
    }
}

