/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.usethesource.vallang.ISourceLocation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.rascalmpl.uri.FileTree;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.zip.ZipFileTree;

public class ZipFileResolver {
    protected final Cache<ISourceLocation, FileTree> fsCache = Caffeine.newBuilder().weigher((e, v) -> (int)(v.totalSize() / 1024L)).maximumWeight(Runtime.getRuntime().maxMemory() / 100L / 1024L).expireAfterAccess(10L, TimeUnit.MINUTES).softValues().build();

    protected FileTree getFileHierchyCache(ISourceLocation zip) {
        try {
            File zipFile = new File(zip.getPath());
            return this.fsCache.get(URIUtil.changeQuery(zip, "mod=" + zipFile.lastModified()), j -> new ZipFileTree(zipFile));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream(ISourceLocation zip, String path) throws IOException {
        ZipFile zipFile = new ZipFile(zip.getPath());
        ZipEntry zipEntry = zipFile.getEntry(path);
        if (zipEntry == null) {
            throw new FileNotFoundException(path + " inside " + zip);
        }
        return zipFile.getInputStream(zipEntry);
    }

    public boolean exists(ISourceLocation zip, String path) {
        if (path == null || path.isEmpty() || path.equals("/")) {
            return true;
        }
        return this.getFileHierchyCache(zip).exists(path);
    }

    public boolean isDirectory(ISourceLocation zip, String path) {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return this.getFileHierchyCache(zip).isDirectory((String)path);
    }

    public boolean isFile(ISourceLocation zip, String path) {
        return this.getFileHierchyCache(zip).isFile(path);
    }

    public long lastModified(ISourceLocation zip, String path) throws IOException {
        return this.getFileHierchyCache(zip).getLastModified(path);
    }

    public String[] list(ISourceLocation zip, String path) throws IOException {
        if (!((String)path).endsWith("/") && !((String)path).isEmpty()) {
            path = (String)path + "/";
        }
        try {
            return this.getFileHierchyCache(zip).directChildren((String)path);
        }
        catch (IOException e) {
            return new String[0];
        }
    }
}

