/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.rascalmpl.uri.FileTree;

public class ZipFileTree
extends FileTree {
    public ZipFileTree(File jar) {
        this.totalSize = 0L;
        try (ZipFile jarFile = new ZipFile(jar);){
            Enumeration<? extends ZipEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry je = e.nextElement();
                if (je.isDirectory()) continue;
                String name = je.getName();
                this.totalSize += (long)(8 + name.length() * 2);
                this.fs.put(name, new FileTree.FSEntry(je.getTime()));
            }
        }
        catch (IOException e1) {
            this.throwMe = e1;
        }
    }
}

