/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.library.Messages;
import org.rascalmpl.util.maven.ArtifactCoordinate;
import org.rascalmpl.util.maven.Dependency;
import org.rascalmpl.util.maven.MavenParser;
import org.rascalmpl.util.maven.Scope;
import org.rascalmpl.util.maven.SimpleResolver;
import org.rascalmpl.values.IRascalValueFactory;

public class Artifact {
    private final ArtifactCoordinate coordinate;
    private final @Nullable ArtifactCoordinate parentCoordinate;
    private final @Nullable Path resolved;
    private final List<Dependency> dependencies;
    private final @Nullable SimpleResolver ourResolver;
    private final IList messages;
    private final boolean anyError;

    private Artifact(ArtifactCoordinate coordinate, @Nullable ArtifactCoordinate parentCoordinate, @Nullable Path resolved, List<Dependency> dependencies, IList messages, @Nullable SimpleResolver originalResolver) {
        this.coordinate = coordinate;
        this.parentCoordinate = parentCoordinate;
        this.resolved = resolved;
        this.dependencies = dependencies;
        this.messages = messages;
        this.ourResolver = originalResolver;
        this.anyError = messages.stream().anyMatch(Messages::isError);
    }

    public ArtifactCoordinate getCoordinate() {
        return this.coordinate;
    }

    public @Nullable ArtifactCoordinate getParentCoordinate() {
        return this.parentCoordinate;
    }

    public boolean hasErrors() {
        return this.anyError;
    }

    public IList getMessages() {
        return this.messages;
    }

    public @Nullable Path getResolved() {
        return this.resolved;
    }

    List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Artifact> resolveDependencies(Scope forScope, MavenParser parser) {
        HashSet<ArtifactCoordinate.WithoutVersion> alreadyIncluded = new HashSet<ArtifactCoordinate.WithoutVersion>();
        ArrayList<Artifact> result = new ArrayList<Artifact>(this.dependencies.size());
        this.calculateClassPath(forScope, alreadyIncluded, result, parser);
        return result;
    }

    private void calculateClassPath(Scope forScope, HashSet<ArtifactCoordinate.WithoutVersion> alreadyIncluded, ArrayList<Artifact> result, MavenParser parser) {
        ArrayList<Artifact> nextLevel = new ArrayList<Artifact>(this.dependencies.size());
        for (Dependency d : this.dependencies) {
            Path pomDep;
            ArtifactCoordinate.WithoutVersion withoutVersion = d.getCoordinate().versionLess();
            if (alreadyIncluded.contains(withoutVersion) || !d.shouldInclude(forScope) || d.getScope() == Scope.PROVIDED && !Files.notExists(pomDep = this.ourResolver.calculatePomPath(d.getCoordinate()), new LinkOption[0])) continue;
            if (d.getScope() == Scope.SYSTEM) {
                result.add(Artifact.createSystemArtifact(d));
                continue;
            }
            Artifact art = parser.parseArtifact(d.getCoordinate(), d.getExclusions(), this.ourResolver);
            if (art != null) {
                result.add(art);
                nextLevel.add(art);
            }
            alreadyIncluded.add(withoutVersion);
        }
        if (forScope == Scope.TEST) {
            forScope = Scope.COMPILE;
        }
        for (Artifact a : nextLevel) {
            a.calculateClassPath(forScope, alreadyIncluded, result, parser);
        }
    }

    private static Artifact createSystemArtifact(Dependency d) {
        IListWriter messages = IRascalValueFactory.getInstance().listWriter();
        String systemPath = d.getSystemPath();
        Path path = null;
        if (systemPath == null) {
            messages.append(Messages.error("system dependency " + d + " without a systemPath property", d.getPomLocation()));
        } else {
            path = Path.of(systemPath, new String[0]);
            if (Files.notExists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
                messages.append(Messages.error("systemPath property (of" + d + ") points to a file that does not exist (or is not a regular file): " + systemPath, d.getPomLocation()));
                path = null;
            }
        }
        return new Artifact(d.getCoordinate(), null, path, Collections.emptyList(), (IList)messages.done(), null);
    }

    static @Nullable Artifact build(Model m4, boolean isRoot, Path pom, ISourceLocation pomLocation, String classifier, Set<ArtifactCoordinate.WithoutVersion> exclusions, IListWriter messages, SimpleResolver resolver) {
        if (m4.getPackaging() != null && !"jar".equals(m4.getPackaging()) && !"eclipse-plugin".equals(m4.getPackaging())) {
            return null;
        }
        ArtifactCoordinate coordinate = new ArtifactCoordinate(m4.getGroupId(), m4.getArtifactId(), m4.getVersion(), classifier);
        Parent parent = m4.getParent();
        ArtifactCoordinate parentCoordinate = parent == null ? null : new ArtifactCoordinate(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), "");
        try {
            Path loc = isRoot ? null : resolver.resolveJar(coordinate);
            List<Dependency> dependencies = m4.getDependencies().stream().filter(d -> !"import".equals(d.getScope())).filter(d -> !exclusions.contains(ArtifactCoordinate.versionLess(d.getGroupId(), d.getArtifactId()))).map(d -> Dependency.build(d, messages, pomLocation)).collect(Collectors.toUnmodifiableList());
            return new Artifact(coordinate, parentCoordinate, loc, dependencies, (IList)messages.done(), resolver);
        }
        catch (UnresolvableModelException e) {
            messages.append(Messages.error("Could not download corresponding jar", pomLocation));
            return new Artifact(coordinate, parentCoordinate, null, Collections.emptyList(), (IList)messages.done(), resolver);
        }
    }

    static Artifact unresolved(ArtifactCoordinate coordinate, IListWriter messages) {
        return new Artifact(coordinate, null, null, Collections.emptyList(), (IList)messages.done(), null);
    }

    public String toString() {
        return this.coordinate + "[" + (this.resolved != null ? "resolved" : "missing") + "]";
    }

    public void report(PrintWriter target) {
        target.append("coordinate: ");
        target.append(this.coordinate.toString());
        target.append("\n");
        target.append("parent: ");
        target.append(this.parentCoordinate == null ? "null" : this.parentCoordinate.toString());
        target.append("\n");
        target.append("resolved: ");
        target.append(this.resolved == null ? "null" : this.resolved.toString());
        target.append("\n");
        target.append("dependencies (unresolved):\n");
        for (Dependency d : this.dependencies) {
            target.append("- ");
            target.append(d.toString());
            target.append("\n");
        }
        target.append("messsages:\n");
        Messages.write(this.messages, target);
    }
}

