/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.library.Messages;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.util.maven.Artifact;
import org.rascalmpl.util.maven.ArtifactCoordinate;
import org.rascalmpl.util.maven.MavenSettings;
import org.rascalmpl.util.maven.ModelResolutionError;
import org.rascalmpl.util.maven.Scope;
import org.rascalmpl.util.maven.SimpleResolver;
import org.rascalmpl.util.maven.SimpleWorkspaceResolver;
import org.rascalmpl.values.IRascalValueFactory;

public class MavenParser {
    private static final IValueFactory VF = IRascalValueFactory.getInstance();
    private final MavenSettings settings;
    private final Path projectPom;
    private final ISourceLocation projectPomLocation;
    private final ModelBuilder builder;
    private final HttpClient httpClient;
    private final ModelCache modelCache;
    private final Path rootMavenRepo;

    public MavenParser(Path projectPom) {
        this(MavenSettings.readSettings(), projectPom);
    }

    MavenParser(MavenSettings settings, Path projectPom) {
        this(settings, projectPom, settings.getLocalRepository());
    }

    MavenParser(MavenSettings settings, Path projectPom, Path rootMavenRepo) {
        this.settings = settings;
        this.projectPom = projectPom;
        this.rootMavenRepo = rootMavenRepo;
        try {
            this.projectPomLocation = URIUtil.createFileLocation(projectPom);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Project pom is an illegal path", e);
        }
        this.builder = new DefaultModelBuilderFactory().newInstance();
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
        this.modelCache = new CaffeineModelCache();
    }

    public Artifact parseProject() throws ModelResolutionError {
        IListWriter messages;
        SimpleResolver resolver;
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setPomFile(this.projectPom.toFile()).setValidationLevel(30);
        Model model = this.getBestModel(this.projectPomLocation, request, resolver = new SimpleResolver(this.rootMavenRepo, this.builder, this.httpClient, this.settings.getMirrors()), messages = VF.listWriter());
        if (model == null) {
            throw new ModelResolutionError(messages);
        }
        Artifact result = Artifact.build(model, true, this.projectPom, this.projectPomLocation, "", Collections.emptySet(), messages, resolver);
        if (result == null) {
            return Artifact.unresolved(new ArtifactCoordinate(model.getGroupId(), model.getArtifactId(), model.getVersion(), ""), messages);
        }
        return result;
    }

    @Nullable Artifact parseArtifact(ArtifactCoordinate coordinate, Set<ArtifactCoordinate.WithoutVersion> exclusions, SimpleResolver originalResolver) {
        IListWriter messages = VF.listWriter();
        try {
            ModelSource modelSource = originalResolver.resolveModel(coordinate);
            ISourceLocation pomLocation = MavenParser.calculateLocation(modelSource);
            Path pomPath = Path.of(pomLocation.getURI());
            SimpleResolver resolver = new SimpleResolver(this.rootMavenRepo, this.builder, this.httpClient, this.settings.getMirrors());
            SimpleWorkspaceResolver workspaceResolver = new SimpleWorkspaceResolver(originalResolver, this.builder, this);
            ModelBuildingRequest request = new DefaultModelBuildingRequest().setModelSource(modelSource).setWorkspaceModelResolver(workspaceResolver);
            Model model = this.getBestModel(pomLocation, request, resolver, messages);
            if (model == null) {
                return Artifact.unresolved(coordinate, messages);
            }
            return Artifact.build(model, false, pomPath, pomLocation, coordinate.getClassifier(), exclusions, messages, resolver);
        }
        catch (UnresolvableModelException e) {
            return Artifact.unresolved(coordinate, messages);
        }
    }

    private static ISourceLocation calculateLocation(ModelSource source) {
        try {
            URI loc = source instanceof ModelSource2 ? ((ModelSource2)source).getLocationURI() : new URI(source.getLocation());
            return VF.sourceLocation(URIUtil.fixUnicode(loc));
        }
        catch (URISyntaxException e) {
            return URIUtil.unknownLocation();
        }
    }

    private @Nullable Model getBestModel(ISourceLocation pom, ModelBuildingRequest request, ModelResolver resolver, IListWriter messages) {
        try {
            ModelBuildingResult result = this.buildModel(request, resolver);
            MavenParser.translateProblems(result.getProblems(), pom, messages);
            return result.getEffectiveModel();
        }
        catch (ModelBuildingException be) {
            MavenParser.translateProblems(be.getProblems(), pom, messages);
            return be.getModel();
        }
    }

    private static void translateProblems(List<ModelProblem> problems, ISourceLocation loc, IListWriter messages) {
        block4: for (ModelProblem problem : problems) {
            String message = problem.getMessage();
            switch (problem.getSeverity()) {
                case ERROR: 
                case FATAL: {
                    messages.append(Messages.error(message, loc));
                    continue block4;
                }
                case WARNING: {
                    messages.append(Messages.warning(message, loc));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Missing case: " + problem.getSeverity());
        }
    }

    public Model buildEffectiveModel(ModelBuildingRequest request, ModelResolver resolver) throws ModelBuildingException {
        return this.buildModel(request, resolver).getEffectiveModel();
    }

    private ModelBuildingResult buildModel(ModelBuildingRequest request, ModelResolver resolver) throws ModelBuildingException {
        request.setModelResolver(resolver).setModelCache(this.modelCache).setSystemProperties(System.getProperties());
        return this.builder.build(request);
    }

    private static void test(Path target) throws ModelResolutionError {
        long start = System.currentTimeMillis();
        MavenParser parser = new MavenParser(new MavenSettings(), target);
        Artifact project = parser.parseProject();
        long stop = System.currentTimeMillis();
        PrintWriter out = new PrintWriter(System.out);
        project.report(out);
        out.printf("It took %d ms to resolve root artifact%n", stop - start);
        start = System.currentTimeMillis();
        List<Artifact> deps = project.resolveDependencies(Scope.COMPILE, parser);
        stop = System.currentTimeMillis();
        out.println(deps);
        out.printf("It took %d ms to resolve dependencies%n", stop - start);
        out.flush();
    }

    public static void main(String[] args) {
        try {
            MavenParser.test(Path.of("C:/Users/Davy/swat.engineering/rascal/rascal/test/org/rascalmpl/util/maven/poms/multi-module/example-core/pom.xml", new String[0]));
            System.out.println("******");
            System.out.println("******");
            System.out.println("******");
            MavenParser.test(Path.of("pom.xml", new String[0]).toAbsolutePath());
        }
        catch (Throwable t2) {
            System.err.println("Caught: " + t2);
            t2.printStackTrace();
        }
    }

    private static final class CaffeineModelCache
    implements ModelCache {
        private final Cache<Key, Object> modelCache = Caffeine.newBuilder().maximumSize(100L).build();

        private CaffeineModelCache() {
        }

        @Override
        public void put(String groupId, String artifactId, String version, String tag, Object data) {
            this.modelCache.put(new Key(groupId, artifactId, version, tag), data);
        }

        @Override
        public Object get(String groupId, String artifactId, String version, String tag) {
            return this.modelCache.getIfPresent(new Key(groupId, artifactId, version, tag));
        }

        private static final class Key {
            private final String groupId;
            private final String artifactId;
            private final String version;
            private final String tag;

            public Key(String groupId, String artifactId, String version, String tag) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.tag = tag;
            }

            public int hashCode() {
                return this.groupId.hashCode() + this.artifactId.hashCode() * 7 + this.version.hashCode() * 11 + this.tag.hashCode() * 13;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof Key)) {
                    return false;
                }
                Key other = (Key)obj;
                return this.groupId.equals(other.groupId) && this.artifactId.equals(other.artifactId) && this.version.equals(other.version) && this.tag.equals(other.tag);
            }
        }
    }
}

