/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenSettings {
    private final @Nullable Settings userSettings;
    private final @Nullable Settings systemSettings;

    public static Path mavenRepository() {
        return MavenSettings.readSettings().getLocalRepository();
    }

    static MavenSettings readSettings() {
        Path userHome = Path.of(System.getProperty("user.home"), new String[0]);
        Path userSettings = userHome.resolve(".m2").resolve("settings.xml");
        Path globalSettings = null;
        Path mavenHome = MavenSettings.findMavenHome();
        if (mavenHome != null) {
            globalSettings = mavenHome.resolve("conf").resolve("settings.xml");
        }
        return new MavenSettings(MavenSettings.readSettingsFile(userSettings), MavenSettings.readSettingsFile(globalSettings));
    }

    MavenSettings(@Nullable Settings userSettings, @Nullable Settings systemSettings) {
        this.userSettings = userSettings;
        this.systemSettings = systemSettings;
    }

    MavenSettings() {
        this(null, null);
    }

    Path getLocalRepository() {
        String repoProp = System.getProperty("maven.repo.local");
        if (repoProp != null) {
            return Path.of(repoProp, new String[0]);
        }
        if (this.userSettings != null && this.userSettings.getLocalRepository() != null) {
            return Path.of(MavenSettings.replaceVariables(this.userSettings.getLocalRepository()), new String[0]);
        }
        if (this.systemSettings != null && this.systemSettings.getLocalRepository() != null) {
            return Path.of(MavenSettings.replaceVariables(this.systemSettings.getLocalRepository()), new String[0]);
        }
        Path userHome = Path.of(System.getProperty("user.home"), new String[0]);
        return userHome.resolve(".m2").resolve("repository");
    }

    Map<String, Mirror> getMirrors() {
        HashMap<String, Mirror> mirrors = new HashMap<String, Mirror>();
        if (this.systemSettings != null) {
            for (Mirror mirror : this.systemSettings.getMirrors()) {
                mirrors.put(mirror.getMirrorOf(), mirror);
            }
        }
        if (this.userSettings != null) {
            for (Mirror mirror : this.userSettings.getMirrors()) {
                mirrors.put(mirror.getMirrorOf(), mirror);
            }
        }
        return mirrors;
    }

    private static String replaceVariables(String input) {
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource(new PropertiesBasedValueSource(System.getProperties()));
        try {
            interpolator.addValueSource(new EnvarBasedValueSource(false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return interpolator.interpolate(input);
        }
        catch (InterpolationException e) {
            return input;
        }
    }

    private static @Nullable Settings readSettingsFile(Path settingsXmlFile) {
        if (Files.exists(settingsXmlFile, new LinkOption[0])) {
            Settings settings;
            block9: {
                InputStream input = Files.newInputStream(settingsXmlFile, new OpenOption[0]);
                try {
                    settings = new SettingsXpp3Reader().read(input);
                    if (input == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | XmlPullParserException exception) {
                        // empty catch block
                    }
                }
                input.close();
            }
            return settings;
        }
        return null;
    }

    private static @Nullable Path findMavenHome() {
        String path = System.getenv("PATH");
        if (path == null) {
            return null;
        }
        for (String dirname : path.split(File.pathSeparator)) {
            Path dir = Path.of(dirname, new String[0]);
            Path mvnHome = MavenSettings.resolveMavenHome(dir.resolve("mvn.cmd"));
            if (mvnHome != null) {
                return mvnHome;
            }
            mvnHome = MavenSettings.resolveMavenHome(dir.resolve("mvn"));
            if (mvnHome == null) continue;
            return mvnHome;
        }
        return null;
    }

    private static @Nullable Path resolveMavenHome(Path executable) {
        if (Files.isExecutable(executable)) {
            try {
                return executable.toRealPath(new LinkOption[0]).getParent().getParent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

