/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.visualize.dot;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rascalmpl.util.visualize.dot.DotAttribute;
import org.rascalmpl.util.visualize.dot.DotEdge;
import org.rascalmpl.util.visualize.dot.DotNode;
import org.rascalmpl.util.visualize.dot.DotRecord;
import org.rascalmpl.util.visualize.dot.DotStatement;
import org.rascalmpl.util.visualize.dot.NodeId;

public class DotGraph {
    private static final String COLOR_HIGHLIGHT = "red";
    private String id;
    private boolean digraph;
    private List<DotStatement> statements;
    private Map<NodeId, DotNode> nodes;

    public DotGraph(String id, boolean digraph) {
        this.id = id;
        this.digraph = digraph;
        this.statements = new ArrayList<DotStatement>();
        this.nodes = new HashMap<NodeId, DotNode>();
    }

    private void addStatement(DotStatement statement) {
        this.statements.add(statement);
    }

    public boolean containsNode(NodeId id) {
        return this.nodes.containsKey(id);
    }

    public boolean addNode(DotNode node) {
        if (this.nodes.containsKey(node.getId())) {
            return false;
        }
        this.addStatement(node);
        this.nodes.put(node.getId(), node);
        return true;
    }

    public boolean addNode(String id, String label) {
        return this.addNode(new NodeId(id), label);
    }

    public boolean addNode(NodeId id, String label) {
        if (this.nodes.containsKey(id)) {
            return false;
        }
        DotNode node = new DotNode(id);
        node.addAttribute("label", label);
        return this.addNode(node);
    }

    public void addArrayNode(NodeId id, int size) {
        DotNode node = new DotNode(id);
        node.addAttribute("shape", "record");
        node.addAttribute(DotAttribute.createArrayLabel(size));
        this.addNode(node);
    }

    public void addRecordNode(NodeId id, DotRecord dotRecord) {
        DotNode node = new DotNode(id);
        node.addAttribute("shape", "record");
        node.addAttribute(DotAttribute.createRecordLabel(dotRecord));
        this.addNode(node);
    }

    public void addAttribute(NodeId id, String name, String value) {
        DotNode node = this.nodes.get(id);
        if (node != null) {
            node.addAttribute(name, value);
        }
    }

    public void highlight(NodeId id, String color) {
        this.addAttribute(id, "color", color);
    }

    public void highlight(NodeId id) {
        this.highlight(id, COLOR_HIGHLIGHT);
    }

    public void addEdge(String from, String to) {
        this.addEdge(new NodeId(from), new NodeId(to));
    }

    public void addEdge(NodeId from, NodeId to) {
        this.addEdge(new DotEdge(from, true, to));
    }

    public void addEdge(NodeId from, NodeId to, String label, String color) {
        DotEdge edge = new DotEdge(from, true, to);
        edge.addAttribute("label", label);
        if (color != null) {
            edge.addAttribute("color", color);
        }
        this.addEdge(edge);
    }

    public void addEdge(NodeId from, NodeId to, String label) {
        this.addEdge(from, to, label, null);
    }

    public void addEdge(DotEdge edge) {
        this.addStatement(edge);
    }

    public void writeSource(PrintWriter writer) {
        writer.write(this.digraph ? "digraph" : "graph");
        if (this.id != null) {
            writer.write(" ");
            writer.write(this.id);
        }
        writer.println(" {");
        writer.println("ordering = out;");
        for (DotStatement statement : this.statements) {
            statement.writeSource(writer);
            writer.println(";");
        }
        writer.println("}");
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.writeSource(new PrintWriter(writer));
        return writer.toString();
    }
}

