/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.UndeclaredFieldException;
import io.usethesource.vallang.impl.fields.AbstractDefaultWithKeywordParameters;
import io.usethesource.vallang.impl.fields.AbstractValueFactoryAdapter;
import io.usethesource.vallang.impl.fields.ConstructorWithKeywordParametersFacade;
import io.usethesource.vallang.impl.persistent.ValueFactory;
import io.usethesource.vallang.io.StandardTextWriter;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.visitors.TreeVisitor;

public class RascalValueFactory
extends AbstractValueFactoryAdapter
implements IRascalValueFactory {
    public static final TypeStore uptr = new TypeStore(new TypeStore[0]);
    private static final TypeFactory tf = TypeFactory.getInstance();
    private static final IValueFactory bootFactory = ValueFactory.getInstance();
    private final TypeReifier tr = new TypeReifier(bootFactory);
    private static final Type str = tf.stringType();
    public static final Type Tree = tf.abstractDataType(uptr, "Tree", new Type[0]);
    public static final Type Production = tf.abstractDataType(uptr, "Production", new Type[0]);
    public static final Type Attributes = tf.abstractDataType(uptr, "Attributes", new Type[0]);
    public static final Type Attr = tf.abstractDataType(uptr, "Attr", new Type[0]);
    public static final Type Associativity = tf.abstractDataType(uptr, "Associativity", new Type[0]);
    public static final Type Symbol = tf.abstractDataType(uptr, "Symbol", new Type[0]);
    public static final Type CharRange = tf.abstractDataType(uptr, "CharRange", new Type[0]);
    public static final Type Args = tf.listType(Tree);
    public static final Type Attrs = tf.setType(Attr);
    public static final Type Symbols = tf.listType(Symbol);
    public static final Type CharRanges = tf.listType(CharRange);
    public static final Type Alternatives = tf.setType(Tree);
    public static final Type Content = tf.abstractDataType(uptr, "Content", new Type[0]);
    public static final Type TypeParam = tf.parameterType("T");
    public static final Type Type = RascalTypeFactory.getInstance().reifiedType(TypeParam);
    public static final Type Type_Reified;
    public static final Type ADTforType;
    public static final Type Tree_Appl;
    public static final Type Tree_Cycle;
    public static final Type Tree_Amb;
    public static final Type Tree_Char;
    public static final Type Production_Default;
    public static final Type Production_Prod;
    public static final Type Production_Regular;
    public static final Type Production_Cons;
    public static final Type Production_Func;
    public static final Type Production_Choice;
    public static final Type Production_Priority;
    public static final Type Production_Composition;
    public static final Type Production_Associativity;
    public static final Type Production_Error;
    public static final Type Production_Skipped;
    public static final Type Attr_Assoc;
    public static final Type Attr_Tag;
    public static final Type Attr_Bracket;
    public static final Type Associativity_Left;
    public static final Type Associativity_Right;
    public static final Type Associativity_Assoc;
    public static final Type Associativity_NonAssoc;
    public static final Type Condition;
    public static final Type Condition_Follow;
    public static final Type Condition_NotFollow;
    public static final Type Condition_Precede;
    public static final Type Condition_NotPrecede;
    public static final Type Condition_Delete;
    public static final Type Condition_EndOfLine;
    public static final Type Condition_StartOfLine;
    public static final Type Condition_AtColumn;
    public static final Type Condition_Except;
    public static final Type Symbol_Label;
    public static final Type Symbol_Start;
    public static final Type Symbol_Lit;
    public static final Type Symbol_Cilit;
    public static final Type Symbol_Empty;
    public static final Type Symbol_Seq;
    public static final Type Symbol_Opt;
    public static final Type Symbol_Alt;
    public static final Type Symbol_Sort;
    public static final Type Symbol_Lex;
    public static final Type Symbol_Keywords;
    public static final Type Symbol_Meta;
    public static final Type Symbol_Conditional;
    public static final Type Symbol_IterSeps;
    public static final Type Symbol_IterStarSeps;
    public static final Type Symbol_Iter;
    public static final Type Symbol_IterStar;
    public static final Type Symbol_ParameterizedSort;
    public static final Type Symbol_ParameterizedLex;
    public static final Type Symbol_Parameter;
    public static final Type Symbol_Layouts;
    public static final Type Symbol_CharClass;
    public static final Type Symbol_Int;
    public static final Type Symbol_Rat;
    public static final Type Symbol_Bool;
    public static final Type Symbol_Real;
    public static final Type Symbol_Str;
    public static final Type Symbol_Node;
    public static final Type Symbol_Num;
    public static final Type Symbol_Void;
    public static final Type Symbol_Value;
    public static final Type Symbol_Loc;
    public static final Type Symbol_Datetime;
    public static final Type Symbol_Set;
    public static final Type Symbol_Rel;
    public static final Type Symbol_Lrel;
    public static final Type Symbol_Tuple;
    public static final Type Symbol_List;
    public static final Type Symbol_Map;
    public static final Type Symbol_Bag;
    public static final Type Symbol_Adt;
    public static final Type Symbol_Reified;
    public static final Type Symbol_Func;
    public static final Type Symbol_Alias;
    public static final Type Symbol_Cons;
    public static final Type Symbol_Overloaded;
    public static final Type Symbol_Prod;
    public static final Type CharRange_Single;
    public static final Type CharRange_Range;
    public static final IValue Attribute_Assoc_Left;
    public static final IValue Attribute_Assoc_Right;
    public static final IValue Attribute_Assoc_Non_Assoc;
    public static final IValue Attribute_Assoc_Assoc;
    public static final IValue Attribute_Bracket;
    public static final Type Function;
    public static final Type Function_Choice;
    public static final Type Function_Function;
    public static final Type Function_Closure;
    public static final Type Function_Composition;
    public static final Type Grammar;
    public static final Type Grammar_Default;
    public static final String Location = "src";
    public static final String LegacyLocation = "loc";
    private static final ITree[] byteChars;
    private static final Type[] byteCharTypes;
    public static final Supplier<TypeStore> TYPE_STORE_SUPPLIER;

    static IRascalValueFactory getInstance() {
        return InstanceHolder.sInstance;
    }

    public RascalValueFactory() {
        super(bootFactory);
    }

    public static TypeStore getStore() {
        return uptr;
    }

    public static boolean isLegacySourceLocationAnnotation(Type receiver, String label) {
        return receiver.isSubtypeOf(Tree) && label.equals(LegacyLocation);
    }

    @Override
    public INode node(String name, IValue ... children) {
        IConstructor res = this.specializeNode(name, children);
        return res != null ? res : super.node(name, children);
    }

    private IConstructor specializeNode(String name, IValue ... children) {
        if (Type_Reified.getName().equals(name) && children.length == 2 && children[0].getType().isSubtypeOf(Type_Reified.getFieldType(0)) && children[1].getType().isSubtypeOf(Type_Reified.getFieldType(1))) {
            return this.reifiedType((IConstructor)children[0], (IMap)children[1]);
        }
        return null;
    }

    @Override
    public INode node(String name, IValue[] children, Map<String, IValue> kws) throws FactTypeUseException {
        IConstructor result = this.specializeNode(name, children);
        return result != null ? (kws != null && !kws.isEmpty() ? (INode)result.asWithKeywordParameters().setParameters(kws) : result) : super.node(name, children, kws);
    }

    @Override
    public IConstructor constructor(Type constructor, IValue[] children, Map<String, IValue> kwParams) throws FactTypeUseException {
        IConstructor result;
        if (constructor == null) {
            throw new NullPointerException();
        }
        Arrays.stream(children).forEach(t2 -> {
            if (t2 == null) {
                throw new NullPointerException();
            }
        });
        if (kwParams != null) {
            kwParams.values().stream().forEach(t2 -> {
                if (t2 == null) {
                    throw new NullPointerException();
                }
            });
        }
        return (result = this.specializeConstructor(constructor, children)) != null ? (kwParams != null && !kwParams.isEmpty() && result.mayHaveKeywordParameters() ? result.asWithKeywordParameters().setParameters(kwParams) : result) : super.constructor(constructor, children, kwParams);
    }

    @Override
    public IConstructor constructor(Type constructor, IValue ... children) throws FactTypeUseException {
        if (constructor == null) {
            throw new NullPointerException();
        }
        Arrays.stream(children).forEach(t2 -> {
            if (t2 == null) {
                throw new NullPointerException();
            }
        });
        IConstructor result = this.specializeConstructor(constructor, children);
        return result != null ? result : super.constructor(constructor, children);
    }

    private IConstructor specializeConstructor(Type constructor, IValue ... children) {
        if (constructor.getAbstractDataType() == Tree) {
            if (constructor == Tree_Appl) {
                return this.appl((IConstructor)children[0], (IList)children[1]);
            }
            if (constructor == Tree_Amb) {
                return this.amb((ISet)children[0]);
            }
            if (constructor == Tree_Char) {
                return this.character(((IInteger)children[0]).intValue());
            }
            if (constructor == Tree_Cycle) {
                return this.cycle((IConstructor)children[0], ((IInteger)children[1]).intValue());
            }
        } else if (constructor == Type_Reified || constructor.getAbstractDataType() == ADTforType) {
            return this.reifiedType((IConstructor)children[0], (IMap)children[1]);
        }
        return null;
    }

    @Override
    public IConstructor reifiedType(IConstructor symbol, IMap definitions) {
        Map<Type, Type> bindings = Collections.singletonMap(TypeParam, this.tr.symbolToType(symbol, definitions));
        return super.constructor(Type_Reified.instantiate(bindings), symbol, definitions);
    }

    @Override
    public ITree character(int ch) {
        if (ch >= 0 && ch < 127) {
            return this.character((byte)ch);
        }
        return new CharInt(ch);
    }

    @Override
    public ITree character(byte ch) {
        return byteChars[ch];
    }

    @Override
    public IConstructor grammar(IMap rules) {
        return this.constructor(Grammar_Default, new IValue[]{this.setWriter().done(), rules});
    }

    @Override
    public ITree appl(Map<String, IValue> annos, IConstructor prod, IList args) {
        return (ITree)this.appl(prod, args).asWithKeywordParameters().setParameters(annos);
    }

    @Override
    @Deprecated
    public ITree appl(IConstructor prod, ArrayList<ITree> args) {
        switch (args.size()) {
            case 0: {
                return new Appl0(prod);
            }
            case 1: {
                return new Appl1(prod, args.get(0));
            }
            case 2: {
                return new Appl2(prod, args.get(0), args.get(1));
            }
            case 3: {
                return new Appl3(prod, args.get(0), args.get(1), args.get(2));
            }
            case 4: {
                return new Appl4(prod, args.get(0), args.get(1), args.get(2), args.get(3));
            }
            case 5: {
                return new Appl5(prod, args.get(0), args.get(1), args.get(2), args.get(3), args.get(4));
            }
            case 6: {
                return new Appl6(prod, args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5));
            }
            case 7: {
                return new Appl7(prod, args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5), args.get(6));
            }
        }
        return new ApplN(prod, new ArrayListArgumentList(args));
    }

    @Override
    public ITree appl(IConstructor prod, IList args) {
        switch (args.length()) {
            case 0: {
                return new Appl0(prod);
            }
            case 1: {
                return new Appl1(prod, args.get(0));
            }
            case 2: {
                return new Appl2(prod, args.get(0), args.get(1));
            }
            case 3: {
                return new Appl3(prod, args.get(0), args.get(1), args.get(2));
            }
            case 4: {
                return new Appl4(prod, args.get(0), args.get(1), args.get(2), args.get(3));
            }
            case 5: {
                return new Appl5(prod, args.get(0), args.get(1), args.get(2), args.get(3), args.get(4));
            }
            case 6: {
                return new Appl6(prod, args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5));
            }
            case 7: {
                return new Appl7(prod, args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5), args.get(6));
            }
        }
        return new ApplN(prod, args);
    }

    @Override
    public ITree appl(IConstructor prod, IValue ... args) {
        switch (args.length) {
            case 0: {
                return new Appl0(prod);
            }
            case 1: {
                return new Appl1(prod, args[0]);
            }
            case 2: {
                return new Appl2(prod, args[0], args[1]);
            }
            case 3: {
                return new Appl3(prod, args[0], args[1], args[2]);
            }
            case 4: {
                return new Appl4(prod, args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return new Appl5(prod, args[0], args[1], args[2], args[3], args[4]);
            }
            case 6: {
                return new Appl6(prod, args[0], args[1], args[2], args[3], args[4], args[5]);
            }
            case 7: {
                return new Appl7(prod, args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
        }
        return new ApplN(prod, new ArrayArgumentList(args));
    }

    @Override
    public ITree cycle(IConstructor symbol, int cycleLength) {
        return new Cycle(symbol, cycleLength);
    }

    @Override
    public ITree amb(ISet alternatives) {
        if (alternatives.size() == 1) {
            return (ITree)alternatives.iterator().next();
        }
        return new Amb(alternatives);
    }

    static {
        uptr.declareAbstractDataType(Type);
        Type_Reified = tf.constructor(uptr, Type, "type", Symbol, "symbol", tf.mapType(Symbol, Production), "definitions");
        ADTforType = tf.abstractDataType(uptr, "type", TypeParam);
        Tree_Appl = tf.constructor(uptr, Tree, "appl", Production, "prod", tf.listType(Tree), "args");
        Tree_Cycle = tf.constructor(uptr, Tree, "cycle", Symbol, "symbol", tf.integerType(), "cycleLength");
        Tree_Amb = tf.constructor(uptr, Tree, "amb", Alternatives, "alternatives");
        Tree_Char = tf.constructor(uptr, Tree, "char", tf.integerType(), "character");
        Production_Prod = Production_Default = tf.constructor(uptr, Production, "prod", Symbol, "def", tf.listType(Symbol), "symbols", tf.setType(Attr), "attributes");
        Production_Regular = tf.constructor(uptr, Production, "regular", Symbol, "def");
        Production_Cons = tf.constructor(uptr, Production, "cons", Symbol, "def", tf.listType(Symbol), "symbols", tf.listType(Symbol), "kwTypes", tf.setType(Attr), "attributes");
        Production_Func = tf.constructor(uptr, Production, "func", Symbol, "def", tf.listType(Symbol), "symbols", tf.listType(Symbol), "kwTypes", tf.setType(Attr), "attributes");
        Production_Choice = tf.constructor(uptr, Production, "choice", Symbol, "def", tf.setType(Production), "alternatives");
        Production_Priority = tf.constructor(uptr, Production, "priority", Symbol, "def", tf.listType(Production), "choices");
        Production_Composition = tf.constructor(uptr, Production, "composition", Production, "lhs", Production, "rhs");
        Production_Associativity = tf.constructor(uptr, Production, "associativity", Symbol, "def", Associativity, "assoc", tf.setType(Production), "alternatives");
        Production_Error = tf.constructor(uptr, Production, "error", Symbol, "def", Production, "prod", tf.integerType(), "dot");
        Production_Skipped = tf.constructor(uptr, Production, "skipped", Symbol, "def");
        Attr_Assoc = tf.constructor(uptr, Attr, "assoc", Associativity, "assoc");
        Attr_Tag = tf.constructor(uptr, Attr, "tag", tf.valueType(), "tag");
        Attr_Bracket = tf.constructor(uptr, Attr, "bracket", new Type[0]);
        Associativity_Left = tf.constructor(uptr, Associativity, "left", new Type[0]);
        Associativity_Right = tf.constructor(uptr, Associativity, "right", new Type[0]);
        Associativity_Assoc = tf.constructor(uptr, Associativity, "assoc", new Type[0]);
        Associativity_NonAssoc = tf.constructor(uptr, Associativity, "non-assoc", new Type[0]);
        Condition = tf.abstractDataType(uptr, "Condition", new Type[0]);
        Condition_Follow = tf.constructor(uptr, Condition, "follow", Symbol, "symbol");
        Condition_NotFollow = tf.constructor(uptr, Condition, "not-follow", Symbol, "symbol");
        Condition_Precede = tf.constructor(uptr, Condition, "precede", Symbol, "symbol");
        Condition_NotPrecede = tf.constructor(uptr, Condition, "not-precede", Symbol, "symbol");
        Condition_Delete = tf.constructor(uptr, Condition, "delete", Symbol, "symbol");
        Condition_EndOfLine = tf.constructor(uptr, Condition, "end-of-line", new Type[0]);
        Condition_StartOfLine = tf.constructor(uptr, Condition, "begin-of-line", new Type[0]);
        Condition_AtColumn = tf.constructor(uptr, Condition, "at-column", tf.integerType(), "column");
        Condition_Except = tf.constructor(uptr, Condition, "except", str, "label");
        Symbol_Label = tf.constructor(uptr, Symbol, "label", str, "name", Symbol, "symbol");
        Symbol_Start = tf.constructor(uptr, Symbol, "start", Symbol, "symbol");
        Symbol_Lit = tf.constructor(uptr, Symbol, "lit", str, "string");
        Symbol_Cilit = tf.constructor(uptr, Symbol, "cilit", str, "string");
        Symbol_Empty = tf.constructor(uptr, Symbol, "empty", new Type[0]);
        Symbol_Seq = tf.constructor(uptr, Symbol, "seq", tf.listType(Symbol), "symbols");
        Symbol_Opt = tf.constructor(uptr, Symbol, "opt", Symbol, "symbol");
        Symbol_Alt = tf.constructor(uptr, Symbol, "alt", tf.setType(Symbol), "alternatives");
        Symbol_Sort = tf.constructor(uptr, Symbol, "sort", str, "name");
        Symbol_Lex = tf.constructor(uptr, Symbol, "lex", str, "name");
        Symbol_Keywords = tf.constructor(uptr, Symbol, "keywords", str, "name");
        Symbol_Meta = tf.constructor(uptr, Symbol, "meta", Symbol, "symbol");
        Symbol_Conditional = tf.constructor(uptr, Symbol, "conditional", Symbol, "symbol", tf.setType(Condition), "conditions");
        Symbol_IterSeps = tf.constructor(uptr, Symbol, "iter-seps", Symbol, "symbol", tf.listType(Symbol), "separators");
        Symbol_IterStarSeps = tf.constructor(uptr, Symbol, "iter-star-seps", Symbol, "symbol", tf.listType(Symbol), "separators");
        Symbol_Iter = tf.constructor(uptr, Symbol, "iter", Symbol, "symbol");
        Symbol_IterStar = tf.constructor(uptr, Symbol, "iter-star", Symbol, "symbol");
        Symbol_ParameterizedSort = tf.constructor(uptr, Symbol, "parameterized-sort", str, "name", tf.listType(Symbol), "parameters");
        Symbol_ParameterizedLex = tf.constructor(uptr, Symbol, "parameterized-lex", str, "name", tf.listType(Symbol), "parameters");
        Symbol_Parameter = tf.constructor(uptr, Symbol, "parameter", str, "name", Symbol, "bound");
        Symbol_Layouts = tf.constructor(uptr, Symbol, "layouts", str, "name");
        Symbol_CharClass = tf.constructor(uptr, Symbol, "char-class", tf.listType(CharRange), "ranges");
        Symbol_Int = tf.constructor(uptr, Symbol, "int", new Type[0]);
        Symbol_Rat = tf.constructor(uptr, Symbol, "rat", new Type[0]);
        Symbol_Bool = tf.constructor(uptr, Symbol, "bool", new Type[0]);
        Symbol_Real = tf.constructor(uptr, Symbol, "real", new Type[0]);
        Symbol_Str = tf.constructor(uptr, Symbol, "str", new Type[0]);
        Symbol_Node = tf.constructor(uptr, Symbol, "node", new Type[0]);
        Symbol_Num = tf.constructor(uptr, Symbol, "num", new Type[0]);
        Symbol_Void = tf.constructor(uptr, Symbol, "void", new Type[0]);
        Symbol_Value = tf.constructor(uptr, Symbol, "value", new Type[0]);
        Symbol_Loc = tf.constructor(uptr, Symbol, LegacyLocation, new Type[0]);
        Symbol_Datetime = tf.constructor(uptr, Symbol, "datetime", new Type[0]);
        Symbol_Set = tf.constructor(uptr, Symbol, "set", Symbol, "symbol");
        Symbol_Rel = tf.constructor(uptr, Symbol, "rel", tf.listType(Symbol), "symbols");
        Symbol_Lrel = tf.constructor(uptr, Symbol, "lrel", tf.listType(Symbol), "symbols");
        Symbol_Tuple = tf.constructor(uptr, Symbol, "tuple", tf.listType(Symbol), "symbols");
        Symbol_List = tf.constructor(uptr, Symbol, "list", Symbol, "symbol");
        Symbol_Map = tf.constructor(uptr, Symbol, "map", Symbol, "from", Symbol, "to");
        Symbol_Bag = tf.constructor(uptr, Symbol, "bag", Symbol, "symbol");
        Symbol_Adt = tf.constructor(uptr, Symbol, "adt", str, "name", tf.listType(Symbol), "parameters");
        Symbol_Reified = tf.constructor(uptr, Symbol, "reified", Symbol, "symbol");
        Symbol_Func = tf.constructor(uptr, Symbol, "func", Symbol, "ret", tf.listType(Symbol), "parameters", tf.listType(Symbol), "kwTypes");
        Symbol_Alias = tf.constructor(uptr, Symbol, "alias", str, "name", tf.listType(Symbol), "parameters", Symbol, "aliased");
        Symbol_Cons = tf.constructor(uptr, Symbol, "cons", Symbol, "adt", str, "name", tf.listType(Symbol), "parameters");
        Symbol_Overloaded = tf.constructor(uptr, Symbol, "overloaded", tf.setType(Symbol), "overloads", tf.setType(Symbol), "defaults");
        Symbol_Prod = tf.constructor(uptr, Symbol, "prod", Symbol, "sort", str, "name", tf.listType(Symbol), "parameters", tf.setType(Attr), "attributes");
        CharRange_Single = tf.constructor(uptr, CharRange, "single", tf.integerType());
        CharRange_Range = tf.constructor(uptr, CharRange, "range", tf.integerType(), "begin", tf.integerType(), "end");
        Attribute_Assoc_Left = bootFactory.constructor(Attr_Assoc, bootFactory.constructor(Associativity_Left));
        Attribute_Assoc_Right = bootFactory.constructor(Attr_Assoc, bootFactory.constructor(Associativity_Right));
        Attribute_Assoc_Non_Assoc = bootFactory.constructor(Attr_Assoc, bootFactory.constructor(Associativity_NonAssoc));
        Attribute_Assoc_Assoc = bootFactory.constructor(Attr_Assoc, bootFactory.constructor(Associativity_Assoc));
        Attribute_Bracket = bootFactory.constructor(Attr_Bracket);
        Function = tf.abstractDataType(uptr, "Function", new Type[0]);
        Function_Choice = tf.constructor(uptr, Function, "choice", tf.listType(Function), "alternatives", tf.listType(Function), "otherwise");
        Function_Function = tf.constructor(uptr, Function, "function", tf.sourceLocationType(), "id");
        Function_Closure = tf.constructor(uptr, Function, "closure", Function, "definition", tf.mapType(str, tf.valueType()), "environment");
        Function_Composition = tf.constructor(uptr, Function, "composition", Function, "lhs", Function, "rhs");
        Grammar = tf.abstractDataType(uptr, "Grammar", new Type[0]);
        Grammar_Default = tf.constructor(uptr, Grammar, "grammar", tf.setType(Symbol), "starts", tf.mapType(Symbol, "sort", Production, "def"), "rules");
        uptr.declareKeywordParameter(Tree, Location, tf.sourceLocationType());
        byteChars = new ITree[127];
        byteCharTypes = new Type[127];
        for (byte i = 0; i < 127; i = (byte)(i + 1)) {
            RascalValueFactory.byteChars[i] = new CharByte(i);
            RascalValueFactory.byteCharTypes[i] = RascalTypeFactory.getInstance().nonTerminalType(bootFactory.constructor(Symbol_CharClass, bootFactory.list(bootFactory.constructor(CharRange_Range, bootFactory.integer(i), bootFactory.integer(i)))));
        }
        TYPE_STORE_SUPPLIER = () -> {
            TypeStore typeStore = new TypeStore(new TypeStore[0]);
            typeStore.declareAbstractDataType(Type);
            typeStore.declareConstructor(Type_Reified);
            typeStore.declareAbstractDataType(ADTforType);
            return typeStore;
        };
    }

    private static class Appl7
    extends AbstractAppl {
        private final IValue arg0;
        private final IValue arg1;
        private final IValue arg2;
        private final IValue arg3;
        private final IValue arg4;
        private final IValue arg5;
        private final IValue arg6;

        public Appl7(IConstructor production, IValue arg0, IValue arg1, IValue arg2, IValue arg3, IValue arg4, IValue arg5, IValue arg6) {
            super(production);
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
            this.arg5 = arg5;
            this.arg6 = arg6;
        }

        @Override
        public IList getArgs() {
            return new AbstractArgumentList(){

                @Override
                public int length() {
                    return 7;
                }

                @Override
                public IValue get(int i) throws IndexOutOfBoundsException {
                    switch (i) {
                        case 0: {
                            return arg0;
                        }
                        case 1: {
                            return arg1;
                        }
                        case 2: {
                            return arg2;
                        }
                        case 3: {
                            return arg3;
                        }
                        case 4: {
                            return arg4;
                        }
                        case 5: {
                            return arg5;
                        }
                        case 6: {
                            return arg6;
                        }
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                protected IList asNormal() {
                    return RascalValueFactory.getInstance().list(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
                }
            };
        }

        @Override
        public int hashCode() {
            return 31 + 13 * this.production.hashCode() + 17 * this.arg0.hashCode() + 23 * this.arg1.hashCode() + 29 * this.arg2.hashCode() + 31 * this.arg3.hashCode() + 37 * this.arg4.hashCode() + 41 * this.arg5.hashCode() + 43 * this.arg6.hashCode();
        }
    }

    private static class Appl6
    extends AbstractAppl {
        private final IValue arg0;
        private final IValue arg1;
        private final IValue arg2;
        private final IValue arg3;
        private final IValue arg4;
        private final IValue arg5;

        public Appl6(IConstructor production, IValue arg0, IValue arg1, IValue arg2, IValue arg3, IValue arg4, IValue arg5) {
            super(production);
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
            this.arg5 = arg5;
        }

        @Override
        public IList getArgs() {
            return new AbstractArgumentList(){

                @Override
                public int length() {
                    return 6;
                }

                @Override
                public IValue get(int i) throws IndexOutOfBoundsException {
                    switch (i) {
                        case 0: {
                            return arg0;
                        }
                        case 1: {
                            return arg1;
                        }
                        case 2: {
                            return arg2;
                        }
                        case 3: {
                            return arg3;
                        }
                        case 4: {
                            return arg4;
                        }
                        case 5: {
                            return arg5;
                        }
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                protected IList asNormal() {
                    return RascalValueFactory.getInstance().list(arg0, arg1, arg2, arg3, arg4, arg5);
                }
            };
        }

        @Override
        public int hashCode() {
            return 31 + 13 * this.production.hashCode() + 17 * this.arg0.hashCode() + 23 * this.arg1.hashCode() + 29 * this.arg2.hashCode() + 31 * this.arg3.hashCode() + 37 * this.arg4.hashCode() + 41 * this.arg5.hashCode();
        }
    }

    private static class Appl5
    extends AbstractAppl {
        private final IValue arg0;
        private final IValue arg1;
        private final IValue arg2;
        private final IValue arg3;
        private final IValue arg4;

        public Appl5(IConstructor production, IValue arg0, IValue arg1, IValue arg2, IValue arg3, IValue arg4) {
            super(production);
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }

        @Override
        public IList getArgs() {
            return new AbstractArgumentList(){

                @Override
                public int length() {
                    return 5;
                }

                @Override
                public IValue get(int i) throws IndexOutOfBoundsException {
                    switch (i) {
                        case 0: {
                            return arg0;
                        }
                        case 1: {
                            return arg1;
                        }
                        case 2: {
                            return arg2;
                        }
                        case 3: {
                            return arg3;
                        }
                        case 4: {
                            return arg4;
                        }
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                protected IList asNormal() {
                    return RascalValueFactory.getInstance().list(arg0, arg1, arg2, arg3, arg4);
                }
            };
        }

        @Override
        public int hashCode() {
            return 31 + 13 * this.production.hashCode() + 17 * this.arg0.hashCode() + 23 * this.arg1.hashCode() + 29 * this.arg2.hashCode() + 31 * this.arg3.hashCode() + 37 * this.arg4.hashCode();
        }
    }

    private static class Appl4
    extends AbstractAppl {
        private final IValue arg0;
        private final IValue arg1;
        private final IValue arg2;
        private final IValue arg3;

        public Appl4(IConstructor production, IValue arg0, IValue arg1, IValue arg2, IValue arg3) {
            super(production);
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        @Override
        public IList getArgs() {
            return new AbstractArgumentList(){

                @Override
                public int length() {
                    return 4;
                }

                @Override
                public IValue get(int i) throws IndexOutOfBoundsException {
                    switch (i) {
                        case 0: {
                            return arg0;
                        }
                        case 1: {
                            return arg1;
                        }
                        case 2: {
                            return arg2;
                        }
                        case 3: {
                            return arg3;
                        }
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                protected IList asNormal() {
                    return RascalValueFactory.getInstance().list(arg0, arg1, arg2, arg3);
                }
            };
        }

        @Override
        public int hashCode() {
            return 31 + 13 * this.production.hashCode() + 17 * this.arg0.hashCode() + 23 * this.arg1.hashCode() + 29 * this.arg2.hashCode() + 31 * this.arg3.hashCode();
        }
    }

    private static class Appl3
    extends AbstractAppl {
        private final IValue arg0;
        private final IValue arg1;
        private final IValue arg2;

        public Appl3(IConstructor production, IValue arg0, IValue arg1, IValue arg2) {
            super(production);
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public IList getArgs() {
            return new AbstractArgumentList(){

                @Override
                public int length() {
                    return 3;
                }

                @Override
                public IValue get(int i) throws IndexOutOfBoundsException {
                    switch (i) {
                        case 0: {
                            return arg0;
                        }
                        case 1: {
                            return arg1;
                        }
                        case 2: {
                            return arg2;
                        }
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                protected IList asNormal() {
                    return RascalValueFactory.getInstance().list(arg0, arg1, arg2);
                }
            };
        }

        @Override
        public int hashCode() {
            return 29 + 13 * this.production.hashCode() + 17 * this.arg0.hashCode() + 23 * this.arg1.hashCode() + 29 * this.arg2.hashCode();
        }
    }

    private static class Appl2
    extends AbstractAppl {
        private final IValue arg0;
        private final IValue arg1;

        public Appl2(IConstructor production, IValue arg0, IValue arg1) {
            super(production);
            this.arg0 = arg0;
            this.arg1 = arg1;
        }

        @Override
        public IList getArgs() {
            return new AbstractArgumentList(){

                @Override
                public int length() {
                    return 2;
                }

                @Override
                public IValue get(int i) throws IndexOutOfBoundsException {
                    switch (i) {
                        case 0: {
                            return arg0;
                        }
                        case 1: {
                            return arg1;
                        }
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                protected IList asNormal() {
                    return RascalValueFactory.getInstance().list(arg0, arg1);
                }
            };
        }

        @Override
        public int hashCode() {
            return 23 + 13 * this.production.hashCode() + 17 * this.arg0.hashCode() + 23 * this.arg1.hashCode();
        }
    }

    private static class Appl1
    extends AbstractAppl {
        private final IValue arg0;

        public Appl1(IConstructor production, IValue arg) {
            super(production);
            this.arg0 = arg;
        }

        @Override
        public IList getArgs() {
            return new AbstractArgumentList(){

                @Override
                public int length() {
                    return 1;
                }

                @Override
                public IValue get(int i) throws IndexOutOfBoundsException {
                    switch (i) {
                        case 0: {
                            return arg0;
                        }
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                protected IList asNormal() {
                    return RascalValueFactory.getInstance().list(arg0);
                }
            };
        }

        @Override
        public int hashCode() {
            return 17 + 13 * this.production.hashCode() + 17 * this.arg0.hashCode();
        }
    }

    private static class ApplN
    extends AbstractAppl {
        private final IList args;

        public ApplN(IConstructor production, IList args) {
            super(production);
            this.args = args;
        }

        @Override
        public IList getArgs() {
            return this.args;
        }

        @Override
        public int hashCode() {
            return 3 + 17 * this.production.hashCode() + 91 * this.args.hashCode();
        }
    }

    private static class Appl0
    extends AbstractAppl {
        private static final IList EMPTY_LIST = (IList)RascalValueFactory.getInstance().listWriter().done();

        public Appl0(IConstructor production) {
            super(production);
        }

        @Override
        public IList getArgs() {
            return EMPTY_LIST;
        }

        @Override
        public int hashCode() {
            return 17 + 13 * this.production.hashCode();
        }
    }

    @Deprecated
    private static class ArrayListArgumentList
    extends AbstractArgumentList {
        private final ArrayList<ITree> list;

        public ArrayListArgumentList(ArrayList<ITree> list) {
            this.list = list;
        }

        @Override
        public int length() {
            return this.list.size();
        }

        @Override
        public IValue get(int i) throws IndexOutOfBoundsException {
            return this.list.get(i);
        }

        @Override
        protected IList asNormal() {
            IListWriter w = RascalValueFactory.getInstance().listWriter();
            for (int i = 0; i < this.list.size(); ++i) {
                w.append(this.list.get(i));
            }
            return (IList)w.done();
        }
    }

    private static class ArrayArgumentList
    extends AbstractArgumentList {
        private final IValue[] array;

        public ArrayArgumentList(IValue[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public IValue get(int i) throws IndexOutOfBoundsException {
            return this.array[i];
        }

        @Override
        protected IList asNormal() {
            return RascalValueFactory.getInstance().list(this.array);
        }
    }

    private static abstract class AbstractArgumentList
    implements IList {
        protected int hash = 0;

        private AbstractArgumentList() {
        }

        protected abstract IList asNormal();

        @Override
        public Type getType() {
            return tf.listType(this.getElementType());
        }

        @Override
        public boolean contains(IValue e) {
            for (int i = 0; i < this.length(); ++i) {
                if (!this.get(i).equals(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return this.defaultToString();
        }

        @Override
        public boolean equals(Object other) {
            return this.defaultEquals(other);
        }

        @Override
        public boolean match(IValue other) {
            IList o;
            if (other instanceof IList && (o = (IList)other).length() == this.length()) {
                for (int i = 0; i < this.length(); ++i) {
                    if (o.get(i).match(this.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.hash != 0) {
                return this.hash;
            }
            for (IValue element : this) {
                this.hash = this.hash << 1 ^ element.hashCode();
            }
            return this.hash;
        }

        @Override
        public Iterator<IValue> iterator() {
            return new Iterator<IValue>(){
                private int count = 0;

                @Override
                public boolean hasNext() {
                    return this.count < this.length();
                }

                @Override
                public IValue next() {
                    ++this.count;
                    return this.get(this.count - 1);
                }
            };
        }

        @Override
        public Type getElementType() {
            Type lub = tf.voidType();
            for (IValue elem : this) {
                if (lub == Tree) {
                    return Tree;
                }
                lub = lub.lub(elem.getType());
            }
            return lub;
        }

        @Override
        public IList reverse() {
            return this.asNormal().reverse();
        }

        @Override
        public IList append(IValue e) {
            return this.asNormal().append(e);
        }

        @Override
        public IList insert(IValue e) {
            return this.asNormal().insert(e);
        }

        @Override
        public IList concat(IList o) {
            return this.asNormal().concat(o);
        }

        @Override
        public IList shuffle(Random rand) {
            return this.asNormal().shuffle(rand);
        }

        @Override
        public IList put(int i, IValue e) throws FactTypeUseException, IndexOutOfBoundsException {
            return this.asNormal().put(i, e);
        }

        @Override
        public IList replace(int first, int second, int end, IList repl) throws FactTypeUseException, IndexOutOfBoundsException {
            return this.asNormal().replace(first, second, end, repl);
        }

        @Override
        public IList sublist(int offset, int length) {
            return this.asNormal().sublist(offset, length);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public IList delete(IValue e) {
            return this.asNormal().delete(e);
        }

        @Override
        public IList delete(int i) {
            return this.asNormal().delete(i);
        }

        @Override
        public IList product(IList l) {
            return this.asNormal().product(l);
        }

        @Override
        public IList intersect(IList l) {
            return this.asNormal().intersect(l);
        }

        @Override
        public IList subtract(IList l) {
            return this.asNormal().subtract(l);
        }

        @Override
        public boolean isSubListOf(IList l) {
            return this.asNormal().isSubListOf(l);
        }

        @Override
        public boolean isRelation() {
            return false;
        }

        @Override
        public IRelation<IList> asRelation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IListWriter writer() {
            return IRascalValueFactory.getInstance().listWriter();
        }
    }

    private static abstract class AbstractAppl
    implements ITree {
        protected final IConstructor production;
        protected final boolean isMatchIgnorable;
        protected Type type = null;

        @Override
        public int getConcreteMatchFingerprint() {
            return 3000939 + 41 * this.production.hashCode();
        }

        @Override
        public <E extends Throwable> ITree accept(TreeVisitor<E> v) throws E {
            return v.visitTreeAppl(this);
        }

        protected AbstractAppl(IConstructor production) {
            this.production = production;
            this.isMatchIgnorable = ProductionAdapter.isLayout(production) || ProductionAdapter.isCILiteral(production) || ProductionAdapter.isLiteral(production);
        }

        @Override
        public IConstructor getProduction() {
            return this.production;
        }

        @Override
        public boolean isAppl() {
            return true;
        }

        @Override
        public String getName() {
            return Tree_Appl.getName();
        }

        @Override
        public Iterable<IValue> getChildren() {
            return this;
        }

        public int hashCode() {
            return 41 + 1331 * this.production.hashCode() + 13331 * this.getArgs().hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof IConstructor) {
                IConstructor cons = (IConstructor)other;
                return cons.getConstructorType() == this.getConstructorType() && cons.get(0).equals(this.get(0)) && cons.get(1).equals(this.get(1));
            }
            return false;
        }

        @Override
        public boolean match(IValue other) {
            if (this.isMatchIgnorable) {
                return true;
            }
            if (other instanceof IConstructor) {
                IConstructor cons = (IConstructor)other;
                return cons.getConstructorType() == this.getConstructorType() && cons.get(0).equals(this.get(0)) && cons.get(1).match(this.get(1));
            }
            return false;
        }

        @Override
        public abstract IList getArgs();

        @Override
        public Iterator<IValue> iterator() {
            return new Iterator<IValue>(){
                private int count = 0;

                @Override
                public boolean hasNext() {
                    return this.count < 2;
                }

                @Override
                public IValue next() {
                    ++this.count;
                    switch (this.count) {
                        case 1: {
                            return production;
                        }
                        case 2: {
                            return this.getArgs();
                        }
                    }
                    return null;
                }
            };
        }

        @Override
        public int arity() {
            return 2;
        }

        @Override
        public String toString() {
            return StandardTextWriter.valueToString(this);
        }

        @Override
        public INode replace(int first, int second, int end, IList repl) throws FactTypeUseException, IndexOutOfBoundsException {
            throw new UnsupportedOperationException("Replace not supported on constructor.");
        }

        @Override
        public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
            return v.visitConstructor(this);
        }

        @Override
        public boolean mayHaveKeywordParameters() {
            return true;
        }

        @Override
        public Type getType() {
            if (this.type == null) {
                this.type = RascalTypeFactory.getInstance().nonTerminalType(this);
            }
            return this.type;
        }

        @Override
        public Type getConstructorType() {
            return Tree_Appl;
        }

        @Override
        public Type getUninstantiatedConstructorType() {
            return Tree_Appl;
        }

        @Override
        public IValue get(String label) {
            switch (label) {
                case "prod": {
                    return this.production;
                }
                case "args": {
                    return this.getArgs();
                }
            }
            throw new UndeclaredFieldException(Tree_Appl, label);
        }

        @Override
        public ITree set(String label, IValue newChild) throws FactTypeUseException {
            switch (label) {
                case "prod": {
                    return RascalValueFactory.getInstance().appl((IConstructor)newChild, this.getArgs());
                }
                case "args": {
                    return RascalValueFactory.getInstance().appl(this.production, (IList)newChild);
                }
            }
            throw new UndeclaredFieldException(Tree_Appl, label);
        }

        @Override
        public boolean has(String label) {
            return Tree_Appl.hasField(label);
        }

        @Override
        public ITree set(int index, IValue newChild) throws FactTypeUseException {
            switch (index) {
                case 0: {
                    return RascalValueFactory.getInstance().appl((IConstructor)newChild, this.getArgs());
                }
                case 1: {
                    return RascalValueFactory.getInstance().appl(this.production, (IList)newChild);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Type getChildrenTypes() {
            return tf.tupleType(this.production.getType(), Args);
        }

        public IWithKeywordParameters<ITree> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<ITree>((ITree)this, AbstractSpecialisedImmutableMap.mapOf()){

                @Override
                protected ITree wrap(ITree content, Map.Immutable<String, IValue> parameters) {
                    return new ApplWithKeywordParametersFacade(content, parameters);
                }
            };
        }

        @Override
        public IValue get(int i) throws IndexOutOfBoundsException {
            switch (i) {
                case 0: {
                    return this.production;
                }
                case 1: {
                    return this.getArgs();
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }

    public static class CharWithKeywordParametersFacade
    extends ConstructorWithKeywordParametersFacade
    implements ITree {
        public CharWithKeywordParametersFacade(IConstructor content, Map.Immutable<String, IValue> parameters) {
            super(content, parameters);
        }

        @Override
        public int getConcreteMatchFingerprint() {
            return ((ITree)this.content).getConcreteMatchFingerprint();
        }

        @Override
        public <E extends Throwable> ITree accept(TreeVisitor<E> v) throws E {
            return v.visitTreeChar(this);
        }

        @Override
        public ITree set(String label, IValue newChild) throws FactTypeUseException {
            IConstructor newContent = this.content.set(label, newChild);
            return new CharWithKeywordParametersFacade(newContent, this.parameters);
        }

        @Override
        public ITree set(int index, IValue newChild) throws FactTypeUseException {
            IConstructor newContent = this.content.set(index, newChild);
            return new CharWithKeywordParametersFacade(newContent, this.parameters);
        }

        @Override
        public IWithKeywordParameters<? extends IConstructor> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<IConstructor>(this.content, this.parameters){

                @Override
                protected IConstructor wrap(IConstructor content, Map.Immutable<String, IValue> parameters) {
                    return parameters.isEmpty() ? content : new CharWithKeywordParametersFacade(content, parameters);
                }
            };
        }

        @Override
        public boolean isChar() {
            return true;
        }

        @Override
        public IInteger getCharacter() {
            return ((ITree)this.content).getCharacter();
        }
    }

    public static class CycleWithKeywordParametersFacade
    extends ConstructorWithKeywordParametersFacade
    implements ITree {
        public CycleWithKeywordParametersFacade(IConstructor content, Map.Immutable<String, IValue> parameters) {
            super(content, parameters);
        }

        @Override
        public int getConcreteMatchFingerprint() {
            return ((ITree)this.content).getConcreteMatchFingerprint();
        }

        @Override
        public <E extends Throwable> ITree accept(TreeVisitor<E> v) throws E {
            return v.visitTreeCycle(this);
        }

        @Override
        public ITree set(String label, IValue newChild) throws FactTypeUseException {
            IConstructor newContent = this.content.set(label, newChild);
            return new CycleWithKeywordParametersFacade(newContent, this.parameters);
        }

        @Override
        public ITree set(int index, IValue newChild) throws FactTypeUseException {
            IConstructor newContent = this.content.set(index, newChild);
            return new CycleWithKeywordParametersFacade(newContent, this.parameters);
        }

        @Override
        public IWithKeywordParameters<? extends IConstructor> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<IConstructor>(this.content, this.parameters){

                @Override
                protected IConstructor wrap(IConstructor content, Map.Immutable<String, IValue> parameters) {
                    return parameters.isEmpty() ? content : new CycleWithKeywordParametersFacade(content, parameters);
                }
            };
        }

        @Override
        public boolean isCycle() {
            return true;
        }
    }

    public static class AmbWithKeywordParametersFacade
    extends ConstructorWithKeywordParametersFacade
    implements ITree {
        public AmbWithKeywordParametersFacade(IConstructor content, Map.Immutable<String, IValue> parameters) {
            super(content, parameters);
        }

        @Override
        public int getConcreteMatchFingerprint() {
            return ((ITree)this.content).getConcreteMatchFingerprint();
        }

        @Override
        public <E extends Throwable> ITree accept(TreeVisitor<E> v) throws E {
            return v.visitTreeAmb(this);
        }

        @Override
        public ITree set(String label, IValue newChild) throws FactTypeUseException {
            IConstructor newContent = this.content.set(label, newChild);
            return new AmbWithKeywordParametersFacade(newContent, this.parameters);
        }

        @Override
        public ITree set(int index, IValue newChild) throws FactTypeUseException {
            IConstructor newContent = this.content.set(index, newChild);
            return new AmbWithKeywordParametersFacade(newContent, this.parameters);
        }

        @Override
        public IWithKeywordParameters<? extends IConstructor> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<IConstructor>(this.content, this.parameters){

                @Override
                protected IConstructor wrap(IConstructor content, Map.Immutable<String, IValue> parameters) {
                    return parameters.isEmpty() ? content : new AmbWithKeywordParametersFacade(content, parameters);
                }
            };
        }

        @Override
        public boolean isAmb() {
            return true;
        }

        @Override
        public ISet getAlternatives() {
            return ((ITree)this.content).getAlternatives();
        }
    }

    public static class ApplWithKeywordParametersFacade
    extends ConstructorWithKeywordParametersFacade
    implements ITree {
        public ApplWithKeywordParametersFacade(IConstructor content, Map.Immutable<String, IValue> parameters) {
            super(content, parameters);
        }

        @Override
        public int getConcreteMatchFingerprint() {
            return ((ITree)this.content).getConcreteMatchFingerprint();
        }

        @Override
        public <E extends Throwable> ITree accept(TreeVisitor<E> v) throws E {
            return v.visitTreeAppl(this);
        }

        @Override
        public ITree set(String label, IValue newChild) throws FactTypeUseException {
            IConstructor newContent = this.content.set(label, newChild);
            return new ApplWithKeywordParametersFacade(newContent, this.parameters);
        }

        @Override
        public ITree set(int index, IValue newChild) throws FactTypeUseException {
            IConstructor newContent = this.content.set(index, newChild);
            return new ApplWithKeywordParametersFacade(newContent, this.parameters);
        }

        @Override
        public IWithKeywordParameters<? extends IConstructor> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<IConstructor>(this.content, this.parameters){

                @Override
                protected IConstructor wrap(IConstructor content, Map.Immutable<String, IValue> parameters) {
                    return parameters.isEmpty() ? content : new ApplWithKeywordParametersFacade(content, parameters);
                }
            };
        }

        @Override
        public boolean isAppl() {
            return true;
        }

        @Override
        public IConstructor getProduction() {
            return ((ITree)this.content).getProduction();
        }

        @Override
        public IList getArgs() {
            return ((ITree)this.content).getArgs();
        }
    }

    private static class Amb
    implements ITree {
        protected final ISet alternatives;

        public Amb(ISet alts) {
            assert (alts.size() > 0);
            this.alternatives = alts;
        }

        @Override
        public int getConcreteMatchFingerprint() {
            if (this.alternatives.isEmpty()) {
                return 96694;
            }
            return 96694 + 43 * ((NonTerminalType)this.alternatives.getElementType()).getSymbol().hashCode();
        }

        @Override
        public boolean isAmb() {
            return true;
        }

        @Override
        public <E extends Throwable> ITree accept(TreeVisitor<E> v) throws E {
            return v.visitTreeAmb(this);
        }

        @Override
        public String getName() {
            return Tree_Amb.getName();
        }

        @Override
        public Iterable<IValue> getChildren() {
            return this;
        }

        public int hashCode() {
            return 43 + 751 * this.alternatives.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof Amb) {
                ITree cons = (ITree)other;
                return cons.getAlternatives().equals(this.alternatives);
            }
            return false;
        }

        @Override
        public boolean match(IValue other) {
            if (other instanceof Amb) {
                ITree cons = (ITree)other;
                return cons.getAlternatives().match(this.alternatives);
            }
            return false;
        }

        @Override
        public ISet getAlternatives() {
            return this.alternatives;
        }

        @Override
        public Iterator<IValue> iterator() {
            return new Iterator<IValue>(){
                private int count = 0;

                @Override
                public boolean hasNext() {
                    return this.count < 1;
                }

                @Override
                public IValue next() {
                    ++this.count;
                    switch (this.count) {
                        case 1: {
                            return this.getAlternatives();
                        }
                    }
                    return null;
                }
            };
        }

        @Override
        public int arity() {
            return 1;
        }

        @Override
        public String toString() {
            return StandardTextWriter.valueToString(this);
        }

        @Override
        public INode replace(int first, int second, int end, IList repl) throws FactTypeUseException, IndexOutOfBoundsException {
            throw new UnsupportedOperationException("Replace not supported on constructor.");
        }

        @Override
        public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
            return v.visitConstructor(this);
        }

        @Override
        public boolean mayHaveKeywordParameters() {
            return true;
        }

        @Override
        public Type getType() {
            if (!this.alternatives.isEmpty()) {
                return RascalTypeFactory.getInstance().nonTerminalType((IConstructor)this.alternatives.iterator().next());
            }
            return RascalTypeFactory.getInstance().nonTerminalType(IRascalValueFactory.getInstance().constructor(Symbol_Empty));
        }

        @Override
        public Type getConstructorType() {
            return Tree_Amb;
        }

        @Override
        public Type getUninstantiatedConstructorType() {
            return Tree_Amb;
        }

        @Override
        public IValue get(String label) {
            switch (label) {
                case "alternatives": {
                    return this.getAlternatives();
                }
            }
            throw new UndeclaredFieldException(Tree_Amb, label);
        }

        @Override
        public ITree set(String label, IValue newChild) throws FactTypeUseException {
            switch (label) {
                case "alternatives": {
                    return RascalValueFactory.getInstance().amb((ISet)newChild);
                }
            }
            throw new UndeclaredFieldException(Tree_Appl, label);
        }

        @Override
        public boolean has(String label) {
            return Tree_Amb.hasField(label);
        }

        @Override
        public ITree set(int index, IValue newChild) throws FactTypeUseException {
            switch (index) {
                case 0: {
                    return RascalValueFactory.getInstance().amb((ISet)newChild);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Type getChildrenTypes() {
            return tf.tupleType(Alternatives);
        }

        public IWithKeywordParameters<ITree> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<ITree>((ITree)this, AbstractSpecialisedImmutableMap.mapOf()){

                @Override
                protected ITree wrap(ITree content, Map.Immutable<String, IValue> parameters) {
                    return new AmbWithKeywordParametersFacade(content, parameters);
                }
            };
        }

        @Override
        public IValue get(int i) throws IndexOutOfBoundsException {
            switch (i) {
                case 0: {
                    return this.alternatives;
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }

    private static class Cycle
    implements ITree {
        protected final IConstructor symbol;
        protected final int cycleLength;

        public Cycle(IConstructor symbol, int cycleLength) {
            this.symbol = symbol;
            this.cycleLength = cycleLength;
        }

        @Override
        public int getConcreteMatchFingerprint() {
            return 95131878 + 13 * this.symbol.hashCode();
        }

        @Override
        public boolean isCycle() {
            return true;
        }

        @Override
        public <E extends Throwable> ITree accept(TreeVisitor<E> v) throws E {
            return v.visitTreeCycle(this);
        }

        @Override
        public String getName() {
            return Tree_Cycle.getName();
        }

        @Override
        public Iterable<IValue> getChildren() {
            return this;
        }

        public int hashCode() {
            return 17 + 19 * this.symbol.hashCode() + 29 * this.cycleLength;
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof IConstructor) {
                IConstructor cons = (IConstructor)other;
                return cons.getConstructorType() == this.getConstructorType() && cons.get(0).equals(this.get(0)) && ((IInteger)cons.get(1)).intValue() == this.cycleLength;
            }
            return false;
        }

        @Override
        public boolean match(IValue other) {
            return this.equals(other);
        }

        @Override
        public Iterator<IValue> iterator() {
            return new Iterator<IValue>(){
                private int count = 0;

                @Override
                public boolean hasNext() {
                    return this.count < 2;
                }

                @Override
                public IValue next() {
                    ++this.count;
                    switch (this.count) {
                        case 1: {
                            return symbol;
                        }
                        case 2: {
                            return RascalValueFactory.getInstance().integer(cycleLength);
                        }
                    }
                    return null;
                }
            };
        }

        @Override
        public int arity() {
            return 2;
        }

        @Override
        public String toString() {
            return StandardTextWriter.valueToString(this);
        }

        @Override
        public INode replace(int first, int second, int end, IList repl) throws FactTypeUseException, IndexOutOfBoundsException {
            throw new UnsupportedOperationException("Replace not supported on constructor.");
        }

        @Override
        public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
            return v.visitConstructor(this);
        }

        @Override
        public boolean mayHaveKeywordParameters() {
            return false;
        }

        @Override
        public Type getType() {
            return RascalTypeFactory.getInstance().nonTerminalType(this.symbol);
        }

        @Override
        public Type getConstructorType() {
            return Tree_Cycle;
        }

        @Override
        public Type getUninstantiatedConstructorType() {
            return Tree_Cycle;
        }

        @Override
        public IValue get(String label) {
            switch (label) {
                case "symbol": {
                    return this.symbol;
                }
                case "cycleLength": {
                    return RascalValueFactory.getInstance().integer(this.cycleLength);
                }
            }
            throw new UndeclaredFieldException(Tree_Amb, label);
        }

        @Override
        public IConstructor set(String label, IValue newChild) throws FactTypeUseException {
            switch (label) {
                case "symbol": {
                    return RascalValueFactory.getInstance().cycle((IConstructor)newChild, this.cycleLength);
                }
                case "cycleLength": {
                    return RascalValueFactory.getInstance().cycle(this.symbol, ((IInteger)newChild).intValue());
                }
            }
            throw new UndeclaredFieldException(Tree_Appl, label);
        }

        @Override
        public boolean has(String label) {
            return Tree_Cycle.hasField(label);
        }

        @Override
        public IConstructor set(int index, IValue newChild) throws FactTypeUseException {
            switch (index) {
                case 0: {
                    return RascalValueFactory.getInstance().cycle((IConstructor)newChild, this.cycleLength);
                }
                case 1: {
                    return RascalValueFactory.getInstance().cycle(this.symbol, ((IInteger)newChild).intValue());
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Type getChildrenTypes() {
            return tf.tupleType(Symbol, tf.integerType());
        }

        public IWithKeywordParameters<IConstructor> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<IConstructor>((IConstructor)this, AbstractSpecialisedImmutableMap.mapOf()){

                @Override
                protected IConstructor wrap(IConstructor content, Map.Immutable<String, IValue> parameters) {
                    return new CycleWithKeywordParametersFacade(content, parameters);
                }
            };
        }

        @Override
        public IValue get(int i) throws IndexOutOfBoundsException {
            switch (i) {
                case 0: {
                    return this.symbol;
                }
                case 1: {
                    return RascalValueFactory.getInstance().integer(this.cycleLength);
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }

    private static class CharByte
    implements ITree {
        final byte ch;

        public CharByte(byte ch) {
            this.ch = ch;
        }

        @Override
        public int getConcreteMatchFingerprint() {
            return 3052374 + this.ch;
        }

        @Override
        public boolean isChar() {
            return true;
        }

        @Override
        public INode setChildren(IValue[] childArray) {
            return this.set(0, childArray[0]);
        }

        @Override
        public <E extends Throwable> ITree accept(TreeVisitor<E> v) throws E {
            return v.visitTreeChar(this);
        }

        @Override
        public IValue get(int i) throws IndexOutOfBoundsException {
            switch (i) {
                case 0: {
                    return RascalValueFactory.getInstance().integer(this.ch);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int arity() {
            return 1;
        }

        @Override
        public String getName() {
            return Tree_Char.getName();
        }

        @Override
        public Iterable<IValue> getChildren() {
            return this;
        }

        public int hashCode() {
            return this.ch;
        }

        @Override
        public Iterator<IValue> iterator() {
            return new Iterator<IValue>(){
                boolean done = false;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public IValue next() {
                    this.done = true;
                    return RascalValueFactory.getInstance().integer(ch);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public String toString() {
            return StandardTextWriter.valueToString(this);
        }

        @Override
        public INode replace(int first, int second, int end, IList repl) throws FactTypeUseException, IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
            return v.visitConstructor(this);
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof CharByte) {
                CharByte o = (CharByte)other;
                return o.ch == this.ch;
            }
            return false;
        }

        @Override
        public boolean match(IValue other) {
            return this.equals(other);
        }

        @Override
        public boolean mayHaveKeywordParameters() {
            return true;
        }

        @Override
        public Type getType() {
            return byteCharTypes[this.ch];
        }

        @Override
        public Type getConstructorType() {
            return Tree_Char;
        }

        @Override
        public Type getUninstantiatedConstructorType() {
            return Tree_Char;
        }

        @Override
        public IValue get(String label) {
            return this.get(Tree_Char.getFieldIndex(label));
        }

        @Override
        public IConstructor set(String label, IValue newChild) throws FactTypeUseException {
            return this.set(Tree_Char.getFieldIndex(label), newChild);
        }

        @Override
        public boolean has(String label) {
            return Tree_Char.hasField(label);
        }

        @Override
        public IConstructor set(int index, IValue newChild) throws FactTypeUseException {
            switch (index) {
                case 0: {
                    return RascalValueFactory.getInstance().character(((IInteger)newChild).intValue());
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Type getChildrenTypes() {
            return tf.tupleType(tf.integerType());
        }

        public IWithKeywordParameters<ITree> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<ITree>((ITree)this, AbstractSpecialisedImmutableMap.mapOf()){

                @Override
                protected ITree wrap(ITree content, Map.Immutable<String, IValue> parameters) {
                    return new CharWithKeywordParametersFacade(content, parameters);
                }
            };
        }
    }

    static class CharInt
    implements ITree {
        final int ch;

        @Override
        public boolean isChar() {
            return true;
        }

        @Override
        public int getConcreteMatchFingerprint() {
            return 3052374 + this.ch;
        }

        @Override
        public INode setChildren(IValue[] childArray) {
            return this.set(0, childArray[0]);
        }

        @Override
        public <E extends Throwable> ITree accept(TreeVisitor<E> v) throws E {
            return v.visitTreeChar(this);
        }

        public CharInt(int ch) {
            this.ch = ch;
        }

        @Override
        public IValue get(int i) throws IndexOutOfBoundsException {
            switch (i) {
                case 0: {
                    return RascalValueFactory.getInstance().integer(this.ch);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int arity() {
            return 1;
        }

        @Override
        public String getName() {
            return Tree_Char.getName();
        }

        @Override
        public Iterable<IValue> getChildren() {
            return this;
        }

        public int hashCode() {
            return this.ch;
        }

        @Override
        public Iterator<IValue> iterator() {
            return new Iterator<IValue>(){
                boolean done = false;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public IValue next() {
                    this.done = true;
                    return RascalValueFactory.getInstance().integer(ch);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public INode replace(int first, int second, int end, IList repl) throws FactTypeUseException, IndexOutOfBoundsException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
            return v.visitConstructor(this);
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof CharInt) {
                CharInt o = (CharInt)other;
                return o.ch == this.ch;
            }
            return false;
        }

        @Override
        public boolean match(IValue other) {
            return this.equals(other);
        }

        @Override
        public boolean mayHaveKeywordParameters() {
            return true;
        }

        @Override
        public Type getType() {
            return RascalTypeFactory.getInstance().nonTerminalType(SymbolAdapter.charClass(this.ch));
        }

        @Override
        public Type getConstructorType() {
            return Tree_Char;
        }

        @Override
        public Type getUninstantiatedConstructorType() {
            return Tree_Char;
        }

        @Override
        public IValue get(String label) {
            return this.get(Tree_Char.getFieldIndex(label));
        }

        @Override
        public IConstructor set(String label, IValue newChild) throws FactTypeUseException {
            return this.set(Tree_Char.getFieldIndex(label), newChild);
        }

        @Override
        public boolean has(String label) {
            return Tree_Char.hasField(label);
        }

        @Override
        public IConstructor set(int index, IValue newChild) throws FactTypeUseException {
            switch (index) {
                case 0: {
                    return RascalValueFactory.getInstance().character(((IInteger)newChild).intValue());
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Type getChildrenTypes() {
            return tf.tupleType(tf.integerType());
        }

        public IWithKeywordParameters<ITree> asWithKeywordParameters() {
            return new AbstractDefaultWithKeywordParameters<ITree>((ITree)this, AbstractSpecialisedImmutableMap.mapOf()){

                @Override
                protected ITree wrap(ITree content, Map.Immutable<String, IValue> parameters) {
                    return new CharWithKeywordParametersFacade(content, parameters);
                }
            };
        }
    }

    private static class InstanceHolder {
        static final RascalValueFactory sInstance = new RascalValueFactory();

        private InstanceHolder() {
        }
    }
}

