/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.vallang.INode;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Iterator;

public interface IConstructor
extends INode {
    @Override
    default public int getMatchFingerprint() {
        return this.getName().hashCode() + 131 * this.arity();
    }

    public Type getConstructorType();

    public Type getUninstantiatedConstructorType();

    public IValue get(String var1);

    public IConstructor set(String var1, IValue var2);

    public boolean has(String var1);

    @Override
    public IConstructor set(int var1, IValue var2);

    public Type getChildrenTypes();

    public IWithKeywordParameters<? extends IConstructor> asWithKeywordParameters();

    @Override
    default public boolean match(IValue value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof IConstructor) {
            IConstructor otherTree = (IConstructor)value;
            if (this.getConstructorType() != otherTree.getConstructorType()) {
                return false;
            }
            Iterator<IValue> it1 = this.iterator();
            Iterator<IValue> it2 = otherTree.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (it1.next().match(it2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    default public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitConstructor(this);
    }

    public static boolean assertTypeCorrectConstructorApplication(Type cons, IValue[] children) {
        if (!1.$assertionsDisabled && cons.getArity() != children.length) {
            throw new AssertionError((Object)(cons + " has arity " + cons.getArity() + " while " + children.length + " arguments are provided."));
        }
        for (int i = 0; i < cons.getArity(); ++i) {
            if (!1.$assertionsDisabled && !children[i].getType().isSubtypeOf(cons.getFieldType(i))) {
                throw new AssertionError((Object)("Constructing " + cons + ", expected argument " + i + " of type " + cons.getFieldType(i) + " but got " + children[i].getType()));
            }
        }
        return true;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

