/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.visitors.IValueVisitor;
import org.checkerframework.checker.interning.qual.EqualsMethod;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ISet
extends ICollection<ISet> {
    @Override
    default public int getMatchFingerprint() {
        return 113762;
    }

    default public ISet insert(IValue element) {
        IWriter sw = this.writer();
        sw.insertAll(this);
        sw.insert(element);
        return (ISet)sw.done();
    }

    default public ISet delete(IValue elem) {
        IWriter w = this.writer();
        boolean deleted = false;
        for (IValue e : this) {
            if (!deleted && e.equals(elem)) {
                deleted = true;
                continue;
            }
            w.insert(e);
        }
        return (ISet)w.done();
    }

    @Override
    default public ISet product(ISet that) {
        IWriter w = this.writer();
        for (IValue t1 : this) {
            for (IValue t2 : that) {
                w.insertTuple(t1, t2);
            }
        }
        return (ISet)w.done();
    }

    @Override
    default public boolean match(IValue other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof ISet) {
            ISet set2 = (ISet)other;
            if (this.size() == set2.size()) {
                for (IValue v1 : this) {
                    if (set2.containsMatch(v1)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    default public ISet union(ISet that) {
        if (this == that) {
            return this;
        }
        if (this.isEmpty()) {
            return that;
        }
        if (that.isEmpty()) {
            return this;
        }
        IWriter w = this.writer();
        w.insertAll(this);
        w.insertAll(that);
        return (ISet)w.done();
    }

    default public ISet intersect(ISet that) {
        if (this == that) {
            return this;
        }
        if (this.isEmpty()) {
            return this;
        }
        if (that.isEmpty()) {
            return that;
        }
        IWriter w = this.writer();
        for (IValue v : this) {
            if (!that.contains(v)) continue;
            w.insert(v);
        }
        return (ISet)w.done();
    }

    default public ISet subtract(ISet that) {
        if (this == that) {
            return (ISet)this.writer().done();
        }
        if (this.isEmpty()) {
            return this;
        }
        if (that.isEmpty()) {
            return this;
        }
        IWriter sw = this.writer();
        for (IValue a : this) {
            if (that.contains(a)) continue;
            sw.insert(a);
        }
        return (ISet)sw.done();
    }

    public boolean contains(IValue var1);

    default public boolean containsMatch(IValue e) {
        for (IValue v : this) {
            if (!v.match(e)) continue;
            return true;
        }
        return false;
    }

    default public boolean isSubsetOf(ISet that) {
        for (IValue elem : this) {
            if (that.contains(elem)) continue;
            return false;
        }
        return true;
    }

    default public int defaultHashCode() {
        int hash = 0;
        for (IValue element : this) {
            hash ^= element.hashCode();
        }
        return hash;
    }

    @EqualsMethod
    default public boolean defaultEquals(@Nullable Object that) {
        if (that == this) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (that instanceof ISet) {
            ISet set2 = (ISet)that;
            if (this.getType() != set2.getType()) {
                return false;
            }
            if (this.hashCode() != set2.hashCode()) {
                return false;
            }
            if (this.size() == set2.size()) {
                for (IValue v1 : this) {
                    if (set2.contains(v1)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    default public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitSet(this);
    }

    @Override
    default public IRelation<ISet> asRelation() {
        if (!this.getType().isRelation()) {
            throw new UnsupportedOperationException(this.getType() + " is not a relation");
        }
        return new IRelation<ISet>(){

            public String toString() {
                return ISet.this.toString();
            }

            @Override
            public ISet asContainer() {
                return ISet.this;
            }
        };
    }
}

