/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BoolValue
implements IBool {
    static final BoolValue TRUE = new BoolValue(){

        @Override
        public boolean getValue() {
            return true;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public IBool not() {
            return FALSE;
        }

        @Override
        public IBool and(IBool other) {
            return other;
        }

        @Override
        public IBool or(IBool other) {
            return this;
        }

        @Override
        public IBool xor(IBool other) {
            return other == this ? FALSE : TRUE;
        }

        @Override
        public IBool implies(IBool other) {
            return other;
        }
    };
    static final BoolValue FALSE = new BoolValue(){

        @Override
        public boolean getValue() {
            return false;
        }

        @Override
        public IBool not() {
            return TRUE;
        }

        @Override
        public IBool and(IBool other) {
            return this;
        }

        @Override
        public IBool or(IBool other) {
            return other;
        }

        @Override
        public IBool xor(IBool other) {
            return other;
        }

        @Override
        public IBool implies(IBool other) {
            return TRUE;
        }

        @Override
        public int hashCode() {
            return 2;
        }
    };
    private static final Type BOOL_TYPE = TypeFactory.getInstance().boolType();

    private BoolValue() {
    }

    static BoolValue getBoolValue(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public abstract int hashCode();

    @Override
    public String toString() {
        return this.defaultToString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this == o;
    }

    @Override
    public Type getType() {
        return BOOL_TYPE;
    }

    @Override
    public IBool equivalent(IBool other) {
        return other == this ? TRUE : this;
    }

    @Override
    public String getStringRepresentation() {
        return this.toString();
    }
}

