/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.impl.persistent.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StringValue {
    private static final char NEWLINE = '\n';
    private static final Type STRING_TYPE = TypeFactory.getInstance().stringType();
    private static final int DEFAULT_MAX_FLAT_STRING = 512;
    private static int MAX_FLAT_STRING = 512;
    private static final int DEFAULT_MAX_UNBALANCE = 0;
    private static int MAX_UNBALANCE = 0;

    public static synchronized void setMaxFlatString(int maxFlatString) {
        MAX_FLAT_STRING = maxFlatString;
    }

    public static synchronized void resetMaxFlatString() {
        MAX_FLAT_STRING = 512;
    }

    public static synchronized void setMaxUnbalance(int maxUnbalance) {
        MAX_UNBALANCE = maxUnbalance;
    }

    public static synchronized void resetMaxUnbalance() {
        MAX_UNBALANCE = 0;
    }

    public static IString newString(String value) {
        if (value == null || value.isEmpty()) {
            return EmptyString.getInstance();
        }
        boolean containsSurrogatePairs = false;
        int count = 0;
        int len = value.length();
        char prev = '\u0000';
        for (int i = 0; i < len; ++i) {
            char cur = value.charAt(i);
            containsSurrogatePairs |= Character.isSurrogatePair(prev, cur);
            if (cur == '\n') {
                ++count;
            }
            prev = cur;
        }
        char last = value.charAt(len - 1);
        if (last != '\n') {
            ++count;
        }
        return StringValue.newString(value, containsSurrogatePairs, count);
    }

    public static IString newString(String value, boolean fullUnicode) {
        if (value == null || value.isEmpty()) {
            return EmptyString.getInstance();
        }
        int count = 0;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char cur = value.charAt(i);
            if (cur != '\n') continue;
            ++count;
        }
        char last = value.charAt(len - 1);
        if (last != '\n') {
            ++count;
        }
        return StringValue.newString(value, fullUnicode, count);
    }

    static IString newString(String value, boolean fullUnicode, int lineCount) {
        if (value == null || value.isEmpty()) {
            return EmptyString.getInstance();
        }
        if (fullUnicode) {
            return new FullUnicodeString(value, lineCount);
        }
        return new SimpleUnicodeString(value, lineCount);
    }

    public static class IndentationBenchmarkTool {
        private static IValueFactory vf = ValueFactory.getInstance();
        private static ThreadMXBean bean = ManagementFactory.getThreadMXBean();

        public static void main(String[] args) throws IOException {
            long afterBuild;
            IString value;
            long start;
            long lazyTime = 0L;
            long eagerTime = 0L;
            boolean runLazy = true;
            boolean runEager = true;
            IndentationBenchmarkTool.warmup();
            if (runLazy) {
                System.err.println("Benchmarking lazy implementation... press enter");
                System.in.read();
                start = bean.getCurrentThreadCpuTime();
                value = IndentationBenchmarkTool.buildLargeLazyValue();
                afterBuild = bean.getCurrentThreadCpuTime();
                System.err.println("LAZY BUILD        :" + Duration.of(afterBuild - start, ChronoUnit.NANOS).toString());
                for (int i = 0; i < 100; ++i) {
                    value.write(new NullWriter());
                }
                long afterWrite = bean.getCurrentThreadCpuTime();
                lazyTime = afterWrite - start;
                System.err.println("LAZY         WRITE:" + Duration.of(afterWrite - afterBuild, ChronoUnit.NANOS).toString());
                System.err.println("LAZY BUILD + WRITE:" + Duration.of(afterWrite - start, ChronoUnit.NANOS).toString());
                System.err.println("STRING LENGTH      :" + value.length());
                value = null;
                System.gc();
            }
            if (runEager) {
                System.err.println("Benchmarking eager implementation... press enter");
                System.in.read();
                start = bean.getCurrentThreadCpuTime();
                value = IndentationBenchmarkTool.buildLargeEagerValue();
                afterBuild = bean.getCurrentThreadCpuTime();
                System.err.println("EAGER BUILD        :" + Duration.of(afterBuild - start, ChronoUnit.NANOS).toString());
                for (int i = 0; i < 100; ++i) {
                    value.write(new NullWriter());
                }
                long afterWrite = bean.getCurrentThreadCpuTime();
                eagerTime = afterWrite - start;
                System.err.println("EAGER         WRITE:" + Duration.of(afterWrite - afterBuild, ChronoUnit.NANOS).toString());
                System.err.println("EAGER BUILD + WRITE:" + Duration.of(eagerTime, ChronoUnit.NANOS).toString());
                System.err.println("STRING LENGTH      :" + value.length());
                value = null;
                System.gc();
            }
            if (runEager && runLazy) {
                System.err.println("LAZY is " + Math.round((double)lazyTime * 1.0 / ((double)eagerTime * 1.0) * 100.0) + "% of EAGER\n\n");
            }
        }

        private static void warmup() throws IOException {
            for (int i = 0; i < 5; ++i) {
                IndentationBenchmarkTool.buildLargeLazyValue().write(new NullWriter());
            }
            System.gc();
        }

        private static IString buildLargeEagerValue() {
            IString ws = vf.string("    ");
            IString base = vf.string("if ( .. ) then if while bla bla bla aap noot mies x { ... } \n");
            IString result = vf.string("");
            for (int l = 0; l < 5; ++l) {
                IString outer2 = vf.string("");
                for (int k = 0; k < 100; ++k) {
                    IString outer = vf.string("");
                    for (int j = 0; j < 100; ++j) {
                        IString block = base;
                        for (int i = 0; i < 100; ++i) {
                            block = block.concat(StringValue.newString(base.indent(ws, true).getValue()));
                        }
                        outer = outer.concat(StringValue.newString(block.indent(ws, true).getValue()));
                    }
                    outer2 = outer2.concat(StringValue.newString(outer.indent(ws, true).getValue()));
                }
                result = result.concat(StringValue.newString(outer2.indent(ws, true).getValue()));
            }
            return result;
        }

        private static IString buildLargeLazyValue() {
            IString ws = vf.string("    ");
            IString base = vf.string("if ( .. ) then if while bla bla bla aap noot mies x { ... } \n");
            IString result = vf.string("");
            for (int l = 0; l < 5; ++l) {
                IString outer2 = vf.string("");
                for (int k = 0; k < 100; ++k) {
                    IString outer = vf.string("");
                    for (int j = 0; j < 100; ++j) {
                        IString block = base;
                        for (int i = 0; i < 100; ++i) {
                            block = block.concat(base.indent(ws, true));
                        }
                        outer = outer.concat(block.indent(ws, true));
                    }
                    outer2 = outer2.concat(outer.indent(ws, true));
                }
                result = result.concat(outer2.indent(ws, true));
            }
            return result;
        }

        private static class NullWriter
        extends Writer {
            private NullWriter() {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
            }

            @Override
            public void write(String str) throws IOException {
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
            }

            @Override
            public void write(char[] cbuf) throws IOException {
            }

            @Override
            public void write(int c) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }
    }

    private static class IndentedString
    extends AbstractString {
        private final IString indent;
        private final AbstractString wrapped;
        private final boolean indentFirstLine;
        private volatile @MonotonicNonNull AbstractString flattened = null;

        IndentedString(AbstractString istring, IString whiteSpace, boolean indentFirstLine) {
            assert (istring != null && whiteSpace != null);
            this.indent = whiteSpace;
            this.wrapped = istring;
            this.indentFirstLine = indentFirstLine;
        }

        @Override
        protected boolean hasNonBMPCodePoints() {
            if (this.flattened != null) {
                return this.flattened.hasNonBMPCodePoints();
            }
            return this.wrapped.hasNonBMPCodePoints();
        }

        @Override
        public IString concat(IString other) {
            if (other.length() == 0) {
                return this;
            }
            if (this.flattened != null) {
                return LazyConcatString.build(this.flattened, (AbstractString)other);
            }
            if (other instanceof IndentedString) {
                IndentedString o = (IndentedString)other;
                if (o.indent != null && o.wrapped != null && o.indent.equals(this.indent)) {
                    return LazyConcatString.build(this.wrapped, o.wrapped).indent(this.indent, this.indentFirstLine);
                }
            }
            return LazyConcatString.build(this, (AbstractString)other);
        }

        @Override
        public IString indent(IString indent, boolean indentFirstLine) {
            assert (!indent.getValue().contains("\n") && !indent.getValue().contains("\r"));
            if (indent.length() == 0) {
                return this;
            }
            if (this.flattened != null) {
                return new IndentedString(this.flattened, indent, indentFirstLine);
            }
            return new IndentedString(this.wrapped, indent.concat(this.indent), indentFirstLine);
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            if (this.flattened != null) {
                return this.flattened.iterator();
            }
            return new PrimitiveIterator.OfInt(){
                final PrimitiveIterator.OfInt content;
                PrimitiveIterator.OfInt nextIndentation;
                {
                    this.content = wrapped.iterator();
                    this.nextIndentation = indentFirstLine ? indent.iterator() : EmptyString.getInstance().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.content.hasNext();
                }

                @Override
                public int nextInt() {
                    if (this.nextIndentation.hasNext()) {
                        return this.nextIndentation.nextInt();
                    }
                    int cur = this.content.nextInt();
                    if (cur == 10) {
                        this.nextIndentation = indent.iterator();
                    }
                    return cur;
                }
            };
        }

        @Override
        public Iterator<CharBuffer> iterateParts() {
            if (this.flattened != null) {
                return this.flattened.iterateParts();
            }
            final CharBuffer indentBuffer = CharBuffer.wrap(this.indent.getValue());
            return new Iterator<CharBuffer>(){
                final Iterator<CharBuffer> content;
                CharBuffer active;
                boolean indentNext;
                {
                    this.content = wrapped.iterateParts();
                    this.active = CharBuffer.allocate(0);
                    this.indentNext = indentFirstLine;
                }

                @Override
                public boolean hasNext() {
                    return this.indentNext || this.content.hasNext() || this.active.hasRemaining();
                }

                private CharBuffer nextTillNewlineOrEndOfBuffer() {
                    int cur;
                    int start = this.active.position();
                    int end = start + this.active.remaining();
                    for (cur = start; cur < end; ++cur) {
                        if (this.active.get(cur) != '\n') continue;
                        ++cur;
                        this.indentNext = true;
                        break;
                    }
                    if (cur != end) {
                        CharBuffer result = this.active.duplicate();
                        result.limit(cur);
                        this.active.position(cur);
                        return result;
                    }
                    CharBuffer result = this.active;
                    if (this.content.hasNext()) {
                        this.active = this.content.next();
                    } else {
                        this.indentNext = false;
                        this.active = CharBuffer.allocate(0);
                    }
                    return result;
                }

                @Override
                public CharBuffer next() {
                    if (this.indentNext) {
                        this.indentNext = false;
                        return indentBuffer.asReadOnlyBuffer();
                    }
                    return this.nextTillNewlineOrEndOfBuffer();
                }
            };
        }

        @Override
        public IString reverse() {
            return this.applyIndentation().reverse();
        }

        private IString applyIndentation() {
            if (this.flattened == null) {
                this.flattened = (AbstractString)StringValue.newString(this.getValue());
            }
            return this.flattened;
        }

        @Override
        public IString substring(int start, int end) {
            return this.applyIndentation().substring(start, end);
        }

        @Override
        public int charAt(int index) {
            return this.applyIndentation().charAt(index);
        }

        @Override
        public IString replace(int first, int second, int end, IString repl) {
            return this.applyIndentation().replace(first, second, end, repl);
        }

        @Override
        public void write(Writer w) throws IOException {
            if (this.flattened != null) {
                this.flattened.write(w);
                return;
            }
            ArrayDeque<IString> indents = new ArrayDeque<IString>(10);
            indents.push(this.indent);
            this.wrapped.indentedWrite(w, indents, this.indentFirstLine);
            indents.pop();
            assert (indents.isEmpty());
        }

        @Override
        public void indentedWrite(Writer w, Deque<IString> whitespace, boolean indentFirstLine) throws IOException {
            if (this.flattened != null) {
                this.flattened.indentedWrite(w, whitespace, indentFirstLine);
                return;
            }
            whitespace.push(this.indent);
            this.wrapped.indentedWrite(w, whitespace, indentFirstLine);
            whitespace.pop();
        }

        @Override
        public int length() {
            if (this.flattened != null) {
                return this.flattened.length();
            }
            return this.wrapped.length() + (this.wrapped.lineCount() - (this.indentFirstLine ? 0 : 1)) * this.indent.length();
        }

        @Override
        public int lineCount() {
            if (this.flattened != null) {
                return this.flattened.lineCount();
            }
            return this.wrapped.lineCount();
        }

        @Override
        public boolean isNewlineTerminated() {
            if (this.flattened != null) {
                return this.flattened.isNewlineTerminated();
            }
            return this.wrapped.isNewlineTerminated();
        }
    }

    private static class LazyConcatString
    extends AbstractString {
        private final AbstractString left;
        private final AbstractString right;
        private final int length;
        private final int depth;
        private final int lineCount;
        private final boolean terminated;
        private int hash = 0;

        public static IStringTreeNode build(AbstractString left, AbstractString right) {
            assert (left.invariant());
            assert (right.invariant());
            AbstractString result = LazyConcatString.balance(left, right);
            assert (result.invariant());
            assert (result.left().invariant());
            assert (result.right().invariant());
            return result;
        }

        @Override
        public IString concat(IString other) {
            if (other.length() == 0) {
                return this;
            }
            return LazyConcatString.build(this, (AbstractString)other);
        }

        @Override
        protected boolean hasNonBMPCodePoints() {
            return this.left.hasNonBMPCodePoints() || this.right.hasNonBMPCodePoints();
        }

        @Override
        public int hashCode() {
            if (this.hash == 0) {
                this.hash = this.right.hashCode(this.left.hashCode());
            }
            return this.hash;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return super.equals(other);
        }

        private static AbstractString balance(AbstractString left, AbstractString right) {
            AbstractString result = new LazyConcatString(left, right);
            while (result.balanceFactor() - 1 > MAX_UNBALANCE) {
                if (result.right().balanceFactor() < 0) {
                    result = result.rotateRightLeft();
                    continue;
                }
                result = result.rotateLeft();
            }
            while (result.balanceFactor() + 1 < -MAX_UNBALANCE) {
                if (result.left().balanceFactor() > 0) {
                    result = result.rotateLeftRight();
                    continue;
                }
                result = result.rotateRight();
            }
            return result;
        }

        private LazyConcatString(AbstractString left, AbstractString right) {
            this.left = left;
            this.right = right;
            this.length = left.length() + right.length();
            this.depth = Math.max(left.depth(), right.depth()) + 1;
            this.lineCount = IIndentableString.concatLineCount(left, right);
            this.terminated = right.isNewlineTerminated();
        }

        @Override
        public int lineCount() {
            return this.lineCount;
        }

        @Override
        public boolean isNewlineTerminated() {
            return this.terminated;
        }

        @Override
        public IString reverse() {
            return this.right.reverse().concat(this.left.reverse());
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public AbstractString left() {
            return this.left;
        }

        @Override
        public AbstractString right() {
            return this.right;
        }

        @Override
        public int balanceFactor() {
            return this.right().depth() - this.left().depth();
        }

        @Override
        public int depth() {
            return this.depth;
        }

        @Override
        public IString substring(int start, int end) {
            assert (end >= start);
            if (end <= this.left.length()) {
                return this.left.substring(start, end);
            }
            if (start >= this.left.length()) {
                return this.right.substring(start - this.left.length(), end - this.left.length());
            }
            return this.left.substring(start, this.left.length()).concat(this.right.substring(0, end - this.left.length()));
        }

        @Override
        public int charAt(int index) {
            if (index < this.left.length()) {
                return this.left.charAt(index);
            }
            return this.right.charAt(index - this.left.length());
        }

        @Override
        public IString replace(int first, int second, int end, IString repl) {
            if (end < this.left.length()) {
                return this.left.replace(first, second, end, repl).concat(this.right);
            }
            if (first >= this.left.length()) {
                return this.left.concat(this.right.replace(first - this.left.length(), second - this.left.length(), end - this.left.length(), repl));
            }
            return this.left.replace(first, second, this.left.length(), repl).concat(this.right.replace(0, second - this.left.length(), end - this.left.length(), repl));
        }

        @Override
        public void write(Writer w) throws IOException {
            this.left.write(w);
            this.right.write(w);
        }

        @Override
        public void indentedWrite(Writer w, Deque<IString> whitespace, boolean indentFirstLine) throws IOException {
            this.left.indentedWrite(w, whitespace, indentFirstLine);
            this.right.indentedWrite(w, whitespace, this.left.isNewlineTerminated());
        }

        @Override
        public AbstractString rotateRight() {
            LazyConcatString p = new LazyConcatString(this.left().right(), this.right());
            p = (LazyConcatString)LazyConcatString.balance(p.left, p.right);
            return new LazyConcatString(this.left().left(), p);
        }

        @Override
        public AbstractString rotateLeft() {
            LazyConcatString p = new LazyConcatString(this.left(), this.right().left());
            return new LazyConcatString(LazyConcatString.balance(p.left, p.right), this.right().right());
        }

        @Override
        public AbstractString rotateRightLeft() {
            LazyConcatString rotateRight = new LazyConcatString(this.left(), this.right().rotateRight());
            return rotateRight.rotateLeft();
        }

        @Override
        public AbstractString rotateLeftRight() {
            LazyConcatString rotateLeft = new LazyConcatString(this.left().rotateLeft(), this.right());
            return rotateLeft.rotateRight();
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return new PrimitiveIterator.OfInt(){
                final InOrderIterator<PrimitiveIterator.OfInt> it;
                {
                    this.it = new InOrderIterator<PrimitiveIterator.OfInt>(IString::iterator);
                }

                @Override
                public boolean hasNext() {
                    return this.it.getActive().hasNext();
                }

                @Override
                public int nextInt() {
                    return this.it.getActive().nextInt();
                }
            };
        }

        @Override
        public Iterator<CharBuffer> iterateParts() {
            return new Iterator<CharBuffer>(){
                final InOrderIterator<Iterator<CharBuffer>> it;
                {
                    this.it = new InOrderIterator<Iterator>(IStringTreeNode::iterateParts);
                }

                @Override
                public boolean hasNext() {
                    return this.it.getActive().hasNext();
                }

                @Override
                public CharBuffer next() {
                    return this.it.getActive().next();
                }
            };
        }

        private static IStringTreeNode leftmostLeaf(Deque<AbstractString> todo, IStringTreeNode start) {
            IStringTreeNode cur = start;
            while (cur.depth() > 1) {
                todo.push(cur.right());
                cur = cur.left();
            }
            return cur;
        }

        private class InOrderIterator<T extends Iterator<?>> {
            private final Deque<AbstractString> todo;
            private final Function<IStringTreeNode, T> getActualIterator;
            private T activeIterator;

            InOrderIterator(Function<IStringTreeNode, T> getActualIterator) {
                this.getActualIterator = getActualIterator;
                this.todo = new ArrayDeque<AbstractString>(LazyConcatString.this.depth);
                this.activeIterator = (Iterator)((Object)getActualIterator.apply(LazyConcatString.leftmostLeaf(this.todo, LazyConcatString.this)));
            }

            T getActive() {
                while (!this.activeIterator.hasNext() && !this.todo.isEmpty()) {
                    this.activeIterator = (Iterator)this.getActualIterator.apply(LazyConcatString.leftmostLeaf(this.todo, this.todo.pop()));
                }
                return this.activeIterator;
            }
        }
    }

    private static abstract class AbstractString
    implements IString,
    IStringTreeNode,
    IIndentableString {
        private AbstractString() {
        }

        @Override
        public String toString() {
            return this.defaultToString();
        }

        @Override
        public Type getType() {
            return STRING_TYPE;
        }

        @Override
        public IString indent(IString whitespace, boolean indentFirstLine) {
            assert (!whitespace.getValue().contains("\n") && !whitespace.getValue().contains("\r"));
            if (whitespace.length() == 0) {
                return this;
            }
            if (!indentFirstLine && this.lineCount() <= 1) {
                return this;
            }
            return new IndentedString(this, whitespace, indentFirstLine);
        }

        @Override
        public String getValue() {
            String string;
            int len = this.length();
            StringWriter w = new StringWriter(len + len / 10);
            try {
                this.write(w);
                string = w.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return "";
                }
            }
            w.close();
            return string;
        }

        @Override
        public IString substring(int start) {
            return this.substring(start, this.length());
        }

        @Override
        public int compare(IString other) {
            PrimitiveIterator.OfInt it1 = this.iterator();
            PrimitiveIterator.OfInt it2 = other.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                int c2;
                int c1 = it1.nextInt();
                int diff = c1 - (c2 = it2.nextInt());
                if (diff == 0) continue;
                return diff < 0 ? -1 : 1;
            }
            int result = this.length() - other.length();
            if (result == 0) {
                return 0;
            }
            if (result < 0) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof AbstractString)) {
                return false;
            }
            AbstractString o = (AbstractString)other;
            if (o.length() != this.length()) {
                return false;
            }
            if (o.lineCount() != this.lineCount()) {
                return false;
            }
            PrimitiveIterator.OfInt it1 = this.iterator();
            PrimitiveIterator.OfInt it2 = o.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                int c2;
                int c1 = it1.nextInt();
                if (c1 == (c2 = it2.nextInt())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode(0);
        }

        protected final int hashCode(int prefixCode) {
            int h2 = prefixCode;
            PrimitiveIterator.OfInt it = this.iterator();
            while (it.hasNext()) {
                int c = it.nextInt();
                if (!Character.isBmpCodePoint(c)) {
                    h2 = 31 * h2 + Character.highSurrogate(c);
                    h2 = 31 * h2 + Character.lowSurrogate(c);
                    continue;
                }
                h2 = 31 * h2 + (char)c;
            }
            return h2;
        }

        abstract boolean hasNonBMPCodePoints();

        @Override
        public abstract Iterator<CharBuffer> iterateParts();

        @Override
        public Reader asReader() {
            return new Reader(){
                final Iterator<CharBuffer> parts;
                CharBuffer currentBuffer;
                {
                    this.parts = this.iterateParts();
                    this.currentBuffer = CharBuffer.allocate(0);
                }

                private CharBuffer getBuffer() {
                    CharBuffer actualBuffer = this.currentBuffer;
                    while (!actualBuffer.hasRemaining()) {
                        if (!this.parts.hasNext()) {
                            return actualBuffer;
                        }
                        actualBuffer = this.currentBuffer = this.parts.next();
                    }
                    return actualBuffer;
                }

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    CharBuffer actualBuffer;
                    if (off < 0 || len < 0 || len > cbuf.length + off) {
                        throw new IndexOutOfBoundsException();
                    }
                    CharBuffer target = CharBuffer.wrap(cbuf, off, len);
                    while (target.hasRemaining() && (actualBuffer = this.getBuffer()).hasRemaining()) {
                        actualBuffer.read(target);
                    }
                    return target.position() == off ? -1 : len - target.remaining();
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    private static interface IStringTreeNode
    extends IString {
        default public int depth() {
            return 1;
        }

        default public boolean invariant() {
            return Math.abs(this.balanceFactor()) - 1 <= MAX_UNBALANCE;
        }

        default public int balanceFactor() {
            return 0;
        }

        default public AbstractString left() {
            throw new UnsupportedOperationException();
        }

        default public AbstractString right() {
            throw new UnsupportedOperationException();
        }

        default public AbstractString rotateRight() {
            return (AbstractString)this;
        }

        default public AbstractString rotateLeft() {
            return (AbstractString)this;
        }

        default public AbstractString rotateRightLeft() {
            return (AbstractString)this;
        }

        default public AbstractString rotateLeftRight() {
            return (AbstractString)this;
        }

        public Iterator<CharBuffer> iterateParts();
    }

    private static interface IIndentableString
    extends IString {
        public int lineCount();

        default public boolean isNewlineTerminated() {
            return this.length() != 0 && this.charAt(this.length() - 1) == 10;
        }

        public static int concatLineCount(IIndentableString left, IIndentableString right) {
            return left.lineCount() - (left.isNewlineTerminated() ? 0 : 1) + right.lineCount();
        }

        default public void indentedWrite(Writer w, Deque<IString> indentStack, boolean indentFirstLine) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class SimpleUnicodeString
    extends FullUnicodeString {
        public SimpleUnicodeString(String value, int lineCount) {
            super(value, lineCount);
        }

        @Override
        protected boolean hasNonBMPCodePoints() {
            return false;
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public int charAt(int index) {
            return this.value.charAt(index);
        }

        @Override
        public IString substring(int start, int end) {
            return StringValue.newString(this.value.substring(start, end), false);
        }

        @Override
        public IString reverse() {
            return StringValue.newString(new StringBuilder(this.value).reverse().toString(), false, this.lineCount);
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return new PrimitiveIterator.OfInt(){
                private int cur = 0;

                @Override
                public boolean hasNext() {
                    return this.cur < value.length();
                }

                @Override
                public int nextInt() {
                    return value.charAt(this.cur++);
                }
            };
        }

        @Override
        public Reader asReader() {
            return new StringReader(this.value);
        }

        @Override
        public Iterator<CharBuffer> iterateParts() {
            return Collections.singleton(CharBuffer.wrap(this.value)).iterator();
        }
    }

    private static class FullUnicodeString
    extends AbstractString {
        protected final String value;
        protected final int lineCount;

        private FullUnicodeString(String value, int lineCount) {
            this.value = value;
            this.lineCount = lineCount;
        }

        @Override
        protected boolean hasNonBMPCodePoints() {
            return true;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isNewlineTerminated() {
            return this.value.isEmpty() ? false : this.value.charAt(this.value.length() - 1) == '\n';
        }

        @Override
        public int lineCount() {
            return this.lineCount;
        }

        @Override
        public IString concat(IString other) {
            int newLineCount;
            if (other.length() == 0) {
                return this;
            }
            AbstractString o = (AbstractString)other;
            if (this.length() + other.length() <= MAX_FLAT_STRING && (newLineCount = IIndentableString.concatLineCount(this, o)) <= 1) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(this.getValue());
                buffer.append(other.getValue());
                return StringValue.newString(buffer.toString(), this.hasNonBMPCodePoints() || o.hasNonBMPCodePoints(), newLineCount);
            }
            return LazyConcatString.build(this, (AbstractString)other);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return super.equals(other);
        }

        @Override
        public IString reverse() {
            return StringValue.newString(new StringBuilder(this.value).reverse().toString(), true, this.lineCount);
        }

        @Override
        public int length() {
            return this.value.codePointCount(0, this.value.length());
        }

        @Override
        public IString substring(int start, int end) {
            return StringValue.newString(this.value.substring(this.value.offsetByCodePoints(0, start), this.value.offsetByCodePoints(0, end)));
        }

        @Override
        public IString substring(int start) {
            return StringValue.newString(this.value.substring(this.value.offsetByCodePoints(0, start)));
        }

        @Override
        public int charAt(int index) {
            return this.value.codePointAt(this.value.offsetByCodePoints(0, index));
        }

        private int nextCP(CharBuffer cbuf) {
            int cp = Character.codePointAt(cbuf, 0);
            CharBuffer buffer = cbuf;
            if (buffer.position() < buffer.capacity()) {
                ((Buffer)buffer).position(buffer.position() + Character.charCount(cp));
            }
            return cp;
        }

        private void skipCP(CharBuffer cbuf) {
            if (cbuf.hasRemaining()) {
                CharBuffer buffer = cbuf;
                int cp = Character.codePointAt(cbuf, 0);
                ((Buffer)buffer).position(buffer.position() + Character.charCount(cp));
            }
        }

        @Override
        public IString replace(int first, int second, int end, IString repl) {
            int valueIndex;
            StringBuilder buffer = new StringBuilder();
            int valueLen = this.value.codePointCount(0, this.value.length());
            int replLen = repl.length();
            CharBuffer replBuf = CharBuffer.wrap(repl.getValue());
            int increment = Math.abs(second - first);
            if (first <= end) {
                CharBuffer valueBuf = CharBuffer.wrap(this.value);
                for (valueIndex = 0; valueIndex < first; ++valueIndex) {
                    buffer.appendCodePoint(this.nextCP(valueBuf));
                }
                int replIndex = 0;
                boolean wrapped = false;
                while (valueIndex < end) {
                    buffer.appendCodePoint(this.nextCP(replBuf));
                    if (++replIndex == replLen) {
                        ((Buffer)replBuf).position(0);
                        replIndex = 0;
                        wrapped = true;
                    }
                    this.skipCP(valueBuf);
                    ++valueIndex;
                    for (int j = 1; j < increment && valueIndex < end; ++valueIndex, ++j) {
                        buffer.appendCodePoint(this.nextCP(valueBuf));
                    }
                }
                if (!wrapped) {
                    while (replIndex < replLen) {
                        buffer.appendCodePoint(this.nextCP(replBuf));
                        ++replIndex;
                    }
                }
                while (valueIndex < valueLen) {
                    buffer.appendCodePoint(this.nextCP(valueBuf));
                    ++valueIndex;
                }
            } else {
                CharBuffer valueBuf = CharBuffer.wrap(new StringBuilder(this.value).reverse().toString());
                for (valueIndex = valueLen - 1; valueIndex > first; --valueIndex) {
                    buffer.appendCodePoint(this.nextCP(valueBuf));
                }
                int replIndex = 0;
                boolean wrapped = false;
                while (valueIndex > end) {
                    buffer.appendCodePoint(this.nextCP(replBuf));
                    if (++replIndex == repl.length()) {
                        ((Buffer)replBuf).position(0);
                        replIndex = 0;
                        wrapped = true;
                    }
                    this.skipCP(valueBuf);
                    --valueIndex;
                    for (int j = 1; j < increment && valueIndex > end; --valueIndex, ++j) {
                        buffer.appendCodePoint(this.nextCP(valueBuf));
                    }
                }
                if (!wrapped) {
                    while (replIndex < replLen) {
                        buffer.appendCodePoint(this.nextCP(replBuf));
                        ++replIndex;
                    }
                }
                while (valueIndex >= 0) {
                    buffer.appendCodePoint(this.nextCP(valueBuf));
                    --valueIndex;
                }
                buffer.reverse();
            }
            String res = buffer.toString();
            return StringValue.newString(res);
        }

        @Override
        public void write(Writer w) throws IOException {
            w.write(this.value);
        }

        @Override
        public Reader asReader() {
            return new StringReader(this.value);
        }

        @Override
        public void indentedWrite(Writer w, Deque<IString> whitespace, boolean indentFirstLine) throws IOException {
            if (this.value.isEmpty()) {
                return;
            }
            if (indentFirstLine) {
                this.writeWhitespace(w, whitespace);
            }
            if (this.lineCount <= 1) {
                w.write(this.value);
                return;
            }
            int pos = this.value.indexOf(10);
            int next = 0;
            while (true) {
                if (pos == -1) {
                    if (next != this.value.length()) {
                        w.write(this.value, next, this.value.length() - next);
                    }
                    return;
                }
                w.write(this.value, next, pos - next + 1);
                if (pos < this.value.length() - 1) {
                    this.writeWhitespace(w, whitespace);
                }
                next = pos + 1;
                pos = this.value.indexOf(10, next);
            }
        }

        private void writeWhitespace(Writer w, Deque<IString> whitespace) throws IOException {
            Iterator<IString> it = whitespace.descendingIterator();
            while (it.hasNext()) {
                it.next().write(w);
            }
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return new PrimitiveIterator.OfInt(){
                int cur = 0;

                @Override
                public boolean hasNext() {
                    return this.cur < value.length();
                }

                @Override
                public int nextInt() {
                    char c2;
                    char c1;
                    int length = value.length();
                    String val = value;
                    if (this.cur >= length) {
                        throw new NoSuchElementException();
                    }
                    if (Character.isHighSurrogate(c1 = val.charAt(this.cur++)) && this.cur < length && Character.isLowSurrogate(c2 = val.charAt(this.cur))) {
                        ++this.cur;
                        return Character.toCodePoint(c1, c2);
                    }
                    return c1;
                }
            };
        }

        @Override
        public Iterator<CharBuffer> iterateParts() {
            return Collections.singleton(CharBuffer.wrap(this.value)).iterator();
        }
    }

    private static class EmptyString
    extends AbstractString {
        public static EmptyString getInstance() {
            return InstanceHolder.instance;
        }

        private EmptyString() {
        }

        @Override
        boolean hasNonBMPCodePoints() {
            return false;
        }

        @Override
        public String getValue() {
            return "";
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other == this;
        }

        @Override
        public IString reverse() {
            return this;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public IString substring(int start, int end) {
            if (start == 0 && end == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int charAt(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IString replace(int first, int second, int end, IString repl) {
            if (first == 0 && end == 0) {
                return repl;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void write(Writer w) throws IOException {
        }

        @Override
        public void indentedWrite(Writer w, Deque<IString> whiteSpace, boolean indentFirstLine) {
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return new PrimitiveIterator.OfInt(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public int nextInt() {
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public IString indent(IString whitespace, boolean indentFirstLine) {
            return !indentFirstLine ? this : whitespace;
        }

        @Override
        public int lineCount() {
            return 0;
        }

        @Override
        public boolean isNewlineTerminated() {
            return false;
        }

        @Override
        public IString concat(IString other) {
            return other;
        }

        @Override
        public Reader asReader() {
            return Reader.nullReader();
        }

        @Override
        public Iterator<CharBuffer> iterateParts() {
            return Collections.emptyIterator();
        }

        private static class InstanceHolder {
            public static EmptyString instance = new EmptyString();

            private InstanceHolder() {
            }
        }
    }
}

