/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.wire.binary;

import io.usethesource.vallang.io.binary.util.ByteBufferInputStream;
import io.usethesource.vallang.io.binary.util.TaggedInt;
import io.usethesource.vallang.io.binary.util.TrackLastRead;
import io.usethesource.vallang.io.binary.util.WindowCacheFactory;
import io.usethesource.vallang.io.binary.wire.IWireInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BinaryWireInputStream
implements IWireInputStream {
    private static final byte[] WIRE_VERSION = new byte[]{1, 0, 0};
    private final InputStream __stream;
    private final TrackLastRead<String> stringsRead;
    private boolean closed = false;
    private int current;
    private int messageID;
    private int fieldType;
    private int fieldID;
    private @Nullable String stringValue;
    private int intValue;
    private byte @Nullable [] bytesValue;
    private int nestedType;
    private String @Nullable [] stringValues;
    private int @Nullable [] intValues;
    private int nestedLength;

    public BinaryWireInputStream(InputStream stream) throws IOException {
        this(stream, 8192);
    }

    public BinaryWireInputStream(InputStream stream, int bufferSize) throws IOException {
        this.__stream = stream instanceof BufferedInputStream || stream instanceof ByteBufferInputStream ? stream : new BufferedInputStream(stream, bufferSize);
        byte[] header = BinaryWireInputStream.readBytes(stream, WIRE_VERSION.length);
        if (!Arrays.equals(WIRE_VERSION, header)) {
            throw new IOException("Unsupported wire format");
        }
        int stringReadSize = BinaryWireInputStream.decodeInteger(this.__stream);
        this.stringsRead = WindowCacheFactory.getInstance().getTrackLastRead(stringReadSize);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.__stream.close();
            }
            finally {
                this.closed = true;
                WindowCacheFactory.getInstance().returnTrackLastRead(this.stringsRead);
            }
        } else {
            throw new IOException("Already closed");
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed");
        }
    }

    private byte[] readBytes(int len) throws IOException {
        return BinaryWireInputStream.readBytes(this.__stream, len);
    }

    private static byte[] readBytes(InputStream stream, int len) throws IOException, EOFException {
        int read;
        byte[] result = new byte[len];
        for (int pos = 0; pos < len; pos += read) {
            read = stream.read(result, pos, len - pos);
            if (read != -1) continue;
            throw new EOFException();
        }
        return result;
    }

    private int decodeInteger() throws IOException {
        return BinaryWireInputStream.decodeInteger(this.__stream);
    }

    private static int decodeInteger(InputStream stream) throws IOException {
        try {
            byte b = (byte)stream.read();
            if ((b & 0x80) == 0) {
                return b;
            }
            int result = b & 0x7F;
            b = (byte)stream.read();
            result ^= (b & 0x7F) << 7;
            if ((b & 0x80) == 0) {
                return result;
            }
            b = (byte)stream.read();
            result ^= (b & 0x7F) << 14;
            if ((b & 0x80) == 0) {
                return result;
            }
            b = (byte)stream.read();
            result ^= (b & 0x7F) << 21;
            if ((b & 0x80) == 0) {
                return result;
            }
            b = (byte)stream.read();
            result ^= (b & 0x7F) << 28;
            if ((b & 0x80) == 0) {
                return result;
            }
            throw new IOException("Incorrect integer");
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    private String decodeString() throws IOException {
        int len = this.decodeInteger();
        byte[] bytes = this.readBytes(len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public int next() throws IOException {
        this.assertNotClosed();
        this.intValues = null;
        this.stringValues = null;
        int next = this.decodeInteger();
        if (next == 0) {
            this.current = 2;
            return 2;
        }
        this.fieldID = TaggedInt.getOriginal(next);
        this.fieldType = TaggedInt.getTag(next);
        block0 : switch (this.fieldType) {
            case 0: {
                this.messageID = this.fieldID;
                this.current = 0;
                return 0;
            }
            case 4: {
                break;
            }
            case 3: {
                this.stringValue = this.decodeString();
                this.stringsRead.read(this.stringValue);
                break;
            }
            case 2: {
                this.intValue = this.decodeInteger();
                break;
            }
            case 1: {
                int reference = this.decodeInteger();
                this.fieldType = TaggedInt.getTag(reference);
                assert (this.fieldType == 3);
                this.stringValue = this.stringsRead.lookBack(TaggedInt.getOriginal(reference));
                break;
            }
            case 5: {
                int flaggedAmount = this.decodeInteger();
                this.nestedType = TaggedInt.getTag(flaggedAmount);
                this.nestedLength = TaggedInt.getOriginal(flaggedAmount);
                if (this.nestedLength == 0x1FFFFFFF) {
                    this.nestedLength = this.decodeInteger();
                }
                switch (this.nestedType) {
                    case 0: {
                        this.bytesValue = this.readBytes(this.nestedLength);
                        break block0;
                    }
                    case 2: {
                        int[] intValues = new int[this.nestedLength];
                        for (int i = 0; i < this.nestedLength; ++i) {
                            intValues[i] = this.decodeInteger();
                        }
                        this.intValues = intValues;
                        break block0;
                    }
                    case 3: {
                        String[] stringValues = new String[this.nestedLength];
                        for (int i = 0; i < this.nestedLength; ++i) {
                            stringValues[i] = this.readNestedString();
                        }
                        this.stringValues = stringValues;
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IOException("Unsupported nested type:" + this.nestedType);
            }
            default: {
                throw new IOException("Unexpected wire type: " + this.fieldType);
            }
        }
        this.current = 1;
        return 1;
    }

    private String readNestedString() throws IOException {
        String result;
        int reference = this.decodeInteger();
        if (TaggedInt.getTag(reference) == 3) {
            result = this.decodeString();
            this.stringsRead.read(result);
        } else {
            assert (TaggedInt.getTag(reference) == 1);
            result = this.stringsRead.lookBack(TaggedInt.getOriginal(reference));
        }
        return result;
    }

    @Override
    public int current() {
        return this.current;
    }

    @Override
    public int message() {
        assert (this.current == 0);
        return this.messageID;
    }

    @Override
    public int field() {
        assert (this.current == 1);
        return this.fieldID;
    }

    @Override
    public int getInteger() {
        assert (this.fieldType == 2);
        return this.intValue;
    }

    @Override
    public String getString() {
        assert (this.fieldType == 3);
        return BinaryWireInputStream.nonNull(this.stringValue);
    }

    private static <T> T nonNull(@Nullable T field) {
        if (field == null) {
            throw new RuntimeException("Unexpected null field");
        }
        return field;
    }

    @Override
    public byte[] getBytes() {
        assert (this.fieldType == 5 && this.nestedType == 0);
        return BinaryWireInputStream.nonNull(this.bytesValue);
    }

    @Override
    public int getFieldType() {
        assert (this.current == 1);
        return this.fieldType;
    }

    @Override
    public int getRepeatedType() {
        assert (this.current == 1 && this.fieldType == 5);
        return this.nestedType;
    }

    @Override
    public int getRepeatedLength() {
        assert (this.current == 1 && this.fieldType == 5);
        return this.nestedLength;
    }

    @Override
    public String[] getStrings() {
        assert (this.getRepeatedType() == 3);
        return BinaryWireInputStream.nonNull(this.stringValues);
    }

    @Override
    public int[] getIntegers() {
        assert (this.getRepeatedType() == 2);
        return BinaryWireInputStream.nonNull(this.intValues);
    }

    @Override
    public void skipMessage() throws IOException {
        int toSkip = 1;
        block4: while (toSkip != 0) {
            switch (this.next()) {
                case 0: {
                    ++toSkip;
                    continue block4;
                }
                case 2: {
                    --toSkip;
                    continue block4;
                }
            }
        }
    }
}

